define([
  'core/js/adapt',
  'core/js/views/adaptView',
  'core/js/views/articleView'
], function (Adapt, AdaptView, ArticleView) {

  var SetupView = Backbone.View.extend({

    attributes: function () {
      return {
        'data-home': 'true'
      }
    },
    events:{
      'click .continue_btn':'handleGoBtn',
      'click .selectBox':'showCheckboxes',
      'change input[type="radio"]':'handelRadio',
      'keyup #username':'handelInput',
      'click .exit':'exitCourse',
      'click .i_icon':'openPopup',
      'click .langclose':'closePopup'

    },
    expanded:true,
    isRadioCheck:false,
    isNameAvilable:false,
    handelRadio:function(e){
      this.isRadioCheck = true;
      this.showContinueBtn(e);
    },
    handelInput:function(e){
      if($(e.target).val()){
        this.isNameAvilable = true;
      }else{
        this.isNameAvilable =false;
      }
      this.showContinueBtn(e);
    },
    openPopup:function(){
      this.$('.languagepopupoverlay').fadeIn();
    },
    closePopup:function(){
      this.$('.languagepopupoverlay').fadeOut();
    },
    showContinueBtn:function(e){
      $(".redio-btn-container").removeClass('checked');
  //    if(this.isNameAvilable && this.isRadioCheck){
    if(this.isRadioCheck){
      $(e.currentTarget).closest(".redio-btn-container").addClass('checked');
       // this
        this.$('.continue_btn').removeClass("disable_btn");
      }else{
        this.$('.continue_btn').addClass("disable_btn");
      }
    },
    exitCourse:function(e){
      e.preventDefault();
      if(window.parent){
         window.parent.close();
      } 
      else{
        window.close();
      }
    },

    showCheckboxes:function () {
      var checkboxes = this.$('#checkboxes');
       
      if (!this.expanded) {
        this.$('#checkboxes').slideDown(function(){
            
        });
          this.expanded = true;
          $(".select-arrow").addClass("icon-controls-up").removeClass("icon-controls-down")

      } else {
        this.$('#checkboxes').slideUp(function(){                
        })          
          this.expanded = false;
          $(".select-arrow").addClass("icon-controls-down").removeClass("icon-controls-up")
      }
  },
    handleGoBtn:function(){   
//alert("setupView.js");

      // var userName = this.$('#username').val();
       var userLang = this.$('[name="language"]:checked').val();
       var langName=this.$('[name="language"]:checked').attr("data-lang");

      // Adapt.userInfo = {
      // // name:userName,
      //   language:userLang,
      //   languagename:langName
      // }
      // Adapt.offlineStorage.set('userInfo',JSON.stringify(Adapt.userInfo));
      // Adapt.offlineStorage.set('lang',userLang);           
      // this.setLanguage(userLang,function(){

      // Backbone.history.navigate('/corona-msg', {trigger: true, replace: false})
      // // Backbone.history.navigate('menu', {trigger: true, replace: false})

      //   if(!$('.nav').length){
      //     Adapt.navigation.render();
      //   } 
      // });
      //Backbone.history.navigate('/disclaimer', {trigger: true, replace: false})
      Backbone.history.navigate('/corona-msg', { trigger: true, replace: false });
    //  if(langName==="English"){
      
    //   }
    //   else{
    //     Adapt.trigger('notify:popup',{
    //      // title: "Hi "+userName+",\n Please Select English",
    //       title: "Hi, Please Select English",
    //       body: "Course is not avilable in "+langName+"."
    //     })
    //   }

    // Backbone.history.navigate('/disclaimerI', {trigger: true, replace: false})

    // $(".loading").show();
    // this.$(".home-page-container").css("opacity","0");
     
    },
    setLanguage:function(newLang,cb){            
      Adapt.config.set('_activeLanguage',newLang);
      Adapt.loadCourseData.apply(Adapt.dataOjb,[cb,newLang]);

      if(newLang==='ar' || newLang==='he'){
        Adapt.config.attributes._defaultDirection='rtl'
        Adapt.config.attributes._activeLanguage=newLang;
      }
      else{
        $("html").removeClass("dir-rtl");

        Adapt.config.attributes._defaultDirection='ltr'
        Adapt.config.attributes._activeLanguage=newLang;
      }

      //Adapt.trigger('app:languageChanged',newLang);
      //Adapt.trigger('languagepicker:changelanguage:new');

    },

    className: function () {
      return 'setup-page'
    },

    preRender: function () {
      
    },

    // postRender: function () {
    //   console.log("posteedd")
    //   this.$('#checkboxes').resize(function(e){
    //     console.log($(e.target).css('overflow'),$(e.target).height());
    //        if(($(e.target).height()>=359)){
    //         $(e.target).css("padding-right","0px")
    //        }
    //        else{
    //          $(e.target).css("padding-right","17px")
    //        }
    //   })
    // },

    initialize: function() {
      // ;  
      console.log("%cSiddhartha Sharma",'font-size:24px;color:teal')

      
      var user = Adapt.offlineStorage.get('userInfo');
      if(user){
        Adapt.userInfo = JSON.parse(user);
      }
      this.render();

      this.showContinueBtn();
      //this.postRender();
      Adapt.trigger('setupView:ready');
    },
    render: function () {
      var user = Adapt.userInfo;
      var data = this.model.attributes.getsetuppage;
      data.languages = Adapt.config.get('_languagePicker')['_languages'];
      if(user){
        data.username = user.name;
        data.language = user.language
      }
      var template = Handlebars.templates.setuppage;
      this.$el.html(template(data));
      if(user){
        this.$("#username").val(user.name);
        this.$('input[value="'+user.language+'"]').prop("checked", true);
        this.isRadioCheck=true;
        this.isNameAvilable=true;
        this.showContinueBtn();
        
      }
    }
  });

  return SetupView;

});
