define([
    'core/js/adapt'
  ], function (Adapt) {
  
    var DisclaimersecondView = Backbone.View.extend({
  
      attributes: function () {
        return {
          'data-disclaimersecond-view': 'true'
        }
      },
      events:{
        'click .start-btn':'handleStartBtn'
      },
      handleStartBtn:function(){ 
        Backbone.history.navigate('/menu', {trigger: true, replace: false})
      },
  
      className: function () {
        return 'disclaimer-view-page'
      },
  
      preRender: function () {
      },
  
      initialize: function() {
        this.render();
      },
      render: function () {
        var data = this.model.attributes.disclaimersecond;
        var template = Handlebars.templates.disclaimer;
        this.$el.html(template(data));
        Adapt.trigger('disclaimersecondView:ready');
      }
    });
  
    return DisclaimersecondView;
  
  });
  