define([
    'core/js/adapt'
  ], function (Adapt) {
  
    var DisclaimerView = Backbone.View.extend({
  
      attributes: function () {
        return {
          'data-disclaimer-view': 'true'
        }
      },
      events:{
        'click .gomenu':'handleStartBtn',
        'click .trnascriptBtn':'openTranscript',
        'click .playIcon':'playVideoWithIconClickHandler'        
      },
      handleStartBtn:function(){ 
        Backbone.history.navigate('/menu', {trigger: true, replace: false})
      },
  
      className: function () {
        return 'disclaimer-view-page'
      },
  
      preRender: function () {
          
       
      },

      openTranscript: function(e){       
        $(e.currentTarget).closest(".vid_transcriptArea").find('.transcript_text').slideToggle();
        var toggletext=$(e.currentTarget).text().toLocaleLowerCase();
        if(toggletext=='transcript'){
          $(e.currentTarget).text("HIDE TRANSCRIPT")
        }else{
          $(e.currentTarget).text("TRANSCRIPT")
        }
      },  

    
    playVideoWithIconClickHandler: function(e){
     
 
     $(e.currentTarget).closest(".video_page").find(".video_backdrop").hide()
     $(e.currentTarget).closest(".video_page").find("video")[0].play();

         
    },
      videoPlayPause:function(){
        var vidClip1 = document.getElementById("video1"); 
        var vidClip2 = document.getElementById("video2");
        
        vidClip1.onplay = function() {
          
          vidClip2.pause();

         }; 

         vidClip1.addEventListener('pause', (event) => {
          
        });

        vidClip1.addEventListener('play', (event) => {
          
          vidClip2.pause();
        });

        vidClip2.onplay = function() {
          
          vidClip1.pause()
         }; 

         vidClip2.addEventListener('pause', (event) => {
          
        });

        vidClip2.addEventListener('play', (event) => {
          
          vidClip1.pause()
        });

      },
      initialize: function() {
        this.render();
      },
      render: function () {        
        var data = this.model.attributes.disclaimer;
        var template = Handlebars.templates.disclaimer;
        this.$el.html(template(data));
        Adapt.trigger('disclaimerView:ready');
 
        $('.nav').show(); 

        var $that=this;
        setTimeout(function(){
          $that.videoPlayPause(); 

        
        }, 2000)
      

        
       
        
      }
    });
  
    return DisclaimerView;
  
  });
  
  