define([
    'core/js/adapt',
    'core/js/views/adaptView',
    'core/js/views/articleView'
], function(Adapt, AdaptView, ArticleView) {

    var MeetTeamView = Backbone.View.extend({

        attributes: function() {
            return {
                'data-home': 'true'
            }
        },
        events: {
            'click .start-btn': 'handleGoBtn',
            'click .team-container': 'openPopup'
        },
        handleGoBtn: function() {
            Backbone.history.navigate('/disclaimer', { trigger: true, replace: false })
        },

        openPopup: function(e) {
            $("body,html").addClass("overflow_hidden");
            var template = Handlebars.templates.meettheteam;
            var data = this.model.attributes.meettheteam.team;

            var name = $(e.currentTarget).data('name');
            var title = this.model.attributes.meettheteam.displayTitle;
            var popupData = data.filter(function(v) { return v.name === name });




            popupData.displayTitle = title;
            popupData.button = this.model.attributes.meettheteam.button;
            Adapt.trigger("notify:popup", {

                _view: new MeetTeamPopupView({ model: popupData }),
                _isCancellable: true,
                _showCloseButton: true,
                _classes: ' meet-team-notify'
            });
            this.listenToOnce(Adapt, {
                'popup:closed': this.onPopupClosed
            });
        },
        onPopupClosed: function() {
            $("body,html").removeClass("overflow_hidden");
        },

        className: function() {
            return 'setup-page'
        },

        preRender: function() {},

        initialize: function() {
            $(".loading").hide();
            this.render();
            Adapt.trigger('MeetTeamView:ready');
        },
        render: function() {
            // console.log(JSON.stringify(Adapt.userInfo)+'%c','font-size:32px;color:red')
            //;

            var data = this.model.attributes.meettheteam;
            data.name = (Adapt.userInfo && Adapt.userInfo.name) || Adapt.offlineStorage.get('userInfo').name || "John";
            var template = Handlebars.templates.meettheteam;
            this.$el.html(template(data));
        }
    });


    var MeetTeamPopupView = Backbone.View.extend({
        className: function() { return 'meet-the-team-pop-up' },
        initialize: function() {
            this.render();
        },
        render: function() {
            var data = (this.model.length && this.model[0]) || {}
            data.displayTitle = this.model.displayTitle;
            data.button = this.model.button;
            var template = Handlebars.templates.meetteampopup;
            this.$el.html(template(data));
        }
    });

    return MeetTeamView;

});