define([
  'core/js/adapt',
  'core/js/views/adaptView',
  'core/js/views/articleView'
], function (Adapt, AdaptView, ArticleView) {

  var WelcomeView = Backbone.View.extend({

    attributes: function () {
      return {
        'data-home': 'true'
      }
    },
    events:{
      'click .start-btn':'handleStartBtn'
    },
    handleStartBtn:function(){      
      Backbone.history.navigate('/disclaimer', { trigger: true, replace: false });
     // Backbone.history.navigate('/corona-msg', { trigger: true, replace: false })
      
    },

    className: function () {
      return 'home-page'
    },

    preRender: function () {      
    },

    initialize: function() {
      this.render();
     
    },
    render: function () {
      var data = this.model.attributes.getstartedpage;
      var template = Handlebars.templates.homepage;
      this.$el.html(template(data));
      Adapt.trigger('homeView:ready');
     
      
      
    }
  });

  return WelcomeView;

});
