require(["bowser","underscore","backbone","semver","react","react-dom","html-react-parser","libraries/SCORM_API_wrapper","libraries/lzma-min","libraries/lzma_worker-min.js","libraries/js-cookie.js","libraries/jquery.keycombo","libraries/plyr.min"],(function(Bowser,_$1,Backbone$1,semver,React,ReactDOM,HTMLReactParser,pipwerks,lzmaMin,lzma_workerMin_js,Cookies,jquery_keycombo,plyr_min){function _interopDefaultLegacy(e){return e&&typeof e==="object"&&"default"in e?e:{default:e}}var Bowser__default=_interopDefaultLegacy(Bowser);var ___default=_interopDefaultLegacy(_$1);var Backbone__default=_interopDefaultLegacy(Backbone$1);var semver__default=_interopDefaultLegacy(semver);var React__default=_interopDefaultLegacy(React);var ReactDOM__default=_interopDefaultLegacy(ReactDOM);var HTMLReactParser__default=_interopDefaultLegacy(HTMLReactParser);var pipwerks__default=_interopDefaultLegacy(pipwerks);var Cookies__default=_interopDefaultLegacy(Cookies);class Wait extends Backbone.Controller{initialize(){this._waitCount=0;this._callbackHandle=null;this.being=this.begin.bind(this);this.end=this.end.bind(this)}isWaiting(){return this._waitCount!==0}begin(){if(!this.isWaiting())this.trigger("wait");this._waitCount++;if(this._callbackHandle){clearTimeout(this._callbackHandle);this._callbackHandle=null}return this}end(){if(!this.isWaiting())return this;this._waitCount--;if(this.isWaiting()||this._callbackHandle)return this;this._callbackHandle=setTimeout(function(){this._callbackHandle=null;this.trigger("ready")}.bind(this),0);return this}queue(callback){if(!callback){this.begin();return new Promise((resolve=>{this.once("ready",resolve);this.end()}))}this.begin();this.once("ready",callback);this.end();return this}for(callback){this.begin();_.defer((()=>callback(_.once(this.end))));return this}}const wait=new Wait;var Wait$1=__AMD("core/js/wait",wait);var LockingModel=__AMD("core/js/models/lockingModel",class LockingModel extends Backbone.Model{lockedAttributes(){return null}set(...args){if(typeof args[0]!=="object"){const[name,value]=args.splice(0,2);args.unshift({[name]:value})}const options=args[1]??{};const attrValues=args[0];const newValues={};for(const attrName in attrValues){const attrVal=attrValues[attrName];const willChange=this.attributes[attrName]!==attrValues[attrName];if(!willChange)continue;const isNotLocking=typeof attrVal!=="boolean"||!this.isLocking(attrName);if(isNotLocking){newValues[attrName]=attrVal;continue}const defaults=_.result(this,"defaults");const isDefault=defaults[attrName]!==undefined;const isInitialDefault=isDefault&&!this.changed;if(isInitialDefault){this._lockedAttributes[attrName]=!defaults[attrName]}const isSettingValueForSpecificPlugin=options?.pluginName;if(!isSettingValueForSpecificPlugin){if(!isInitialDefault){console.error("Must supply a pluginName to change a locked attribute")}options.pluginName="compatibility"}const pluginName=options.pluginName;const lockingValue=this._lockedAttributes[attrName];const isAttemptingToLock=lockingValue===attrVal;if(isAttemptingToLock){this.setLockState(attrName,true,{pluginName:pluginName,skipcheck:true});newValues[attrName]=lockingValue;continue}this.setLockState(attrName,false,{pluginName:pluginName,skipcheck:true});const totalLockValue=this.getLockCount(attrName,{skipcheck:true});if(totalLockValue===0){newValues[attrName]=!lockingValue;continue}}if(!Object.keys(newValues))return this;super.set(newValues,options);return this}setLocking(attrName,defaultLockValue){if(this.isLocking(attrName))return;if(!this._lockedAttributes)this._lockedAttributes={};this._lockedAttributes[attrName]=defaultLockValue}unsetLocking(attrName){if(!this.isLocking(attrName))return;if(!this._lockedAttributes)return;delete this._lockedAttributes[attrName];delete this._lockedAttributesValues[attrName];if(Object.keys(this._lockedAttributes).length===0){delete this._lockedAttributes;delete this._lockedAttributesValues}}isLocking(attrName){const isCheckingGeneralLockingState=attrName===undefined;let hasDerivedLockedAttributes=Object.prototype.hasOwnProperty.call(this,"_lockedAttributes");if(!hasDerivedLockedAttributes){this._lockedAttributes=_.result(this,"lockedAttributes");hasDerivedLockedAttributes=true}const isUsingLockedAttributes=Boolean(this._lockedAttributes);if(isCheckingGeneralLockingState){return isUsingLockedAttributes}if(!isUsingLockedAttributes)return false;const isAttributeALockingAttribute=Object.prototype.hasOwnProperty.call(this._lockedAttributes,attrName);if(!isAttributeALockingAttribute)return false;if(!this._lockedAttributesValues){this._lockedAttributesValues={}}if(!this._lockedAttributesValues[attrName]){this._lockedAttributesValues[attrName]={}}return true}isLocked(attrName,options){const shouldSkipCheck=options?.skipcheck;if(!shouldSkipCheck){const stopProcessing=!this.isLocking(attrName);if(stopProcessing)return}return this.getLockCount(attrName)>0}getLockCount(attrName,options){const shouldSkipCheck=options?.skipcheck;if(!shouldSkipCheck){const stopProcessing=!this.isLocking(attrName);if(stopProcessing)return}const isGettingValueForSpecificPlugin=options?.pluginName;if(isGettingValueForSpecificPlugin){return this._lockedAttributesValues[attrName][options.pluginName]?1:0}const lockingAttributeValues=Object.values(this._lockedAttributesValues[attrName]);const lockingAttributeValuesSum=lockingAttributeValues.reduce(((sum,value)=>sum+(value?1:0)),0);return lockingAttributeValuesSum}setLockState(attrName,value,options){const shouldSkipCheck=options?.skipcheck;if(!shouldSkipCheck){const stopProcessing=!this.isLocking(attrName);if(stopProcessing)return this}const isSettingValueForSpecificPlugin=options?.pluginName;if(!isSettingValueForSpecificPlugin){console.error("Must supply a pluginName to set a locked attribute lock value");options.pluginName="compatibility"}if(value){this._lockedAttributesValues[attrName][options.pluginName]=value}else{delete this._lockedAttributesValues[attrName][options.pluginName]}return this}});class AdaptSingleton extends LockingModel{initialize(){this.loadScript=window.__loadScript}defaults(){return{_canScroll:true,_outstandingCompletionChecks:0,_pluginWaitCount:0,_isStarted:false,_shouldDestroyContentObjects:true}}lockedAttributes(){return{_canScroll:false}}async init(){this.addDirection();this.disableAnimation();this.trigger("adapt:preInitialize");await Wait$1.queue();this.deferUntilCompletionChecked((async()=>{this.trigger("adapt:start");await Wait$1.queue();if(!Backbone.History.started){Backbone.history.start()}this.set("_isStarted",true);this.trigger("adapt:initialize");await Wait$1.queue()}))}checkingCompletion(){const outstandingChecks=this.get("_outstandingCompletionChecks");this.set("_outstandingCompletionChecks",outstandingChecks+1)}checkedCompletion(){const outstandingChecks=this.get("_outstandingCompletionChecks");this.set("_outstandingCompletionChecks",outstandingChecks-1)}async deferUntilCompletionChecked(callback=(()=>{})){if(this.get("_outstandingCompletionChecks")===0)return callback();return new Promise((resolve=>{const checkIfAnyChecksOutstanding=(model,outstandingChecks)=>{if(outstandingChecks!==0)return;this.off("change:_outstandingCompletionChecks",checkIfAnyChecksOutstanding);callback();resolve()};this.on("change:_outstandingCompletionChecks",checkIfAnyChecksOutstanding)}))}isWaitingForPlugins(){this.log.deprecated("Use wait.isWaiting() as Adapt.isWaitingForPlugins() will be removed in the future");return Wait$1.isWaiting()}checkPluginsReady(){this.log.deprecated("Use wait.isWaiting() as Adapt.checkPluginsReady() will be removed in the future");if(this.isWaitingForPlugins()){return}this.trigger("plugins:ready")}parseRelativeString(relativeString){const parts=relativeString.replace(/\s*([+\-=]+\d+){1}/g,"$1").split(/[@ ]/).filter(Boolean);const parsed=parts.map((part=>{let splitIndex=part.search(/[+\-=\d]{1}/);if(splitIndex===-1)splitIndex=part.length;const symbol=part.slice(splitIndex,splitIndex+1);const type=part.slice(0,splitIndex).replace(/^@/,"");let offset=null;let inset=null;switch(symbol){case"=":inset=parseInt(part.slice(splitIndex+1).trim()||0);break;default:offset=parseInt(part.slice(splitIndex).trim()||0);break}return{type:type,offset:offset,inset:inset}}));return parsed.length===1?parsed[0]:parsed}addDirection(){const defaultDirection=this.config.get("_defaultDirection");$("html").addClass("dir-"+defaultDirection).attr("dir",defaultDirection)}disableAnimation(){const disableAnimationArray=this.config.get("_disableAnimationFor");const disableAnimation=this.config.get("_disableAnimation");if(disableAnimationArray){for(let i=0,l=disableAnimationArray.length;i<l;i++){if(!$("html").is(disableAnimationArray[i]))continue;this.config.set("_disableAnimation",true);$("html").addClass("disable-animation");console.log("Animation disabled.")}return}$("html").toggleClass("disable-animation",disableAnimation===true)}async remove(){const currentView=this.parentView;if(currentView){currentView.model.setOnChildren({_isReady:false,_isRendered:false})}this.trigger("preRemove",currentView);await Wait$1.queue();if(currentView&&this.get("_shouldDestroyContentObjects")){currentView.destroy()}this.trigger("remove",currentView);_.defer(this.trigger.bind(this),"postRemove",currentView)}get a11y(){}get componentStore(){}get data(){}get device(){}get drawer(){}get location(){}get notify(){}get offlineStorage(){}get router(){}get scrolling(){}get startController(){}get store(){}get tracking(){}get wait(){}async navigateToElement(){}async scrollTo(){}register(name,object){}getViewName(){}getViewClass(){}getModelName(){}getModelClass(){}findById(){}findViewByModelId(){}findByTrackingPosition(){}}const Adapt=new AdaptSingleton;var Adapt$1=__AMD("core/js/adapt",Adapt);class OfflineStorage$1 extends Backbone.Controller{initialize(handler){this.ready=true;this._handler=undefined;if(!handler){return}this.ready=false;this._handler=handler}hasHandler(){return this._handler!==undefined}save(){Adapt$1.trigger("tracking:save");return this._handler?.save?.(...arguments)}serialize(value){if(this._handler?.serialize){return this._handler.serialize(...arguments)}return JSON.stringify(value)}deserialize(value){if(this._handler?.deserialize){return this._handler.deserialize(...arguments)}return JSON.parse(value)}set(name,value){if(this._handler?.set){return this._handler.set(...arguments)}this[name]=value}get(name){if(this._handler?.get){return this._handler.get(...arguments)}return this[name]}clear(){if(this._handler?.clear){return this._handler.clear(...arguments)}return false}setReadyStatus(){this.ready=true;Adapt$1.trigger("offlineStorage:ready")}}const offlineStorage=new OfflineStorage$1;var offlineStorage$1=__AMD("core/js/offlineStorage",offlineStorage);class Device extends Backbone.Controller{initialize(){___default["default"].bindAll(this,"onWindowResize","calculateResize");this.bowser=Bowser__default["default"].parse(window.navigator.userAgent);this.$html=$("html");this.$window=$(window);this.touch=Modernizr.touchevents;this.screenWidth=this.getScreenWidth();this.screenHeight=this.getScreenHeight();this.setViewportHeight();this.browser=(this.bowser.browser.name||"").toLowerCase();this.version=(this.bowser.browser.version||"").toLowerCase();this.OS=this.getOperatingSystem().toLowerCase();this.osVersion=this.bowser.os.version||"";this.renderingEngine=this.getRenderingEngine();this.listenTo(Adapt$1,{"configModel:dataLoaded":this.onConfigDataLoaded,"navigationView:postRender":this.setNavigationHeight});const browser=this.browser.toLowerCase();let browserString=browser.replace(/msie|internet explorer/,"ie");browserString+=` version-${this.version} OS-${this.OS} ${this.getAppleDeviceType()}`;browserString+=browserString.replace(".","-").toLowerCase();browserString+=` ${browserString.replace(/\./g,"-").toLowerCase()}`;browserString+=` pixel-density-${this.pixelDensity()}`;this.$html.addClass(browserString)}get orientation(){return this.screenWidth>=this.screenHeight?"landscape":"portrait"}get aspectRatio(){return this.screenWidth/this.screenHeight}onConfigDataLoaded(){this.screenSize=this.checkScreenSize();this.$html.addClass("size-"+this.screenSize);if(this.orientation){this.$html.addClass("orientation-"+this.orientation)}this.$window.on("resize orientationchange",this.onWindowResize)}get screenSizes(){const screenSizes={...Adapt$1.config.get("screenSize")};const screenSizesList=Object.entries(screenSizes);const screensizeEmThreshold=300;const baseFontSize=16;for(const[name,value]of screenSizesList){screenSizes[name]=value>screensizeEmThreshold?value/baseFontSize:value}return screenSizes}isScreenSizeMin(name){return Boolean(window.matchMedia(`(min-width: ${this.screenSizes[name]}em)`)?.matches)}checkScreenSize(){const screenSizesList=Object.entries(this.screenSizes);screenSizesList.sort(((a,b)=>a[1]-b[1]));const fontSize=parseFloat($("html").css("font-size"));const screenSizeEmWidth=window.innerWidth/fontSize;const smallestScreenSize=screenSizesList[0][0];const screenSize=screenSizesList.reduce(((screenSize,[name,value])=>{if(screenSizeEmWidth>=value)return name;return screenSize}),smallestScreenSize);return screenSize}getScreenWidth(){return this.isAppleDevice()?this.getAppleScreenWidth():window.innerWidth||this.$window.width()}getScreenHeight(){return this.isAppleDevice()?this.getAppleScreenHeight():window.innerHeight||this.$window.height()}setViewportHeight(){document.documentElement.style.setProperty("--adapt-viewport-height",`${window.innerHeight}px`)}setNavigationHeight(){document.documentElement.style.setProperty("--adapt-navigation-height",`${$(".nav").height()}px`)}getOperatingSystem(){let os=this.bowser.os.name.toLowerCase()||"";if(os===""){const platform=navigator.platform.toLowerCase();const match=platform.match(/win|mac|linux/);if(match)os=match[0];if(os==="win")os="windows";if(!os)os=""}if(!os)os="platformunknown";return os}getRenderingEngine(){return this.bowser.engine.name||""}onWindowResize(){if(this.hasWindowResized)return;requestAnimationFrame(this.calculateResize);this.hasWindowResized=true}calculateResize(){this.hasWindowResized=false;const previousWidth=this.screenWidth;const previousHeight=this.screenHeight;this.screenWidth=this.getScreenWidth();this.screenHeight=this.getScreenHeight();this.setViewportHeight();this.setNavigationHeight();if(previousWidth===this.screenWidth&&previousHeight===this.screenHeight){return}if(this.orientation){this.$html.toggleClass("orientation-landscape",this.orientation==="landscape");this.$html.toggleClass("orientation-portrait",this.orientation==="portrait")}const newScreenSize=this.checkScreenSize();if(newScreenSize!==this.screenSize){this.screenSize=newScreenSize;const screenSizes=this.screenSizes;for(const name in screenSizes){if(name===this.screenSize)continue;this.$html.removeClass(`size-${name}`)}this.$html.toggleClass(`size-${this.screenSize}`,true);Adapt$1.trigger("device:changed",this.screenSize)}Adapt$1.trigger("device:preResize device:resize device:postResize",this.screenWidth)}isAppleDevice(){return/iPad|iPhone|iPod/.test(navigator.userAgent)&&!window.MSStream||navigator.userAgent.match(/Mac/)&&navigator?.maxTouchPoints>2}get shouldReportInvertedAppleScreenSize(){const windowRatio=window.innerWidth/window.innerHeight;const screenRatio=window.screen.width/window.screen.height;const isWindowPortrait=windowRatio<1;const isScreenPortrait=screenRatio<1;const isDeviceBadlyReportingScreenOrientation=isWindowPortrait!==isScreenPortrait;return isDeviceBadlyReportingScreenOrientation}getAppleScreenWidth(){return this.shouldReportInvertedAppleScreenSize?window.screen.height:window.screen.width}getAppleScreenHeight(){return this.shouldReportInvertedAppleScreenSize?window.screen.width:window.screen.height}getAppleDeviceType(){const platformType=this.bowser.platform.type?.toLowerCase()||"";const browserName=this.bowser.browser.name?.toLowerCase()||"";const isIPhone=platformType==="mobile"&&browserName==="safari";const isIPad=platformType==="tablet"&&browserName==="safari";if(isIPhone)return"iphone";if(isIPad)return"ipad";return""}pixelDensity(){const pixelDensity=window.devicePixelRatio||1;if(pixelDensity>=3){return"ultra-high"}else if(pixelDensity>=2){return"high"}else if(pixelDensity>=1.5){return"medium"}else{return"low"}}}const device=new Device;var device$1=__AMD("core/js/device",device);class Location extends Backbone__default["default"].Controller{initialize(){this._previousId=null;this._previousContentType=null;this._previousModel=null;this._previousClasses=null;this._lastVisitedType=null;this._lastVisitedMenu=null;this._lastVisitedPage=null;this._currentId=null;this._currentModel=null;this._currentLocation=null;this._contentType=null}}const location=new Location;var location$1=__AMD("core/js/location",location);var BrowserConfig=__AMD("core/js/a11y/browserConfig",class BrowserConfig extends Backbone.Controller{initialize({a11y:a11y}){this.a11y=a11y;this.listenTo(Adapt$1,{"accessibility:ready":this._onReady})}_onReady(){if(this.a11y.config._options._isPrefersReducedMotionEnabled)this._enablePrefersReducedMotion()}_enablePrefersReducedMotion(){if(!window.matchMedia)return;const isEnabledInBrowser=window.matchMedia("(prefers-reduced-motion: reduce");$("html").toggleClass("is-prefers-reduced-motion",Boolean(isEnabledInBrowser?.matches))}});var BrowserFocus=__AMD("core/js/a11y/browserFocus",class BrowserFocus extends Backbone.Controller{initialize({a11y:a11y}){this.a11y=a11y;this._onBlur=this._onBlur.bind(this);this._onClick=this._onClick.bind(this);this.$body=$("body");this.listenTo(Adapt$1,{"accessibility:ready":this._attachEventListeners})}_attachEventListeners(){this.$body.on("blur","*",this._onBlur).on("blur",this._onBlur);this.$body[0].addEventListener("click",this._onClick,true)}_onBlur(event){const config=this.a11y.config;if(!config._isEnabled||!config._options._isFocusNextOnDisabled){return}const $element=$(event.target);if($element.is("[data-a11y-force-focus]")){$element.removeAttr("tabindex data-a11y-force-focus")}if(event.target!==event.currentTarget){return}if(!$(event.relatedTarget).is("body")){return}if(!$element.is("[disabled]")&&$element.css("display")!=="none"&&$element.css("visibility")!=="hidden"){return}this.a11y.focusNext($element)}_onClick(event){if(!event.isTrusted)return;const $element=$(event.target);const isAriaDisabled=$element.closest("[aria-disabled=true]").length===1;if(isAriaDisabled){event.preventDefault();event.stopImmediatePropagation()}const config=this.a11y.config;if(!config._isEnabled||!config._options._isFocusOnClickEnabled){return}const $stack=$([...$element.toArray(),...$element.parents().toArray()]);const $focusable=$stack.filter(config._options._tabbableElements);if(!$focusable.length){return}const $closestFocusable=$element.closest(config._options._tabbableElements);if($closestFocusable[0]!==document.activeElement){this.a11y._isForcedFocus=true;$closestFocusable[0].focus();this.a11y._isForcedFocus=false}if(!config._options._isClickDelayedAfterFocusEnabled)return;event.preventDefault();event.stopImmediatePropagation();setTimeout((()=>{$element[0].click()}),50)}});var FocusOptions=__AMD("core/js/a11y/focusOptions",class FocusOptions{constructor({preventScroll:preventScroll=false,defer:defer=false}={}){this.preventScroll=preventScroll;this.defer=defer}});var KeyboardFocusOutline=__AMD("core/js/a11y/keyboardFocusOutline",class KeyboardFocusOutline extends Backbone.Controller{initialize({a11y:a11y}){this.a11y=a11y;this._onKeyDown=this._onKeyDown.bind(this);this.$html=$("html");this.showOnKeys={9:true,13:true,32:true,37:true,38:true,39:true,40:true};this.listenTo(Adapt$1,{"accessibility:ready":this._attachEventListeners})}_attachEventListeners(){document.addEventListener("keydown",this._onKeyDown);this._start()}_start(){const config=this.a11y.config;if(config._options._isFocusOutlineDisabled){this.$html.addClass("a11y-disable-focusoutline");return}if(!config._isEnabled||!config._options._isFocusOutlineKeyboardOnlyEnabled){return}this.$html.addClass("a11y-disable-focusoutline")}_onKeyDown(event){const config=this.a11y.config;if(config._options._isFocusOutlineDisabled){this.$html.addClass("a11y-disable-focusoutline");return}if(!config._isEnabled||!config._options._isFocusOutlineKeyboardOnlyEnabled||!this.showOnKeys[event.keyCode]){return}const $element=$(event.target);if(!$element.is(config._options._tabbableElements)||$element.is(config._options._focusOutlineKeyboardOnlyIgnore)){return}this.$html.removeClass("a11y-disable-focusoutline")}});const LOG_LEVEL=ENUM(["DEBUG","INFO","WARN","ERROR","FATAL"]);var LOG_LEVEL$1=__AMD("core/js/enums/logLevelEnum",LOG_LEVEL);class Logging extends Backbone.Controller{initialize(){this._config={_isEnabled:true,_level:LOG_LEVEL$1.INFO.asLowerCase,_console:true,_warnFirstOnly:true};this._warned={};this.listenToOnce(Adapt$1,"configModel:dataLoaded",this.onLoadConfigData)}onLoadConfigData(){this.loadConfig();this.debug("Logging config loaded");this.trigger("log:ready")}loadConfig(){if(Adapt$1.config.has("_logging")){this._config=Adapt$1.config.get("_logging")}this.checkQueryStringOverride()}checkQueryStringOverride(){const matches=window.location.search.match(/[?&]loglevel=([a-z]*)/i);if(!matches||matches.length<2)return;const override=LOG_LEVEL$1(matches[1].toUpperCase());if(!override)return;this._config._level=override.asLowerCase;this.debug("Loglevel override in query string:",this._config._level)}debug(...args){this._log(LOG_LEVEL$1.DEBUG,args)}info(...args){this._log(LOG_LEVEL$1.INFO,args)}warn(...args){this._log(LOG_LEVEL$1.WARN,args)}error(...args){this._log(LOG_LEVEL$1.ERROR,args)}fatal(...args){this._log(LOG_LEVEL$1.FATAL,args)}removed(...args){args=["REMOVED"].concat(args);this.warnOnce(...args)}deprecated(...args){args=["DEPRECATED"].concat(args);this.warnOnce(...args)}warnOnce(...args){if(this._hasWarned(args)){return}this._log(LOG_LEVEL$1.WARN,args)}_log(level,data){const isEnabled=this._config._isEnabled;if(!isEnabled)return;const configLevel=LOG_LEVEL$1(this._config._level.toUpperCase());const isLogLevelAllowed=level>=configLevel;if(!isLogLevelAllowed)return;this._logToConsole(level,data);this.trigger("log",level,data);this.trigger("log:"+level.asLowerCase,level,data)}_logToConsole(level,data){const shouldLogToConsole=this._config._console;if(!shouldLogToConsole)return;const log=[level.asUpperCase+":"];data&&log.push(...data);if(console[level.asLowerCase]){console[level.asLowerCase](...log)}else{console.log(...log)}}_hasWarned(args){if(!this._config._warnFirstOnly){return false}const hash=args.map(String).join(":");if(this._warned[hash]){return true}this._warned[hash]=true;return false}}const logging=new Logging;var logging$1=__AMD("core/js/logging",logging);var Log=__AMD("core/js/a11y/log",class Log extends Backbone.Controller{initialize({a11y:a11y}){this.a11y=a11y;this._warned={}}_hasWarned(args){const config=this.a11y.config;if(!config._options._warnFirstOnly){return false}const hash=args.map(String).join(":");if(this._warned[hash]){return true}this._warned[hash]=true;return false}_canWarn(){const config=this.a11y.config;return Boolean(config._options._warn)}removed(...args){if(!this._canWarn){return}args=["A11Y"].concat(args);if(this._hasWarned(args)){return}logging$1.removed(...args);return this}deprecated(...args){if(!this._canWarn){return}args=["A11Y"].concat(args);if(this._hasWarned(args)){return}logging$1.deprecated(...args);return this}});var Scroll=__AMD("core/js/a11y/scroll",class Scroll extends Backbone.Controller{initialize({a11y:a11y}){this._a11y=a11y;this._onTouchStart=this._onTouchStart.bind(this);this._onTouchEnd=this._onTouchEnd.bind(this);this._onScrollEvent=this._onScrollEvent.bind(this);this._onKeyDown=this._onKeyDown.bind(this);this._scrollDisabledElements=$([]);this.$window=$(window);this.$body=$("body");this._preventScrollOnKeys={33:true,34:true,35:true,36:true,37:true,38:true,39:true,40:true};this._arrowKeys={37:true,38:true,39:true,40:true};this._ignoreKeysOnElementsMatching="textarea, input[type=radio], select";this._isRunning=false;this._touchStartEventObject=null;window.addEventListener("touchstart",this._onTouchStart);window.addEventListener("touchend",this._onTouchEnd);window.addEventListener("touchmove",this._onScrollEvent,{passive:false});window.addEventListener("wheel",this._onScrollEvent,{passive:false});document.addEventListener("wheel",this._onScrollEvent,{passive:false});document.addEventListener("keydown",this._onKeyDown)}disable($elements){$elements=$($elements);this._scrollDisabledElements=this._scrollDisabledElements.add($elements);this._checkRunning();return this}enable($elements){$elements=$($elements);if(!$elements.length){this.clear();return this}this._scrollDisabledElements=this._scrollDisabledElements.not($elements);this._checkRunning();return this}clear(){this._scrollDisabledElements=$([]);this._checkRunning();return this}_checkRunning(){if(!this._scrollDisabledElements.length){this._stop();return}this._start()}_start(){if(this._isRunning){return}this._isRunning=true}_onTouchStart(event){if(!this._isRunning)return;event=$.event.fix(event);this._touchStartEventObject=event;return true}_onTouchEnd(){if(!this._isRunning)return;this._touchStartEventObject=null;return true}_onScrollEvent(event){if(!this._isRunning)return;event=$.event.fix(event);return this._preventScroll(event)}_onKeyDown(event){if(!this._isRunning)return;event=$.event.fix(event);if(this._arrowKeys[event.which]&&this._a11y.isArrowable(event.target)){return}if(!this._preventScrollOnKeys[event.which]){return}if(this._a11y.isPopupOpen&&!this._isScrollable($(event.target))){const $openPopup=this._a11y.popupStack[this._a11y.popupStack.length-1];const $firstScrollable=this._isScrollable($openPopup)?$openPopup:this._a11y._findFirstForwardDescendant($openPopup,this._isScrollable);if($firstScrollable.length){event.target=$firstScrollable}}const $target=$(event.target);if($target.is(this._ignoreKeysOnElementsMatching)){return}return this._preventScroll(event)}_preventScroll(event){const isGesture=event.touches?.length>1;if(isGesture){return}const $target=$(event.target);if(this._scrollDisabledElements.length){const scrollingParent=this._getScrollingParent(event,$target);if(scrollingParent.filter(this._scrollDisabledElements).length===0){this.$window.scroll();return}}event.preventDefault();return false}_getScrollingParent(event,$target){const isTouchEvent=event.type==="touchmove";const isKeyDownEvent=event.type==="keydown";const hasTouchStartEvent=this._touchStartEventObject?.originalEvent;if(isTouchEvent&&!hasTouchStartEvent&&!isKeyDownEvent){return $target}const directionY=this._getScrollDirection(event);if(directionY==="none"){return this.$body}const parents=[$target[0],...$target.parents()];for(let i=0,l=parents.length;i<l;i++){const $parent=$(parents[i]);if($parent.is("body")){return this.$body}if(!this._isScrollable($parent)){continue}if(!this._isScrolling($parent,directionY)){continue}return $parent}return this.$body}_isScrollable($target){const scrollType=$target.css("overflow-y");if(scrollType!=="auto"&&scrollType!=="scroll"){return false}const pointerEvents=$target.css("pointer-events");if(pointerEvents==="none"){return false}return true}_isScrolling($target,directionY){const scrollTop=Math.ceil($target.scrollTop());const innerHeight=$target.outerHeight();const scrollHeight=$target[0].scrollHeight;let hasScrollingSpace=false;switch(directionY){case"down":hasScrollingSpace=scrollTop+innerHeight<scrollHeight;if(hasScrollingSpace){return true}break;case"up":hasScrollingSpace=scrollTop>0;if(hasScrollingSpace){return true}break}return false}_getScrollDirection(event){const deltaY=this._getScrollDelta(event);if(deltaY===0){return"none"}return deltaY>0?"up":"down"}_getScrollDelta(event){let deltaY=0;const isTouchEvent=event.type==="touchmove";const isKeyDownEvent=event.type==="keydown";const originalEvent=event.originalEvent;if(isTouchEvent){const startOriginalEvent=this._touchStartEventObject.originalEvent;let currentY=originalEvent.pageY;let previousY=startOriginalEvent.pageY;if(currentY===0||currentY===previousY){currentY=originalEvent.touches[0].pageY;previousY=startOriginalEvent.touches[0].pageY}deltaY=currentY-previousY}else if(isKeyDownEvent){deltaY=[33,36,38].includes(event.which)?1:[34,35,40].includes(event.which)?-1:0}else{const hasDeltaY=originalEvent.wheelDeltaY||originalEvent.deltaY!==undefined;if(hasDeltaY){deltaY=-originalEvent.deltaY}else{deltaY=originalEvent.wheelDelta||0}}return deltaY}_stop(){if(!this._isRunning){return}this._isRunning=false}});var WrapFocus=__AMD("core/js/a11y/wrapFocus",class WrapFocus extends Backbone.Controller{initialize({a11y:a11y}){this.a11y=a11y;_.bindAll(this,"_onWrapAround");this.listenTo(Adapt$1,{"accessibility:ready":this._attachEventListeners})}_attachEventListeners(){const config=this.a11y.config;$("body").on("click focus",config._options._focusguard,this._onWrapAround)}_onWrapAround(event){const config=this.a11y.config;if(!config._isEnabled||!config._options._isPopupWrapFocusEnabled){return}event.preventDefault();event.stopPropagation();this.a11y.focusFirst("body",{defer:false})}});var Popup=__AMD("core/js/a11y/popup",class Popup extends Backbone.Controller{initialize({a11y:a11y}){this.a11y=a11y;this._floorStack=[$("body")];this._focusStack=[];this._tabIndexes={};this._ariaHiddens={};this._elementUIDIndex=0;this.listenTo(Adapt$1,{"popup:opened"($element,ignoreInternalTrigger){if(ignoreInternalTrigger){return}this.a11y.log.deprecated('Adapt.trigger("popup:opened", $element) is replaced with a11y.popupOpened($element);');this.opened($element,true)},"popup:closed"($target,ignoreInternalTrigger){if(ignoreInternalTrigger){return}this.a11y.log.deprecated('Adapt.trigger("popup:closed", $target) is replaced with a11y.popupClosed($target);');this.closed($target,true)}})}get isOpen(){return this._floorStack.length>1}get stack(){return this._floorStack.slice(1)}opened($popupElement,silent){$popupElement=$popupElement||$(document.activeElement);this._addPopupLayer($popupElement);if(!silent){Adapt$1.trigger("popup:opened",$popupElement,true)}return this}_addPopupLayer($popupElement){$popupElement=$($popupElement);const config=this.a11y.config;if(!config._isEnabled||!config._options._isPopupManagementEnabled||$popupElement.length===0){return $popupElement}this._floorStack.push($popupElement);this._focusStack.push($(document.activeElement));let $elements=$(config._options._tabbableElements).filter(config._options._tabbableElementsExcludes);const $branch=$popupElement.add($popupElement.parents());const $siblings=$branch.siblings().filter(config._options._tabbableElementsExcludes);$elements=$elements.add($siblings);$elements.each(((index,item)=>{const $item=$(item);if(typeof item.a11y_uid==="undefined"){item.a11y_uid="UID"+ ++this._elementUIDIndex}const elementUID=item.a11y_uid;if(this._tabIndexes[elementUID]===undefined){this._tabIndexes[elementUID]=[]}if(this._ariaHiddens[elementUID]===undefined){this._ariaHiddens[elementUID]=[]}const tabindex=$item.attr("tabindex");const ariaHidden=$item.attr("aria-hidden");this._tabIndexes[elementUID].push(tabindex===undefined?"":tabindex);this._ariaHiddens[elementUID].push(ariaHidden===undefined?"":ariaHidden);if(config._options._isPopupTabIndexManagementEnabled){$item.attr("tabindex",-1)}if(config._options._isPopupAriaHiddenManagementEnabled){$item.attr("aria-hidden",true)}}));const $items=$popupElement.find(config._options._tabbableElements).filter(config._options._tabbableElementsExcludes);if(config._options._isPopupTabIndexManagementEnabled){$items.attr("tabindex",0)}if(config._options._isPopupAriaHiddenManagementEnabled){$items.removeAttr("aria-hidden").removeClass("aria-hidden").parents(config._options._ariaHiddenExcludes).removeAttr("aria-hidden").removeClass("aria-hidden")}}closed($focusElement,silent){const $previousFocusElement=this._removeLastPopupLayer();$focusElement=$focusElement||$previousFocusElement||$("body");if(!silent){Adapt$1.trigger("popup:closed",$focusElement,true)}this.a11y.focusFirst($($focusElement),{preventScroll:true});return this}_removeLastPopupLayer(){const config=this.a11y.config;if(!config._isEnabled||!config._options._isPopupManagementEnabled){return $(document.activeElement)}if(this._floorStack.length<=1){return}this._floorStack.pop();$(config._options._tabbableElements).filter(config._options._tabbableElementsExcludes).each(((index,item)=>{const $item=$(item);let previousTabIndex="";let previousAriaHidden="";if(typeof item.a11y_uid==="undefined"){item.a11y_uid="UID"+ ++this._elementUIDIndex}const elementUID=item.a11y_uid;if(this._tabIndexes[elementUID]?.length){previousTabIndex=this._tabIndexes[elementUID].pop();previousAriaHidden=this._ariaHiddens[elementUID].pop()}if(this._tabIndexes[elementUID]?.length){delete this._tabIndexes[elementUID];delete this._ariaHiddens[elementUID]}if(config._options._isPopupTabIndexManagementEnabled){if(previousTabIndex===""){$item.removeAttr("tabindex")}else{$item.attr({tabindex:previousTabIndex})}}if(config._options._isPopupAriaHiddenManagementEnabled){if(previousAriaHidden===""){$item.removeAttr("aria-hidden")}else{$item.attr({"aria-hidden":previousAriaHidden})}}}));return this._focusStack.pop()}setCloseTo($focusElement){const $original=this._focusStack.pop();this._focusStack.push($focusElement);return $original}});var defaultAriaLevels=__AMD("core/js/enums/defaultAriaLevels",{_menu:1,_menuGroup:2,_menuItem:2,_page:1,_article:2,_block:3,_component:4,_componentItem:5,_notify:1});var deprecated=__AMD("core/js/a11y/deprecated",(function(a11y){Object.assign($.fn,{isFixedPostion(){a11y.log.removed('$("..").isFixedPostion was unneeded and has been removed, let us know if you need it back.');return false},a11y_aria_label(){a11y.log.removed('$("..").a11y_aria_label was incorrect behaviour.');return this},limitedScrollTo(){a11y.log.removed("$.limitedScrollTo had no impact on the screen reader cursor.");return this},a11y_text(){a11y.log.removed("a11y_text is no longer required. https://tink.uk/understanding-screen-reader-interaction-modes/");return this},a11y_selected(){a11y.log.removed('$("..").a11y_selected is removed. Please use aria-live instead.');return this},a11y_on(isOn){a11y.log.deprecated('$("..").a11y_on, use a11y.findTabbable($element); and a11y.toggleAccessible($elements, isAccessible); instead.');const $tabbable=a11y.findTabbable(this);a11y.toggleAccessible($tabbable,isOn);return this},a11y_only(){a11y.log.removed('$("..").a11y_only, use a11y.popupOpened($popupElement); instead.');return this},scrollDisable(){if(a11y.config._options._isScrollDisableEnabled===false){return this}a11y.log.deprecated('$("..").scrollDisable, use a11y.scrollDisable($elements); instead.');a11y.scrollDisable(this);return this},scrollEnable(){if(a11y.config._options._isScrollDisableEnabled===false){return this}a11y.log.deprecated('$("..").scrollEnable, use a11y.scrollEnable($elements); instead.');a11y.scrollEnable(this);return this},a11y_popup(){a11y.log.deprecated('$("..").a11y_popup, use a11y.popupOpened($popupElement); instead.');return a11y.popupOpened(this)},a11y_cntrl(isOn,withDisabled){a11y.log.deprecated('$("..").a11y_cntrl, use a11y.toggleAccessible($elements, isAccessible); and if needed a11y.toggleEnabled($elements, isEnabled); instead.');a11y.toggleAccessible(this,isOn);if(withDisabled)a11y.toggleEnabled(this,isOn);return this},a11y_cntrl_enabled(isOn){a11y.log.deprecated('$("..").a11y_cntrl_enabled, use a11y.toggleAccessibleEnabled($elements, isAccessibleEnabled); instead.');a11y.toggleAccessibleEnabled(this,isOn);return this},isReadable(){a11y.log.deprecated('$("..").isReadable, use a11y.isReadable($element); instead.');return a11y.isReadable(this)},findForward(selector){a11y.log.removed('$("..").findForward has been removed as the use cases are very small, let us know if you need it back.');return a11y._findFirstForward(this,selector)},findWalk(selector){a11y.log.removed('$("..").findWalk has been removed as the use cases are very small, let us know if you need it back.');return a11y._findFindForwardDescendant(this,selector)},focusNoScroll(){a11y.log.deprecated('$("..").focusNoScroll, use a11y.focus($element); instead.');return a11y.focus(this)},focusNext(returnOnly){a11y.log.deprecated('$("..").focusNext, use a11y.focusNext($element); or if needed a11y.findFirstReadable($element); instead.');if(returnOnly){return a11y.findFirstReadable(this)}return a11y.focusNext(this)},focusOrNext(returnOnly){a11y.log.deprecated('$("..").focusOrNext, use a11y.focusFirst($element); or if needed a11y.findFirstReadable($element); or a11y.isReadable($element); instead.');if(returnOnly){if(a11y.isReadable(this))return this;return a11y.findFirstReadable(this)}return a11y.focusFirst(this)},a11y_focus(dontDefer){a11y.log.deprecated('$("..").a11y_focus, use a11y.focusFirst($element, { defer: true }); instead.');a11y.focusFirst(this,{defer:!dontDefer});return this}});Object.assign($,{a11y_alert(){a11y.log.removed("$.a11y_alert is removed. Please use aria-live instead.");return this},a11y_update(){a11y.log.removed("a11y_update is no longer required.");return this},a11y_text(text){a11y.log.removed("a11y_text is no longer required. https://tink.uk/understanding-screen-reader-interaction-modes/");return text},a11y_on(isOn,selector){a11y.log.deprecated('$("..").a11y_on, use a11y.toggleHidden($elements, isHidden); instead.');return a11y.toggleHidden(selector,!isOn)},a11y_popdown($focusTarget){a11y.log.removed("$.a11y_popdown, use a11y.popupClosed($focusTarget); instead.");return a11y.popupClosed($focusTarget)},a11y_focus(dontDefer){a11y.log.deprecated('$.a11y_focus, use a11y.focusFirst("body", { defer: true }); instead.');a11y.focusFirst("body",{defer:!dontDefer});return this},a11y_normalize(html){a11y.log.deprecated('$.a11y_normalize, use a11y.normalize("html"); instead.');return a11y.normalize(html)},a11y_remove_breaks(html){a11y.log.deprecated('$.a11y_remove_breaks, use a11y.removeBreaks("html"); instead.');return a11y.removeBreaks(html)}})}));class Components extends Backbone__default["default"].Controller{initialize(){this._register={};this.register=this.register.bind(this);this.getViewName=this.getViewName.bind(this);this.getViewClass=this.getViewClass.bind(this);this.getModelName=this.getModelName.bind(this);this.getModelClass=this.getModelClass.bind(this)}register(name,object){if(Array.isArray(name)){name.forEach((name=>this.register(name,object)));return object}if(name.split(" ").length>1){this.register(name.split(" "),object);return object}if(!object.view&&!object.model||object instanceof Backbone__default["default"].View){logging$1.deprecated("View-only registrations are no longer supported");object={view:object}}if(object.view&&!object.view.template){object.view.template=name}const isModelSetAndInvalid=object.model&&!(object.model.prototype instanceof Backbone__default["default"].Model)&&!(object.model instanceof Function);if(isModelSetAndInvalid){throw new Error("The registered model is not a Backbone.Model or Function")}const isViewSetAndInvalid=object.view&&!(object.view.prototype instanceof Backbone__default["default"].View)&&!(object.view instanceof Function);if(isViewSetAndInvalid){throw new Error("The registered view is not a Backbone.View or Function")}this._register[name]=Object.assign({},this._register[name],object);return object}getViewName(nameModelViewOrData){if(typeof nameModelViewOrData==="string"){return nameModelViewOrData}if(nameModelViewOrData instanceof Backbone__default["default"].Model){nameModelViewOrData=nameModelViewOrData.toJSON()}if(nameModelViewOrData instanceof Backbone__default["default"].View){let foundName;Object.entries(this._register).forEach((([key,entry])=>{if(!entry?.view)return;if(!(nameModelViewOrData instanceof entry.view))return;foundName=key;return true}));return foundName}if(nameModelViewOrData instanceof Object){const names=[typeof nameModelViewOrData._view==="string"&&nameModelViewOrData._view,typeof nameModelViewOrData._component==="string"&&nameModelViewOrData._component,typeof nameModelViewOrData._type==="string"&&nameModelViewOrData._type].filter(Boolean);if(names.length){const name=names.find((name=>this._register[name]?.view));return name||names.pop()}}throw new Error("Cannot derive view class name from input")}getViewClass(nameModelViewOrData){const name=this.getViewName(nameModelViewOrData);const object=this._register[name];if(!object){logging$1.error(`A view for '${name}' isn't registered in your project`);return}const isBackboneView=object.view?.prototype instanceof Backbone__default["default"].View;if(!isBackboneView&&object.view instanceof Function){return object.view()}return object.view}getModelName(nameModelOrData){if(typeof nameModelOrData==="string"){return nameModelOrData}if(nameModelOrData instanceof Backbone__default["default"].Model){nameModelOrData=nameModelOrData.toJSON()}if(nameModelOrData instanceof Object){const name=nameModelOrData._component;const entry=this._register[name];const isViewOnlyQuestion=entry&&!entry.model&&entry.view?._isQuestionType;if(isViewOnlyQuestion){logging$1.deprecated(`Assuming a question model for a view-only question: ${name}`);return"question"}const names=[typeof nameModelOrData._model==="string"&&nameModelOrData._model,typeof nameModelOrData._component==="string"&&nameModelOrData._component,typeof nameModelOrData._type==="string"&&nameModelOrData._type].filter(Boolean);if(names.length){const name=names.find((name=>this._register[name]?.model));return name||names.pop()}}throw new Error("Cannot derive model class name from input")}getModelClass(nameModelOrData){const name=this.getModelName(nameModelOrData);const object=this._register[name];if(!object){logging$1.error(`A model for '${name}' isn't registered in your project`);return}const isBackboneModel=object.model?.prototype instanceof Backbone__default["default"].Model;if(!isBackboneModel&&object.model instanceof Function){return object.model()}return object.model}}const components=new Components;var components$1=__AMD("core/js/components",components);var AdaptCollection=__AMD("core/js/collections/adaptCollection",class AdaptCollection extends Backbone.Collection{initialize(models,options){this.once("reset",this.loadedData,this)}loadedData(){Adapt$1.trigger("adaptCollection:dataLoaded")}});var BuildModel=__AMD("core/js/models/buildModel",class BuildModel extends LockingModel{defaults(){return{jsonext:"json"}}initialize(attrs,options){this.url=options.url;this.fetch({success:()=>{this.isLoaded=true;Adapt$1.trigger("buildModel:dataLoaded")},error:()=>{console.log("Unable to load adapt/js/build.js");Adapt$1.trigger("buildModel:dataLoaded")}})}isFrameworkVersion(version){return semver__default["default"].satisfies(this.get("package").version,version,{includePrerelease:true})}isPluginInstalled(name,version="*"){const plugin=this.get("plugins").find((plugin=>{if(plugin.name!==name)return false;return semver__default["default"].satisfies(plugin.version,version,{includePrerelease:true})}));return Boolean(plugin)}whenReady(){if(this.isLoaded)return Promise.resolve();return new Promise((resolve=>{Adapt$1.once("buildModel:dataLoaded",resolve)}))}});var ConfigModel=__AMD("core/js/models/configModel",class ConfigModel extends LockingModel{defaults(){return{screenSize:null,_forceRouteLocking:false,_canLoadData:true,_disableAnimation:false}}setValuesFromURLParams(){const paramMappings={dir:"_defaultDirection",lang:"_defaultLanguage"};const params=new URLSearchParams(window.location.search);Object.entries(paramMappings).forEach((([key,value])=>{const passedVal=params.get(key);if(!passedVal)return;if(key==="lang"&&Adapt$1.build.get("availableLanguageNames")?.includes(passedVal)===false)return;this.set(value,passedVal)}))}initialize(attrs,options){this.url=options.url;this.fetch({success:()=>{this.setValuesFromURLParams();Adapt$1.trigger("offlineStorage:prepare");Wait$1.queue((()=>{Adapt$1.trigger("configModel:dataLoaded");if(!this.get("_canLoadData"))return;Adapt$1.trigger("configModel:loadCourseData")}))},error:()=>logging$1.error("Unable to load course/config.json")})}loadData(){}});class Data extends AdaptCollection{model(json){const ModelClass=components$1.getModelClass(json);if(!ModelClass){return new LockingModel(json)}return new ModelClass(json,{parse:true})}initialize(){super.initialize();this.findById=this.findById.bind(this);this.findViewByModelId=this.findViewByModelId.bind(this);this.findByTrackingPosition=this.findByTrackingPosition.bind(this);this.on({add:this.onAdded,remove:this.onRemoved})}async init(){this.reset();this._byAdaptID={};Adapt$1.build=new BuildModel(null,{url:"adapt/js/build.min.js",reset:true});await Adapt$1.build.whenReady();$("html").attr("data-adapt-framework-version",Adapt$1.build.get("package").version);this.loadConfigData()}onAdded(model){this._byAdaptID[model.get("_id")]=model}onRemoved(model){delete this._byAdaptID[model.get("_id")]}loadConfigData(){Adapt$1.config=new ConfigModel(null,{url:Adapt$1.build.get("coursedir")+"/config."+Adapt$1.build.get("jsonext"),reset:true});this.listenToOnce(Adapt$1,"configModel:loadCourseData",this.onLoadCourseData);this.listenTo(Adapt$1.config,{"change:_activeLanguage":this.onLanguageChange,"change:_defaultDirection":this.onDirectionChange})}onDirectionChange(model,direction){if(direction==="rtl"){$("html").removeClass("dir-ltr").addClass("dir-rtl").attr("dir","rtl")}else{$("html").removeClass("dir-rtl").addClass("dir-ltr").attr("dir","ltr")}}onLoadCourseData(){if(!Adapt$1.config.get("_activeLanguage")){Adapt$1.config.set("_activeLanguage",Adapt$1.config.get("_defaultLanguage"));return}this.loadCourseData()}async onLanguageChange(model,language){await Wait$1.queue();const previousAttributes=model.previousAttributes();const previousLanguage=previousAttributes._activeLanguage;offlineStorage$1.set("lang",language);if(Adapt$1.get("_isStarted")){Adapt$1.set("_isStarted",false)}this.loadCourseData(language,previousLanguage)}async loadCourseData(newLanguage,previousLanguage){const language=Adapt$1.config.get("_activeLanguage");const courseFolder=Adapt$1.build.get("coursedir")+"/"+language+"/";$("html").attr("lang",language);await this.loadManifestFiles(courseFolder);await this.triggerDataLoaded();await this.triggerDataReady(newLanguage,previousLanguage);this.triggerInit()}getJSON(path){return new Promise(((resolve,reject)=>{$.getJSON(path,(data=>{data.__path__=path;resolve(data)})).fail((()=>{reject(new Error(`Unable to load ${path}`))}))}))}async loadManifestFiles(languagePath){this.trigger("loading");this.reset();this._byAdaptID={};const manifestPath=languagePath+"language_data_manifest.js";let manifest;try{manifest=await this.getJSON(manifestPath)}catch(err){manifest=["course.json","contentObjects.json","articles.json","blocks.json","components.json"];logging$1.error(`Manifest path '${manifestPath} not found. Using traditional files: ${manifest.join(", ")}`)}let allFileData;try{allFileData=await Promise.all(manifest.map((filePath=>this.getJSON(`${languagePath}${filePath}`))))}catch(error){logging$1.error(error);return}const allModelData=allFileData.reduce(((result,fileData)=>{if(Array.isArray(fileData)){fileData.forEach(((datum,index)=>{datum.__path__=fileData.__path__;datum.__index__=index}));result.push(...fileData)}else if(fileData instanceof Object){result.push(fileData)}else{logging$1.warnOnce(`File data isn't an array or object: ${fileData.__path__}`)}return result}),[]);const course=allModelData.find((modelData=>modelData._type==="course"));if(!course){throw new Error('Expected a model data with "_type": "course", none found.')}Adapt$1.trigger("courseModel:dataLoading");Adapt$1.course=this.push(course);Adapt$1.trigger("courseModel:dataLoaded");allModelData.forEach((modelData=>{if(modelData._type==="course"){return}try{components$1.getModelName(modelData)}catch(error){logging$1.error(`Failed to load object ${modelData.__path__}${Object.hasOwn(modelData,"__index__")?`[${modelData.__index__}]`:""}`);logging$1.error(error);return}this.push(modelData)}));this.checkData();this.trigger("reset");this.trigger("loaded");await Wait$1.queue()}async triggerDataLoaded(){logging$1.debug("Firing app:dataLoaded");try{this.forEach((model=>model.setupModel?.()));Adapt$1.trigger("app:dataLoaded")}catch(e){logging$1.error("Error during app:dataLoading trigger",e)}await Wait$1.queue()}async triggerDataReady(newLanguage,previousLanguage){if(newLanguage){Adapt$1.trigger("app:languageChanged",newLanguage,previousLanguage);await Wait$1.queue()}logging$1.debug("Firing app:dataReady");try{Adapt$1.trigger("app:dataReady")}catch(e){logging$1.error("Error during app:dataReady trigger",e)}await Wait$1.queue()}triggerInit(){this.isReady=true;this.trigger("ready")}whenReady(){if(this.isReady)return Promise.resolve();return new Promise((resolve=>{this.once("ready",resolve)}))}hasId(id){return Boolean(this._byAdaptID[id])}findById(id){const model=this._byAdaptID[id];if(!model){logging$1.warn(`data.findById() unable to find id: ${id}`);return}return model}findViewByModelId(id){const model=this.findById(id);if(!model||!Adapt$1.parentView)return;const idPathToView=[id];const currentLocationId=location$1._currentId;const currentLocationModel=model.getAncestorModels().find((model=>{const modelId=model.get("_id");if(modelId===currentLocationId)return true;idPathToView.unshift(modelId);return false}));if(!currentLocationModel){return logging$1.warn(`data.findViewByModelId() unable to find view for model id: ${id}`)}const foundView=idPathToView.reduce(((view,currentId)=>{if(!view)return null;const childViews=view.getChildViews();return childViews?.find((view=>view.model.get("_id")===currentId))}),Adapt$1.parentView);return foundView}findByTrackingPosition(trackingPosition){const[trackingId,indexInTrackingIdDescendants]=trackingPosition;const trackingIdModel=this.find((model=>model.get("_trackingId")===trackingId));if(!trackingIdModel){logging$1.warn(`data.findByTrackingPosition() unable to find trackingPosition: ${trackingPosition}`);return}if(indexInTrackingIdDescendants>=0){let trackingIdDescendants=[trackingIdModel].concat(trackingIdModel.getAllDescendantModels(true));trackingIdDescendants=trackingIdDescendants.filter((model=>!(model.isTypeGroup("component")&&model.get("_isTrackable")===false)));return trackingIdDescendants[indexInTrackingIdDescendants]}const trackingIdAncestors=trackingIdModel.getAncestorModels();const ancestorDistance=Math.abs(indexInTrackingIdDescendants)-1;return trackingIdAncestors[ancestorDistance]}logReadyError(view){const notReadyDescendants=view.model.getAllDescendantModels(true).filter((model=>!model.get("_isReady")));logging$1.error(`View ${notReadyDescendants.map((model=>`${model.get("_id")} (${model.get("_component")??model.get("_type")})`)).join(", ")} failed to become ready, forcing ready status.`);notReadyDescendants.reverse().forEach((model=>model.set("_isReady",true)))}checkData(){this.checkIds();this.checkTrackingIds()}checkIds(){const items=this.toJSON();const idIndex=___default["default"].indexBy(items,"_id");const idGroups=___default["default"].groupBy(items,"_id");const parentIdGroups=___default["default"].groupBy(items,"_parentId");let orphanedIds={};let emptyIds={};let duplicateIds={};let missingIds={};items.forEach((o=>{const isCourseType=o._type==="course";const isComponentType=o._type==="component";if(idGroups[o._id].length>1){duplicateIds[o._id]=true}if(!isComponentType&&!parentIdGroups[o._id]){emptyIds[o._id]=true}if(!isCourseType&&(!o._parentId||!idIndex[o._parentId])){orphanedIds[o._id]=true}if(!isCourseType&&o._parentId&&!idIndex[o._parentId]){missingIds[o._parentId]=true}}));orphanedIds=Object.keys(orphanedIds);emptyIds=Object.keys(emptyIds);duplicateIds=Object.keys(duplicateIds);missingIds=Object.keys(missingIds);const hasErrored=orphanedIds.length||emptyIds.length||duplicateIds.length||missingIds.length;if(orphanedIds.length){logging$1.error(`Orphaned _ids: ${orphanedIds.join(", ")}`)}if(missingIds.length){logging$1.error(`Missing _ids: ${missingIds.join(", ")}`)}if(emptyIds.length){logging$1.error(`Empty _ids: ${emptyIds.join(", ")}`)}if(duplicateIds.length){logging$1.error(`Duplicate _ids: ${duplicateIds.join(", ")}`)}if(hasErrored){const err=new Error("Oops, looks like you have some json errors.");err.number=10011;throw err}}checkTrackingIds(){const items=this.toJSON();const trackingIdType=Adapt$1.build.get("trackingIdType")||"block";const trackingIdCounts=___default["default"].groupBy(items.filter((item=>item._type===trackingIdType)),"_trackingId");const missingTrackingIds=items.filter((item=>item._type===trackingIdType&&item._trackingId===undefined)).map((item=>item._id));if(missingTrackingIds.length){logging$1.error(`Missing _trackingIds: ${missingTrackingIds.join(", ")}`)}const duplicateTrackingIds=Object.entries(trackingIdCounts).filter((([id,group])=>group.length>1)).map((([id,group])=>`${id}:[${group.map((item=>item._id)).join(", ")}]`));if(duplicateTrackingIds.length){logging$1.error(`Duplicate _trackingIds: ${duplicateTrackingIds.join(", ")}`)}const hasErrored=missingTrackingIds.length||duplicateTrackingIds.length;if(hasErrored){const err=new Error("Oops, looks like you have some json errors with trackingIds.");err.number=10011;throw err}}}const data=new Data;var data$1=__AMD("core/js/data",data);class A11y extends Backbone.Controller{defaults(){return{_isPrefersReducedMotionEnabled:true,_isFocusOutlineKeyboardOnlyEnabled:true,_isFocusOutlineDisabled:false,_isFocusAssignmentEnabled:true,_isFocusOnClickEnabled:true,_isClickDelayedAfterFocusEnabled:false,_isFocusNextOnDisabled:true,_isScrollDisableEnabled:true,_isAriaHiddenManagementEnabled:true,_isPopupManagementEnabled:true,_isPopupWrapFocusEnabled:true,_isPopupAriaHiddenManagementEnabled:true,_isPopupTabIndexManagementEnabled:true,_ariaHiddenExcludes:":not(#wrapper):not(body)",_tabbableElements:"a,button,input,select,textarea,[tabindex]:not([data-a11y-force-focus])",_focusOutlineKeyboardOnlyIgnore:"input,textarea",_tabbableElementsExcludes:":not(.a11y-ignore):not([data-a11y-force-focus])",_focusableElements:"a,button,input,select,textarea,[tabindex],label",_readableElements:"[role=heading],[aria-label],[aria-labelledby],[alt]",_focusForwardElementsExcludes:":not([aria-labelledby][role=dialog],[aria-labelledby][role=main],[aria-labelledby][role=region],[aria-labelledby][role=radiogroup],[aria-labelledby][role=group],[aria-labelledby][role=tablist],[aria-labelledby][role=list],[aria-labelledby][role=tree],[aria-labelledby][role=treegrid],[aria-labelledby][role=table],[aria-labelledby][role=grid][aria-labelledby],[role=menu],[aria-labelledby][role=rowgroup])",_focusguard:".a11y-focusguard",_wrapStyleElements:"b,i,abbr,strong,em,small,sub,sup,ins,del,mark,zw,nb",_arrowElements:"input[type=radio]",_warnFirstOnly:true,_warn:true}}initialize(){this.isFocusable=this.isFocusable.bind(this);this.isReadable=this.isReadable.bind(this);this.isTabbable=this.isTabbable.bind(this);this.$html=$("html");this._htmlCharRegex=/&.*;/g;this.config=null;this._browserConfig=new BrowserConfig({a11y:this});this._browserFocus=new BrowserFocus({a11y:this});this._keyboardFocusOutline=new KeyboardFocusOutline({a11y:this});this._wrapFocus=new WrapFocus({a11y:this});this._popup=new Popup({a11y:this});this._scroll=new Scroll({a11y:this});this._isForcedFocus=false;this.log=new Log({a11y:this});deprecated(this);this._removeLegacyElements();this.listenToOnce(Adapt$1,{"configModel:dataLoaded":this._onConfigDataLoaded,"navigationView:postRender":this._removeLegacyElements},this);Adapt$1.on("device:changed",this._setupNoSelect);this.listenTo(Adapt$1,{"router:location":this._onNavigationStart,"contentObjectView:ready router:plugin":this._onNavigationEnd})}_onConfigDataLoaded(){this.config=Adapt$1.config.get("_accessibility");this.config._isActive=false;this.config._options=_.defaults(this.config._options||{},this.defaults());offlineStorage$1.set("a11y",false);this.$html.toggleClass("has-accessibility",this.isEnabled());this._setupNoSelect();this._addFocuserDiv();if(this._isReady){return}this._isReady=true;Adapt$1.trigger("accessibility:ready")}_setupNoSelect(){if(!this.config?._disableTextSelectOnClasses){return}const classes=this.config._disableTextSelectOnClasses.split(" ");const isMatch=classes.some((className=>this.$html.is(className)));this.$html.toggleClass("u-no-select",isMatch)}_addFocuserDiv(){if($("#a11y-focuser").length){return}$("body").append($('<div id="a11y-focuser" class="a11y-ignore" tabindex="-1">&nbsp;</div>'))}_removeLegacyElements(){const $legacyElements=$("body").children("#accessibility-toggle, #accessibility-instructions");const $navigationElements=$(".nav").find("#accessibility-toggle, #accessibility-instructions");if(!$legacyElements.length&&!$navigationElements.length){return}logging$1.warn("REMOVED: #accessibility-toggle and #accessibility-instructions have been removed. Please remove them from all of your .html files.");$legacyElements.remove();$navigationElements.remove()}_onNavigationStart(){if(!this.isEnabled()){return}_.defer((()=>this.toggleHidden(".contentobject",true)))}_onNavigationEnd(view){if(view?.model?.get("_id")!==location$1._currentId||!this.isEnabled()){return}this.toggleHidden(".contentobject",false)}isActive(){this.log.removed("Accessibility is now always active when enabled. Please unify your user experiences.");return false}isEnabled(){return this.config?._isEnabled}ariaLevel({id:id=null,level:level="1",override:override=null}={}){if(level==="course")level="menu";if(arguments.length===2){level=arguments[0];override=arguments[1];id=null}const ariaLevels=Adapt$1.config.get("_accessibility")?._ariaLevels??defaultAriaLevels;if(override===0)override=null;function calculateLevel(id=null,level,offset=0){const isNumber=!isNaN(level);const isTypeName=/[a-zA-z]/.test(level);if(!isTypeName&&isNumber){return parseInt(level)+offset}const relativeDescriptor=Adapt$1.parseRelativeString(level);const nextLevel=ariaLevels?.["_"+relativeDescriptor.type];const hasModelId=Boolean(id);if(!hasModelId){logging$1.warnOnce("Cannot calculate appropriate heading level, no model id was specified");return calculateLevel(id,nextLevel,offset+relativeDescriptor.offset)}const nextModel=data$1.findById(id)?.findAncestor(relativeDescriptor.type?.toLowerCase())??data$1.findById(id);const nextModelId=nextModel?.get("_id")??id;const hasNextTitle=Boolean(nextModel.get("displayTitle"));let nextModelOverride=nextModel.get("_ariaLevel");if(nextModelOverride===0)nextModelOverride=null;const accumulatedOffset=offset+(hasNextTitle?relativeDescriptor.offset:0);const resolvedLevel=nextModelOverride??nextLevel;return calculateLevel(nextModelId,resolvedLevel,accumulatedOffset)}return calculateLevel(id,override??level)}toggleHidden($elements,isHidden=true){$elements=$($elements);const config=this.config;if(!config._isEnabled||!config._options._isAriaHiddenManagementEnabled){return this}if(isHidden===true){$elements.attr("aria-hidden",true)}else{$elements.removeAttr("aria-hidden")}return this}toggleAccessibleEnabled($elements,isAccessibleEnabled){this.toggleAccessible($elements,isAccessibleEnabled);this.toggleEnabled($elements,isAccessibleEnabled);return this}toggleAccessible($elements,isReadable=true){$elements=$($elements);const config=this.config;if(!config._isEnabled||!config._options._isAriaHiddenManagementEnabled||$elements.length===0){return this}if(!isReadable){$elements.attr({tabindex:"-1","aria-hidden":"true"}).addClass("aria-hidden")}else{$elements.removeAttr("aria-hidden tabindex").removeClass("aria-hidden");$elements.parents(config._options._ariaHiddenExcludes).removeAttr("aria-hidden").removeClass("aria-hidden")}return this}toggleEnabled($elements,isEnabled=true){$elements=$($elements);if($elements.length===0){return this}if(!isEnabled){$elements.attr({"aria-disabled":"true"}).addClass("is-disabled")}else{$elements.removeAttr("aria-disabled").removeClass("is-disabled")}return this}toggleTabbableDescendants($element,isTabbable=true){const $tabbable=this.findTabbable($element);if(!isTabbable){$tabbable.each(((index,element)=>{if(element.isAdaptTabHidden)return;const $element=$(element);element.isAdaptTabHidden=true;element.adaptPreviousTabIndex=$element.attr("tabindex")??null;$element.attr("tabindex",-1)}));return this}$tabbable.each(((index,element)=>{if(!element.isAdaptTabHidden)return;const $element=$(element);if(element.adaptPreviousTabIndex===null)$element.removeAttr("tabindex");else $element.attr("tabindex",element.adaptPreviousTabIndex);delete element.isAdaptTabHidden;delete element.adaptPreviousTabIndex}));return this}findFirstTabbable($element){$element=$($element).first();return this._findFirstForward($element,this.isTabbable)}findFirstReadable($element){$element=$($element).first();return this._findFirstForward($element,this.isReadable)}findFirstFocusable($element){$element=$($element).first();return this._findFirstForward($element,this.isFocusable)}findTabbable($element){const config=this.config;return $($element).find(config._options._tabbableElements).filter(config._options._tabbableElementsExcludes)}findReadable($element){return $($element).find("*").filter(((index,element)=>this.isReadable(element)))}findFocusable($element){return $($element).find("*").filter(((index,element)=>this.isFocusable(element)))}isTabbable($element){const config=this.config;const value=$($element).is(config._options._tabbableElements).is(config._options._tabbableElementsExcludes);if(!value){return null}return value}isReadable($element,checkParents=true){const config=this.config;$element=$($element).first();const $branch=checkParents?$element.add($element.parents()):$element;const isInDOM=Boolean($element.parents("body").length);if(!isInDOM)return false;const isNotVisible=$branch.toArray().some((item=>{const style=window.getComputedStyle(item);return style.display==="none"||style.visibility==="hidden"||item.getAttribute("aria-hidden")==="true"}));if(isNotVisible){return false}const hasReadableContent=!/^\s*$/.test($element.text())||!/^\s*$/.test($element.attr("aria-label")??"")||!/^\s*$/.test($element.attr("aria-labelledby")??"");const hasNativeFocusOrIsScreenReadable=($element.is(config._options._focusableElements)||$element.is(config._options._readableElements))&&hasReadableContent;if(hasNativeFocusOrIsScreenReadable){return true}const childNodes=$element[0].childNodes;for(let c=0,cl=childNodes.length;c<cl;c++){const childNode=childNodes[c];const isTextNode=childNode.nodeType===3;if(!isTextNode){continue}const isOnlyWhiteSpace=/^\s*$/.test(childNode.nodeValue);if(isOnlyWhiteSpace){continue}return true}return null}isFocusable($element,checkParents=true){const config=this.config;$element=$($element).first();if(!$element.is(config._options._focusForwardElementsExcludes))return null;return this.isReadable($element,checkParents)}isArrowable($element){const config=this.config;$element=$($element).first();return $element.is(config._options._arrowElements)}_findFirstForward($element,selector){$element=$($element).first();let iterator;switch(typeof selector){case"string":iterator=function($tag){return $tag.is(selector)||undefined};break;case"function":iterator=selector;break;case"undefined":iterator=Boolean}if($element.length===0){return $element.not("*")}let $found=this._findFirstForwardDescendant($element,iterator);if($found.length){return $found}$element.nextAll().toArray().some((sibling=>{const $sibling=$(sibling);const value=iterator($sibling);if(value===false){return false}if(value){$found=$sibling;return true}$found=this._findFirstForwardDescendant($sibling,iterator);return Boolean($found.length)}));if($found.length){return $found}$element.add($element.parents()).toArray().reverse().some((parent=>{const $parent=$(parent);if(iterator($parent)===false){return false}return $parent.nextAll().toArray().some((sibling=>{const $sibling=$(sibling);const value=iterator($sibling);if(value===false){return false}if(value){$found=$sibling;return true}$found=this._findFirstForwardDescendant($sibling,iterator);return Boolean($found.length)}))}));if(!$found.length){return $element.not("*")}return $found}_findFirstForwardDescendant($element,selector){$element=$($element).first();let iterator;switch(typeof selector){case"string":iterator=function($tag){return $tag.is(selector)||undefined};break;case"function":iterator=selector;break;case"undefined":iterator=Boolean}const $notFound=$element.not("*");if($element.length===0){return $notFound}const stack=[{item:$element[0],value:undefined}];let stackIndexPosition=0;let childIndexPosition=stackIndexPosition+1;do{const stackEntry=stack[stackIndexPosition];const $stackItem=$(stackEntry.item);switch(stackEntry.value){case true:return $stackItem;case false:return $notFound}$stackItem.children().toArray().forEach((item=>{const $item=$(item);const value=iterator($item);if(value===false){return}stack.splice(childIndexPosition++,0,{item:item,value:value})}));stackIndexPosition++;childIndexPosition=stackIndexPosition+1}while(stackIndexPosition<stack.length);return $notFound}focusNext($element,options){options=new FocusOptions(options);$element=$($element).first();$element=this.findFirstFocusable($element);this.focus($element,options);return this}focusFirst($element,options){options=new FocusOptions(options);$element=$($element).first();if(this.isReadable($element)){this.focus($element,options);return $element}$element=this.findFirstFocusable($element);this.focus($element,options);return $element}focus($element,options){options=new FocusOptions(options);$element=$($element).first();const config=this.config;if(!config._isEnabled||!config._options._isFocusAssignmentEnabled||$element.length===0){return this}const perform=()=>{if($element.attr("tabindex")===undefined){$element.attr({tabindex:"0","data-a11y-force-focus":"true"})}if(options.preventScroll){const y=$(window).scrollTop();try{this._isForcedFocus=true;$element[0].focus({preventScroll:true});this._isForcedFocus=false}catch(e){}switch(device$1.browser){case"internet explorer":case"microsoft edge":case"safari":window.scrollTo(null,y)}}else{this._isForcedFocus=true;$element[0].focus();this._isForcedFocus=false}};if(options.defer){_.defer(perform)}else{perform()}return this}get isForcedFocus(){return this._isForcedFocus}normalize(htmls){htmls=[...arguments].filter(Boolean).filter(_.isString).join(" ");const text=$("<div>"+htmls+"</div>").text();return text.replace(this._htmlCharRegex,"")}removeBreaks(htmls){htmls=[...arguments].filter(Boolean).filter(_.isString).join(" ");const $div=$("<div>"+htmls+"</div>");const stack=[$div[0]];let stackIndex=0;const outputs=[];do{if(stack[stackIndex].childNodes.length){const nodes=stack[stackIndex].childNodes;const usable=nodes.filter((node=>{const isTextNode=node.nodeType===3;if(isTextNode){return true}const isStyleElement=$(node).is(this.config._options._wrapStyleElements);if(isStyleElement){return true}return false}));outputs.push.apply(outputs,usable);stack.push.apply(stack,nodes)}stackIndex++}while(stackIndex<stack.length);let rtnText="";outputs.forEach((function(item){rtnText+=item.outerHTML||item.textContent}));return rtnText}scrollEnable($elements){this._scroll.enable($elements);return this}scrollDisable($elements){this._scroll.disable($elements);return this}popupOpened($popupElement){this._popup.opened($popupElement);return this}popupClosed($focusElement){this._popup.closed($focusElement);return this}setPopupCloseTo($focusElement){return this._popup.setCloseTo($focusElement)}get isPopupOpen(){return this._popup.isOpen}get popupStack(){return this._popup.stack}}const a11y=new A11y;var a11y$1=__AMD("core/js/a11y",a11y);class DrawerItemView extends Backbone.View{className(){return"drawer__menu drawer__item"}attributes(){return{role:"listitem"}}initialize(){this.listenTo(Adapt$1,"drawer:empty",this.remove);this.render()}events(){return{"click .drawer__item-btn":"onDrawerItemClicked"}}render(){const data=this.model.toJSON();const template=Handlebars.templates.drawerItem;$(this.el).html(template(data)).appendTo(".drawer__holder");return this}onDrawerItemClicked(event){event.preventDefault();const eventCallback=this.model.get("eventCallback");Adapt$1.trigger(eventCallback)}}DrawerItemView.type="drawerItem";var DrawerItemView$1=__AMD("core/js/views/drawerItemView",DrawerItemView);class DrawerView extends Backbone__default["default"].View{className(){return["drawer","u-display-none"].filter(Boolean).join(" ")}attributes(){return{role:"dialog","aria-modal":"true","aria-labelledby":"drawer-heading","aria-hidden":"true","aria-expanded":"false"}}events(){return{"click .drawer__back":"onBackButtonClicked","click .drawer__close":"onCloseClicked"}}initialize(){this._isVisible=false;this.disableAnimation=Adapt$1.config.has("_disableAnimation")?Adapt$1.config.get("_disableAnimation"):false;this._globalDrawerPosition=Adapt$1.config.get("_drawer")?._position??"auto";this.drawerDuration=Adapt$1.config.get("_drawer")?._duration??400;this.setupEventListeners();this.render()}setupEventListeners(){this.onKeyUp=this.onKeyUp.bind(this);$(window).on("keyup",this.onKeyUp)}onKeyUp(event){if(event.which!==27)return;event.preventDefault();this.hideDrawer()}render(){const template=Handlebars.templates.drawer;$(this.el).html(template({_globals:Adapt$1.course.get("_globals")})).prependTo("body");const shadowTemplate=Handlebars.templates.shadow;$(shadowTemplate()).prependTo("body");_.defer(this.postRender.bind(this));return this}postRender(){this.$("a, button, input, select, textarea").attr("tabindex",-1);this.checkIfDrawerIsAvailable()}setDrawerPosition(position){if(this._useMenuPosition)position=null;const isGlobalPositionAuto=this._globalDrawerPosition==="auto";const isRTL=Adapt$1.config.get("_defaultDirection")==="rtl";if(position&&isGlobalPositionAuto&&isRTL)position=position==="left"?"right":"left";if(!isGlobalPositionAuto||!position)position=this._globalDrawerPosition;this.$el.removeClass(`is-position-${this.drawerPosition}`).addClass(`is-position-${position}`);this.drawerPosition=position;this.drawerAnimationDir=position==="auto"?isRTL?"left":"right":position}openCustomView(view,hasBackButton=true,position){this.$(".js-drawer-holder").removeAttr("role");this._hasBackButton=hasBackButton;this._isCustomViewVisible=true;this._customView=view;Adapt$1.trigger("drawer:empty");this.showDrawer(null,position);this.$(".drawer__holder").html(view instanceof Backbone__default["default"].View?view.$el:view)}checkIfDrawerIsAvailable(){const isEmptyDrawer=this.collection.length===0;$(".js-nav-drawer-btn").toggleClass("u-display-none",isEmptyDrawer);if(isEmptyDrawer){Adapt$1.trigger("drawer:noItems")}}onBackButtonClicked(event){event.preventDefault();this.showDrawer(true)}onCloseClicked(event){event.preventDefault();this.hideDrawer()}get isOpen(){return this._isVisible&&this._isCustomViewVisible===false}showDrawer(emptyDrawer,position=null){this.setDrawerPosition(position);this.$el.removeClass("u-display-none").attr("aria-hidden","false").attr("aria-expanded","true");if(!this._isVisible){a11y$1.popupOpened(this.$el);a11y$1.scrollDisable("body");this._isVisible=true}this.$("a, button, input, select, textarea").attr("tabindex",0);if(emptyDrawer){this.$(".drawer__back").addClass("u-display-none");this._isCustomViewVisible=false;this.emptyDrawer();if(this.collection.models.length===1){Adapt$1.trigger(this.collection.models[0].get("eventCallback"));this._isCustomViewVisible=false}else{this._useMenuPosition=true;this.renderItems();Adapt$1.trigger("drawer:openedItemView")}}else{const hideDrawerBackButton=!this._hasBackButton||this.collection.models.length<=1;this.$(".drawer__back").toggleClass("u-display-none",hideDrawerBackButton);Adapt$1.trigger("drawer:openedCustomView")}$(".js-shadow").removeClass("u-display-none");$(".js-drawer-holder").scrollTop(0);const direction={};direction[this.drawerAnimationDir]=0;const complete=()=>{this.addShadowEvent();$(".js-nav-drawer-btn").attr("aria-expanded",true);Adapt$1.trigger("drawer:opened");a11y$1.focusFirst(this.$el,{defer:true})};if(this.disableAnimation){this.$el.css(direction);complete()}else{const easing=Adapt$1.config.get("_drawer")?._showEasing||"easeOutQuart";this.$el.velocity(direction,this.drawerDuration,easing);$(".js-shadow").velocity({opacity:1},{duration:this.drawerDuration,begin:()=>{complete()}})}}emptyDrawer(){this.$(".drawer__holder").empty()}renderItems(){Adapt$1.trigger("drawer:empty");this.emptyDrawer();const isList=this.collection.length>1;if(isList)this.$(".js-drawer-holder").attr("role","list");else this.$(".js-drawer-holder").removeAttr("role");this.collection.forEach((model=>new DrawerItemView$1({model:model})))}hideDrawer($toElement){if(!this._isVisible)return;this._useMenuPosition=false;const direction={};a11y$1.popupClosed($toElement);this._isVisible=false;a11y$1.scrollEnable("body");direction[this.drawerAnimationDir]=-this.$el.width();const complete=()=>{this.$el.removeAttr("style").addClass("u-display-none").attr("aria-hidden","true").attr("aria-expanded","false");this.$(".js-drawer-holder").removeAttr("role");this._customView=null;$(".js-nav-drawer-btn").attr("aria-expanded",false);Adapt$1.trigger("drawer:closed");this.setDrawerPosition(this._globalDrawerPosition)};if(this.disableAnimation){this.$el.css(direction);$(".js-shadow").addClass("u-display-none");complete()}else{const easing=Adapt$1.config.get("_drawer")?._hideEasing||"easeInQuart";this.$el.velocity(direction,this.drawerDuration,easing,(()=>{complete()}));$(".js-shadow").velocity({opacity:0},{duration:this.drawerDuration,complete(){$(".js-shadow").addClass("u-display-none")}})}this._isCustomViewVisible=false;this.removeShadowEvent()}addShadowEvent(){$(".js-shadow").one("click touchstart",(()=>this.hideDrawer()))}removeShadowEvent(){$(".js-shadow").off("click touchstart")}remove(){this.hideDrawer();super.remove();$(window).off("keyup",this.onKeyUp);Adapt$1.trigger("drawer:empty");this.collection.reset();$(".js-shadow").remove()}}Object.assign(DrawerView,{childContainer:".js-drawer-holder",childView:DrawerItemView$1});var DrawerView$1=__AMD("core/js/views/drawerView",DrawerView);var TemplateRenderEvent=__AMD("core/js/templateRenderEvent",class TemplateRenderEvent{constructor(type,name,mode,value,args){this.type=type;this.name=name;this.mode=mode;this.value=value;this.args=args}});var register=__AMD("core/js/reactHelpers",(function register(name,component){templates[name]=(...args)=>{const mode="reactTemplate";const preRenderEvent=new TemplateRenderEvent(`${mode}:preRender`,name,mode,null,args);Adapt$1.trigger(preRenderEvent.type,preRenderEvent);const value=component(...preRenderEvent.args);const postRenderEvent=new TemplateRenderEvent(`${mode}:postRender`,name,mode,value,preRenderEvent.args);Adapt$1.trigger(postRenderEvent.type,postRenderEvent);return postRenderEvent.value}}));(function(){const original=React__default["default"].createElement;React__default["default"].createElement=(...args)=>{const name=args[0];const mode="reactElement";const preRenderEvent=new TemplateRenderEvent(`${mode}:preRender`,name,mode,null,args);Adapt$1.trigger(preRenderEvent.type,preRenderEvent);const value=original(...preRenderEvent.args);const postRenderEvent=new TemplateRenderEvent(`${mode}:postRender`,name,mode,value,preRenderEvent.args);Adapt$1.trigger(postRenderEvent.type,postRenderEvent);return postRenderEvent.value}})();const templates={};function compile(template,...args){const output=Handlebars.compile(template)(...args);return output}function classes(...args){return _.uniq(_.flatten(args).filter(Boolean).join(" ").split(" ")).join(" ")}function prefixClasses(prefixes,...args){const classes=_.flatten(args).filter(Boolean);const prefixed=_.flatten(prefixes.map((prefix=>classes.map((className=>`${prefix}${className}`)))));return _.uniq(prefixed.join(" ").split(" ")).join(" ")}const FIRST_PASS=1;const SECOND_PASS=2;const THIRD_PASS=3;var TooltipItemView=__AMD("core/js/views/TooltipItemView",class TooltipItemView extends Backbone.View{className(){return["tooltip",this.model.get("isTargetFixedPosition")&&"is-fixed",this.model.get("tooltipClasses")||"is-vertical-axis is-arrow-middle is-bottom is-middle",this.model.get("isShown")&&"is-shown",this.model.get("_classes")].filter(Boolean).join(" ")}attributes(){return{id:`tooltip-${this.model.get("_id")}`,style:Object.entries(this.model.get("tooltipStyles")??{}).map((([name,value])=>`${name}: ${value};`)).join(" ")}}updateViewProperties(){const classesToAdd=_.result(this,"className").trim().split(/\s+/);classesToAdd.forEach((i=>this._classSet.add(i)));const classesToRemove=[...this._classSet].filter((i=>!classesToAdd.includes(i)));classesToRemove.forEach((i=>this._classSet.delete(i)));this._setAttributes({..._.result(this,"attributes"),id:_.result(this,"id")});this.$el.removeClass(classesToRemove).addClass(classesToAdd)}initialize({$target:$target,parent:parent}){_.bindAll(this,"onDeviceResize","onMouseOut","doSubsequentPasses");this._classSet=new Set(_.result(this,"className").trim().split(/\s+/));this.$target=$target;this.parent=parent;this.$target.attr("aria-describedby",`tooltip-${this.model.get("_id")}`);this.model.set("ariaLabel",this.$target.attr("aria-label")||this.$target.find(".aria-label").text());this.listenTo(Adapt$1,"device:resize",this.onDeviceResize);$(document).on("mouseleave blur","[data-tooltip-id]",this.onMouseOut);this.doFirstPass();setTimeout(this.doSubsequentPasses,17)}get environment(){const navigationAlignment=Adapt$1.course.get("_navigation")?._navigationAlignment??"top";const navHeight=$(".nav").outerHeight(true);const $target=this.$target;return{position:this.model.get("_position")||"outside bottom middle right",isDisabled:$target.attr("aria-disabled")!==undefined||$target.hasClass("is-disabled")||$target.is(":disabled"),isTargetFixedPosition:Boolean(this.$target.add(this.$target.parents()).filter(((index,el)=>$(el).css("position")==="fixed")).length),isRTL:Adapt$1.config.get("_defaultDirection")==="rtl",topNavOffset:navigationAlignment==="top"?navHeight:0,bottomNavOffset:navigationAlignment==="bottom"?navHeight:0,targetDOMRect:$target[0]?.getBoundingClientRect(),clientDOMRect:{width:parseInt(getComputedStyle(document.body).width),height:$("html")[0].clientHeight},tooltipDOMRect:this.$(".tooltip__body")[0]?.getBoundingClientRect(),arrowDOMRect:this.$(".tooltip__arrow")[0]?.getBoundingClientRect(),ariaHidden:document.activeElement===this.$target[0]}}doFirstPass(){this.model.set("isShown",false);const environment=this.environment;const positions=position(environment,{},FIRST_PASS);const{isDisabled:isDisabled,isTargetFixedPosition:isTargetFixedPosition,ariaHidden:ariaHidden}=environment;this.model.set({isDisabled:isDisabled,isTargetFixedPosition:isTargetFixedPosition,ariaHidden:ariaHidden,...positions});this.render()}doSubsequentPasses(){if(!this.model)return;this.model.set("hasLoaded",true);const multipassCache={};for(let pass=SECOND_PASS,l=THIRD_PASS;pass<=l;pass++){const environment=this.environment;const positions=position(this.environment,multipassCache,pass);const{isDisabled:isDisabled,isTargetFixedPosition:isTargetFixedPosition,ariaHidden:ariaHidden}=environment;this.model.set({isDisabled:isDisabled,isTargetFixedPosition:isTargetFixedPosition,ariaHidden:ariaHidden,...positions});this.render()}this.model.set("isShown",true);this.render()}render(){if(!this.model)return;const Template=templates.tooltip;this.updateViewProperties();ReactDOM__default["default"].render(React__default["default"].createElement(Template,this.model.toJSON()),this.el)}onDeviceResize(){this.remove()}onMouseOut(){this.remove()}remove(){if(this.$el.hasClass("test"))return;this.stopListening(Adapt$1);$(document).off("mouseleave blur","[data-tooltip-id]",this.onMouseOut);this.model?.set("isShown",false);this.render();this.model=null;this.$target=null;if(this.$target)this.$target.removeAttr("aria-describedby");const rem=super.remove.bind(this);setTimeout((()=>{rem();this.parent.removeItem(this)}),1e3)}});function fetchCSSVariables(){const computed=getComputedStyle(document.documentElement);return{offset:lengthToPx("@tooltip-offset",computed.getPropertyValue("--adapt-tooltip-offset")),distance:lengthToPx("@tooltip-distance",computed.getPropertyValue("--adapt-tooltip-distance")),viewPortPadding:lengthToPx("@tooltip-viewport-padding",computed.getPropertyValue("--adapt-tooltip-viewport-padding"))}}function lengthToPx(name,length){const unit=String(length).replaceAll(/[\d.]+/g,"").trim();const value=parseFloat(length);if(unit==="rem")return value*parseInt(getComputedStyle(document.body).fontSize);if(unit==="px")return value;throw new Error(`Cannot convert ${name} ${length} to pixels`)}function parseRelativePosition({position:position}){function fixConditions(positions,item1,item2,type){positions=positions.slice(0);const indexOf1=positions.indexOf(item1);const indexOf2=positions.indexOf(item2);let has1=indexOf1!==-1;let has2=indexOf2!==-1;let assume3=false;let specifiedAtIndex=null;if(has1&&has2){const isItem1=has1<has2;specifiedAtIndex=isItem1?indexOf1:indexOf2;has1=isItem1;has2=!isItem1}else if(has1){specifiedAtIndex=indexOf1}else if(has2){specifiedAtIndex=indexOf2}else{assume3=true}if(specifiedAtIndex!==null){positions[specifiedAtIndex]=type;positions=positions.filter(((item,index)=>{if(index<=specifiedAtIndex)return true;return item!==item1&&item!==item2}))}const hasSpecified=has1||has2;return[positions,has1,has2,assume3,hasSpecified,specifiedAtIndex]}position=position.toLowerCase().split(" ").filter(Boolean).join(" ");let positions=position.split(" ");let isArrowStart=null;let isArrowEnd=null;let isArrowMiddle=null;let isTop=null;let isCenter=null;let isBottom=null;let isLeft=null;let isMiddle=null;let isRight=null;let isOutside=null;let isInside=null;let isAreaAuto=null;let hasArrowSpecified=null;let hasVerticalSpecified=null;let verticalIndex=null;let hasHorizontalSpecified=null;let horizontalIndex=null;[positions,isOutside,isInside,isAreaAuto]=fixConditions(positions,"outside","inside","area");if(isAreaAuto)positions.unshift("area");[positions,isArrowStart,isArrowEnd,isArrowMiddle,hasArrowSpecified]=fixConditions(positions,"start","end","arrow");[positions,isTop,isBottom,isCenter,hasVerticalSpecified,verticalIndex]=fixConditions(positions,"top","bottom","vertical");[positions,isLeft,isRight,isMiddle,hasHorizontalSpecified,horizontalIndex]=fixConditions(positions,"left","right","horizontal");if(positions.length>4){positions.length=4}if(positions.length<4){const start=positions.length;positions.length=4;positions.fill("auto",start)}let specifiedCount=[hasArrowSpecified,hasHorizontalSpecified,hasVerticalSpecified].reduce(((sum,bool)=>sum+(bool?1:0)),0);let wasVerticalFilled=false;let wasHorizontalFilled=false;let wasArrowFilled=false;while(true){let isAuto=false;const indexOfMiddle=positions.indexOf("middle");const indexOfAuto=positions.indexOf("auto");const hasMiddleSpecified=indexOfMiddle!==-1;const hasAutoSpecified=indexOfAuto!==-1;let indexOf;let hasValue=false;if(hasMiddleSpecified&&hasAutoSpecified){isAuto=indexOfAuto<indexOfMiddle;indexOf=isAuto?indexOfAuto:indexOfMiddle;hasValue=true}else if(hasAutoSpecified){isAuto=true;indexOf=indexOfAuto;hasValue=true}else if(hasMiddleSpecified){isAuto=false;indexOf=indexOfMiddle;hasValue=true}if(!hasValue)break;const requiresHorizontal=!hasHorizontalSpecified&&!wasHorizontalFilled;const requiresVertical=!hasVerticalSpecified&&!wasVerticalFilled;const requiresArrow=!hasArrowSpecified&&!wasArrowFilled;const shouldArrow=requiresArrow&&(specifiedCount===1||specifiedCount===0||!requiresHorizontal&&!requiresVertical);const shouldHorizontal=!shouldArrow&&requiresHorizontal;const shouldVertical=!shouldHorizontal&&!shouldArrow&&requiresVertical;if(shouldHorizontal){positions[indexOf]="horizontal";if(isAuto)wasHorizontalFilled=true;else hasHorizontalSpecified=true;horizontalIndex=indexOf}else if(shouldArrow){positions[indexOf]="arrow";if(isAuto)wasArrowFilled=true;else hasArrowSpecified=true}else if(shouldVertical){positions[indexOf]="vertical";if(isAuto)wasVerticalFilled=true;else hasVerticalSpecified=true;verticalIndex=indexOf}if(!isAuto)specifiedCount+=1}const isVerticalAxis=verticalIndex<horizontalIndex;const isHorizontalAxis=horizontalIndex<verticalIndex;const isInsideMiddleCenter=isVerticalAxis&&isCenter||isHorizontalAxis&&isMiddle;if(isAreaAuto){isOutside=!isInsideMiddleCenter;isInside=!isOutside}if(isOutside&&isVerticalAxis&&isCenter){isTop=true;isCenter=false;logging$1.info(`tooltips: "${position}"(${positions.join(" ")}) is not a valid location, assuming side 'top'`)}else if(isOutside&&isHorizontalAxis&&isMiddle){isLeft=true;isMiddle=false;logging$1.info(`tooltips: "${position}"(${positions.join(" ")}) is not a valid location, assuming side 'left'`)}const shouldSensibleDefaults=specifiedCount===2;if(shouldSensibleDefaults){if(isOutside&&!hasArrowSpecified&&isVerticalAxis&&hasVerticalSpecified){isArrowMiddle=false;isArrowEnd=isRight;isArrowStart=!isArrowEnd}if(isOutside&&!hasArrowSpecified&&isHorizontalAxis&&hasHorizontalSpecified){isArrowMiddle=false;isArrowEnd=isBottom;isArrowStart=!isArrowEnd}if(isInside&&!hasArrowSpecified&&isVerticalAxis&&hasVerticalSpecified){isArrowMiddle=false;isArrowEnd=!isRight;isArrowStart=!isArrowEnd}if(isInside&&!hasArrowSpecified&&isHorizontalAxis&&hasHorizontalSpecified){isArrowMiddle=false;isArrowEnd=!isBottom;isArrowStart=!isArrowEnd}if(isOutside&&!hasHorizontalSpecified&&isVerticalAxis&&hasArrowSpecified&&!isArrowMiddle){isMiddle=false;isRight=!isArrowStart;isLeft=!isRight}if(isOutside&&!hasVerticalSpecified&&isHorizontalAxis&&hasArrowSpecified&&!isArrowMiddle){isCenter=false;isBottom=!isArrowStart;isTop=!isBottom}if(isInside&&!hasHorizontalSpecified&&isVerticalAxis&&hasArrowSpecified&&!isArrowMiddle){isMiddle=false;isRight=isArrowStart;isLeft=!isRight}if(isInside&&!hasVerticalSpecified&&isHorizontalAxis&&hasArrowSpecified&&!isArrowMiddle){isCenter=false;isBottom=isArrowStart;isTop=!isBottom}}return{isOutside:isOutside,isInside:isInside,isVerticalAxis:isVerticalAxis,isHorizontalAxis:isHorizontalAxis,isLeft:isLeft,isMiddle:isMiddle,isRight:isRight,isTop:isTop,isCenter:isCenter,isBottom:isBottom,isArrowStart:isArrowStart,isArrowMiddle:isArrowMiddle,isArrowEnd:isArrowEnd}}function convertToDistanceRect(DOMRect,clientDOMRect){return{top:DOMRect.top,left:DOMRect.left,right:clientDOMRect.width-DOMRect.right,bottom:clientDOMRect.height-DOMRect.bottom,width:DOMRect.width,height:DOMRect.height}}function invertRTL(bool,isRTL){if(!isRTL)return bool;return!bool}function constrainDimensions(distanceRect,viewPortPadding,isTargetFixedPosition,topNavOffset,bottomNavOffset){return{top:distanceRect.top-viewPortPadding-(isTargetFixedPosition?0:topNavOffset),left:distanceRect.left-viewPortPadding,right:distanceRect.right-viewPortPadding,bottom:distanceRect.bottom-viewPortPadding-(isTargetFixedPosition?0:bottomNavOffset),width:distanceRect.width,height:distanceRect.height}}function swapValues(a,b){return[b,a]}function calculateScrollOffset({isTargetFixedPosition:isTargetFixedPosition}){const scrollOffsetTop=isTargetFixedPosition?0:$(window).scrollTop();const scrollOffsetLeft=isTargetFixedPosition?0:$(window).scrollLeft();return{scrollOffsetLeft:scrollOffsetLeft,scrollOffsetTop:scrollOffsetTop}}function position({isTargetFixedPosition:isTargetFixedPosition,position:position,isRTL:isRTL,topNavOffset:topNavOffset,bottomNavOffset:bottomNavOffset,targetDOMRect:targetDOMRect,clientDOMRect:clientDOMRect,tooltipDOMRect:tooltipDOMRect,arrowDOMRect:arrowDOMRect}={},multipassCache,pass){const{offset:offset,distance:distance,viewPortPadding:viewPortPadding}=fetchCSSVariables();const targetDistRect=convertToDistanceRect(targetDOMRect,clientDOMRect);const constrainedClientDistRect={width:clientDOMRect.width-viewPortPadding*2,height:clientDOMRect.height-viewPortPadding*2-(isTargetFixedPosition?0:topNavOffset+bottomNavOffset)};let{isOutside:isOutside,isInside:isInside,isVerticalAxis:isVerticalAxis,isHorizontalAxis:isHorizontalAxis,isLeft:isLeft,isMiddle:isMiddle,isRight:isRight,isFillWidth:isFillWidth=false,isTop:isTop,isCenter:isCenter,isBottom:isBottom,isFillHeight:isFillHeight=false,isArrowStart:isArrowStart,isArrowMiddle:isArrowMiddle,isArrowEnd:isArrowEnd}=parseRelativePosition({position:position});if(pass>=THIRD_PASS){({isOutside:isOutside,isInside:isInside,isVerticalAxis:isVerticalAxis,isHorizontalAxis:isHorizontalAxis,isLeft:isLeft,isMiddle:isMiddle,isRight:isRight,isFillWidth:isFillWidth=false,isTop:isTop,isCenter:isCenter,isBottom:isBottom,isFillHeight:isFillHeight=false}=multipassCache)}let isSnapTop=false;let isSnapLeft=false;let isSnapBottom=false;let isSnapRight=false;let isArrowSnap=false;const tooltipStyles={};if(pass>=SECOND_PASS){const tooltipDistRect=convertToDistanceRect(tooltipDOMRect,clientDOMRect);const arrowDistRect=convertToDistanceRect(arrowDOMRect,clientDOMRect);const constrainedTargetDistRect=constrainDimensions(targetDistRect,viewPortPadding,isTargetFixedPosition,topNavOffset,bottomNavOffset);const constrainedTooltipDistRect=constrainDimensions(tooltipDistRect,viewPortPadding,isTargetFixedPosition,topNavOffset,bottomNavOffset);const constrainedArrowDistRect=constrainDimensions(arrowDistRect,viewPortPadding,isTargetFixedPosition,topNavOffset,bottomNavOffset);const overallHeight=isOutside&&isVerticalAxis?constrainedTooltipDistRect.height+constrainedArrowDistRect.height+distance:constrainedTooltipDistRect.height;const overallWidth=isOutside&&isHorizontalAxis?constrainedTooltipDistRect.width+constrainedArrowDistRect.width+distance:constrainedTooltipDistRect.width;const isOverflowTop=constrainedTooltipDistRect.top<0;const isOverflowBottom=constrainedTooltipDistRect.bottom<0;const isOverflowLeft=constrainedTooltipDistRect.left<0;const isOverflowRight=constrainedTooltipDistRect.right<0;const isOverflowHorizontal=isOverflowLeft||isOverflowRight;const isOverflowVertical=isOverflowTop||isOverflowBottom;const isOverflow=isOverflowHorizontal||isOverflowVertical;const tooltipArea=overallHeight*overallWidth;const topArea=constrainedTargetDistRect.top*constrainedClientDistRect.width;const bottomArea=constrainedTargetDistRect.bottom*constrainedClientDistRect.width;const leftArea=constrainedTargetDistRect.left*constrainedClientDistRect.height;const rightArea=constrainedTargetDistRect.right*constrainedClientDistRect.height;const maxHorizontalArea=Math.max(leftArea,rightArea);const maxVerticalArea=Math.max(topArea,bottomArea);const isVerticalAreaLarger=maxVerticalArea>=maxHorizontalArea;const isHorizontalAreaLarger=maxHorizontalArea>=maxVerticalArea;const canFitWidthLength=isVerticalAxis?overallWidth<=constrainedClientDistRect.width:overallWidth<=constrainedTargetDistRect.left||overallWidth<=constrainedTargetDistRect.right;const canFitHeightLength=isHorizontalAxis?overallHeight<=constrainedClientDistRect.height:overallHeight<=constrainedTargetDistRect.top||overallHeight<=constrainedTargetDistRect.bottom;const canFitInLeftArea=tooltipArea<leftArea;const canFitInRightArea=tooltipArea<rightArea;const canFitInTopArea=tooltipArea<topArea;const canFitInBottomArea=tooltipArea<bottomArea;const canFitInVerticalArea=tooltipArea<maxVerticalArea;const canFitInHorizontalArea=tooltipArea<maxHorizontalArea;const isArrowOffscreen=isVerticalAxis&&(constrainedArrowDistRect.left<offset||constrainedArrowDistRect.right<offset)||isHorizontalAxis&&(constrainedArrowDistRect.top<offset||constrainedArrowDistRect.bottom<offset);const isBadShape=!canFitHeightLength||!canFitWidthLength;const isSwapAxis=isArrowOffscreen&&isHorizontalAxis&&isOverflowVertical||isArrowOffscreen&&isVerticalAxis&&isOverflowHorizontal||isHorizontalAxis&&!canFitInHorizontalArea&&isVerticalAreaLarger||isVerticalAxis&&!canFitInVerticalArea&&isHorizontalAreaLarger;const isFillArea=isSwapAxis&&isBadShape||isVerticalAxis&&isOverflow&&isBadShape&&(canFitInVerticalArea||isVerticalAreaLarger)||isHorizontalAxis&&isOverflow&&isBadShape&&(canFitInHorizontalArea||isHorizontalAreaLarger);if(pass===SECOND_PASS&&(isBadShape||isOverflow)){if(isSwapAxis){[isVerticalAxis,isHorizontalAxis]=swapValues(isVerticalAxis,isHorizontalAxis);if(isCenter){[isMiddle,isLeft,isRight]=[true,false,false];[isBottom,isTop,isCenter]=[true,false,false]}}if(isFillArea){if(isVerticalAxis)isFillWidth=true;if(isHorizontalAxis)isFillHeight=true}const isSwapVerticalSide=!(isHorizontalAxis&&canFitInHorizontalArea)&&(isFillArea&&!(isTop&&canFitInTopArea||isBottom&&canFitInBottomArea)||!isFillArea&&(isBottom&&isOverflowBottom||isTop&&isOverflowTop));if(isSwapVerticalSide&&isFillArea&&(canFitInTopArea||canFitInBottomArea)){isTop=!canFitInBottomArea;isBottom=canFitInBottomArea}else if(isSwapVerticalSide){isTop=constrainedTargetDistRect.top>=constrainedTargetDistRect.bottom;isBottom=constrainedTargetDistRect.top<constrainedTargetDistRect.bottom}const isSwapHorizontalSide=!(isVerticalAxis&&canFitInVerticalArea)&&(isFillArea&&!(isLeft&&canFitInLeftArea||isRight&&canFitInRightArea)||!isFillArea&&(isLeft&&isOverflowLeft||isRight&&isOverflowRight));if(isSwapHorizontalSide&&isFillArea&&(canFitInLeftArea||canFitInRightArea)){isLeft=invertRTL(!canFitInRightArea,isRTL);isRight=invertRTL(canFitInRightArea,isRTL)}else if(isSwapHorizontalSide){isLeft=invertRTL(constrainedTargetDistRect.left>=constrainedTargetDistRect.right,isRTL);isRight=invertRTL(constrainedTargetDistRect.left<constrainedTargetDistRect.right,isRTL)}else if(isSwapAxis){isLeft=invertRTL(isLeft,isRTL);isRight=invertRTL(isRight,isRTL)}if(isSwapVerticalSide||isSwapHorizontalSide||isSwapAxis){isMiddle=!isLeft&&!isRight;isCenter=!isTop&&!isBottom}}if(pass===THIRD_PASS){if(isVerticalAxis){isSnapLeft=isOverflowLeft;isSnapRight=!isSnapLeft&&isOverflowRight}if(isHorizontalAxis){isSnapTop=isOverflowTop;isSnapBottom=!isSnapTop&&isOverflowBottom}isArrowSnap=isArrowOffscreen}Object.assign(tooltipStyles,{"--adapt-tooltip-target-distancetoedge-left":`${constrainedTargetDistRect.left}px`,"--adapt-tooltip-target-distancetoedge-top":`${constrainedTargetDistRect.top}px`,"--adapt-tooltip-target-distancetoedge-right":`${constrainedTargetDistRect.right}px`,"--adapt-tooltip-target-distancetoedge-bottom":`${constrainedTargetDistRect.bottom}px`,"--adapt-tooltip-target-distancetoedge-height":`${constrainedTargetDistRect.height}px`,"--adapt-tooltip-target-distancetoedge-width":`${constrainedTargetDistRect.width}px`});if(pass>=2){Object.assign(multipassCache,{isOutside:isOutside,isInside:isInside,isVerticalAxis:isVerticalAxis,isHorizontalAxis:isHorizontalAxis,isLeft:isLeft,isMiddle:isMiddle,isRight:isRight,isFillWidth:isFillWidth,isTop:isTop,isCenter:isCenter,isBottom:isBottom,isFillHeight:isFillHeight})}}const tooltipClasses=[isOutside&&"is-outside",isInside&&"is-inside",isArrowSnap&&"is-arrow-snap",isVerticalAxis&&"is-vertical-axis",isHorizontalAxis&&"is-horizontal-axis",isLeft&&"is-left",isMiddle&&"is-middle",isRight&&"is-right",isFillWidth&&"is-fill-width",isSnapLeft&&"is-snap-left",isSnapRight&&"is-snap-right",isTop&&"is-top",isCenter&&"is-center",isBottom&&"is-bottom",isFillHeight&&"is-fill-height",isSnapTop&&"is-snap-top",isSnapBottom&&"is-snap-bottom",isArrowStart&&"is-arrow-start",isArrowMiddle&&"is-arrow-middle",isArrowEnd&&"is-arrow-end"].filter(Boolean).join(" ");const{scrollOffsetLeft:scrollOffsetLeft,scrollOffsetTop:scrollOffsetTop}=calculateScrollOffset({isTargetFixedPosition:isTargetFixedPosition});Object.assign(tooltipStyles,{"--adapt-tooltip-viewport-constrained-height":`${constrainedClientDistRect.height}px`,"--adapt-tooltip-viewport-constrained-width":`${constrainedClientDistRect.width}px`,"--adapt-tooltip-scroll-top":`${scrollOffsetTop}px`,"--adapt-tooltip-scroll-left":`${scrollOffsetLeft}px`,"--adapt-tooltip-target-position-top":`${targetDistRect.top}px`,"--adapt-tooltip-target-position-left":`${targetDistRect.left}px`,"--adapt-tooltip-target-position-width":`${targetDistRect.width}px`,"--adapt-tooltip-target-position-height":`${targetDistRect.height}px`});return{tooltipClasses:tooltipClasses,tooltipStyles:tooltipStyles}}var TooltipItemModel=__AMD("core/js/models/TooltipItemModel",class TooltipItemModel extends Backbone__default["default"].Model{defaults(){return{...Adapt$1.course.get("_tooltips")||{},_id:null,_isEnabled:true,_classes:"",disabledText:"{{text}}",text:""}}});var TooltipView=__AMD("core/js/views/TooltipView",class TooltipView extends Backbone.View{className(){return"tooltip__container"}attributes(){return{role:"region","aria-live":"assertive"}}initialize(){_.bindAll(this,"onMouseOver","onKeyDown","onMouseOut","onClick");this._tooltipData={};this._tooltips=[];this.listenToOnce(Adapt$1,"adapt:preInitialize",this.onAdaptPreInitialize);this.render()}onAdaptPreInitialize(){if(this.config?._isEnabled===false)return;this.onMouseOver=_.debounce(this.onMouseOver,500);$(document).on("keydown",this.onKeyDown);$(document).on("focus","[data-tooltip-id]",((...args)=>{if(a11y$1.isForcedFocus)return;this.onMouseOver(...args)}));$(document).on("mouseenter","[data-tooltip-id]",this.onMouseOver);$(document).on("mouseleave blur","[data-tooltip-id]",this.onMouseOut);$(document).on("click","[data-tooltip-id]",this.onClick)}get config(){return{_position:"outside bottom middle right",...Adapt$1.course.get("_tooltips")}}onKeyDown(event){if(event.key!=="Escape")return;this.hide()}onMouseOver(event){const $mouseoverEl=$(event.currentTarget);if(!a11y$1.isFocusable($mouseoverEl))return;const id=$mouseoverEl.data("tooltip-id");if(this._currentId===id&&event.name==="focusin")return;this._currentId=id;const tooltip=this.getTooltip(id);if(!tooltip?.get("_isEnabled"))return this.hide();if(event.ctrlKey&&this.config._allowTest){this.showTest(tooltip,$mouseoverEl)}else{this.show(tooltip,$mouseoverEl)}$(document).on("scroll",this.onScroll)}onMouseOut(){this.onMouseOver.cancel()}onClick(){this.hide()}render(){this.$el.appendTo("body")}show(tooltip,$mouseoverEl){if(this.isShowing(tooltip))return;const tooltipItem=new TooltipItemView({model:tooltip,$target:$mouseoverEl,parent:this});this._tooltips.push(tooltipItem);this.$el.append(tooltipItem.$el)}isShowing(tooltip){const id=tooltip.get("_id");return this._tooltips.some((tooltipView=>tooltipView.model?.get("_id")===id))}hide(tooltipItem=null){tooltipItem=tooltipItem??this._tooltips.pop();this.removeItem(tooltipItem);if(!tooltipItem)return;tooltipItem.remove()}removeItem(tooltipItem){const currentIndex=this._tooltips.findIndex((item=>tooltipItem===item));if(currentIndex===-1)return;this._tooltips.splice(currentIndex,1)}register(tooltipData){if(!tooltipData._id)return logging$1.warn("Tooltip cannot be registered with no id");this._tooltipData[tooltipData._id]=new TooltipItemModel(tooltipData)}getTooltip(id){return this._tooltipData[id]}showTest(tooltip,$target){const produce=parts=>{const lastIndex=parts.length-1;const partIndex=new Array(parts.length).fill(0);const tooltips=[];const json=tooltip.toJSON();while(true){const position=parts.map(((part,index)=>part[partIndex[index]])).join(" ");tooltips.push(new TooltipItemModel({...json,disabledText:`D ${position}`,text:`T ${position}`,_position:position,_classes:"test"}));for(let i=lastIndex;i>=0;i--){partIndex[i]+=1;if(partIndex[i]<parts[i].length)break;if(i===0)break;partIndex[i]=0}if(partIndex[0]>=parts[0].length)break}tooltips.forEach((model=>{const tooltipItem=new TooltipItemView({model:model,$target:$target,parent:this});this._tooltips.push(tooltipItem);this.$el.append(tooltipItem.$el)}))};const areaOutside=["outside"];const areaInside=["inside"];const arrowPosition=["middle","start","end",""];const vertical=["middle","top","bottom",""];const horizontal=["middle","right","left",""];const partsVertical=[areaOutside,vertical,arrowPosition,horizontal];const partsHorizontal=[areaOutside,horizontal,arrowPosition,vertical];const partsVerticalInside=[areaInside,vertical,arrowPosition,horizontal];const partsHorizontalInside=[areaInside,horizontal,arrowPosition,vertical];produce(partsVertical);produce(partsHorizontal);produce(partsVerticalInside);produce(partsHorizontalInside)}});const tooltips=new TooltipView;var tooltips$1=__AMD("core/js/tooltips",tooltips);const DrawerCollection$1=new Backbone__default["default"].Collection(null,{comparator:"drawerOrder"});class Drawer$1 extends Backbone__default["default"].Controller{initialize(){this.listenTo(Adapt$1,{"adapt:start":this.onAdaptStart,"app:languageChanged":this.onLanguageChanged,"navigation:toggleDrawer":this.toggle,"router:navigate":this.close})}onAdaptStart(){this._drawerView=new DrawerView$1({collection:DrawerCollection$1})}onLanguageChanged(){tooltips$1.register({_id:"drawer",...Adapt$1.course.get("_globals")?._extensions?._drawer?._navTooltip||{}});this.remove()}toggle(){this.isOpen?this.close():this.open()}get isOpen(){return this._drawerView?.isOpen??false}open(){this._drawerView?.showDrawer(true)}openCustomView(view,hasBackButton,position){this._drawerView?.openCustomView(view,hasBackButton,position)}addItem(drawerObject,eventCallback){if(this.hasItem(eventCallback)){DrawerCollection$1.remove(DrawerCollection$1.find((item=>item.eventCallback===eventCallback)))}drawerObject.eventCallback=eventCallback;DrawerCollection$1.add(drawerObject)}hasItem(eventCallback){return Boolean(DrawerCollection$1.find((item=>item.eventCallback===eventCallback)))}close($toElement=null){this._drawerView?.hideDrawer($toElement)}remove(){this._drawerView?.remove();this._drawerView=null}}var drawer=__AMD("core/js/drawer",new Drawer$1);var AdaptSubsetCollection=__AMD("core/js/collections/adaptSubsetCollection",class AdaptSubsetCollection extends AdaptCollection{initialize(models,options){super.initialize(models,options);this.parent=options.parent;this.listenTo(this.parent,"reset",this.loadSubset)}loadSubset(){this.set(this.parent.filter((model=>model instanceof this.model)));this._byAdaptID=this.groupBy("_id")}});var ModelEvent=__AMD("core/js/modelEvent",class ModelEvent extends Backbone.Controller{initialize(type,target,value){this.type=type;this.target=target;this.value=value;this.canBubble=true;this.deepPath=[target];this.timeStamp=null}stopPropagation(){this.canBubble=false}addPath(target){this.deepPath.unshift(target)}});var AdaptModel=__AMD("core/js/models/adaptModel",class AdaptModel extends LockingModel{toJSON(){const json={...this.attributes};delete json._children;delete json._parent;return $.extend(true,{},json)}get(name){switch(name){case"_parent":case"_children":logging$1.deprecated("Use model.getChildren() or model.getParent() instead of model.get('_children') or model.get('_parent')")}return super.get(name)}defaults(){return{_canShowFeedback:true,_classes:"",_canReset:true,_canRequestChild:false,_isComplete:false,_isInteractionComplete:false,_isA11yRegionEnabled:false,_isA11yCompletionDescriptionEnabled:true,_requireCompletionOf:-1,_isEnabled:true,_isResetOnRevisit:false,_isAvailable:true,_isOptional:false,_isRendered:false,_isReady:false,_isVisible:true,_isVisited:false,_isLocked:false,_isHidden:false}}get trackingPosition(){const firstDescendant=this.getAllDescendantModels(false).concat([this])[0];const nearestTrackingIdModel=[firstDescendant].concat(firstDescendant.getAncestorModels()).find((model=>model.has("_trackingId")));if(!nearestTrackingIdModel)return;const trackingId=nearestTrackingIdModel.get("_trackingId");let trackingIdDescendants=[nearestTrackingIdModel].concat(nearestTrackingIdModel.getAllDescendantModels(true));trackingIdDescendants=trackingIdDescendants.filter((model=>!(model.isTypeGroup("component")&&model.get("_isTrackable")===false)));const indexInTrackingIdDescendants=trackingIdDescendants.findIndex((descendant=>descendant===this));if(indexInTrackingIdDescendants>=0){return[trackingId,indexInTrackingIdDescendants]}const trackingIdAncestors=nearestTrackingIdModel.getAncestorModels();const ancestorDistance=trackingIdAncestors.findIndex((ancestor=>ancestor===this));return[trackingId,-(ancestorDistance+1)]}parse(data){if(data._isResetOnRevisit==="false"){data._isResetOnRevisit=false}return data}trackable(){return["_id","_isComplete","_isInteractionComplete","_isVisited"]}trackableType(){return[String,Boolean,Boolean,Boolean]}bubblingEvents(){return["change:_isComplete","change:_isInteractionComplete","change:_isActive","change:_isVisited"]}setupModel(){if(this.hasManagedChildren){this.setupChildListeners()}this.init();_.defer((()=>{if(this.hasManagedChildren){this.checkCompletionStatus();this.checkInteractionCompletionStatus();this.checkLocking();this.checkVisitedStatus()}this.setupTrackables()}))}setupTrackables(){const originalTrackableStateFunction=this.triggerTrackableState;this.triggerTrackableState=_.compose((()=>{this.triggerTrackableState.isQueued=true}),_.debounce((()=>{originalTrackableStateFunction.apply(this);this.triggerTrackableState.isQueued=false}),17));this.listenTo(this,"change",(({changed:changed})=>{if(this.triggerTrackableState.isQueued||!Adapt$1.attributes._isStarted){return}const trackablePropertyNames=_.result(this,"trackable",[]);const changedPropertyNames=Object.keys(changed);const isTrackable=changedPropertyNames.find((item=>trackablePropertyNames.includes(item)));if(isTrackable){this.triggerTrackableState()}}))}setupChildListeners(){const children=this.getChildren();if(!children.length){return}this.listenTo(children,{all:this.onAll,bubble:this.bubble,"change:_isVisited":this.checkVisitedStatus,"change:_isReady":this.checkReadyStatus,"change:_isComplete":this.onIsComplete,"change:_isInteractionComplete":this.checkInteractionCompletionStatus})}init(){}getTrackableState(){const trackable=this.resultExtend("trackable",[]);const json=this.toJSON();const args=trackable;args.unshift(json);return _.pick(...args)}setTrackableState(state){const trackable=this.resultExtend("trackable",[]);const args=trackable;args.unshift(state);state=_.pick(...args);this.set(state);return this}triggerTrackableState(){Adapt$1.trigger("state:change",this,this.getTrackableState())}reset(type="hard",canReset=this.get("_canReset")){if(!canReset)return false;const isHardReset=type==="hard"||type===true;const isSoftReset=type==="soft";if(!isHardReset&&!isSoftReset)return false;const resetData={_isEnabled:true,_isInteractionComplete:false};if(isHardReset)resetData._isComplete=false;this.set(resetData);this.trigger("reset");return true}checkReadyStatus(model,value){if(value===false){return false}const children=this.getAvailableChildModels();if(children.find((child=>child.get("_isReady")===false&&child.get("_isRendered")))){return false}this.set("_isReady",true);return true}setReadyStatus(){this.set("_isReady",true)}checkVisitedStatus(){const children=this.getAvailableChildModels();const isVisited=children.some((child=>child.get("_isVisited")||child.get("_isComplete")||child.get("_isInteractionComplete")));if(isVisited)this.set("_isVisited",true);return isVisited}setVisitedStatus(){if(!this.get("_isReady")||!this.get("_isRendered"))return;this.set("_isVisited",true)}setCompletionStatus(){if(!this.get("_isVisible"))return;this.set({_isComplete:true,_isInteractionComplete:true,_isVisited:true})}checkCompletionStatus(){Adapt$1.checkingCompletion();_.defer(this.checkCompletionStatusFor.bind(this),"_isComplete")}checkInteractionCompletionStatus(){Adapt$1.checkingCompletion();_.defer(this.checkCompletionStatusFor.bind(this),"_isInteractionComplete")}checkCompletionStatusFor(completionAttribute="_isComplete"){let completed=false;const children=this.getAvailableChildModels();const requireCompletionOf=this.get("_requireCompletionOf");const isOptional=this.get("_isOptional");const isEveryChildOptional=children.every((child=>child.get("_isOptional")));if(isOptional&&isEveryChildOptional){completed=children.every((child=>child.get(completionAttribute)))}else if(requireCompletionOf===-1){completed=children.every((child=>child.get(completionAttribute)||child.get("_isOptional")))}else{completed=children.filter((child=>child.get(completionAttribute)&&!child.get("_isOptional"))).length>=requireCompletionOf}this.set(completionAttribute,completed);Adapt$1.checkedCompletion()}getTypeGroup(){}isTypeGroup(typeGroup){const hasUpperCase=/[A-Z]+/.test(typeGroup);const isPluralized=typeGroup.slice(-1)==="s";const lowerCased=typeGroup.toLowerCase();const singular=isPluralized&&lowerCased.slice(0,-1);const singularLowerCased=(singular||lowerCased).toLowerCase();if(isPluralized||hasUpperCase){logging$1.deprecated(`'${typeGroup}' appears pluralized or contains uppercase characters, suggest using the singular, lowercase type group '${singularLowerCased}'.`)}const pluralizedLowerCaseTypes=[singularLowerCased,!isPluralized&&`${lowerCased}s`].filter(Boolean);const typeGroups=this.getTypeGroups();if(_.intersection(pluralizedLowerCaseTypes,typeGroups).length){return true}return false}getTypeGroups(){if(this._typeGroups)return this._typeGroups;const typeGroups=[this.get("_type")];let parentClass=this;while(parentClass=Object.getPrototypeOf(parentClass)){if(!Object.prototype.hasOwnProperty.call(parentClass,"getTypeGroup"))continue;typeGroups.push(parentClass.getTypeGroup.call(this))}return this._typeGroups=_.uniq(typeGroups.filter(Boolean).map((s=>s.toLowerCase())))}findAncestor(ancestorType){const parent=this.getParent();if(!parent)return;if(!ancestorType||parent.isTypeGroup(ancestorType)){return parent}return parent.findAncestor(ancestorType)}findDescendantModels(descendants,options){const allDescendantsModels=this.getAllDescendantModels();const returnedDescendants=allDescendantsModels.filter((model=>model.isTypeGroup(descendants)));if(!options){return returnedDescendants}if(options.where){return returnedDescendants.filter((descendant=>{for(const property in options.where){const value=options.where[property];if(descendant.get(property)!==value){return false}}return true}))}}getAllDescendantModels(isParentFirst){const descendants=[];if(!this.hasManagedChildren){return descendants}const children=this.getChildren();children.models.forEach((child=>{if(!child.hasManagedChildren){descendants.push(child);return}const subDescendants=child.getAllDescendantModels(isParentFirst);if(isParentFirst===true){descendants.push(child)}descendants.push(...subDescendants);if(isParentFirst!==true){descendants.push(child)}}));return descendants}findRelativeModel(relativeString,options={}){if(!relativeString)return this;let relativeDescriptorObjects=Adapt$1.parseRelativeString(relativeString);if(!Array.isArray(relativeDescriptorObjects))relativeDescriptorObjects=[relativeDescriptorObjects];const find=({type:type,offset:offset,inset:inset})=>{const isInset=inset!==null;const isOffset=offset!==null;const rootModel=options.limitParentId?data$1.findById(options.limitParentId):isInset?this:Adapt$1.course;const increment=isOffset?offset:inset;const searchBackwards=increment<0;let moveBy=Math.abs(increment);let movementCount=0;const hasDescendantsOfType=Boolean(this.findDescendantModels(type).length);if(isInset&&!hasDescendantsOfType)return undefined;if(isOffset&&hasDescendantsOfType){moveBy--}if(isInset&&searchBackwards){moveBy--}const searchDescendants=searchBackwards?[rootModel,...rootModel.getAllDescendantModels(true)].reverse():[...rootModel.getAllDescendantModels(false),rootModel];const modelId=this.get("_id");const searchFromIndex=isInset?0:searchDescendants.findIndex((searchDescendant=>searchDescendant.get("_id")===modelId));const hasFilterFunction=typeof options.filter==="function";if(options.loop){const totalOfType=searchDescendants.reduce(((count,model)=>{if(!model.isTypeGroup(type))return count;return++count}),0);moveBy=moveBy%totalOfType;searchDescendants.push(...searchDescendants.slice(0))}for(let i=searchFromIndex,l=searchDescendants.length;i<l;i++){const descendant=searchDescendants[i];if(!descendant.isTypeGroup(type))continue;const isSelf=i===searchFromIndex;if(!isSelf&&hasFilterFunction&&!options.filter(descendant))continue;if(movementCount>moveBy){break}if(movementCount===moveBy){return descendant}movementCount++}};const nextDescriptor=relativeDescriptorObjects.slice(1).reduce(((output,{type:type,offset:offset,inset:inset})=>{const isInset=inset!==null;const isOffset=offset!==null;if(isOffset)return`${output}@${type}${offset<0?offset:`+${offset}`}`;if(isInset)return`${output}@${type}=${inset}`;return`${output}@${type}`}),"");const foundModel=find(relativeDescriptorObjects[0]);if(nextDescriptor){return foundModel?.findRelativeModel(nextDescriptor)}return foundModel}get hasManagedChildren(){return true}getChildren(){if(this._childrenCollection){return this._childrenCollection}let childrenCollection;if(!this.hasManagedChildren){childrenCollection=new Backbone.Collection}else{const id=this.get("_id");const children=data$1.filter((model=>model.get("_parentId")===id));childrenCollection=new Backbone.Collection(children)}if(this.get("_type")==="block"&&childrenCollection.length===2&&childrenCollection.models[0].get("_layout")!=="left"){childrenCollection.comparator="_layout";childrenCollection.sort()}this.setChildren(childrenCollection);return this._childrenCollection}setChildren(children){this._childrenCollection=children;this.set("_children",children)}getAvailableChildModels(){return this.getChildren().where({_isAvailable:true})}getParent(){if(this._parentModel){return this._parentModel}const parentId=this.get("_parentId");if(!parentId)return;const parent=data$1.findById(parentId);if(!parent){logging$1.warn("adaptModel.getParent(): parent is empty");return}this.setParent(parent);return this._parentModel}setParent(parent){this._parentModel=parent;this.set("_parentId",this._parentModel.get("_id"));this.set("_parent",this._parentModel)}getAncestorModels(shouldIncludeChild){const parents=[];let context=this;if(shouldIncludeChild)parents.push(context);while(context.has("_parentId")){context=context.getParent();parents.push(context)}return parents.length?parents:null}getSiblings(passSiblingsAndIncludeSelf){const id=this.get("_id");const parentId=this.get("_parentId");let siblings;if(!passSiblingsAndIncludeSelf){if(this._hasSiblingsAndSelf===false){return this.get("_siblings")}siblings=data$1.filter((model=>model.get("_parentId")===parentId&&model.get("_id")!==id));this._hasSiblingsAndSelf=false}else{if(this._hasSiblingsAndSelf){return this.get("_siblings")}siblings=data$1.filter((model=>model.get("_parentId")===parentId));this._hasSiblingsAndSelf=true}const siblingsCollection=new Backbone.Collection(siblings);this.set("_siblings",siblingsCollection);return siblingsCollection}setOnChildren(...args){this.set(...args);if(!this.hasManagedChildren)return;const children=this.getChildren();children.models.forEach((child=>child.setOnChildren(...args)))}setOptional(value){logging$1.deprecated("Use model.set('_isOptional', value) as setOptional() may be removed in the future");this.set({_isOptional:value})}checkLocking(){const lockType=this.get("_lockType");if(!lockType)return;switch(lockType){case"sequential":this.setSequentialLocking();break;case"unlockFirst":this.setUnlockFirstLocking();break;case"lockLast":this.setLockLastLocking();break;case"custom":this.setCustomLocking();break;default:logging$1.warn(`AdaptModel.checkLocking: unknown _lockType '${lockType}' found on ${this.get("_id")}`)}}setSequentialLocking(){const children=this.getAvailableChildModels();children.slice(1).forEach(((child,index)=>{const previousChild=children[index];const isLockedByPreviousChild=previousChild.get("_isLocked")||!previousChild.get("_isComplete")&&!previousChild.get("_isOptional");child.set("_isLocked",isLockedByPreviousChild)}),false)}setUnlockFirstLocking(){const children=this.getAvailableChildModels();const firstChild=children.shift();const isLockedByFirstChild=!firstChild.get("_isComplete")&&!firstChild.get("_isOptional");children.forEach((child=>child.set("_isLocked",isLockedByFirstChild)))}setLockLastLocking(){const children=this.getAvailableChildModels();const lastChild=children.pop();const isLockedByChildren=children.some((child=>!child.get("_isComplete")&&!child.get("_isOptional")));lastChild.set("_isLocked",isLockedByChildren)}setCustomLocking(){const children=this.getAvailableChildModels();children.forEach((child=>child.set("_isLocked",this.shouldLock(child))))}shouldLock(child){const lockedBy=child.get("_lockedBy");if(!lockedBy)return false;return lockedBy.some((id=>{try{const anotherModel=data$1.findById(id);return anotherModel.get("_isAvailable")&&(anotherModel.get("_isLocked")||!anotherModel.get("_isComplete")&&!anotherModel.get("_isOptional"))}catch(e){logging$1.warn(`AdaptModel.shouldLock: unknown _lockedBy ID '${id}' found on ${child.get("_id")}`);return false}}))}onIsComplete(){this.checkCompletionStatus();this.checkLocking()}checkIfResetOnRevisit(){const isResetOnRevisit=this.get("_isResetOnRevisit");this.reset(isResetOnRevisit)}deepClone(modifier=null){const ModelClass=this.constructor;const clonedModel=new ModelClass(this.toJSON());if(modifier){modifier(clonedModel,this)}let clonedId=clonedModel.get("_id");const hasId=Boolean(clonedId);const shouldAssignUniqueId=this.get("_id")===clonedId;if(hasId&&shouldAssignUniqueId){const cid=_.uniqueId(ModelClass.prototype.cidPrefix||"c");clonedId=`${clonedId}_${cid}`;clonedModel.set("_id",clonedId)}if(hasId){data$1.add(clonedModel)}if(this.hasManagedChildren){this.getChildren().each((child=>{if(!child.deepClone){throw new Error("Cannot deepClone child.")}child.deepClone(((clone,child)=>{if(hasId){clone.set("_parentId",clonedId)}if(modifier){modifier(clone,child)}}))}))}clonedModel.getParent().getChildren().add(clonedModel);clonedModel.setupModel();return clonedModel}onAll(type,model,value){if(!_.result(this,"bubblingEvents").includes(type))return;const event=new ModelEvent(type,model,value);this.bubble(event)}bubble(event){if(!event.canBubble)return;event.addPath(this);this.trigger(`bubble:${event.type} bubble`,event)}});var ContentObjectModel=__AMD("core/js/models/contentObjectModel",class ContentObjectModel extends AdaptModel{get _parent(){logging$1.deprecated("contentObjectModel._parent, use contentObjectModel.getParent() instead, parent models are defined by the JSON");const isParentCourse=this.get("_parentId")===Adapt$1.course.get("_id");if(isParentCourse){return"course"}return"contentObjects"}get _siblings(){logging$1.deprecated("contentObjectModel._siblings, use contentObjectModel.getSiblings() instead, sibling models are defined by the JSON");return"contentObjects"}get _children(){logging$1.deprecated("contentObjectModel._children, use contentObjectModel.hasManagedChildren instead, child models are defined by the JSON");return null}getTypeGroup(){return"contentobject"}});class ArticleModel extends AdaptModel{get _parent(){logging$1.deprecated("articleModel._parent, use articleModel.getParent() instead, parent models are defined by the JSON");return"contentObjects"}get _siblings(){logging$1.deprecated("articleModel._siblings, use articleModel.getSiblings() instead, sibling models are defined by the JSON");return"articles"}get _children(){logging$1.deprecated("articleModel._children, use articleModel.hasManagedChildren instead, child models are defined by the JSON");return"blocks"}getTypeGroup(){return"article"}}components$1.register("article",{model:ArticleModel});var ArticleModel$1=__AMD("core/js/models/articleModel",ArticleModel);class BlockModel extends AdaptModel{get _parent(){logging$1.deprecated("blockModel._parent, use blockModel.getParent() instead, parent models are defined by the JSON");return"articles"}get _siblings(){logging$1.deprecated("blockModel._siblings, use blockModel.getSiblings() instead, sibling models are defined by the JSON");return"blocks"}get _children(){logging$1.deprecated("blockModel._children, use blockModel.hasManagedChildren instead, child models are defined by the JSON");return"components"}getTypeGroup(){return"block"}}components$1.register("block",{model:BlockModel});var BlockModel$1=__AMD("core/js/models/blockModel",BlockModel);class ComponentModel extends AdaptModel{get _parent(){logging$1.deprecated("componentModel._parent, use componentModel.getParent() instead, parent models are defined by the JSON");return"blocks"}get _siblings(){logging$1.deprecated("componentModel._siblings, use componentModel.getSiblings() instead, sibling models are defined by the JSON");return"components"}getTypeGroup(){return"component"}defaults(){return AdaptModel.resultExtend("defaults",{_isA11yComponentDescriptionEnabled:true,_shouldStoreAttempts:true,_userAnswer:null,_attemptStates:null})}trackable(){return AdaptModel.resultExtend("trackable",["_userAnswer","_attemptStates"])}trackableType(){return AdaptModel.resultExtend("trackableType",[Array,Array])}get hasManagedChildren(){return false}init(){if(Adapt$1.get("_isStarted")){this.onAdaptInitialize();return}this.listenToOnce(Adapt$1,"adapt:initialize",this.onAdaptInitialize)}onAdaptInitialize(){this.restoreUserAnswers()}restoreUserAnswers(){}storeUserAnswer(){}resetUserAnswer(){this.set("_userAnswer",null)}reset(type="hard",canReset=this.get("_canReset")){const wasReset=super.reset(type,canReset);if(!wasReset)return false;this.resetUserAnswer();return true}getAttemptState(object=this.toJSON()){const trackables=this.trackable();const types=this.trackableType();trackables.find(((name,index)=>{if(name!=="_attemptStates")return false;trackables.splice(index,1);types.splice(index,1);return true}));const values=trackables.map((n=>object[n]));const booleans=values.filter(((v,i)=>types[i]===Boolean)).map(Boolean);const numbers=values.filter(((v,i)=>types[i]===Number)).map((v=>Number(v)||0));const arrays=values.filter(((v,i)=>types[i]===Array));return[numbers,booleans,arrays]}getAttemptObject(state=this.getAttemptState()){const trackables=this.trackable();const types=this.trackableType();trackables.find(((name,index)=>{if(name!=="_attemptStates")return false;trackables.splice(index,1);types.splice(index,1);return true}));const numbers=(state[0]||[]).slice(0);const booleans=(state[1]||[]).slice(0);const arrays=(state[2]||[]).slice(0);const object={};trackables.forEach(((n,i)=>{if(n==="_id")return;switch(types[i]){case Number:object[n]=numbers.shift();break;case Boolean:object[n]=booleans.shift();break;case Array:object[n]=arrays.shift();break}}));return object}setAttemptObject(object,silent=true){this.set(object,{silent:silent});this.restoreUserAnswers()}addAttemptObject(object=this.getAttemptObject()){const attemptStates=this.get("_attemptStates")||[];const state=this.getAttemptState(object);attemptStates.push(state);this.set("_attemptStates",attemptStates)}getAttemptObjects(){const states=this.get("_attemptStates")||[];return states.map((state=>this.getAttemptObject(state)))}}components$1.register("component",{model:ComponentModel});var ComponentModel$1=__AMD("core/js/models/componentModel",ComponentModel);class MenuModel extends ContentObjectModel{get _children(){logging$1.deprecated("menuModel._children, use menuModel.hasManagedChildren instead, child models are defined by the JSON");return"contentObjects"}getTypeGroup(){return"menu"}setCustomLocking(){const children=this.getAvailableChildModels();children.forEach((child=>{child.set("_isLocked",this.shouldLock(child));if(!(child instanceof MenuModel))return;child.checkLocking()}))}}components$1.register("menu",{model:MenuModel});var MenuModel$1=__AMD("core/js/models/menuModel",MenuModel);class CourseModel extends MenuModel$1{get _parent(){logging$1.deprecated("courseModel._parent, use courseModel.getParent() instead, parent models are defined by the JSON");return null}get _siblings(){logging$1.deprecated("courseModel._siblings, use courseModel.getSiblings() instead, sibling models are defined by the JSON");return null}getTypeGroup(){return"course"}}components$1.register("course",{model:CourseModel});__AMD("core/js/models/courseModel",CourseModel);class PageModel extends ContentObjectModel{get _children(){logging$1.deprecated("pageModel._children, use menuModel.hasManagedChildren instead, child models are defined by the JSON");return"articles"}getTypeGroup(){return"page"}}components$1.register("page",{model:PageModel});__AMD("core/js/models/pageModel",PageModel);var ChildEvent=__AMD("core/js/childEvent",class ChildEvent extends Backbone.Controller{initialize(type,target,model){this.type=type;this.target=target;this.isForced=false;this.isStoppedImmediate=false;this.isStoppedNext=false;this.hasRequestChild=false;this._model=model}get model(){return this._model}set model(model){if(this.type!=="requestChild"){logging$1.warn(`Cannot change model in ${this.type} event.`);return}if(this._model){logging$1.warn(`Cannot inject two models in one sitting. ${model.get("_id")} attempts to overwrite ${this._model.get("_id")}`);return}this._model=model;this.hasRequestChild=true}reset(){this.isStoppedImmediate=false;this.isStoppedNext=false}force(){this.isForced=true}stop(immediate=true){if(!immediate){return this.stopNext()}this.isStoppedImmediate=true}stopNext(){this.isStoppedNext=true}close(){this.trigger("closed")}});class AdaptView extends Backbone.View{attributes(){return{"data-adapt-id":this.model.get("_id"),role:"presentation"}}initialize(){this._jsxIgnoreChanges=0;this.listenTo(this.model,{"change:_isVisible":this.toggleVisibility,"change:_isHidden":this.toggleHidden,"change:_isComplete":this.onIsCompleteChange});this.isJSX=(this.constructor.template||"").includes(".jsx");if(this.isJSX){this._classSet=new Set(_.result(this,"className").trim().split(/\s+/));this.listenTo(this.model,"change",this.changed);const children=this.model?.getChildren?.();children&&this.listenTo(children,"change",this.changed);this.listenTo(Adapt$1,"device:changed",this.changed)}this.model.set({_globals:Adapt$1.course.get("_globals"),_isReady:false});this._isRemoved=false;if(location$1._currentId===this.model.get("_id")){Adapt$1.parentView=this}this.preRender();this.render();this.setupOnScreenHandler()}preRender(){}async postRender(){await this.addChildren()}render(){const type=this.constructor.type;Adapt$1.trigger(`${type}View:preRender view:preRender`,this);if(this.isJSX){this.changed()}else{const data=this.model.toJSON();data.view=this;const template=Handlebars.templates[this.constructor.template];this.$el.html(template(data))}Adapt$1.trigger(`${type}View:render view:render`,this);_.defer((async()=>{if(this._isRemoved)return;await this.postRender();Adapt$1.trigger(`${type}View:postRender view:postRender`,this)}));return this}changed(eventName=null){if(this._jsxIgnoreChanges!==0)return;if(!this.isJSX)return;if(typeof eventName==="string"&&eventName.startsWith("bubble")){return}if(!this.model.get("_isRendered"))return;const props={...this,...this.model.toJSON(),_globals:Adapt$1.course.get("_globals")};const Template=templates[this.constructor.template.replace(".jsx","")];this.updateViewProperties();ReactDOM__default["default"].render(React__default["default"].createElement(Template,props),this.el)}stopRendering(){this._jsxIgnoreChanges++}startRendering(){this._jsxIgnoreChanges--;if(this._jsxIgnoreChanges<0){this._jsxIgnoreChanges=0}}updateViewProperties(){const classesToAdd=_.result(this,"className").trim().split(/\s+/);classesToAdd.forEach((i=>this._classSet.add(i)));const classesToRemove=[...this._classSet].filter((i=>!classesToAdd.includes(i)));classesToRemove.forEach((i=>this._classSet.delete(i)));this._setAttributes({..._.result(this,"attributes"),id:_.result(this,"id")});this.$el.removeClass(classesToRemove).addClass(classesToAdd)}setupOnScreenHandler(){const onscreen=this.model.get("_onScreen");if(!onscreen?._isEnabled)return;this.$el.addClass(`has-animation ${onscreen._classes}-before`);this.$el.on("onscreen.adaptView",((e,m)=>{if(!m.onscreen)return;const minVerticalInview=onscreen._percentInviewVertical||33;if(m.percentInviewVertical<minVerticalInview)return;this.$el.addClass(`${onscreen._classes}-after`).off("onscreen.adaptView")}))}async addChildren(){this.nthChild=this.nthChild||0;let addedCount=await this.addDescendants(false);while(true){const models=this.model.getAvailableChildModels();const event=this._getAddChildEvent(models[this.nthChild]);if(!event){break}if(event.isForced){event.reset()}if(event.isStoppedImmediate||!event.model){const subsequentModels=models.slice(this.nthChild);subsequentModels.forEach((model=>model.setOnChildren("_isRendered",false)));break}const model=event.model;model.set({_isRendered:true,_nthChild:++this.nthChild});const ChildView=this.constructor.childView||components$1.getViewClass(model);if(!ChildView){throw new Error(`The component '${model.attributes._id}' ('${model.attributes._component}') has not been installed, and so is not available in your project.`)}const childView=new ChildView({model:model});this.addChildView(childView);addedCount++;if(event.isStoppedNext){break}}if(!addedCount){return addedCount}this.model.set("_isReady",false);return addedCount}addChildView(childView){const childModel=childView.model;const type=childModel.get("_type");const childViews=this.getChildViews()||[];childViews.push(childView);this.setChildViews(childViews);const $parentContainer=this.$(this.constructor.childContainer);switch(childModel.get("_renderPosition")){case"outer-append":this.$el.append(childView.$el);break;case"inner-append":default:$parentContainer.append(childView.$el);break}Adapt$1.trigger(`${type}View:childAdded view:childAdded`,this,childView);return childView}async addDescendants(){let addedDescendantCount=0;const childViews=this.getChildViews();if(!childViews){return addedDescendantCount}for(let i=0,l=childViews.length;i<l;i++){const view=childViews[i];addedDescendantCount=view.addChildren?await view.addChildren():0;if(addedDescendantCount){break}}if(!addedDescendantCount){this.model.checkReadyStatus();return addedDescendantCount}this.model.set("_isReady",false);return addedDescendantCount}async whenReady(){if(this.model.get("_isReady"))return;return new Promise((resolve=>{const onReadyChange=(model,value)=>{if(!value)return;this.stopListening(this.model,"change:_isReady",onReadyChange);resolve()};this.listenTo(this.model,"change:_isReady",onReadyChange);this.model.checkReadyStatus()}))}_getAddChildEvent(model){const isRequestChild=!model;const event=new ChildEvent(null,this,model);if(isRequestChild){const canRequestChild=this.model.get("_canRequestChild");if(!canRequestChild){return}event.type="requestChild";Adapt$1.trigger("view:requestChild",event);if(!event.hasRequestChild){event.close();return}model=event.model}const type=model.get("_type");event.type="addChild";Adapt$1.trigger(`${type}View:addChild view:addChild`,event);event.close();return event}findDescendantViews(isParentFirst){const descendants=[];const childViews=this.getChildViews();childViews?.forEach((view=>{if(isParentFirst)descendants.push(view);const children=view.findDescendantViews?.(isParentFirst);if(children)descendants.push(...children);if(!isParentFirst)descendants.push(view)}));return descendants}setReadyStatus(){this.model.setReadyStatus()}setCompletionStatus(){this.model.setCompletionStatus()}resetCompletionStatus(type){if(!this.model.get("_canReset"))return;const descendantComponents=this.model.findDescendantModels("component");if(descendantComponents.length===0){this.model.reset(type)}else{descendantComponents.forEach((model=>model.reset(type)))}}preRemove(){const type=this.constructor.type;Adapt$1.trigger(`${type}View:preRemove view:preRemove`,this);this.trigger("preRemove")}remove(){const type=this.constructor.type;this.preRemove();Adapt$1.trigger(`${type}View:remove view:remove`,this);this.trigger("remove");this._isRemoved=true;this.stopListening();Wait$1.for((end=>{if(this.isJSX){ReactDOM__default["default"].unmountComponentAtNode(this.el)}this.$el.off("onscreen.adaptView");super.remove();_.defer((()=>{Adapt$1.trigger(`${type}View:postRemove view:postRemove`,this);this.trigger("postRemove")}));end()}));return this}setVisibility(){return this.model.get("_isVisible")?"":"u-visibility-hidden"}toggleVisibility(){this.$el.toggleClass("u-visibility-hidden",!this.model.get("_isVisible"))}setHidden(){return this.model.get("_isHidden")?"u-display-none":""}toggleHidden(){this.$el.toggleClass("u-display-none",this.model.get("_isHidden"))}onIsCompleteChange(model,isComplete){this.$el.toggleClass("is-complete",isComplete)}getChildViews(){if(!this._childViews)return null;return Object.entries(this._childViews).map((([key,value])=>value))}setChildViews(value){this._childViews=value}get childViews(){logging$1.deprecated("view.childViews use view.getChildViews() and view.setChildViews([])");if(Array.isArray(this._childViews)){return _.indexBy(this._childViews,(view=>view.model.get("_id")))}return this._childViews}set childViews(value){logging$1.deprecated("view.childViews use view.getChildViews() and view.setChildViews([])");this.setChildViews(value)}}AdaptView.className="";var AdaptView$1=__AMD("core/js/views/adaptView",AdaptView);var RouterModel=__AMD("core/js/models/routerModel",class RouterModel extends LockingModel{defaults(){return{_canNavigate:true,_shouldNavigateFocus:true}}lockedAttributes(){return{_canNavigate:false,_shouldNavigateFocus:false}}});class Router extends Backbone.Router{routes(){return{"":"handleRoute","id/:id":"handleRoute","preview/:id":"handlePreview",":pluginName(/*location)(/*action)":"handleRoute"}}initialize({model:model}){this.navigateToElement=this.navigateToElement.bind(this);this._isBackward=false;this.model=model;this._navigationRoot=null;this._isCircularNavigationInProgress=false;this.showLoading();this.$wrapper=$("#wrapper");this.$html=$("html");this.listenToOnce(Adapt$1,"app:dataReady",this.setDocumentTitle);this.listenTo(Adapt$1,"router:navigateTo",this.navigateToArguments)}get rootModel(){return this._navigationRoot||Adapt$1.course}set rootModel(model){this._navigationRoot=model}showLoading(){$("html").removeClass("is-loading-hidden").addClass("is-loading-visible");$(".js-loading").show()}hideLoading(){$("html").addClass("is-loading-hidden").removeClass("is-loading-visible");$(".js-loading").hide()}setDocumentTitle(){const currentModel=location$1._currentModel;const hasSubTitle=currentModel&&currentModel!==router.rootModel&&currentModel.get("title");const title=[this.rootModel.get("title"),hasSubTitle&&currentModel.get("title")].filter(Boolean).join(" | ");this.listenToOnce(Adapt$1,"contentObjectView:preRender",(()=>{const escapedTitle=$(`<div>${title}</div>`).text();document.title=escapedTitle}))}navigateToArguments(args){args=args.filter((v=>v!==null));const options={trigger:false,replace:false};if(args.length===1&&data$1.findById(args[0])){this.navigate("#/id/"+args[0],options);return}if(args.length<=3){this.navigate("#/"+args.join("/"),options);return}logging$1.deprecated("Use Backbone.history.navigate or window.location.href instead of Adapt.trigger('router:navigateTo')");this.handleRoute(...args)}handlePreview(...args){args=args.filter((v=>v!==null));if(this.model.get("_canNavigate")){this._isCircularNavigationInProgress=false}if(this._isCircularNavigationInProgress===false){Adapt$1.trigger("router:navigate",args)}if(this.model.get("_canNavigate")){this.model.set("_canNavigate",false,{pluginName:"adapt"});this._isBackward=false;if(args.length<=1){return this.handleIdPreview(...args)}return this.handlePluginRouter(...args)}if(this._isCircularNavigationInProgress){this._isCircularNavigationInProgress=false;return}this._isCircularNavigationInProgress=true;Adapt$1.trigger("router:navigationCancelled",args);Backbone.history.history[this._isBackward?"forward":"back"]();this._isBackward=false}handleRoute(...args){args=args.filter((v=>v!==null));if(this.model.get("_canNavigate")){this._isCircularNavigationInProgress=false}if(this._isCircularNavigationInProgress===false){Adapt$1.trigger("router:navigate",args)}if(this.model.get("_canNavigate")){this.model.set("_canNavigate",false,{pluginName:"adapt"});this._isBackward=false;if(args.length<=1){return this.handleId(...args)}return this.handlePluginRouter(...args)}if(this._isCircularNavigationInProgress){this._isCircularNavigationInProgress=false;return}this._isCircularNavigationInProgress=true;Adapt$1.trigger("router:navigationCancelled",args);Backbone.history.history[this._isBackward?"forward":"back"]();this._isBackward=false}async handlePluginRouter(pluginName,location,action){const pluginLocation=[pluginName,location&&`-${location}`,action&&`-${action}`].filter(Boolean).join("");await this.updateLocation(pluginLocation,null,null,null);Adapt$1.trigger("router:plugin:"+pluginName,pluginName,location,action);Adapt$1.trigger("router:plugin",pluginName,location,action);this.model.set("_canNavigate",true,{pluginName:"adapt"})}async handleId(id){const rootModel=router.rootModel;let model=!id?rootModel:data$1.findById(id);if(!model){this.model.set("_canNavigate",true,{pluginName:"adapt"});return}const isContentObject=model.isTypeGroup?.("contentobject");const navigateToId=model.get("_id");model=isContentObject?model:model.findAncestor("contentobject");id=model.get("_id");const isRoot=model===rootModel;if(isRoot&&Adapt$1.course.has("_start")){const startController=Adapt$1.course.get("_start");if(startController._isEnabled===true&&startController._isMenuDisabled===true){return}}if(model.get("_isLocked")&&Adapt$1.config.get("_forceRouteLocking")){logging$1.warn("Unable to navigate to locked id: "+id);this.model.set("_canNavigate",true,{pluginName:"adapt"});if(location$1._previousId===undefined){return this.navigate("#/",{trigger:true,replace:true})}return this.navigateBack()}this.showLoading();await Adapt$1.remove();await this.removePreviews();const isCourse=model.isTypeGroup?.("course");const type=isCourse?"menu":model.get("_type");const newLocation=isCourse?"course":`${type}-${id}`;model.set({_isVisited:true,_isRendered:true});await this.updateLocation(newLocation,type,id,model);Adapt$1.once("contentObjectView:ready",(()=>{this.model.set("_canNavigate",true,{pluginName:"adapt"});this.handleNavigationFocus()}));Adapt$1.trigger(`router:${type} router:contentObject`,model);const ViewClass=components$1.getViewClass(model);const isMenu=model.isTypeGroup?.("menu");if(!ViewClass&&isMenu){logging$1.deprecated(`Using event based menu view instantiation for '${components$1.getViewName(model)}'`);return}if(!isMenu){_.invoke(model.getAllDescendantModels(),"checkIfResetOnRevisit");await Adapt$1.deferUntilCompletionChecked()}this.$wrapper.append(new ViewClass({model:model}).$el);if(!isContentObject&&!this.isScrolling){await this.navigateToElement("."+navigateToId,{replace:true,duration:400})}}async handleIdPreview(id){const rootModel=router.rootModel;let model=!id?rootModel:data$1.findById(id);if(!model){this.model.set("_canNavigate",true,{pluginName:"adapt"});return}this.showLoading();await Adapt$1.remove();await this.removePreviews();let isContentObject=model.isTypeGroup?.("contentobject");if(!isContentObject){const types=["page","article","block","component"];const type=model.get("_type");const buildTypes=types.slice(0,types.indexOf(type));let parentModel=Adapt$1.course;let _parentId=parentModel.get("_id");const built=buildTypes.map(((_type,index)=>{const ModelClass=components$1.getModelClass({_type:_type});const _id=`preview-${_type}`;const builtModel=new ModelClass({_type:_type,_id:_id,_parentId:_parentId,_isPreview:true});if(index)parentModel.getChildren().add(builtModel);data$1.add(builtModel);parentModel=builtModel;_parentId=_id;return builtModel}));model.deepClone(((clone,orig)=>{clone.set({_isAvailable:true,_isLocked:false});clone.on("change",(function(){const state=this.getAttemptObject?this.getAttemptObject():this.getTrackableState();delete state._id;delete state._isAvailable;delete state._isLocked;if(this.getAttemptObject)orig.setAttemptObject(state);else orig.set(state)}));if(orig!==model)return;clone.set({_parentId:_parentId})}));built.forEach((model=>model.setupModel()));isContentObject=true;model=built[0];model.setOnChildren({_isPreview:true})}model.get("_id");model=isContentObject?model:model.findAncestor("contentobject");id=model.get("_id");const isCourse=model.isTypeGroup?.("course");const type=isCourse?"menu":model.get("_type");const newLocation=isCourse?"course":`${type}-${id}`;model.set({_isVisited:true,_isRendered:true});await this.updateLocation(newLocation,type,id,model);Adapt$1.once("contentObjectView:ready",(()=>{this.model.set("_canNavigate",true,{pluginName:"adapt"});this.handleNavigationFocus()}));Adapt$1.trigger(`router:${type} router:contentObject`,model);const ViewClass=components$1.getViewClass(model);const isMenu=model.isTypeGroup?.("menu");if(!ViewClass&&isMenu){logging$1.deprecated(`Using event based menu view instantiation for '${components$1.getViewName(model)}'`);return}if(!isMenu){_.invoke(model.getAllDescendantModels(),"checkIfResetOnRevisit");await Adapt$1.deferUntilCompletionChecked()}this.$wrapper.append(new ViewClass({model:model}).$el)}async removePreviews(){const previews=data$1.filter((model=>model.get("_isPreview")));previews.forEach((model=>data$1.remove(model)))}async updateLocation(currentLocation,type,id,currentModel){location$1._previousModel=location$1._currentModel;location$1._previousId=location$1._currentId;location$1._previousContentType=location$1._contentType;location$1._currentModel=currentModel;location$1._currentId=id;location$1._contentType=type;location$1._currentLocation=currentLocation;if(type==="menu"){location$1._lastVisitedType="menu";location$1._lastVisitedMenu=id}else if(type==="page"){location$1._lastVisitedType="page";location$1._lastVisitedPage=id}this.setDocumentTitle();this.setGlobalClasses();Adapt$1.trigger("router:location",location$1);await Wait$1.queue()}setGlobalClasses(){const currentModel=location$1._currentModel;const htmlClasses=currentModel?.get("_htmlClasses")||"";const classes=location$1._currentId?`location-${location$1._contentType} location-id-${location$1._currentId}`:`location-${location$1._currentLocation}`;const currentClasses=`${classes} ${htmlClasses}`;this.$html.removeClass(location$1._previousClasses).addClass(currentClasses).attr("data-location",location$1._currentLocation);this.$wrapper.removeClass().addClass(classes).attr("data-location",location$1._currentLocation);location$1._previousClasses=currentClasses}handleNavigationFocus(){if(!this.model.get("_shouldNavigateFocus"))return;a11y$1.focus("body")}navigateBack(){this._isBackward=true;Backbone.history.history.back()}navigateToCurrentRoute(force){if(!this.model.get("_canNavigate")&&!force){return}if(!location$1._currentId){return}const currentId=location$1._currentModel.get("_id");const isRoot=location$1._currentModel===this.rootModel;const route=isRoot?"#/":"#/id/"+currentId;this.navigate(route,{trigger:true,replace:true})}navigateToPreviousRoute(force){if(!this.model.get("_canNavigate")&&!force){return}const currentModel=location$1._currentModel;const previousModel=location$1._previousModel;if(!currentModel){return this.navigateBack()}if(location$1._currentModel?.isTypeGroup("menu")){return this.navigateToParent()}if(previousModel){return this.navigateBack()}this.navigateToParent()}navigateToParent(force){if(!this.model.get("_canNavigate")&&!force){return}const parentId=location$1._currentModel.get("_parentId");const parentModel=data$1.findById(parentId);const isRoot=parentModel===this.rootModel;const route=isRoot?"#/":"#/id/"+parentId;this.navigate(route,{trigger:true})}navigateToHomeRoute(force){if(!this.model.get("_canNavigate")&&!force){return}this.navigate("#/",{trigger:true})}async navigateToElement(selector,settings={}){const currentModelId=typeof selector==="string"&&selector.replace(/\./g,"").split(" ")[0];const isSelectorAnId=data$1.hasId(currentModelId);if(isSelectorAnId){const currentModel=data$1.findById(currentModelId);const contentObject=currentModel.isTypeGroup?.("contentobject")?currentModel:currentModel.findAncestor("contentobject");const contentObjectId=contentObject.get("_id");const isNotInCurrentContentObject=contentObjectId!==location$1._currentId;if(currentModel&&(!currentModel.get("_isRendered")||!currentModel.get("_isReady")||isNotInCurrentContentObject)){const shouldReplace=settings.replace||false;if(isNotInCurrentContentObject){this.isScrolling=true;this.navigate(`#/id/${currentModelId}`,{trigger:true,replace:shouldReplace});this.model.set("_shouldNavigateFocus",false,{pluginName:"adapt"});await new Promise((resolve=>Adapt$1.once("contentObjectView:ready",_.debounce((()=>{this.model.set("_shouldNavigateFocus",true,{pluginName:"adapt"});resolve()}),1))));this.isScrolling=false;if(currentModel.isTypeGroup("contentobject")){a11y$1.focusFirst(document.body);return}}await Adapt$1.parentView.renderTo(currentModelId)}if(currentModel&&selector===currentModel.get("_id")){selector=`.${selector}`}}const isElementUnavailable=!$(selector).length;if(isElementUnavailable){logging$1.warn(`router.navigateToElement, selector not found in document: ${selector}`);return}const newLocation=location$1._contentType?location$1._contentType:location$1._currentLocation;Adapt$1.trigger(`${newLocation}:scrollTo`,selector);const disableScrollToAnimation=Adapt$1.config.has("_disableAnimation")?Adapt$1.config.get("_disableAnimation"):false;if(disableScrollToAnimation){settings.duration=0}else if(!settings.duration){settings.duration=$.scrollTo.defaults.duration}const $wrapper=$("#wrapper");let offsetTop=-parseInt($wrapper.css("padding-top"));if($(selector).hasClass("component")){offsetTop-=$(selector).find(".aria-label").height()||0}if(!settings.offset)settings.offset={top:offsetTop,left:0};if(settings.offset.top===undefined)settings.offset.top=offsetTop;if(settings.offset.left===undefined)settings.offset.left=0;if(settings.offset.left===0)settings.axis="y";if(Adapt$1.get("_canScroll")!==false){$.scrollTo(selector,settings)}await new Promise((resolve=>{_.delay((()=>{a11y$1.focusNext(selector);Adapt$1.trigger(`${newLocation}:scrolledTo`,selector);resolve()}),settings.duration+300)}))}get(...args){logging$1.deprecated("router.get, please use router.model.get");return this.model.get(...args)}set(...args){logging$1.deprecated("router.set, please use router.model.set");return this.model.set(...args)}}const router=new Router({model:new RouterModel(null,{reset:true})});var router$1=__AMD("core/js/router",router);var ContentObjectView=__AMD("core/js/views/contentObjectView",class ContentObjectView extends AdaptView$1{attributes(){return AdaptView$1.resultExtend("attributes",{role:"main"},this)}className(){return[this.constructor.type,"contentobject",this.constructor.className,this.model.get("_id"),this.model.get("_classes"),this.setVisibility(),this.model.get("_isComplete")?"is-complete":"",this.model.get("_isOptional")?"is-optional":""].filter(Boolean).join(" ")}preRender(){$.inview.lock(this.constructor.type+"View");this.disableAnimation=Adapt$1.config.has("_disableAnimation")?Adapt$1.config.get("_disableAnimation"):false;this.$el.css("opacity",0);this.listenTo(this.model,"change:_isReady",this.isReady);this._loadingErrorTimeout=setTimeout((()=>data$1.logReadyError(this)),1e4)}render(){const type=this.constructor.type;Adapt$1.trigger(`${type}View:preRender contentObjectView:preRender view:preRender`,this);if(this.isJSX){this.changed()}else{const data=this.model.toJSON();data.view=this;const template=Handlebars.templates[this.constructor.template];this.$el.html(template(data))}Adapt$1.trigger(`${type}View:render contentObjectView:render view:render`,this);_.defer((()=>{if(this._isRemoved)return;this.postRender();Adapt$1.trigger(`${type}View:postRender contentObjectView:postRender view:postRender`,this)}));return this}async isReady(){if(!this.model.get("_isReady")||this._isTriggeredReady)return;this._isTriggeredReady=true;clearTimeout(this._loadingErrorTimeout);delete this._loadingErrorTimeout;const type=this.constructor.type;const performIsReady=async()=>{Adapt$1.trigger(`${type}View:preReady contentObjectView:preReady view:preReady`,this);await Wait$1.queue();router$1.hideLoading();if(Adapt$1.get("_shouldContentObjectScrollTop")!==false){$(window).scrollTop(0)}Adapt$1.trigger(`${type}View:ready contentObjectView:ready view:ready`,this);$.inview.unlock(`${type}View`);const styleOptions={opacity:1};if(this.disableAnimation){this.$el.css(styleOptions);$.inview();_.defer((()=>{Adapt$1.trigger(`${type}View:postReady contentObjectView:postReady view:postReady`,this)}))}else{this.$el.velocity(styleOptions,{duration:"fast",complete:()=>{$.inview();Adapt$1.trigger(`${type}View:postReady contentObjectView:postReady view:postReady`,this)}})}$(window).scroll()};_.defer(performIsReady)}async renderTo(id){const isRenderToSelf=id===this.model.get("_id");if(isRenderToSelf)return;let models=this.model.getAllDescendantModels(true).filter((model=>model.get("_isAvailable")));const index=models.findIndex((model=>model.get("_id")===id));if(index===-1){throw new Error(`Cannot renderTo "${id}" as it isn't a descendant.`)}const model=models[index];if(model.get("_isRendered")&&model.get("_isReady")){return}models=models.slice(0,index+1);const isLocked=models.some((model=>model.get("_isLocked")));if(isLocked)throw new Error(`Cannot renderTo ${id} as it is preceded by locked content`);const ids=_.indexBy(models,(model=>model.get("_id")));const forceUntilId=event=>{const addingId=event.model.get("_id");if(!ids[addingId])return;event.force();if(addingId!==id)return;Adapt$1.off("view:addChild",forceUntilId)};Adapt$1.on("view:addChild",forceUntilId);await this.addChildren();await this.whenReady();if(!model.get("_isRendered")||!model.get("_isReady")){throw new Error(`Cannot renderTo "${id}".`)}}preRemove(){const type=this.constructor.type;Adapt$1.trigger(`${type}View:preRemove contentObjectView:preRemove view:preRemove`,this);this.trigger("preRemove")}remove(){const type=this.constructor.type;this.preRemove();Adapt$1.trigger(`${type}View:remove contentObjectView:remove view:remove`,this);this.trigger("remove");this._isRemoved=true;Wait$1.for((end=>{if(this.isJSX){ReactDOM__default["default"].unmountComponentAtNode(this.el)}this.$el.off("onscreen.adaptView");this.findDescendantViews().reverse().forEach((view=>{view.remove()}));this.setChildViews(null);super.remove();_.defer((()=>{Adapt$1.trigger(`${type}View:postRemove contentObjectView:postRemove view:postRemove`,this);this.trigger("postRemove")}));end()}));return this}destroy(){this.remove();if(Adapt$1.parentView===this){Adapt$1.parentView=null}}});class PageView extends ContentObjectView{remove(){if(this.$pageLabel){this.$pageLabel.remove()}super.remove()}}Object.assign(PageView,{childContainer:".article__container",type:"page",template:"page"});components$1.register("page",{view:PageView});__AMD("core/js/views/pageView",PageView);class ArticleView extends AdaptView$1{className(){return["article",this.model.get("_id"),this.model.get("_classes"),this.setVisibility(),this.setHidden(),this.model.get("_isComplete")?"is-complete":"",this.model.get("_isOptional")?"is-optional":""].join(" ")}}Object.assign(ArticleView,{childContainer:".block__container",type:"article",template:"article"});components$1.register("article",{view:ArticleView});var ArticleView$1=__AMD("core/js/views/articleView",ArticleView);class BlockView extends AdaptView$1{className(){return["block",this.model.get("_id"),this.model.get("_classes"),this.setVisibility(),this.setHidden(),this.model.get("_isComplete")?"is-complete":"",this.model.get("_isOptional")?"is-optional":""].join(" ")}}Object.assign(BlockView,{childContainer:".component__container",type:"block",template:"block"});components$1.register("block",{view:BlockView});__AMD("core/js/views/blockView",BlockView);class MPABC extends Backbone.Controller{initialize(){this.listenTo(data$1,{loading:this.waitForDataLoaded,loaded:this.onDataLoaded});this.setupSubsetCollections()}waitForDataLoaded(){Wait$1.begin()}onDataLoaded(){Wait$1.end()}setupSubsetCollections(){Adapt$1.contentObjects=new AdaptSubsetCollection(null,{parent:data$1,model:ContentObjectModel});Adapt$1.articles=new AdaptSubsetCollection(null,{parent:data$1,model:ArticleModel$1});Adapt$1.blocks=new AdaptSubsetCollection(null,{parent:data$1,model:BlockModel$1});Adapt$1.components=new AdaptSubsetCollection(null,{parent:data$1,model:ComponentModel$1})}}const mpabc=new MPABC;var mpabc$1=__AMD("core/js/mpabc",mpabc);var NotifyPushView=__AMD("core/js/views/notifyPushView",class NotifyPushView extends Backbone.View{className(){const classes=["notify-push",this.model.get("_classes"),this.model.get("_type")==="a11y-push"&&"aria-label"].filter(Boolean).join(" ");return classes}attributes(){return{role:"dialog","aria-labelledby":"notify-push-heading","aria-modal":"false"}}initialize(){this.listenTo(Adapt$1,{"notify:pushShown notify:pushRemoved":this.updateIndexPosition,remove:this.remove});this.listenTo(this.model.collection,{remove:this.updateIndexPosition,"change:_index":this.updatePushPosition});this.preRender();this.render()}events(){return{"click .js-notify-push-close-btn":"closePush","click .js-notify-push-inner":"triggerEvent"}}preRender(){this.hasBeenRemoved=false}render(){const data=this.model.toJSON();const template=Handlebars.templates.notifyPush;this.$el.html(template(data)).appendTo(".notify__push-container");_.defer(this.postRender.bind(this));return this}postRender(){this.$el.addClass("is-active");_.delay(this.closePush.bind(this),this.model.get("_timeout"));Adapt$1.trigger("notify:pushShown")}closePush(event){if(event){event.preventDefault()}if(this.hasBeenRemoved===false){this.hasBeenRemoved=true;this.$el.removeClass("is-active");_.delay((()=>{this.model.collection.remove(this.model);Adapt$1.trigger("notify:pushRemoved",this);this.remove()}),600)}}triggerEvent(event){Adapt$1.trigger(this.model.get("_callbackEvent"));this.closePush()}updateIndexPosition(){if(this.hasBeenRemoved)return;const models=this.model.collection.models;models.forEach(((model,index)=>{if(!model.get("_isActive"))return;model.set("_index",index);this.updatePushPosition()}))}updatePushPosition(){if(this.hasBeenRemoved){return}if(typeof this.model.get("_index")!=="undefined"){const elementHeight=this.$el.height();const offset=20;const navigationHeight=$(".nav").height();const currentIndex=this.model.get("_index");let flippedIndex=currentIndex===0?1:0;if(this.model.collection.where({_isActive:true}).length===1){flippedIndex=0}const positionLowerPush=(elementHeight+offset)*flippedIndex+navigationHeight+offset;this.$el.css("top",positionLowerPush)}}});var NotifyModel=__AMD("core/js/models/notifyModel",class NotifyModel extends LockingModel{defaults(){return{_isActive:false,_showIcon:false,_timeout:3e3}}});var NotifyPushCollection=__AMD("core/js/collections/notifyPushCollection",class NotifyPushCollection extends Backbone.Collection{initialize(){this.model=NotifyModel;this.listenTo(this,"add",this.onPushAdded);this.listenTo(Adapt$1,"notify:pushRemoved",this.onRemovePush)}onPushAdded(model){this.checkPushCanShow(model)}checkPushCanShow(model){if(!this.canShowPush())return;model.set("_isActive",true);this.showPush(model)}canShowPush(){const availablePushNotifications=this.where({_isActive:true});return availablePushNotifications.length<2}showPush(model){new NotifyPushView({model:model})}onRemovePush(view){const inactivePushNotifications=this.where({_isActive:false});if(inactivePushNotifications.length>0){this.checkPushCanShow(inactivePushNotifications[0])}}});var NotifyPopupView=__AMD("core/js/views/notifyPopupView",class NotifyPopupView extends Backbone__default["default"].View{className(){return`notify ${this.model.get("_classes")||""}`}attributes(){return Object.assign({role:"dialog","aria-labelledby":"notify-heading","aria-modal":"true"},this.model.get("_attributes"))}events(){return{"click .js-notify-btn-alert":"onAlertButtonClicked","click .js-notify-btn-prompt":"onPromptButtonClicked","click .js-notify-close-btn":"onCloseButtonClicked","click .js-notify-shadow-click":"onShadowClicked"}}initialize({notify:notify}){this.notify=notify;_.bindAll(this,"resetNotifySize","onKeyUp");this.disableAnimation=Adapt$1.config.get("_disableAnimation")||false;this.isOpen=false;this.hasOpened=false;this.setupEventListeners();this.render()}setupEventListeners(){this.listenTo(Adapt$1,{remove:this.closeNotify,"notify:resize":this.resetNotifySize,"notify:cancel":this.cancelNotify,"notify:close":this.closeNotify,"device:resize":this.resetNotifySize});this.setupEscapeKey()}setupEscapeKey(){$(window).on("keyup",this.onKeyUp)}onKeyUp(event){if(event.which!==27)return;event.preventDefault();this.cancelNotify()}render(){const data=this.model.toJSON();const template=Handlebars.templates.notifyPopup;this.$el.css("visibility","hidden");this.$el.html(template(data)).appendTo(".notify__popup-container");this.$(".notify__popup").css("visibility","hidden");this.$el.css("visibility","visible");this.showNotify();return this}onAlertButtonClicked(event){event.preventDefault();this.closeNotify();Adapt$1.trigger(this.model.get("_callbackEvent"),this)}onPromptButtonClicked(event){event.preventDefault();this.closeNotify();Adapt$1.trigger($(event.currentTarget).attr("data-event"),this)}onCloseButtonClicked(event){event.preventDefault();this.cancelNotify()}onShadowClicked(event){event.preventDefault();if(this.model.get("_closeOnShadowClick")===false)return;this.cancelNotify()}cancelNotify(){if(this.model.get("_isCancellable")===false)return;this.closeNotify();Adapt$1.trigger("notify:cancelled",this)}resetNotifySize(){if(!this.hasOpened)return;this.resizeNotify()}resizeNotify(){const windowHeight=$(window).height();const notifyHeight=this.$(".notify__popup-inner").outerHeight();const isFullWindow=notifyHeight>=windowHeight;this.$(".notify__popup").css({height:isFullWindow?"100%":"auto",top:isFullWindow?0:"","margin-top":isFullWindow?"":-(notifyHeight/2),"overflow-y":isFullWindow?"scroll":"","-webkit-overflow-scrolling":isFullWindow?"touch":""})}async showNotify(){this.isOpen=true;await this.addSubView();this.notify.stack.push(this);this.$previousActiveElement=$(document.activeElement);Adapt$1.trigger("notify:opened",this);this.$el.imageready(this.onLoaded.bind(this))}onLoaded(){if(this.disableAnimation){this.$(".notify__shadow").css("display","block")}else{this.$(".notify__shadow").velocity({opacity:0},{duration:0}).velocity({opacity:1},{duration:400,begin:()=>{this.$(".notify__shadow").css("display","block")}})}this.resizeNotify();if(this.disableAnimation){this.$(".notify__popup").css("visibility","visible");this.onOpened()}else{this.$(".notify__popup").velocity({opacity:0},{duration:0}).velocity({opacity:1},{duration:400,begin:()=>{this.$(".notify__popup").css("visibility","visible");this.onOpened()}})}}onOpened(){$.inview();this.hasOpened=true;a11y$1.popupOpened(this.$el);a11y$1.scrollDisable("body");$("html").addClass("notify");a11y$1.focusFirst(this.$(".notify__popup"),{defer:false})}async addSubView(){this.subView=this.model.get("_view");if(this.model.get("_shouldRenderId")&&this.model.get("_id")){const model=data$1.findById(this.model.get("_id"));const View=components$1.getViewClass(model);this.subView=new View({model:model})}if(!this.subView)return;this.subView.$el.on("resize",this.resetNotifySize);this.$(".notify__content-inner").append(this.subView.$el);if(!(this.subView instanceof AdaptView$1)||this.subView.model.get("_isReady"))return;return new Promise((resolve=>{const check=(model,value)=>{if(!value)return;this.subView.model.off("change:_isReady",check);resolve()};this.subView.model.on("change:_isReady",check)}))}closeNotify(){const stackItem=this.notify.stack[this.notify.stack.length-1];if(this!==stackItem)return;this.notify.stack.pop();if(!this.isOpen)return;this.isOpen=false;if(this.hasOpened){this.onCloseReady();return}this.listenToOnce(Adapt$1,"popup:opened",(()=>{_.defer(this.onCloseReady.bind(this))}))}onCloseReady(){if(this.disableAnimation){this.$(".notify__popup").css("visibility","hidden");this.$el.css("visibility","hidden");this.remove()}else{this.$(".notify__popup").velocity({opacity:0},{duration:400,complete:()=>{this.$(".notify__popup").css("visibility","hidden")}});this.$(".notify__shadow").velocity({opacity:0},{duration:400,complete:()=>{this.$el.css("visibility","hidden");this.remove()}})}a11y$1.scrollEnable("body");$("html").removeClass("notify");a11y$1.popupClosed(this.$previousActiveElement);Adapt$1.trigger("notify:closed",this)}remove(...args){this.removeSubView();$(window).off("keyup",this.onKeyUp);super.remove(...args)}removeSubView(){if(!this.subView)return;this.subView.$el.off("resize",this.resetNotifySize);if(this.subView instanceof AdaptView$1){const views=[...this.subView.findDescendantViews(),this.subView];views.forEach((view=>{view.model.set("_isReady",false);view.remove()}))}else{this.subView.remove()}this.subView=null}});var NotifyView=__AMD("core/js/views/notifyView",class NotifyView extends Backbone.View{className(){return"notify__container"}initialize(){this._stack=[];this.notifyPushes=new NotifyPushCollection;this.listenTo(Adapt$1,{"notify:popup":this._deprecated.bind(this,"popup"),"notify:alert":this._deprecated.bind(this,"alert"),"notify:prompt":this._deprecated.bind(this,"prompt"),"notify:push":this._deprecated.bind(this,"push")});this.render()}get stack(){return this._stack}get isOpen(){return this.stack.length>0}_deprecated(type,notifyObject){logging$1.deprecated(`NOTIFY DEPRECATED: Adapt.trigger('notify:${type}', notifyObject); is no longer supported, please use notify.${type}(notifyObject);`);return this.create(notifyObject,{_type:type})}render(){const notifyTemplate=Handlebars.templates.notify;this.$el.html(notifyTemplate());this.$el.appendTo("body")}create(notifyObject,defaults){notifyObject=_.defaults({},notifyObject,defaults,{_type:"popup",_shouldRenderId:false,_isCancellable:true,_showCloseButton:true,_closeOnShadowClick:true});if(notifyObject._type==="a11y-push")notifyObject._showCloseButton=false;switch(notifyObject._type){case"a11y-push":case"push":this.notifyPushes.push(notifyObject);return}return new NotifyPopupView({model:new NotifyModel(notifyObject),notify:this})}popup(notifyObject){return this.create(notifyObject,{_type:"popup"})}alert(notifyObject){return this.create(notifyObject,{_type:"alert"})}prompt(notifyObject){return this.create(notifyObject,{_type:"prompt"})}push(notifyObject){return this.create(notifyObject,{_type:"push"})}});const notify=new NotifyView;var notify$1=__AMD("core/js/notify",notify);class Scrolling extends Backbone.Controller{initialize(){this.scrollTo=this.scrollTo.bind(this);this.$html=$("html");this.isLegacyScrolling=true;Adapt$1.once("configModel:dataLoaded",this._loadConfig.bind(this))}_loadConfig(){const config=Adapt$1.config.get("_scrollingContainer");if(!config?._isEnabled)return;const limitTo=config._limitToSelector;const isIncluded=!limitTo||this.$html.is(limitTo)||this.$html.hasClass(limitTo);if(!isIncluded)return;this.isLegacyScrolling=false;this._windowScrollFix();this._addStyling();this._updateScrollbarWidth();this.listenTo(Adapt$1,"device:resize",this._updateScrollbarWidth)}_addStyling(){this.$html.addClass("adapt-scrolling")}_updateScrollbarWidth(){const $tester=$('<div class="outer" style="overflow:scroll; visibility: hidden; position:fixed; top: 0; left: 0;"><div class="inner"> </div></div>"');$("body").append($tester);const scrollBarWidth=$tester.outerWidth()-$tester.find(".inner").outerWidth();$tester.remove();const documentStyle=document.documentElement.style;documentStyle.setProperty("--adapt-scrollbar-width",`${scrollBarWidth}px`)}_windowScrollFix(){const body=document.body;const html=scrolling.$html[0];const scrollY={get:()=>body.scrollTop,set:value=>body.scrollTop=value};const scrollX={get:()=>body.scrollLeft,set:value=>body.scrollLeft=value};const scrollHeight={get:()=>body.scrollHeight,set:value=>body.scrollHeight=value};const scrollWidth={get:()=>body.scrollWidth,set:value=>body.scrollWidth=value};Object.defineProperties(window,{scrollY:scrollY,scrollX:scrollX,pageYOffset:scrollY,pageXOffset:scrollX});Object.defineProperties(html,{scrollHeight:scrollHeight,scrollWidth:scrollWidth});window.scrollTo=(...args)=>{const isObject=args.length===1&&typeof args[0]==="object"&&args[0]!==null;const left=(isObject?args[0].left:args[0])??null;const top=(isObject?args[0].top:args[1])??null;left!==null&&(body.scrollLeft=left);top!==null&&(body.scrollTop=top)};const MouseEvent=window.MouseEvent;Object.defineProperties(MouseEvent.prototype,{pageX:{get:function(){return this.clientX+scrollX.get()}},pageY:{get:function(){return this.clientY+scrollY.get()}}});const $window=$(window);$(document.body).on("scroll",(()=>$window.scroll()))}async scrollTo(selector,settings={}){logging$1.deprecated("Adapt.scrollTo and Adapt.scrolling.scrollTo, use router.navigateToElement instead.");return router$1.navigateToElement(selector,settings)}}const scrolling=new Scrolling;var scrolling$1=__AMD("core/js/scrolling",scrolling);class StartController extends Backbone.Controller{initialize(...args){super.initialize(...args);this._isSessionInProgress=false;this.model=null;this.setupListeners()}setupListeners(){this.listenTo(Adapt$1,{"adapt:start":this.onAdaptStart,"navigation:returnToStart":this.returnToStartLocation})}loadCourseData(){this.model=new LockingModel(Adapt$1.course.get("_start"))}setStartLocation(){if(!this._isSessionInProgress){this._isSessionInProgress=true;if(!this.isEnabled())return;return window.history.replaceState("","",this.getStartHash())}const hash=this.isEnabled()?this.getStartHash(false):"#/";router$1.navigate(hash,{trigger:true,replace:true})}returnToStartLocation(){const startIds=this.model.get("_startIds");if(startIds){startIds.forEach((startId=>startId._skipIfComplete=false))}window.location.hash=this.getStartHash(true)}getStartHash(alwaysForce){const startId=this.getStartId();const isRouteSpecified=window.location.href.indexOf("#")>-1;const shouldForceStartId=alwaysForce||this.model.get("_force");const shouldNavigateToStartId=startId&&(!isRouteSpecified||shouldForceStartId);if(shouldNavigateToStartId&&startId!==Adapt$1.course.get("_id"))return`#/id/${startId}`;return window.location.hash||"#/"}isEnabled(){return Boolean(this.model?.get("_isEnabled"))}getStartId(){let startId=this.model.get("_id");const startIds=this.model.get("_startIds");if(!startIds?.length)return startId;const $html=$("html");for(let i=0,l=startIds.length;i<l;i++){const item=startIds[i];const className=item._className;const skipIfComplete=item._skipIfComplete;const model=data$1.findById(item._id);if(!model){console.log("startController: cannot find id",item._id);continue}if(skipIfComplete&&model.get("_isComplete"))continue;if(!className||$html.is(className)||$html.hasClass(className)){startId=item._id;break}}return startId}onAdaptStart(){this.loadCourseData();this.setStartLocation()}}const startController=new StartController;var startController$1=__AMD("core/js/startController",startController);const COMPLETION_STATE$2=ENUM([["NOT ATTEMPTED","NOTATTEMPTED"],"INCOMPLETE","COMPLETED","PASSED","FAILED"]);var COMPLETION_STATE$3=__AMD("core/js/enums/completionStateEnum",COMPLETION_STATE$2);class Tracking extends Backbone.Controller{initialize(){this._config={_requireContentCompleted:true,_requireAssessmentCompleted:false,_submitOnEveryAssessmentAttempt:false,_shouldSubmitScore:false};this._assessmentState=null;Adapt$1.once("configModel:dataLoaded",this.loadConfig.bind(this));Adapt$1.on("app:dataReady",this.setupEventListeners.bind(this))}setupEventListeners(){this.listenTo(Adapt$1,{"assessment:complete":this.onAssessmentComplete,"assessment:restored":this.onAssessmentRestored,"scoring:complete":this.onScoringComplete,"scoring:restored":this.onScoringRestored});if(this._config._requireContentCompleted){this.listenTo(Adapt$1.course,"change:_isComplete",this.checkCompletion)}}submitScore(){const isPassed=Boolean(this._assessmentState?.isPass??this._assessmentState?.isPassed);Adapt$1.course.set("_isAssessmentPassed",isPassed);if(!this._config._shouldSubmitScore)return;offlineStorage$1.set("score",this._assessmentState.score,this._assessmentState.minScore,this._assessmentState.maxScore,this._assessmentState.isPercentageBased)}checkCompletion(){const completionData=this.getCompletionData();if(completionData.status===COMPLETION_STATE$3.INCOMPLETE)return;const canRetry=completionData.assessment?.canRetry;if(!this._config._submitOnEveryAssessmentAttempt&&completionData.status===COMPLETION_STATE$3.FAILED&&canRetry)return;Adapt$1.trigger("tracking:complete",completionData);logging$1.debug("tracking:complete",completionData)}getCompletionData(){const completionData={status:COMPLETION_STATE$3.INCOMPLETE,assessment:null};if(this._config._requireContentCompleted&&!Adapt$1.course.get("_isComplete"))return completionData;if(this._config._requireAssessmentCompleted){if(!this._assessmentState)return completionData;const isPassed=this._assessmentState?.isPass??this._assessmentState?.isPassed;completionData.status=isPassed?COMPLETION_STATE$3.PASSED:COMPLETION_STATE$3.FAILED;completionData.assessment=this._assessmentState;return completionData}completionData.status=COMPLETION_STATE$3.COMPLETED;return completionData}loadConfig(){Object.assign(this._config,Adapt$1.config.get("_completionCriteria"));const newShouldSubmitScore=this._config._shouldSubmitScore;const legacyShouldSubmitScore=Adapt$1.config.get("_spoor")?._tracking?._shouldSubmitScore;if(legacyShouldSubmitScore!==undefined)logging$1.deprecated("config.json:_spoor._tracking._shouldSubmitScore, please use only config.json:_completionCriteria._shouldSubmitScore");this._config._shouldSubmitScore=legacyShouldSubmitScore??newShouldSubmitScore??true}onAssessmentComplete(assessmentState){this.stopListening(Adapt$1,"scoring:complete",this.onScoringComplete);this.onScoringComplete(assessmentState)}onScoringComplete(state){this._assessmentState=state;this.submitScore();if(this._config._requireAssessmentCompleted)this.checkCompletion()}onAssessmentRestored(assessmentState){this.onScoringRestored(assessmentState)}onScoringRestored(state){if(this._assessmentState)return;this._assessmentState=state}}const tracking=new Tracking;var tracking$1=__AMD("core/js/tracking",tracking);const beginWait=()=>{logging$1.deprecated("Use wait.begin() as Adapt.trigger('plugin:beginWait') will be removed in the future");Wait$1.begin()};const endWait=()=>{logging$1.deprecated("Use wait.end() as Adapt.trigger('plugin:endWait') will be removed in the future");Wait$1.end()};const ready=()=>{if(Wait$1.isWaiting()){return}const isEventListening=Adapt$1._events["plugins:ready"];if(!isEventListening){return}logging$1.deprecated("Use wait.queue(callback) as Adapt.on('plugins:ready', callback) will be removed in the future");Adapt$1.trigger("plugins:ready")};Adapt$1.listenTo(Wait$1,"ready",ready);Adapt$1.on({"plugin:beginWait":beginWait,"plugin:endWait":endWait});Adapt$1.on({"drawer:remove"(){logging$1.deprecated("Use drawer.remove, Adapt.trigger('drawer:remove') will be removed in the future");drawer.remove()},"drawer:closeDrawer"(){logging$1.deprecated("Use drawer.close, Adapt.trigger('drawer:closeDrawer') will be removed in the future");drawer.close()},"drawer:triggerCustomView"(){logging$1.deprecated("Use drawer.openCustomView(), Adapt.trigger('drawer:triggerCustomView') will be removed in the future");drawer.openCustomView()}});Object.defineProperties(drawer,{triggerCustomView:{get(){a11y$1.log.deprecated("drawer.triggerCustomView has moved to drawer.openCustomView");return drawer.openCustomView}}});Object.defineProperties(Adapt$1,{accessibility:{get(){a11y$1.log.deprecated("Adapt.accessibility has moved to a11y");return a11y$1}},a11y:{get(){logging$1.deprecated("Adapt.a11y, please use core/js/a11y directly");return a11y$1}},componentStore:{get(){logging$1.deprecated("Adapt.componentStore, please use core/js/components directly");return components$1._register}},data:{get(){logging$1.deprecated("Adapt.data, please use core/js/data directly");return data$1}},device:{get(){logging$1.deprecated("device, please use core/js/device directly");return device$1}},drawer:{get(){logging$1.deprecated("Adapt.drawer, please use core/js/drawer directly");return drawer}},findById:{get(){logging$1.deprecated("Adapt.findById, please use data.findById directly");return data$1.findById}},findViewByModelId:{get(){logging$1.deprecated("Adapt.findViewByModelId, please use data.findViewByModelId directly");return data$1.findViewByModelId}},findByTrackingPosition:{get(){logging$1.deprecated("Adapt.findByTrackingPosition, please use data.findByTrackingPosition directly");return data$1.findByTrackingPosition}},getViewName:{get(){logging$1.deprecated("Adapt.getViewName, please use components.getViewName instead");return components$1.getViewName}},getViewClass:{get(){logging$1.deprecated("Adapt.getViewClass, please use components.getViewClass instead");return components$1.getViewClass}},getModelName:{get(){logging$1.deprecated("Adapt.getModelName, please use components.getModelName instead");return components$1.getModelName}},getModelClass:{get(){logging$1.deprecated("Adapt.getModelClass, please use components.getModelClass instead");return components$1.getModelClass}},location:{get(){logging$1.deprecated("Adapt.location, please use core/js/location directly");return location$1}},log:{get(){logging$1.deprecated("Adapt.log, please use core/js/logging directly");return logging$1}},mpabc:{get(){logging$1.deprecated("Adapt.mpabc, please use core/js/mpabc directly");return mpabc$1}},notify:{get(){logging$1.deprecated("Adapt.notify, please use core/js/notify directly");return notify$1}},offlineStorage:{get(){logging$1.deprecated("offlineStorage, please use core/js/offlineStorage instead");return offlineStorage$1}},navigateToElement:{get(){logging$1.deprecated("Adapt.navigateToElement, please use router.navigateToElement");return router$1.navigateToElement}},register:{get(){logging$1.deprecated("Adapt.register, please use components.register instead");return components$1.register}},router:{get(){logging$1.deprecated("Adapt.router, please use core/js/router directly");return router$1}},scrolling:{get(){logging$1.deprecated("Adapt.scrolling, please use core/js/scrolling directly");return scrolling$1}},scrollTo:{get(){logging$1.deprecated("Adapt.scrollTo, please use router.navigateToElement");return scrolling$1.scrollTo}},startController:{get(){logging$1.deprecated("Adapt.startController, please use core/js/startController directly");return startController$1}},store:{get(){logging$1.deprecated("Adapt.store, please use core/js/components directly");return components$1._register}},tracking:{get(){logging$1.deprecated("Adapt.tracking, please use core/js/tracking directly");return tracking$1}},wait:{get(){logging$1.deprecated("Adapt.wait, please use core/js/wait instead");return Wait$1}}});function onRender(cb){const intercept=(object,name,mode,cb)=>object[name]=cb.bind(object,object[name],name,mode);Object.keys(Handlebars.templates).forEach((name=>{intercept(Handlebars.templates,name,"template",cb)}));Object.keys(Handlebars.partials).forEach((name=>{intercept(Handlebars.partials,name,"partial",cb)}))}onRender(((template,name,mode,...args)=>{const preRenderEvent=new TemplateRenderEvent(`${mode}:preRender`,name,mode,null,args);Adapt$1.trigger(preRenderEvent.type,preRenderEvent);const value=template(...preRenderEvent.args);const postRenderEvent=new TemplateRenderEvent(`${mode}:postRender`,name,mode,value,preRenderEvent.args);Adapt$1.trigger(postRenderEvent.type,postRenderEvent);return postRenderEvent.value}));Adapt$1.on("app:dataReady",(()=>{const config=Adapt$1.config.get("_fixes");if(config?._imgLazyLoad===false)return;applyImgLoadingFix()}));function applyImgLoadingFix(){const findImgTag=/<img([^>]*)>/gi;const hasLoadingAttr=/ loading=/gi;Adapt$1.on("template:postRender partial:postRender",(event=>{const imgTagsFound=event.value.match(findImgTag);if(!imgTagsFound){return}event.value=imgTagsFound.reduce(((value,img)=>{if(hasLoadingAttr.test(img)){return value}return value.replace(img,img.replace(findImgTag,'<img loading="eager"$1>'))}),event.value)}));Adapt$1.on("reactElement:preRender",(event=>{if(event.name!=="img")return;const options=event.args[1]=event.args[1]||{};if(options&&options.hasOwnProperty("loading"))return;options.loading="eager"}))}Adapt$1.on("app:dataReady",(()=>{const config=Adapt$1.config.get("_fixes");if(config?._jsxReactHelpersHTML===false)return;applyReactHelpersHTML()}));function applyReactHelpersHTML(){Adapt$1.on("reactElement:preRender",(event=>{let[tagName,props,...children]=event.args;if(!children)return;if(!Array.isArray(children))children=[children];children=children.filter(Boolean);const hasSomeUnsafeConversions=children.some((c=>c?.__html));if(!hasSomeUnsafeConversions)return;const hasManyChildren=children.length>1;if(hasManyChildren){event.args=event.args.map((child=>{if(!child||!child.__html)return child;const attributes=Object.entries(props).map((([name,value])=>`${name}="${value}"`)).join(" ");logging$1.warnOnce(`html() call should be the only child in its parent <${tagName} ${attributes}>`);return child.__html?HTMLReactParser__default["default"](child.__html):undefined}));return}props=event.args[1]=event.args[1]||{};props.dangerouslySetInnerHTML=children[0];event.args.length=2}))}Adapt$1.on("app:dataReady",(()=>{const config=Adapt$1.config.get("_fixes");if(config?._safariLabelClickBlur===false)return;applySafariLabelClickBlur()}));function onLabelClick(event){const input=document.querySelector(`[id="${event.currentTarget.getAttribute("for")}"]`);if(!input)return;event.preventDefault();input.click()}function applySafariLabelClickBlur(){Adapt$1.on("reactElement:preRender",(event=>{const[tagName,props]=event.args;if(tagName!=="label"||!Object.hasOwn(props,"htmlFor")||Object.hasOwn(props,"onClick"))return;props.onClick=onLabelClick}))}const helpers={lowercase(text){return text.toLowerCase()},capitalise(text){return text.charAt(0).toUpperCase()+text.slice(1)},inc(index){return index+1},dec(index){return index-1},odd(index){return(index+1)%2===0?"even":"odd"},equals(value,text,block){return helpers.compare.call(this,value,"==",text,block)},compare(value,operator,text,block){switch(operator){case"===":if(value===text)return block.fn?block.fn(this):true;break;case"=":case"==":if(value==text)return block.fn?block.fn(this):true;break;case">=":if(value>=text)return block.fn?block.fn(this):true;break;case"<=":if(value<=text)return block.fn?block.fn(this):true;break;case">":if(value>text)return block.fn?block.fn(this):true;break;case"<":if(value<text)return block.fn?block.fn(this):true;break}return block.inverse?block.inverse(this):false},math(lvalue,operator,rvalue,options){lvalue=parseFloat(lvalue);rvalue=parseFloat(rvalue);switch(operator){case"+":return lvalue+rvalue;case"-":return lvalue-rvalue;case"*":return lvalue*rvalue;case"/":return lvalue/rvalue;case"%":return lvalue%rvalue}},use(id,block){if(!block.fn)return;try{const model=data$1.findById(id);return block.fn(model.toJSON())}catch(err){}},any(...args){const specified=args.slice(0,-1);const block=args.slice(-1)[0];return specified.some(Boolean)?block.fn?block.fn(this):true:block.inverse?block.inverse(this):false},all(...args){const specified=args.slice(0,-1);const block=args.slice(-1)[0];return specified.every(Boolean)?block.fn?block.fn(this):true:block.inverse?block.inverse(this):false},none(...args){const specified=args.slice(0,-1);const block=args.slice(-1)[0];return!specified.some(Boolean)?block.fn?block.fn(this):true:block.inverse?block.inverse(this):false},compile(template,context){if(!template)return"";if(template instanceof Object)template=template.toString();const data=context?.data?.root?this:context;return Handlebars.compile(template)(data)},compile_a11y_text(template,context){logging$1.deprecated("a11y_text is no longer required. https://tink.uk/understanding-screen-reader-interaction-modes/");return helpers.compile.call(this,template,context)},compile_a11y_normalize(template,context){if(!template){return""}if(template instanceof Object)template=template.toString();return Handlebars.helpers.a11y_normalize.call(this,helpers.compile.call(this,template,context))},compile_a11y_remove_breaks(template,context){if(!template){return""}return Handlebars.helpers.a11y_remove_breaks.call(this,helpers.compile.call(this,template,context))},import_globals(context){if(context.data.root._globals){return""}context.data.root._globals=Adapt$1.course.get("_globals");return""},import_adapt(context){if(context.data.root.Adapt){return}const adapt=context.data.root.Adapt={};let i,l,name;const directImport=["config","course"];for(i=0,l=directImport.length;i<l;i++){name=directImport[i];adapt[name]=Adapt$1[name].toJSON()}const indexedImport=["contentObjects","articles","blocks","components"];for(i=0,l=indexedImport.length;i<l;i++){name=indexedImport[i];const importArray=Adapt$1[name].toJSON();const importIndex={};for(let i1=0,l1=importArray.length;i1<l1;i1++){const item=importArray[i1];importIndex[item._id]=item}adapt[name]=importIndex}return""},component_description(override,context){if(!this._isA11yComponentDescriptionEnabled){return}const isNotDefined=!this._globals._components?.["_"+this._component];if(isNotDefined){return}const hasOverride=arguments.length>1;let description;if(hasOverride){description=override;description=helpers.compile(description,context)}else{description=this._globals._components["_"+this._component].ariaRegion;description=helpers.compile(description,override)}if(!description){return}return new Handlebars.SafeString('<div class="aria-label">'+description+"</div>")},a11y_text(text){logging$1.deprecated("a11y_text is no longer required. https://tink.uk/understanding-screen-reader-interaction-modes/");return text},a11y_normalize(htmls){return a11y$1.normalize.apply(a11y$1,arguments)},a11y_remove_breaks(htmls){return a11y$1.removeBreaks.apply(a11y$1,arguments)},a11y_aria_label(htmls){let values=Array.prototype.slice.call(arguments,0,-1);values=values.filter(Boolean);return new Handlebars.SafeString('<div class="aria-label">'+values.join(" ")+"</div>")},a11y_aria_label_relative(htmls){let values=Array.prototype.slice.call(arguments,0,-1);values=values.filter(Boolean);return new Handlebars.SafeString('<div class="aria-label relative">'+values.join(" ")+"</div>")},a11y_aria_image(texts){let values=Array.prototype.slice.call(arguments,0,-1);values=values.filter(Boolean);return new Handlebars.SafeString('<div class="aria-label" role="img" aria-label="'+values.join(" ")+'"></div>')},a11y_wrap_focus(){const cfg=Adapt$1.config.get("_accessibility");if(cfg._isPopupWrapFocusEnabled===false)return"";return new Handlebars.SafeString('<a class="a11y-focusguard a11y-ignore a11y-ignore-focus" tabindex="0" role="presentation">&nbsp;</a>')},a11y_attrs_heading(level){logging$1.deprecated("a11y_attrs_heading, please use a11y_aria_level or a11y.ariaLevel");const resolvedLevel=a11y$1.ariaLevel({id:this._id??Array.from(arguments).lastItem?.data?.root?._id,level:level,override:this._ariaLevel});return new Handlebars.SafeString(` role="heading" aria-level="${resolvedLevel}" `)},a11y_aria_level(id,level,override=null){const resolvedLevel=a11y$1.ariaLevel({id:id,level:level,override:override});return resolvedLevel},a11y_attrs_tabbable(){logging$1.deprecated("a11y_attrs_tabbable should not be used. tabbable elements should be natively tabbable.");return new Handlebars.SafeString(' role="region" tabindex="0" ')},a11y_alt_text(visible,alternatives){let values=Array.prototype.slice.call(arguments,1,-1);values=values.filter(Boolean);return new Handlebars.SafeString('<span aria-hidden="true">'+visible+'</span><span class="aria-label">'+values.join(" ")+"</span>")}};Object.assign(helpers,{if_value_equals(){logging$1.deprecated("if_value_equals, use equals instead.");return helpers.equals.apply(this,arguments)},numbers(){logging$1.deprecated("numbers, use inc instead.");return helpers.inc.apply(this,arguments)},lowerCase(){logging$1.deprecated("lowerCase, use lowercase instead.");return helpers.lowercase.apply(this,arguments)}});for(const name in helpers){Handlebars.registerHelper(name,helpers[name])}__AMD("core/js/helpers",helpers);class HeadingView extends Backbone.View{initialize({parentView:parentView}){this.listenTo(parentView,"preRemove",this.remove);this.listenTo(Adapt$1.parentView,"postRemove",this.remove);this.listenTo(this.model,"change:_isComplete",this.updateAria);this.render()}render(){const template=Handlebars.templates[this.constructor.template];const data=this.model.toJSON();const customHeadingType=this.$el.attr("data-a11y-heading-type");const isBackwardCompatible=[...this.$el[0].classList].every((name=>!name.includes("-inner")));data._isBackwardCompatible=isBackwardCompatible;if(customHeadingType)data._type=customHeadingType;this.$el.html(template(data));this.checkCompletion()}updateAria(){const template=Handlebars.templates[this.constructor.template];const data=this.model.toJSON();const $rendered=$(`<div>${template(data)}</div>`);this.$(".aria-label").html($rendered.find(".aria-label").html());this.checkCompletion()}checkCompletion(){const isComplete=this.model.get("_isComplete");if(isComplete===undefined)return;this.$el.toggleClass("is-complete",isComplete).toggleClass("is-incomplete",!isComplete)}}HeadingView.template="heading";var HeadingView$1=__AMD("core/js/views/headingView",HeadingView);class Headings extends Backbone.Controller{initialize(){this.listenTo(Adapt$1,"view:render",this.onViewRender)}onViewRender(view){const $headingSeats=view.$(".js-heading");$headingSeats.each(((index,el)=>new HeadingView$1({el:el,model:view.model,parentView:view})))}}__AMD("core/js/headings",new Headings);var NavigationButtonView=__AMD("core/js/views/NavigationButtonView",class NavigationButtonView extends Backbone.View{tagName(){return"button"}events(){return{click:"triggerEvent"}}className(){if(this.isInjectedButton){return[this.model.get("_showLabel")===false&&"hide-label"].filter(Boolean).join(" ")}return["btn-icon nav__btn",this.model.get("_classes"),this.model.get("_showLabel")===false&&"hide-label"].filter(Boolean).join(" ")}attributes(){const attributes=this.model.toJSON();if(this.isInjectedButton){return{name:attributes._id,"data-order":attributes._order,"data-event":attributes._event}}return{name:attributes._id,role:attributes._role==="button"?undefined:attributes._role,"aria-label":attributes.ariaLabel,"data-order":attributes._order,"data-event":attributes._event}}initialize({el:el}){if(el){this.isInjectedButton=true}else{this.isJSX=(this.constructor.template||"").includes(".jsx")}this._classSet=new Set(_.result(this,"className").trim().split(/\s+/));this._attributes=_.result(this,"attributes");this.listenTo(this.model,"change",this.changed);this.render()}static get template(){return"navButton.jsx"}render(){if(this.isInjectedButton){this.changed()}else if(this.isJSX){this.changed()}else{const data=this.model.toJSON();data.view=this;const template=Handlebars.templates[this.constructor.template];this.$el.html(template(data))}return this}updateViewProperties(){const classesToAdd=_.result(this,"className").trim().split(/\s+/);classesToAdd.forEach((i=>this._classSet.add(i)));const classesToRemove=[...this._classSet].filter((i=>!classesToAdd.includes(i)));classesToRemove.forEach((i=>this._classSet.delete(i)));Object.keys(this._attributes).forEach((name=>this.$el.removeAttr(name)));Object.entries(_.result(this,"attributes")).forEach((([name,value])=>this.$el.attr(name,value)));this.$el.removeClass(classesToRemove).addClass(classesToAdd)}injectLabel(){const textLabel=this.$el.find("> .nav__btn-label");const ariaLabel=this.$el.attr("aria-label")??this.$el.find(".aria-label").text();const text=this.model.get("text");const output=compile(text??"",{ariaLabel:ariaLabel});if(!textLabel.length){this.$el.append(`<span class="nav__btn-label" aria-hidden="true">${output}</span>`);return}textLabel.html(output)}changed(eventName=null){if(typeof eventName==="string"&&eventName.startsWith("bubble")){return}if(this.isInjectedButton){this.updateViewProperties();this.injectLabel();return}if(!this.isJSX){this.updateViewProperties();return}const props={...this,...this.model.toJSON(),_globals:Adapt$1.course?.get("_globals")};const Template=templates[this.constructor.template.replace(".jsx","")];this.updateViewProperties();ReactDOM__default["default"].render(React__default["default"].createElement(Template,props),this.el)}triggerEvent(event){event.preventDefault();const currentEvent=$(event.currentTarget).attr("data-event");if(!currentEvent)return;Adapt$1.trigger("navigation:"+currentEvent);switch(currentEvent){case"backButton":router$1.navigateToPreviousRoute();break;case"homeButton":router$1.navigateToHomeRoute();break;case"parentButton":router$1.navigateToParent();break;case"skipNavigation":_.delay((()=>{a11y$1.focusFirst("."+location$1._contentType)}),250);break;case"returnToStart":startController$1.returnToStartLocation();break}}remove(){this._isRemoved=true;this.stopListening();Wait$1.for((end=>{if(this.isJSX){ReactDOM__default["default"].unmountComponentAtNode(this.el)}super.remove();end()}));return this}});var NavigationButtonModel=__AMD("core/js/models/NavigationButtonModel",class NavigationButtonModel extends LockingModel{defaults(){return{_id:"",_classes:"",_iconClasses:"",_order:0,_event:"",_showLabel:null,_role:"button",ariaLabel:"",text:"{{ariaLabel}}"}}});class NavigationView extends Backbone.View{className(){return["nav",this.model?.get("_showLabel")===true?"show-label":"hide-label",`show-label-${this.model?.get("_showLabelAtWidth")||"medium"}`,`has-label-${this.model?.get("_labelPosition")||"auto"}`].filter(Boolean).join(" ")}attributes(){return{role:"navigation"}}get buttons(){return this._buttons=this._buttons||[]}set buttons(value){this._buttons=value}initialize(){___default["default"].bindAll(this,"sortNavigationButtons");this._classSet=new Set(___default["default"].result(this,"className").trim().split(/\s+/))}start(model){tooltips$1.register({_id:"back",...Adapt$1.course.get("_globals")?._extensions?._navigation?._backNavTooltip||{}});this.model=model;this.listenTo(model,"change",this.update);this.listenToOnce(Adapt$1,"courseModel:dataLoading",this.remove);this.listenTo(Adapt$1,{"router:contentObject":this.hideNavigationButton,"adapt:preInitialize device:resize":this.onDeviceResize});this.update();this.preRender()}update(){this.updateViewProperties();this.onDeviceResize()}onDeviceResize(){let{_navigationAlignment:_navigationAlignment="top",_isBottomOnTouchDevices:_isBottomOnTouchDevices=false}=this.model.toJSON();const $html=$("html");const isBottomOnTouchDevices=device$1.touch&&_isBottomOnTouchDevices;if(isBottomOnTouchDevices)_navigationAlignment="bottom";$html.removeClass("is-nav-top is-nav-bottom").addClass("is-nav-"+_navigationAlignment)}preRender(){Adapt$1.trigger("navigationView:preRender",this);this.render()}render(){const template=Handlebars.templates[this.constructor.template];this.$el.html(template({_config:Adapt$1.config.toJSON(),_globals:Adapt$1.course.get("_globals"),_accessibility:Adapt$1.config.get("_accessibility")})).insertBefore("#app");this.sortNavigationButtons();___default["default"].defer((()=>{Adapt$1.trigger("navigationView:postRender navigation:ready",this)}));return this}updateViewProperties(){const classesToAdd=___default["default"].result(this,"className").trim().split(/\s+/);classesToAdd.forEach((i=>this._classSet.add(i)));const classesToRemove=[...this._classSet].filter((i=>!classesToAdd.includes(i)));classesToRemove.forEach((i=>this._classSet.delete(i)));this._setAttributes({...___default["default"].result(this,"attributes"),id:___default["default"].result(this,"id")});this.$el.removeClass(classesToRemove).addClass(classesToAdd)}listenForInjectedButtons(){this.observer=this.observer||new MutationObserver(this.sortNavigationButtons);this.observer.observe(this.$(".nav__inner")[0],{childList:true,attributes:true,subtree:true})}sortNavigationButtons(changed){if(Array.isArray(changed)){const changes=Object.entries(changed.reduce(((changes,change)=>{const changeTypeName=`${change.type}.${change.attributeName}`;changes[changeTypeName]=changes[changeTypeName]||0;changes[changeTypeName]++;return changes}),{}));const shouldIgnore=changes.every((([key])=>["attributes.data-a11y-force-focus","attributes.tabindex","attributes.aria-hidden","attributes.aria-expanded"].includes(key)));if(shouldIgnore)return}this.observer?.disconnect();const $container=this.$(".nav__inner");const items=[...$container[0].children];const identifiers={".js-nav-drawer-btn":"drawer",".js-nav-back-btn":"back",".js-nav-home-btn":"home","*":null};items.forEach((el=>{const $el=$(el);if($el.is(".nav__spacer"))return;const foundId=($el.attr("name")??Object.entries(identifiers).find((([classes])=>$el.is(classes)))?.[1])||$el.attr("class");const attributes={_id:foundId,_order:parseFloat($el.attr("data-order")||0),_event:$el.attr("data-event")};const existingButton=this.getButton(attributes._id);if(existingButton){if(!existingButton.isInjectedButton)return;if(existingButton.el!==el){existingButton.undelegateEvents();existingButton.el=el;existingButton.$el=$(el);existingButton.delegateEvents()}existingButton.model.set(attributes);existingButton.changed();return}const navigationButtonModel=new NavigationButtonModel(attributes);this.addButton(new NavigationButtonView({el:el,model:navigationButtonModel}))}));const focusElement=document.activeElement;const domOrder=[...$container[0].children];items.sort(((a,b)=>parseFloat($(a).attr("data-order")||0)-parseFloat($(b).attr("data-order")||0)));const hasOrderChanged=domOrder.some(((item,index)=>item!==items[index]));if(hasOrderChanged){let indexOfFocused=items.findIndex((el=>el===focusElement));if(indexOfFocused===-1)indexOfFocused=Infinity;const before=items.slice(0,indexOfFocused);const after=items.slice(indexOfFocused+1);before.reverse().forEach((el=>$container.prepend(el)));after.forEach((el=>$container.append(el)))}this.observer?.takeRecords();this.listenForInjectedButtons()}hideNavigationButton(contentObjectModel){const shouldHide=contentObjectModel.get("_type")==="course";this.$(".nav__back-btn, .nav__home-btn").toggleClass("u-display-none",shouldHide)}showNavigationButton(){this.$(".nav__back-btn, .nav__home-btn").removeClass("u-display-none")}addButton(buttonView){this.buttons.push(buttonView);const container=this.$(".nav__inner");container.append(buttonView.$el);this.listenTo(buttonView.model,"change",this.sortNavigationButtons);if(buttonView.isInjectedButton)return;this.sortNavigationButtons()}getButton(id){return this.buttons.find((button=>button.model.get("_id")===id))}removeButton(buttonView){this.buttons=this.buttons.filter((view=>view!==buttonView));this.stopListening(buttonView.model,"change",this.sortNavigationButtons);if(buttonView.isInjectedButton){buttonView.$el.remove();return}buttonView.remove()}}NavigationView.template="nav";var NavigationView$1=__AMD("core/js/views/navigationView",NavigationView);var NavigationModel=__AMD("core/js/models/NavigationModel",class NavigationModel extends LockingModel{defaults(){return{_navigationAlignment:"top",_isBottomOnTouchDevices:false,_showLabel:false,_showLabelAtWidth:"medium",_labelPosition:"auto"}}});class NavigationController extends Backbone.Controller{initialize(){this.navigation=new NavigationView$1;this.listenTo(Adapt$1,"adapt:preInitialize",this.addNavigationBar)}addNavigationBar(){const adaptConfig=Adapt$1.course.get("_navigation");if(adaptConfig?._isDefaultNavigationDisabled){Adapt$1.trigger("navigation:initialize");return}this.navigation.start(new NavigationModel(adaptConfig))}}var navigation=__AMD("core/js/navigation",Adapt$1.navigation=(new NavigationController).navigation);class DOMElementModificationEventObject{constructor({type:type,target:target,changedAttributes:changedAttributes,previousAttributes:previousAttributes}={}){this.type=type;this.target=target;this.changedAttributes=changedAttributes;this.previousAttributes=previousAttributes}}class DOMElementModifications extends Backbone__default["default"].View{initialize({el:el=document.documentElement,watchImmediateChildrenOnly:watchImmediateChildrenOnly=true,watchAttributes:watchAttributes=false}={}){this._onMutation=this._onMutation.bind(this);this.el=el;this._watch={childList:true,subtree:!watchImmediateChildrenOnly,attributes:watchAttributes,attributeOldValue:watchAttributes}}startWatching(){this._calculateElementFilters();if(this._observer)return this;this._observer=new MutationObserver(this._onMutation);this._observer.observe(this.el,this._watch);return this}static calculateEventNames(eventNames){const firstEvent=eventNames[0];const isNew=firstEvent==="added";const lastRemovedIndex=eventNames.lastIndexOf("removed");const lastAddedIndex=eventNames.lastIndexOf("added");const hasReAdded=lastRemovedIndex!==-1&&lastAddedIndex!==-1&&lastRemovedIndex<lastAddedIndex;if(!isNew&&hasReAdded)return["changed"];const events=_.uniq([isNew&&"added",eventNames[eventNames.length-1]].filter(Boolean));return events}_onMutation(list){const reducedChanges=list.reduce(((changes,item)=>{let addedNodes=Array.from(item.addedNodes);let removedNodes=Array.from(item.removedNodes);const allNodes=[...addedNodes,...removedNodes];const isTextChange=allNodes.some((node=>node.nodeType===Node.TEXT_NODE));const isAttributeChange=this._watch.attributes&&item.type==="attributes";addedNodes=addedNodes.filter((node=>node.nodeType===Node.ELEMENT_NODE));removedNodes=removedNodes.filter((node=>node.nodeType===Node.ELEMENT_NODE));const isAddedEvent=Boolean(addedNodes.length);const isRemovedEvent=Boolean(removedNodes.length);const isChangedEvent=Boolean(isAttributeChange||isTextChange);if(!isAddedEvent&&!isRemovedEvent&&!isChangedEvent)return changes;const targetNodes=isChangedEvent?[item.target]:Array.from(isAddedEvent?addedNodes:removedNodes).flatMap((node=>this._watch.subtree?[node,...node.querySelectorAll("*")]:[node]));const eventName=isAddedEvent?"added":isRemovedEvent?"removed":"changed";targetNodes.forEach((target=>{const value=changes.get(target)??{eventNames:[],previousAttributes:this._watch.attributes?{}:null};value.eventNames.push(eventName);const shouldRecordAttribute=isChangedEvent&&item.attributeName;if(shouldRecordAttribute)value.previousAttributes[item.attributeName]??=item.oldValue;changes.set(target,value)}));return changes}),new Map);for(let[target,{eventNames:eventNames,previousAttributes:previousAttributes}]of reducedChanges.entries()){eventNames=DOMElementModifications.calculateEventNames(eventNames);eventNames.forEach((eventName=>{const isNodeAdded=eventName==="added";const isNodeRemoved=eventName==="removed";const selectorFilters=isNodeAdded?this._addedFilters:isNodeRemoved?this._removedFilters:this._changedFilters;if(!selectorFilters.length)return;const selectors=selectorFilters.map((filter=>filter(target))).filter(Boolean);if(!selectors.length)return;const changedAttributes=this._watch.attributes?Object.keys(previousAttributes).reduce(((attributes,attrName)=>{attributes[attrName]=target.getAttribute(attrName);return attributes}),{}):null;const EventObject=new DOMElementModificationEventObject({type:eventName,target:target,changedAttributes:changedAttributes,previousAttributes:previousAttributes});selectors.forEach((selector=>{if(selector&&selector!==true){if(eventName!=="changed")this.trigger(`${eventName}:${selector}`,EventObject);this.trigger(`changed:${selector}`,EventObject)}if(eventName!=="changed")this.trigger(`${eventName}`,EventObject);this.trigger("changed",EventObject)}))}))}}stopWatching(){this._calculateElementFilters();if(!this._observer)return this;this._observer.disconnect();this._observer=null;return this}_calculateElementFilters(){const selectorFilter=selector=>{const eventWithNoSelector=selector===undefined;if(eventWithNoSelector)return()=>true;if(Element.prototype.matches){return new Function("el",`return el.matches("${selector}") && "${selector}";`)}return new Function("el",`return $(el).is("${selector}") && "${selector}";`)};const eventNames=Object.keys(this._events);const eventNameParts=eventNames.map((name=>name.split(":")));const changedSelectors=eventNameParts.filter((parts=>parts[0]==="changed")).map((parts=>parts[1]));const addedSelectors=eventNameParts.filter((parts=>parts[0]==="added")).map((parts=>parts[1]));const removedSelectors=eventNameParts.filter((parts=>parts[0]==="removed")).map((parts=>parts[1]));this._changedFilters=changedSelectors.map(selectorFilter);this._addedFilters=addedSelectors.map(selectorFilter).concat(this._changedFilters);this._removedFilters=removedSelectors.map(selectorFilter).concat(this._changedFilters)}on(...args){const rtn=super.on(...args);if(this.shouldListen)this.startWatching();return rtn}once(...args){const rtn=super.once(...args);if(this.shouldListen)this.startWatching();return rtn}listenToOnce(...args){const rtn=super.listenToOnce(...args);if(this.shouldListen)this.startWatching();return rtn}off(...args){const rtn=super.off(...args);if(!this.shouldListen)this.stopWatching();return rtn}stopListening(...args){const rtn=super.stopListening(...args);if(!this.shouldListen)this.stopWatching();return rtn}get shouldListen(){return Boolean(Object.keys(this._events).length||Object.keys(this._listeners).length)}}const documentModifications=new DOMElementModifications({el:document.documentElement,watchImmediateChildrenOnly:false,watchAttributes:true});documentModifications.DOMElementModifications=DOMElementModifications;__AMD("core/js/DOMElementModifications",documentModifications);class ComponentView extends AdaptView$1{attributes(){if(!this.model.get("_isA11yRegionEnabled")){return AdaptView$1.resultExtend("attributes",{},this)}return AdaptView$1.resultExtend("attributes",{"aria-labelledby":this.model.get("_id")+"-heading",role:"region"},this)}className(){return["component",this.model.get("_component").toLowerCase(),this.model.get("_id"),this.model.get("_classes"),this.setVisibility(),this.setHidden(),"is-"+this.model.get("_layout"),this.model.get("_isComplete")?"is-complete":"",this.model.get("_isOptional")?"is-optional":""].join(" ")}renderState(){logging$1.removed("renderState is removed and moved to item title")}setupInviewCompletion(inviewElementSelector=".component__inner",callback=this.setCompletionStatus){this.$inviewElement=this.$(inviewElementSelector);this.inviewCallback=callback;this.$inviewElement.on("inview.componentView",this.onInview.bind(this))}removeInviewListener(){if(!this.$inviewElement)return;this.$inviewElement.off("inview.componentView");this.$inviewElement=null}onInview(event,visible,visiblePartX,visiblePartY){if(!visible)return;switch(visiblePartY){case"top":this.hasSeenTop=true;break;case"bottom":this.hasSeenBottom=true;break;case"both":this.hasSeenTop=this.hasSeenBottom=true}if(!this.hasSeenTop||!this.hasSeenBottom)return;this.inviewCallback();if(this.model.get("_isComplete")){this.removeInviewListener()}}postRender(){}remove(){this.removeInviewListener();super.remove()}}ComponentView.type="component";var ComponentView$1=__AMD("core/js/views/componentView",ComponentView);class GraphicView extends ComponentView$1{className(){return[super.className(),this.model.get("_isScrollable")&&"is-scrollable"].filter(Boolean).join(" ")}events(){return{"click .js-graphic-link":"onClick","keydown .js-graphic-scrollbar":"onKeyDown"}}postRender(){this.$(".graphic__widget").imageready((()=>{this.setReadyStatus();this.setupInviewCompletion(".graphic__widget");this.setupScrollable()}))}setupScrollable(){if(!this.model.get("_isScrollable"))return;this.onScroll=_.debounce(this.onScroll.bind(this),17);const $scrollbar=this.$(".js-graphic-scrollbar");const $scrollContainer=this.$(`#${$scrollbar.attr("aria-controls")}`);$scrollContainer.on("scroll",this.onScroll);this.onKeyDown()}onScroll(event){if(!this.model.get("_isScrollable"))return;const $scrollbar=this.$(".js-graphic-scrollbar");const $scrollContainer=this.$(`#${$scrollbar.attr("aria-controls")}`);const{clientWidth:clientWidth,scrollWidth:scrollWidth}=$scrollContainer[0];const scrollableWidth=scrollWidth-clientWidth;const left=$scrollContainer.scrollLeft();const calculatedScrollPercent=parseInt(left/scrollableWidth*100);this.model.set("_scrollPercent",calculatedScrollPercent)}onKeyDown(event){if(!this.model.get("_isScrollable"))return;const $scrollbar=this.$(".js-graphic-scrollbar");const $scrollContainer=this.$(`#${$scrollbar.attr("aria-controls")}`);const{clientWidth:clientWidth,scrollWidth:scrollWidth}=$scrollContainer[0];const scrollableWidth=scrollWidth-clientWidth;const step=clientWidth*.1;let left=$scrollContainer.scrollLeft();const calculatedScrollPercent=parseInt(left/scrollableWidth*100);const definedScrollPercent=this.model.get("_scrollPercent")??0;if(definedScrollPercent!==calculatedScrollPercent){left=definedScrollPercent/100*scrollableWidth}switch(event?.which){case 37:left-=step;break;case 39:left+=step;break}left=_.max([0,_.min([scrollableWidth,left])]);$scrollContainer.scrollLeft(left)}onClick(event){if(event)event.preventDefault();const item=this.model.get("_graphic");const{_url:url,_target:target="_blank"}=item;const isNewWindow=target!=="_self";if(isNewWindow)return window.open(url,target);const isRouterNavigation=url.substr(0,1)==="#";if(isRouterNavigation)return Backbone.history.navigate(url,{trigger:true});window.location.href=url}preRemove(){if(!this.model.get("_isScrollable"))return;const $scrollbar=this.$(".js-graphic-scrollbar");const $scrollContainer=this.$(`#${$scrollbar.attr("aria-controls")}`);$scrollContainer.off("scroll",this.onScroll)}}GraphicView.template="graphic.jsx";var GraphicView$1=__AMD("components/adapt-contrib-graphic/js/GraphicView",GraphicView);var GraphicModel=__AMD("components/adapt-contrib-graphic/js/GraphicModel",class GraphicModel extends ComponentModel$1{init(){this.set("_scrollPercent",this.get("_defaultScrollPercent"))}});__AMD("components/adapt-contrib-graphic/js/adapt-contrib-graphic",components$1.register("graphic",{model:GraphicModel,view:GraphicView$1}));const BUTTON_STATE=ENUM(["SUBMIT","CORRECT","INCORRECT","SHOW_CORRECT_ANSWER","HIDE_CORRECT_ANSWER","SHOW_FEEDBACK","RESET"]);var BUTTON_STATE$1=__AMD("core/js/enums/buttonStateEnum",BUTTON_STATE);const textPropertyName={SUBMIT:"submit",CORRECT:"correct",INCORRECT:"incorrect",SHOW_CORRECT_ANSWER:"showCorrectAnswer",HIDE_CORRECT_ANSWER:"hideCorrectAnswer",SHOW_FEEDBACK:"showFeedback",RESET:"reset"};var ButtonsView=__AMD("core/js/views/buttonsView",class ButtonsView extends Backbone.View{initialize(options){this.parent=options.parent;this.listenTo(Adapt$1.parentView,"postRemove",this.remove);this.listenTo(this.model,{"change:_buttonState":this.onButtonStateChanged,"change:feedbackMessage":this.onFeedbackMessageChanged,"change:feedbackTitle":this.onFeedbackMessageChanged,"change:_attemptsLeft":this.onAttemptsChanged,"change:_canSubmit":this.onCanSubmitChange});this.render()}events(){return{"click .js-btn-action":"onActionClicked","click .js-btn-feedback":"onFeedbackClicked"}}render(){const data=this.model.toJSON();const template=Handlebars.templates.buttons;_.defer((()=>{this.postRender();Adapt$1.trigger("buttonsView:postRender",this)}));this.$el.html(template(data))}postRender(){this.refresh()}checkResetSubmittedState(){const isSubmitted=this.model.get("_isSubmitted");if(isSubmitted){this.$el.addClass("is-submitted");return}this.$(".js-btn-marking, .js-btn-marking-label").removeClass("is-incorrect is-correct").addClass("u-display-none");this.$el.removeClass("is-submitted");this.model.set("feedbackMessage",undefined);this.disableFeedbackButton()}onActionClicked(){const buttonState=BUTTON_STATE$1(this.model.get("_buttonState"));this.trigger("buttons:stateUpdate",buttonState);this.checkResetSubmittedState();if(buttonState===BUTTON_STATE$1.SHOW_CORRECT_ANSWER){const correctAnswer=this.model.getCorrectAnswerAsText?.();this.updateAnswerLiveRegion(correctAnswer)}if(buttonState===BUTTON_STATE$1.HIDE_CORRECT_ANSWER){const userAnswer=this.model.getUserAnswerAsText?.();this.updateAnswerLiveRegion(userAnswer)}}onFeedbackClicked(){this.trigger("buttons:stateUpdate",BUTTON_STATE$1.SHOW_FEEDBACK)}onFeedbackMessageChanged(model,changedAttribute){if(!changedAttribute)return;this.enableFeedbackButton()}enableFeedbackButton(){if(!this.model.get("_canShowFeedback"))return;a11y$1.toggleEnabled(this.$(".js-btn-feedback"),true)}disableFeedbackButton(){a11y$1.toggleEnabled(this.$(".js-btn-feedback"),false)}onCanSubmitChange(){this.onButtonStateChanged(this.model,this.model.get("_buttonState"))}onButtonStateChanged(model,changedAttribute){this.updateAttemptsCount();const $buttonsAction=this.$(".js-btn-action");const buttonState=BUTTON_STATE$1(changedAttribute);if(!buttonState){return logging$1.error(`No button state found for '${changedAttribute}'`)}if(changedAttribute===BUTTON_STATE$1.CORRECT||changedAttribute===BUTTON_STATE$1.INCORRECT){a11y$1.toggleEnabled($buttonsAction,false);return}const propertyName=textPropertyName[buttonState.asString];const ariaLabel=this.model.get("_buttons")["_"+propertyName].ariaLabel;const buttonText=this.model.get("_buttons")["_"+propertyName].buttonText;a11y$1.toggleEnabled($buttonsAction,this.model.get("_canSubmit"));$buttonsAction.html(buttonText).attr("aria-label",ariaLabel)}checkFeedbackState(){const canShowFeedback=this.model.get("_canShowFeedback");const canShowMarking=this.model.get("_canShowMarking");this.$(".js-btn-action, .js-btn-marking").toggleClass("is-full-width",!canShowFeedback);this.$(".js-btn-feedback").toggleClass("u-display-none",!canShowFeedback);this.$(".js-btn-marking, .js-btn-marking-label").toggleClass("u-display-none",!canShowMarking)}updateAttemptsCount(){const isInteractionComplete=this.model.get("_isInteractionComplete");const attemptsLeft=this.model.get("_attemptsLeft")?this.model.get("_attemptsLeft"):this.model.get("_attempts");const shouldDisplayAttempts=this.model.get("_shouldDisplayAttempts");let attemptsString;this.checkResetSubmittedState();if(!isInteractionComplete&&attemptsLeft>=0){attemptsString=attemptsLeft+" ";attemptsString+=attemptsLeft===1?this.model.get("_buttons").remainingAttemptText:this.model.get("_buttons").remainingAttemptsText}else{this.$(".js-display-attempts").addClass("u-visibility-hidden");this.showMarking()}if(shouldDisplayAttempts){this.$(".js-insert-attempts-string").html(attemptsString)}}updateAnswerLiveRegion(answer){if(!answer)return;this.$(".js-answer-live-region").html(answer)}showMarking(){if(!this.model.shouldShowMarking)return;const isCorrect=this.model.get("_isCorrect");const ariaLabels=Adapt$1.course.get("_globals")._accessibility._ariaLabels;const $marking=this.$(".js-btn-marking, .js-btn-marking-label").removeClass("u-display-none").addClass(isCorrect?"is-correct":"is-incorrect");const $ariaLabel=this.$(".js-btn-marking-label");const hasSpanAriaLabel=Boolean($ariaLabel.length);if(!hasSpanAriaLabel){$marking.attr("aria-label",isCorrect?ariaLabels.answeredCorrectly:ariaLabels.answeredIncorrectly);return}$ariaLabel.html(isCorrect?ariaLabels.answeredCorrectly:ariaLabels.answeredIncorrectly)}refresh(){this.updateAttemptsCount();this.checkResetSubmittedState();this.checkFeedbackState();this.onButtonStateChanged(null,this.model.get("_buttonState"));this.onFeedbackMessageChanged(null,this.model.get("_isSubmitted"))}});class QuestionModel extends ComponentModel$1{defaults(){return ComponentModel$1.resultExtend("defaults",{_isQuestionType:true,_shouldDisplayAttempts:false,_shouldShowMarking:false,_canShowModelAnswer:true,_canShowFeedback:true,_canShowMarking:true,_canSubmit:true,_isSubmitted:false,_isCorrectAnswerShown:false,_questionWeight:Adapt$1.config.get("_questionWeight"),_hasItemScoring:false,_items:[]})}trackable(){return ComponentModel$1.resultExtend("trackable",["_isSubmitted","_score","_isCorrect","_attemptsLeft","_isPartlyCorrect"])}trackableType(){return ComponentModel$1.resultExtend("trackableType",[Boolean,Number,Boolean,Number,Boolean])}getTypeGroup(){return"question"}init(){this.setupDefaultSettings();this.setLocking("_canSubmit",true);this.updateRawScore();super.init()}setupDefaultSettings(){this.setupWeightSettings();this.setupButtonSettings()}setupButtonSettings(){const globalButtons=Adapt$1.course.get("_buttons");if(!this.has("_buttons")){this.set("_buttons",globalButtons)}else{const componentButtons=this.get("_buttons");for(const key in componentButtons){if(typeof componentButtons[key]==="object"){if(!componentButtons[key].buttonText&&globalButtons[key].buttonText){componentButtons[key].buttonText=globalButtons[key].buttonText}if(!componentButtons[key].ariaLabel&&globalButtons[key].ariaLabel){componentButtons[key].ariaLabel=globalButtons[key].ariaLabel}}if(!componentButtons[key]&&globalButtons[key]){componentButtons[key]=globalButtons[key]}}}}setupWeightSettings(){}canSubmit(){}checkCanSubmit(){this.set("_canSubmit",this.canSubmit(),{pluginName:"adapt"})}updateAttempts(){const attemptsLeft=this.get("_attemptsLeft")||this.get("_attempts");this.set("_attemptsLeft",attemptsLeft-1)}setQuestionAsSubmitted(){this.set({_isEnabled:false,_isSubmitted:true,_shouldShowMarking:this.shouldShowMarking})}markQuestion(){this.set({_isCorrect:this.isCorrect(),_isPartlyCorrect:this.isPartlyCorrect()});this.updateRawScore()}isCorrect(){}isPartlyCorrect(){}setScore(){const questionWeight=this.get("_questionWeight");const answeredCorrectly=this.get("_isCorrect");const score=answeredCorrectly?questionWeight:0;this.set("_score",score)}updateRawScore(){this.set({_rawScore:this.score,_maxScore:this.maxScore,_minScore:this.minScore})}get score(){return this.get("_isCorrect")?this.maxScore:0}get maxScore(){return this.get("_questionWeight")}get minScore(){return 0}checkQuestionCompletion(){const isComplete=this.get("_isCorrect")||this.get("_attemptsLeft")===0;if(isComplete){this.setCompletionStatus()}return isComplete}updateButtons(){const isInteractionComplete=this.get("_isInteractionComplete");const isCorrect=this.get("_isCorrect");const isEnabled=this.get("_isEnabled");const buttonState=this.get("_buttonState");const canShowModelAnswer=this.get("_canShowModelAnswer");if(isInteractionComplete){if(isCorrect||!canShowModelAnswer){this.set("_buttonState",BUTTON_STATE$1.CORRECT)}else{switch(buttonState){case BUTTON_STATE$1.SUBMIT:case BUTTON_STATE$1.HIDE_CORRECT_ANSWER:this.set("_buttonState",BUTTON_STATE$1.SHOW_CORRECT_ANSWER);break;default:this.set("_buttonState",BUTTON_STATE$1.HIDE_CORRECT_ANSWER)}}}else{if(isEnabled){this.set("_buttonState",BUTTON_STATE$1.SUBMIT)}else{this.set("_buttonState",BUTTON_STATE$1.RESET)}}}getFeedback(feedback=this.get("_feedback")){if(!feedback)return{};const isFinal=this.get("_attemptsLeft")===0;const isCorrect=this.get("_isCorrect");const correctness=isCorrect?"correct":this.isPartlyCorrect()?"partlyCorrect":"incorrect";const isLegacyConfig=typeof feedback.correct==="string"||typeof feedback._partlyCorrect==="object"||typeof feedback._incorrect==="object";const getLegacyConfigObject=()=>{const subPart=isFinal?"final":"notFinal";return{body:(isCorrect?feedback.correct:feedback[`_${correctness}`]?.[subPart]||feedback[`_${correctness}`]?.final||feedback._incorrect?.final)||""}};const getConfigObject=()=>{const subPart=isFinal?"Final":"NotFinal";return(isCorrect?feedback._correct:feedback[`_${correctness}${subPart}`]||feedback[`_${correctness}Final`]||feedback._incorrectFinal)||{}};const altTitle=feedback.altTitle||Adapt$1.course.get("_globals")._accessibility.altFeedbackTitle;const title=feedback.title||this.get("title")||altTitle||"";const feedbackConfig={isAltTitle:title===altTitle,altTitle:altTitle,title:Handlebars.compile(title)(this.toJSON()),_classes:feedback._classes,...isLegacyConfig?getLegacyConfigObject():getConfigObject()};if(feedbackConfig._graphic?._src&&!feedbackConfig._imageAlignment){feedbackConfig._imageAlignment="right"}return feedbackConfig}setupFeedback(){if(!this.has("_feedback"))return;const{altTitle:altTitle="",title:title="",body:body=""}=this.getFeedback();this.set({feedbackTitle:Handlebars.compile(title)(this.toJSON()),feedbackMessage:Handlebars.compile(body)(this.toJSON())})}isInteractive(){return!this.get("_isComplete")||this.get("_isEnabled")&&!this.get("_isSubmitted")}checkIfResetOnRevisit(){super.checkIfResetOnRevisit();this.set("_buttonState",this.get("_isInteractionComplete")?BUTTON_STATE$1.HIDE_CORRECT_ANSWER:BUTTON_STATE$1.SUBMIT)}reset(type="hard",canReset=this.get("_canReset")){const wasReset=super.reset(type,canReset);if(!wasReset)return false;const attempts=this.get("_attempts");this.set({_attemptsLeft:attempts,_isCorrect:undefined,_isPartlyCorrect:undefined,_isCorrectAnswerShown:false,_isSubmitted:false,_buttonState:BUTTON_STATE$1.SUBMIT,_shouldShowMarking:this.shouldShowMarking});return true}setQuestionAsReset(){this.set({_isEnabled:true,_isSubmitted:false,_shouldShowMarking:this.shouldShowMarking});this.resetQuestion()}resetQuestion(){}refresh(){this.trigger("question:refresh")}getButtonState(){if(this.get("_isCorrect")){return BUTTON_STATE$1.CORRECT}if(this.get("_attemptsLeft")===0){return this.get("_canShowModelAnswer")?BUTTON_STATE$1.SHOW_CORRECT_ANSWER:BUTTON_STATE$1.INCORRECT}return this.get("_isSubmitted")?BUTTON_STATE$1.RESET:BUTTON_STATE$1.SUBMIT}getInteractionObject(){return{}}getResponse(){}getResponseType(){}onSubmitted(){if(this.get("_shouldStoreAttempts"))this.addAttemptObject();this.set("_shouldShowMarking",this.shouldShowMarking)}get shouldShowMarking(){return!this.isInteractive()&&this.get("_canShowMarking")&&this.get("_isInteractionComplete")}}components$1.register("question",{model:QuestionModel});var QuestionModel$1=__AMD("core/js/models/questionModel",QuestionModel);class QuestionView extends ComponentView$1{className(){return["component","is-question",this.model.get("_component").toLowerCase(),this.model.get("_id"),this.model.get("_classes"),this.setVisibility(),"is-"+this.model.get("_layout"),this.model.get("_isComplete")?"is-complete":"",this.model.get("_isOptional")?"is-optional":"",this.model.get("_canShowModelAnswer")?"can-show-model-answer":"",this.model.get("_canShowFeedback")?"can-show-feedback":"",this.model.get("_canShowMarking")?"can-show-marking":""].join(" ")}initialize(...args){this.isInteractive=this.isInteractive.bind(this);super.initialize(...args)}isInteractive(){logging$1.deprecated("questionView.isInteractive please use this.model.isInteractive, this.model.get('_shouldShowMarking') or this.model.shouldShowMarking");return this.model.isInteractive()}preRender(){this.listenTo(this.model,"change:_isEnabled",this.onEnabledChanged);this.listenTo(this.model,"question:refresh",this.refresh);if(this.checkIfResetOnRevisit!==QuestionView.prototype.checkIfResetOnRevisit){logging$1.deprecated("QuestionView.checkIfResetOnRevisit, please use QuestionModel.checkIfResetOnRevisit")}this.checkIfResetOnRevisit();_.defer((()=>this.ensureLegacyLifecycleState()));this._runModelCompatibleFunction("setupDefaultSettings");this.setupQuestion()}onEnabledChanged(model,changedAttribute){if(!changedAttribute){this.$(".component__widget").addClass("is-disabled");this.disableQuestion()}else{this.$(".component__widget").removeClass("is-disabled");this.enableQuestion()}}disableQuestion(){}enableQuestion(){}checkIfResetOnRevisit(){const canReset=this.model.get("_canReset")!==false;const isResetOnRevisit=this.model.get("_isResetOnRevisit");if(!canReset||!isResetOnRevisit)return;if(this.resetQuestionOnRevisit===QuestionView.prototype.resetQuestionOnRevisit)return;logging$1.deprecated("QuestionView.resetQuestionOnRevisit, please QuestionModel.reset");_.defer((()=>{this.resetQuestionOnRevisit(isResetOnRevisit)}))}ensureLegacyLifecycleState(){if(this.model.get("_isSubmitted")){this.onHideCorrectAnswerClicked();return}this.onResetClicked()}resetQuestionOnRevisit(type){}setupQuestion(){}postRender(){this.addButtonsView();this.onQuestionRendered()}addButtonsView(){this.buttonsView=new ButtonsView({model:this.model,el:this.$(".btn__container")});this.listenTo(this.buttonsView,"buttons:stateUpdate",this.onButtonStateUpdate)}onButtonStateUpdate(buttonState){switch(buttonState){case BUTTON_STATE$1.SUBMIT:this.onSubmitClicked();break;case BUTTON_STATE$1.RESET:this.onResetClicked();break;case BUTTON_STATE$1.SHOW_CORRECT_ANSWER:this.onShowCorrectAnswerClicked();break;case BUTTON_STATE$1.HIDE_CORRECT_ANSWER:this.onHideCorrectAnswerClicked();break;case BUTTON_STATE$1.SHOW_FEEDBACK:this.showFeedback();break}}onQuestionRendered(){}onSubmitClicked(){const canSubmit=this._runModelCompatibleFunction("canSubmit");if(!canSubmit){this.showInstructionError();this.onCannotSubmit();return}this.stopRendering();this._runModelCompatibleFunction("updateAttempts");this._runModelCompatibleFunction("setQuestionAsSubmitted");this._runModelCompatibleFunction("storeUserAnswer");this._runModelCompatibleFunction("markQuestion","isCorrect");this._runModelCompatibleFunction("setScore");this._runModelCompatibleFunction("checkQuestionCompletion");if(this.model.shouldShowMarking){this.showMarking()}this.recordInteraction();this._runModelCompatibleFunction("setupFeedback");this.showFeedback();$(window).resize();this._runModelCompatibleFunction("updateButtons");this.startRendering();this.changed();this.model.onSubmitted();this.onSubmitted();Adapt$1.trigger("questionView:submitted",this)}showInstructionError(){Adapt$1.trigger("questionView:showInstructionError",this)}onCannotSubmit(){}onSubmitted(){}setQuestionAsSubmitted(){this.model.setQuestionAsSubmitted();this.$(".component__widget").addClass("is-submitted")}showMarking(){}checkQuestionCompletion(){const isComplete=this.model.checkQuestionCompletion();if(isComplete){this.$(".component__widget").addClass("is-complete show-user-answer")}}recordInteraction(){if(this.model.get("_recordInteraction")===true||!this.model.has("_recordInteraction")){Adapt$1.trigger("questionView:recordInteraction",this)}}showFeedback(){if(this.model.get("_canShowFeedback")){Adapt$1.trigger("questionView:showFeedback",this)}else{Adapt$1.trigger("questionView:disabledFeedback",this)}}onResetClicked(){this.setQuestionAsReset();this._runModelCompatibleFunction("resetUserAnswer");this.model.checkCanSubmit();this._runModelCompatibleFunction("updateButtons");if(!this.model.get("_isReady"))return;const currentModel=data$1.findById(location$1._currentId);if(!currentModel?.get("_isReady"))return;this.focusAfterReset()}setQuestionAsReset(){this.model.setQuestionAsReset();this.resetQuestion();this.$(".component__widget").removeClass("is-submitted")}focusAfterReset(){a11y$1.focusNext(this.$el)}resetQuestion(){}refresh(){this.model.set("_buttonState",this.model.getButtonState());if(this.model.shouldShowMarking){this.showMarking()}if(this.buttonsView){_.defer(this.buttonsView.refresh.bind(this.buttonsView))}}onShowCorrectAnswerClicked(){this.setQuestionAsShowCorrect();this._runModelCompatibleFunction("updateButtons");this.showCorrectAnswer()}setQuestionAsShowCorrect(){this.$(".component__widget").addClass("is-submitted show-correct-answer").removeClass("show-user-answer")}showCorrectAnswer(){this.model.set("_isCorrectAnswerShown",true)}onHideCorrectAnswerClicked(){this.setQuestionAsHideCorrect();this._runModelCompatibleFunction("updateButtons");this.hideCorrectAnswer()}setQuestionAsHideCorrect(){this.$(".component__widget").addClass("is-submitted show-user-answer").removeClass("show-correct-answer")}hideCorrectAnswer(){this.model.set("_isCorrectAnswerShown",false)}getLatency(){return null}_runModelCompatibleFunction(name,lookForViewOnlyFunction){return this.model[name]()}}QuestionView._isQuestionType=true;class ViewOnlyQuestionViewCompatibilityLayer extends QuestionView{getInteractionObject(){logging$1.deprecated("QuestionView.getInteractionObject, please use QuestionModel.getInteractionObject");return this.model.getInteractionObject()}getResponse(){logging$1.deprecated("QuestionView.getResponse, please use QuestionModel.getResponse");return this.model.getResponse()}getResponseType(){logging$1.deprecated("QuestionView.getResponseType, please use QuestionModel.getResponseType");return this.model.getResponseType()}setupDefaultSettings(){logging$1.deprecated("QuestionView.setupDefaultSettings, please use QuestionModel.setupDefaultSettings");return this.model.setupDefaultSettings()}setupButtonSettings(){logging$1.deprecated("QuestionView.setupButtonSettings, please use QuestionModel.setupButtonSettings");return this.model.setupButtonSettings()}setupWeightSettings(){logging$1.deprecated("QuestionView.setupWeightSettings, please use QuestionModel.setupWeightSettings");return this.model.setupWeightSettings()}canSubmit(){logging$1.deprecated("QuestionView.canSubmit, please use QuestionModel.canSubmit");return this.model.canSubmit()}updateAttempts(){logging$1.deprecated("QuestionView.updateAttempts, please use QuestionModel.updateAttempts");return this.model.updateAttempts()}storeUserAnswer(){logging$1.deprecated("QuestionView.storeUserAnswer, please use QuestionModel.storeUserAnswer");return this.model.storeUserAnswer()}resetUserAnswer(){logging$1.deprecated("QuestionView.resetUserAnswer, please use QuestionModel.resetUserAnswer");return this.model.resetUserAnswer()}markQuestion(){if(this._isInViewOnlyCompatibleMode("isCorrect")){if(this.isCorrect()){this.model.set("_isCorrect",true)}else{this.model.set("_isCorrect",false)}this.model.set({_rawScore:this.model.get("_isCorrect")?this.model.get("_questionWeight"):0,_maxScore:this.model.get("_questionWeight"),_minScore:0})}else{return this.model.markQuestion()}}isCorrect(){logging$1.deprecated("QuestionView.isCorrect, please use QuestionModel.isCorrect");return this.model.isCorrect()}setScore(){logging$1.deprecated("QuestionView.setScore, please use QuestionModel.setScore");return this.model.setScore()}updateButtons(){logging$1.deprecated("QuestionView.updateButtons, please use QuestionModel.updateButtons");return this.model.updateButtons()}setupFeedback(){if(this._isInViewOnlyCompatibleMode("isPartlyCorrect")){if(this.model.get("_isCorrect")){this._runModelCompatibleFunction("setupCorrectFeedback")}else if(this.isPartlyCorrect()){this._runModelCompatibleFunction("setupPartlyCorrectFeedback")}else{this._runModelCompatibleFunction("setupIncorrectFeedback")}}else{this.model.setupFeedback()}}isPartlyCorrect(){logging$1.deprecated("QuestionView.isPartlyCorrect, please use QuestionModel.isPartlyCorrect");return this.model.isPartlyCorrect()}setupCorrectFeedback(){logging$1.deprecated("QuestionView.setupCorrectFeedback, please use QuestionModel.setupCorrectFeedback");return this.model.setupCorrectFeedback()}setupPartlyCorrectFeedback(){logging$1.deprecated("QuestionView.setupPartlyCorrectFeedback, please use QuestionModel.setupPartlyCorrectFeedback");return this.model.setupPartlyCorrectFeedback()}setupIncorrectFeedback(){logging$1.deprecated("QuestionView.setupIncorrectFeedback, please use QuestionModel.setupIncorrectFeedback");return this.model.setupIncorrectFeedback()}_runModelCompatibleFunction(name,lookForViewOnlyFunction){if(this._isInViewOnlyCompatibleMode(name,lookForViewOnlyFunction)){return this[name]()}else{return this.model[name]()}}_isInViewOnlyCompatibleMode(name,lookForViewOnlyFunction){const checkForFunction=lookForViewOnlyFunction||name;if(!this.constructor.prototype[checkForFunction])return false;const hasCompatibleVersion=Object.prototype.hasOwnProperty.call(ViewOnlyQuestionViewCompatibilityLayer.prototype,checkForFunction);const usingCompatibleVersion=this.constructor.prototype[checkForFunction]===ViewOnlyQuestionViewCompatibilityLayer.prototype[checkForFunction];if(hasCompatibleVersion&&usingCompatibleVersion){switch(checkForFunction){case"setupFeedback":case"markQuestion":return true}return false}return true}}var QuestionView$1=__AMD("core/js/views/questionView",ViewOnlyQuestionViewCompatibilityLayer);class McqView extends QuestionView$1{initialize(...args){this.onKeyPress=this.onKeyPress.bind(this);this.onItemSelect=this.onItemSelect.bind(this);this.onItemFocus=this.onItemFocus.bind(this);this.onItemBlur=this.onItemBlur.bind(this);super.initialize(...args)}setupQuestion(){this.model.setupRandomisation()}onQuestionRendered(){this.setReadyStatus()}onKeyPress(event){if(event.which!==13)return;this.onItemSelect(event)}onItemFocus(event){if(!this.model.isInteractive())return;if(this.model.get("_isRadio")){this.onItemSelect(event);return}const index=parseInt($(event.currentTarget).data("adapt-index"));const item=this.model.getChildren().findWhere({_index:index});item.set("_isHighlighted",true)}onItemBlur(event){const index=$(event.currentTarget).data("adapt-index");const item=this.model.getChildren().findWhere({_index:index});item.set("_isHighlighted",false)}onItemSelect(event){if(!this.model.isInteractive())return;const index=$(event.currentTarget).data("adapt-index");const itemModel=this.model.getItem(index);let shouldSelect=!itemModel.get("_isActive");if(this.model.isSingleSelect()){shouldSelect=true;this.model.resetActiveItems()}else if(shouldSelect&&this.model.isAtActiveLimit()){this.model.getLastActiveItem().toggleActive(false)}itemModel.toggleActive(shouldSelect)}resetQuestion(){this.model.resetItems()}}McqView.template="mcq.jsx";var McqView$1=__AMD("components/adapt-contrib-mcq/js/McqView",McqView);var ItemModel=__AMD("core/js/models/itemModel",class ItemModel extends LockingModel{defaults(){return{_isActive:false,_isVisited:false,_score:0}}reset(){this.set({_isActive:false,_isVisited:false})}toggleActive(isActive=!this.get("_isActive")){this.set("_isActive",Boolean(isActive))}toggleVisited(isVisited=!this.get("_isVisited")){this.set("_isVisited",Boolean(isVisited))}});var ItemsComponentModel=__AMD("core/js/models/itemsComponentModel",class ItemsComponentModel extends ComponentModel$1{toJSON(){const json=super.toJSON();json._items=this.getChildren().toJSON();return json}init(){this.setUpItems();this.listenTo(this.getChildren(),{all:this.onAll,change:this.storeUserAnswer,"change:_isActive":this.setVisitedStatus,"change:_isVisited":this.checkCompletionStatus});super.init()}restoreUserAnswers(){const booleanArray=this.get("_userAnswer");if(!booleanArray)return;this.getChildren().forEach((child=>child.set("_isVisited",booleanArray[child.get("_index")])))}storeUserAnswer(){const items=this.getChildren().slice(0);items.sort(((a,b)=>a.get("_index")-b.get("_index")));const booleanArray=items.map((child=>child.get("_isVisited")));this.set("_userAnswer",booleanArray)}setUpItems(){const items=this.get("_items")||[];items.forEach(((item,index)=>item._index=index));this.setChildren(new Backbone.Collection(items,{model:ItemModel}))}getItem(index){return this.getChildren().findWhere({_index:index})}getVisitedItems(){return this.getChildren().where({_isVisited:true})}getActiveItems(){return this.getChildren().where({_isActive:true})}getActiveItem(){return this.getChildren().findWhere({_isActive:true})}areAllItemsCompleted(){return this.getVisitedItems().length===this.getChildren().length}checkCompletionStatus(){this.setVisitedStatus();if(!this.areAllItemsCompleted())return;this.setCompletionStatus()}reset(type="hard",canReset=this.get("_canReset")){const wasReset=super.reset(type,canReset);if(!wasReset)return false;this.getChildren().each((item=>item.reset()));return true}resetActiveItems(){this.getChildren().each((item=>item.toggleActive(false)))}setActiveItem(index){const item=this.getItem(index);if(!item)return;const activeItem=this.getActiveItem();if(activeItem)activeItem.toggleActive(false);item.toggleActive(true)}});class BlendedItemsComponentQuestionModel extends QuestionModel$1{init(){ItemsComponentModel.prototype.init.call(this);super.init()}reset(type="hard",canReset=this.get("_canReset")){ItemsComponentModel.prototype.reset.call(this,type,canReset);return super.reset(type,canReset)}}Object.getOwnPropertyNames(ItemsComponentModel.prototype).forEach((name=>{if(name==="constructor"||name==="init"||name==="reset")return;Object.defineProperty(BlendedItemsComponentQuestionModel.prototype,name,{value:ItemsComponentModel.prototype[name]})}));var ItemsQuestionModel=__AMD("core/js/models/itemsQuestionModel",class ItemsQuestionModel extends BlendedItemsComponentQuestionModel{init(){super.init();this.set("_isRadio",this.isSingleSelect());this.listenTo(this.getChildren(),"change:_isActive",this.checkCanSubmit);this.checkCanSubmit()}restoreUserAnswers(){if(!this.get("_isSubmitted"))return;const itemModels=this.getChildren();const userAnswer=this.get("_userAnswer");if(!userAnswer)return;itemModels.each((item=>{item.toggleActive(Boolean(userAnswer[item.get("_index")]))}));this.setQuestionAsSubmitted();this.markQuestion();this.setScore();this.setupFeedback()}setupRandomisation(){if(!this.get("_isRandom")||!this.get("_isEnabled"))return;const children=this.getChildren();children.set(children.shuffle())}canSubmit(){const activeItems=this.getActiveItems();return activeItems.length>0}storeUserAnswer(){const items=this.getChildren().slice(0);items.sort(((a,b)=>a.get("_index")-b.get("_index")));const userAnswer=items.map((itemModel=>itemModel.get("_isActive")));this.set("_userAnswer",userAnswer)}isCorrect(){const allChildren=this.getChildren();const activeChildren=allChildren.filter((itemModel=>itemModel.get("_isActive")));const isItemCorrect=itemModel=>itemModel.get("_shouldBeSelected")&&!itemModel.get("_isPartlyCorrect");const isItemPartlyCorrect=itemModel=>itemModel.get("_isPartlyCorrect");const isItemIncorrect=itemModel=>!itemModel.get("_shouldBeSelected")&&!itemModel.get("_isPartlyCorrect");const sum=(list,predicate)=>list.reduce(((sum,item)=>sum+(predicate(item)?1:0)),0);const props={_numberOfRequiredAnswers:sum(allChildren,isItemCorrect),_numberOfCorrectAnswers:sum(activeChildren,isItemCorrect),_numberOfPartlyCorrectAnswers:sum(activeChildren,isItemPartlyCorrect),_numberOfIncorrectAnswers:sum(activeChildren,isItemIncorrect)};activeChildren.forEach((itemModel=>itemModel.set("_isCorrect",itemModel.get("_shouldBeSelected"))));props._isAtLeastOneCorrectSelection=Boolean(props._numberOfCorrectAnswers||props._numberOfPartlyCorrectAnswers);const numberOfSelectableAnswers=this.get("_selectable");const hasSelectableCorrectAnswers=props._numberOfCorrectAnswers===numberOfSelectableAnswers;const hasAllCorrectAnswers=props._numberOfCorrectAnswers===props._numberOfRequiredAnswers;const hasCorrectAnswers=hasSelectableCorrectAnswers||hasAllCorrectAnswers;const hasIncorrectAnswers=props._numberOfIncorrectAnswers;const hasPartlyCorrectAnswers=props._numberOfPartlyCorrectAnswers;this.set(props);return hasCorrectAnswers&&!hasIncorrectAnswers&&!hasPartlyCorrectAnswers}setScore(){const questionWeight=this.get("_questionWeight");const answeredCorrectly=this.get("_isCorrect");const score=answeredCorrectly?questionWeight:0;this.set("_score",score)}get score(){if(!this.get("_hasItemScoring"))return super.score;const children=this.getChildren()?.toArray()||[];return children.reduce(((score,child)=>score+=child.get("_isActive")?child.get("_score")||0:0),0)}get maxScore(){if(!this.get("_hasItemScoring"))return super.maxScore;const children=this.getChildren()?.toArray()||[];const scores=children.map((child=>child.get("_score")||0));scores.sort(((a,b)=>a-b));return scores.reverse().slice(0,this.get("_selectable")).filter((score=>score>0)).reduce(((maxScore,score)=>maxScore+=score),0)}get minScore(){if(!this.get("_hasItemScoring"))return super.minScore;const children=this.getChildren()?.toArray()||[];const scores=children.map((child=>child.get("_score")||0));scores.sort(((a,b)=>a-b));return scores.slice(0,this.get("_selectable")).filter((score=>score<0)).reduce(((minScore,score)=>minScore+=score),0)}getFeedback(_feedback=this.get("_feedback")){if(!_feedback)return{};const activeItem=this.getActiveItem();const activeItemFeedback=activeItem?.get?.("feedback");const isIndividualFeedback=!this.isCorrect()&&!this.isPartlyCorrect()&&this.isSingleSelect()&&activeItemFeedback;const feedback=super.getFeedback(_feedback);if(!isIndividualFeedback)return feedback;if(typeof activeItemFeedback==="string"){return{...feedback,body:activeItemFeedback||""}}const feedbackConfig={...feedback,...activeItemFeedback};if(feedbackConfig?._graphic?._src&&!feedbackConfig?._imageAlignment){feedbackConfig._imageAlignment="right"}return feedbackConfig}isPartlyCorrect(){return this.get("_isAtLeastOneCorrectSelection")}resetUserAnswer(){this.set("_userAnswer",[])}isAtActiveLimit(){const selectedItems=this.getActiveItems();return selectedItems.length===this.get("_selectable")}isSingleSelect(){return this.get("_selectable")===1}getLastActiveItem(){const selectedItems=this.getActiveItems();return selectedItems[selectedItems.length-1]}resetQuestion(){this.resetItems()}resetItems(){if(this.get("_shouldResetAllAnswers")===false){this.resetIncorrectItems();return}this.resetActiveItems();this.set("_isAtLeastOneCorrectSelection",false)}resetIncorrectItems(){this.getChildren().each((item=>{const isCorrect=item.get("_shouldBeSelected")||item.get("_isCorrect");if(isCorrect)return;item.toggleActive(false)}));this.set("_isAtLeastOneCorrectSelection",Boolean(this.getLastActiveItem()))}getInteractionObject(){const interactions={correctResponsesPattern:[],choices:[]};interactions.choices=this.getChildren().map((itemModel=>({id:(itemModel.get("_index")+1).toString(),description:itemModel.get("text")})));const correctItems=this.getChildren().filter((itemModel=>itemModel.get("_shouldBeSelected")));interactions.correctResponsesPattern=[correctItems.map((itemModel=>String(itemModel.get("_index")+1))).join("[,]")];return interactions}getResponse(){const activeItems=this.getActiveItems();const activeIndexes=activeItems.map((itemModel=>itemModel.get("_index")+1));return activeIndexes.join(",")}getResponseType(){return"choice"}getCorrectAnswerAsText(){const globals=Adapt$1.course.get("_globals")._components["_"+this.get("_component")];const isSingleSelect=this.isSingleSelect();const ariaAnswer=isSingleSelect?globals?.ariaCorrectAnswer:globals?.ariaCorrectAnswers;if(!ariaAnswer)return;const correctOptions=this.getChildren().where({_shouldBeSelected:true});const correctAnswer=isSingleSelect?correctOptions[0]?.get("text"):correctOptions.map((correctOption=>correctOption.get("text"))).join("<br>");return Handlebars.compile(ariaAnswer)({correctAnswer:correctAnswer})}getUserAnswerAsText(){const globals=Adapt$1.course.get("_globals")._components["_"+this.get("_component")];const isSingleSelect=this.isSingleSelect();const ariaAnswer=isSingleSelect?globals?.ariaUserAnswer:globals?.ariaUserAnswers;if(!ariaAnswer)return;const selectedItems=this.getActiveItems();const userAnswer=isSingleSelect?selectedItems[0].get("text"):selectedItems.map((selectedItem=>selectedItem.get("text"))).join("<br>");return Handlebars.compile(ariaAnswer)({userAnswer:userAnswer})}});var McqModel=__AMD("components/adapt-contrib-mcq/js/McqModel",class McqModel extends ItemsQuestionModel{});__AMD("components/adapt-contrib-mcq/js/adapt-contrib-mcq",components$1.register("mcq",{model:McqModel,view:McqView$1}));class TextView extends ComponentView$1{postRender(){this.setReadyStatus();this.setupInview()}setupInview(){const selector=this.getInviewElementSelector();if(!selector)return this.setCompletionStatus();this.setupInviewCompletion(selector)}getInviewElementSelector(){if(this.model.get("body"))return".component__body";if(this.model.get("instruction"))return".component__instruction";if(this.model.get("displayTitle"))return".component__title";return null}}TextView.template="text.jsx";var TextView$1=__AMD("components/adapt-contrib-text/js/TextView",TextView);var TextModel=__AMD("components/adapt-contrib-text/js/TextModel",class TextModel extends ComponentModel$1{});__AMD("components/adapt-contrib-text/js/adapt-contrib-text",components$1.register("text",{model:TextModel,view:TextView$1}));class LaerdalMediaDrawerView extends Backbone.View{className(){return"laerdal-media-drawer"}initialize(config){this.listenTo(Adapt$1,"remove",this.remove);this.listenTo(Adapt$1,"drawer:closed",this.onCloseDrawer);this.config=config;this.render()}onCloseDrawer(){document.activeElement.classList.add("plyr__tab-focus")}render(){const template=Handlebars.templates["laerdal-media-drawer"];this.$el.html(template(this.config))}}var LaerdalMediaDrawerView$1=__AMD("components/adapt-laerdal-media/js/LaerdalMediaDrawerView",LaerdalMediaDrawerView);class LaerdalMediaView extends ComponentView$1{events(){return{"click [data-plyr=transcript]":"onToggleInlineTranscript","click .plyr__poster":"onMediaPosterClick"}}preRender(){this.listenTo(Adapt$1,{"media:stop":this.onMediaStop});this.model.checkMediaSource()}postRender(){if(!this.model.get("_hasValidSource")){this.setReadyStatus();this.$(".component__widget").html("<p class='warning'>Info: Media source not valid</p>");return}if(window.Plyr){this.setupPlayer()}else{this.listenToOnce(Adapt$1,"plyr:ready",this.setupPlayer.bind(this))}}setupPlayer(){const playerOptions=this.model.getPlayerOptions();playerOptions.settings=["speed"];playerOptions.speed={selected:1,options:[.5,1,1.5,2]};this.player=new Plyr(`#player-${this.model.get("_id")}`,playerOptions);this.player.on("ratechange",(event=>{const modelView=this.model;Adapt$1.trigger("media:ratechange",{modelView:modelView})}));this.updateSource();this.updateTranscript();this.setupPlayerEventListeners()}updateSource(){const _media=this.model.get("_media");if(_media.mp4||_media.webm){this.player.source=this.model.getMediaSource()}}async updateTranscript(){const _media=this.model.get("_media");const filteredTranscriptInline=_media.cc.filter((track=>track?._srcType==="transcript"&&track?._srcTypeTranscript?._transcriptType==="transcriptInline"&&track?._transcriptInline?.inlineTranscriptBody!=="")).map((track=>({_setCompletionOnView:track?._transcriptInline?._setCompletionOnView,inlineTranscriptTitle:track?._transcriptInline?.inlineTranscriptTitle,inlineTranscriptBody:track?._transcriptInline?.inlineTranscriptBody})));if(filteredTranscriptInline.length){this.model.set("_transcript",filteredTranscriptInline[0])}const filteredAssets=await Promise.all(_media.cc.filter((track=>track?._srcType==="transcript"&&track?._srcTypeTranscript?._transcriptType==="asset"&&track._srcAssetTranscript?.src!=="")).map((async track=>{const fileContents=await this.setupTranscriptText(track?._srcAssetTranscript?.src);return{_setCompletionOnView:track?._srcAssetTranscript?._setCompletionOnView,inlineTranscriptTitle:track?._srcAssetTranscript?.inlineTranscriptTitle,inlineTranscriptBody:fileContents}})));if(filteredAssets.length){this.model.set("_transcript",filteredAssets[0])}}setupPlayerEventListeners(){this.player.on("stop",this.onMediaStop.bind(this));this.player.on("play",this.onMediaElementPlay.bind(this));this.player.on("ready",this.onMediaElementReady.bind(this));this.player.on("playing",this.onMediaElementPlaying.bind(this));this.player.on("ended",this.onMediaElementEnded.bind(this));this.player.on("pause",this.onMediaElementPause.bind(this));this.player.on("seeking",this.onMediaElementSeeking.bind(this));this.player.on("timeupdate",this.onMediaElementTimeUpdate.bind(this));this.player.on("enterfullscreen",this.onEnterfullscreen.bind(this));this.player.on("exitfullscreen",this.onExitfullscreen.bind(this));this.player.on("captionsenabled",this.onCaptionsEnabled.bind(this));this.player.on("captionsdisabled",this.onCaptionsDisabled.bind(this));this.player.on("chaptersenabled",this.onChaptersEnabled.bind(this));this.player.on("chaptersdisabled",this.onChaptersDisabled.bind(this));this.player.on("volumechange",this.onVolumeChange.bind(this));this.player.on("descriptionsenabled",this.onDescriptionsEnabled.bind(this));this.player.on("descriptionsdisabled",this.onDescriptionsDisabled.bind(this))}async setupTranscriptText(filePath){try{const response=await fetch(filePath);if(!response.ok){throw new Error("Failed to fetch asset")}const text=await response.text();return text}catch(error){console.log(error)}}setupEventListeners(){this.completionEvent=this.model.get("_setCompletionOn")||"play";if(this.completionEvent==="inview"){this.setupInviewCompletion(".component__widget")}}onMediaPosterClick(event){this.setAriaLabel(event)}setAriaLabel(event){const posterElement=$(event.currentTarget);if(!posterElement)return;const isMediaplaying=this.model.get("_isMediaPlaying");posterElement.attr("aria-label",`${isMediaplaying?"Pause":"Play"}`)}openDrawer(){drawer.triggerCustomView(new LaerdalMediaDrawerView$1({title:this.model.get("_transcript")?.inlineTranscriptTitle,body:this.model.get("_transcript")?.inlineTranscriptBody}).$el,true)}onMediaElementReady(event){this.$(".component__widget").addClass(`laerdal-${this.player.type}-plyr`);this.setupEventListeners();this.setReadyStatus();if(this.player.isYoutube){const iframeElement=$("[id*=youtube]")[0];this.hideFromScreenReaders(iframeElement)}this.model.set({_isEmbed:this.player.isEmbed,_isHTML5:this.player.isHTML5,_mediaType:this.player.type,_mediaProvider:this.player.provider,_mediaUrl:this.player.source})}onMediaElementPlay(event){this.queueGlobalEvent("play");Adapt$1.trigger("media:stop",this);if(this.model.get("_pauseWhenOffScreen")){if(this.player.media.tagName==="AUDIO")$(this.player.media.parentElement).on("inview",this.onMediaElementInview);else $(this.player.media).on("inview",this.onMediaElementInview)}this.model.set({_isMediaPlaying:true,_isMediaEnded:false,_mediaCurrentTime:this.player.currentTime,_mediaDuration:this.player.duration});if(this.completionEvent==="play"){this.setCompletionStatus()}if(this.player.isYoutube){const iframeElement=$("[id*=youtube]")[0];this.announceInScreenReaders(iframeElement)}}onMediaElementPlaying(event){this.$el.toggleClass("is-playing",true)}onMediaElementPause(event){this.model.set({_mediaCurrentTime:this.player.currentTime,_mediaDuration:this.player.duration});this.queueGlobalEvent("pause");$(this.player).off("inview",this.onMediaElementInview);this.model.set("_isMediaPlaying",false);this.$el.toggleClass("is-playing",false)}onMediaElementEnded(event){this.queueGlobalEvent("ended");this.$(".sr-helper").text("Media ended");this.model.set({_isMediaEnded:true,_mediaCurrentTime:this.player.currentTime,_mediaDuration:this.player.duration});if(this.completionEvent==="ended"){this.setCompletionStatus()}}onMediaElementInview(event,isInView){if(event.currentTarget.tagName==="DIV"){if(!isInView&&!event.currentTarget.paused)event.currentTarget.childNodes[0].pause()}else if(!isInView&&!event.currentTarget.paused)event.currentTarget.pause()}onMediaElementSeeking(event){let maxViewed=this.model.get("_maxViewed");if(!maxViewed){maxViewed=0}if(event.target.currentTime>maxViewed){event.target.currentTime=maxViewed}}onMediaElementTimeUpdate(event){let maxViewed=this.model.get("_maxViewed");if(!maxViewed){maxViewed=0}if(event.target.currentTime>maxViewed){this.model.set("_maxViewed",event.target.currentTime)}}onMediaStop(view){if(view&&view.cid===this.cid)return;if(!this.player)return;this.player.pause()}onEnterfullscreen(){this.$(".component__widget").toggleClass("is-fullscreen",true)}onExitfullscreen(event){this.$(".component__widget").toggleClass("is-fullscreen",false).find(".plyr").removeClass("plyr--fullscreen-entered");this.setAccessibilityFocus(event)}onCaptionsEnabled(){const lang=this.player?.captions?.language;const _media=this.model.get("_media");if(_media?.type==="vimeo"){this.player?.embed?.enableTextTrack(lang)}this.player.elements.captions=document.createElement("div");this.player.elements.captions.classList.add("plyr__captions");if(this.player.elements.container.lastChild.className==="plyr__captions"){this.player.elements.container.lastChild.remove()}this.player.elements.container.appendChild(this.player.elements.captions);this.player.elements.container.classList.add("plyr--captions-active");if(this.player?.captions?.active){this.$('[data-plyr="captions"]').attr("data-analytics","Enable Captions")}}onCaptionsDisabled(){const _media=this.model.get("_media");if(_media?.type==="vimeo"){this.player?.embed?.disableTextTrack()}if(!this.player?.captions?.active){this.$('[data-plyr="captions"]').attr("data-analytics","Disable Captions")}}onDescriptionsEnabled(){if(this.player?.descriptions?.active)this.$('[data-plyr="descriptions"]').attr("data-analytics","Enable Audio Descriptions")}onDescriptionsDisabled(){if(!this.player?.descriptions?.active)this.$('[data-plyr="descriptions"]').attr("data-analytics","Disable Audio Descriptions")}onChaptersEnabled(){const _media=this.model.get("_media");const ariaLabel=`Enable chapters, ${_media.title}}`;this.$('[data-plyr="chapters"]').attr("aria-label",ariaLabel)}onChaptersDisabled(){const _media=this.model.get("_media");const ariaLabel=`Disable chapters, ${_media.title}}`;this.$('[data-plyr="chapters"]').attr("aria-label",ariaLabel)}onVolumeChange(){}setAccessibilityFocus(event){const tempActiveElement=document.activeElement;const activeElementId=this.getClosestVideoId(tempActiveElement);const eventSourceElementId=this.getEventSourceElementId(event);if(activeElementId===eventSourceElementId){a11y$1.focus(tempActiveElement)}}getClosestVideoId(activeElement){if(activeElement&&activeElement.closest("div.plyr--full-ui").querySelector("video")){return activeElement.closest("div.plyr--full-ui").querySelector("video").id}return 0}getEventSourceElementId(event){if(event.srcElement&&event.srcElement.querySelector("video")){return event.srcElement.querySelector("video").id}return 1}remove(){const media=this.model.get("_media");if(media.type==="'video/vimeo'"){this.$("iframe")[0].isRemoved=true}if(this.player){this.player.destroy();delete this.player}ComponentView$1.prototype.remove.call(this)}onToggleInlineTranscript(event){if(this.model.get("_transcript")?._setCompletionOnView!==false){this.setCompletionStatus()}this.openDrawer()}queueGlobalEvent(eventType){const timestamp=Date.now();const lastEvent=this.lastEvent||{time:0};const timeSinceLastEvent=timestamp-lastEvent.time;const debounceTime=500;this.lastEvent={time:timestamp,type:eventType};clearTimeout(this.eventTimeout);if(eventType==="ended"){return this.triggerGlobalEvent(eventType)}if(timeSinceLastEvent>debounceTime){this.eventTimeout=setTimeout(this.triggerGlobalEvent.bind(this,eventType),debounceTime)}}hideFromScreenReaders(element){if(element){element.setAttribute("tabindex","-1")}}announceInScreenReaders(element){if(element){element.setAttribute("tabindex","0")}}triggerGlobalEvent(eventType){Adapt$1.trigger("media",{isVideo:this.player.isVideo,type:eventType,src:this.player.source,platform:this.player.pluginType})}}LaerdalMediaView.template="laerdal-media";var LaerdalMediaView$1=__AMD("components/adapt-laerdal-media/js/LaerdalMediaView",LaerdalMediaView);var LaerdalMediaModel=__AMD("components/adapt-laerdal-media/js/LaerdalMediaModel",class LaerdalMediaModel extends ComponentModel$1{defaults(){return ComponentModel$1.resultExtend("defaults",{_isMediaEnded:false,_isMediaPlaying:false,_hasValidSource:false})}checkMediaSource(){let _media=this.get("_media");this.set("_mediaTitle",_media?.title);if(_media.mp4||_media.webm){_media.mp3="";_media.ogg="";_media.source="";this.set("_hasValidSource",true);this.set("_media",_media);return}if(_media.source){_media.mp3="";_media.ogg="";this.set("_hasValidSource",true);this.set("_media",_media);return}if(_media.mp3||_media.ogg){this.set("_hasValidSource",true);this.set("_media",_media)}}getMediaSource(){let _media=this.get("_media");let sources=[];let tracks=[];let captions,descriptions,chapters;let captionsFiltered=_media.cc.filter((track=>track.kind==="captions"));let descriptionsFiltered=_media.cc.filter((track=>track.kind==="descriptions"));let chaptersFiltered=_media.cc.filter((track=>track.kind==="chapters"));if(captionsFiltered.length>0||descriptionsFiltered.length>0||chaptersFiltered.length>0){captions=captionsFiltered;descriptions=descriptionsFiltered;chapters=chaptersFiltered}else{captions=_media.cc.filter((track=>track._srcType==="captions"&&track._srcTypeCaption?.src!=="")).map((track=>({kind:"captions",label:track._srcTypeCaption?.label,srclang:track._srcTypeCaption?.srclang,src:track._srcTypeCaption?.src})));descriptions=_media.cc.filter((track=>track._srcType==="descriptions"&&track._srcTypeDescriptions?.src!=="")).map((track=>({kind:"descriptions",label:track._srcTypeDescriptions?.label,srclang:track._srcTypeDescriptions?.srclang,src:track._srcTypeDescriptions?.src})));chapters=_media.cc.filter((track=>track._srcType==="chapters"&&track._srcTypeChapters?.src!=="")).map((track=>({kind:"chapters",label:track._srcTypeChapters?.label,srclang:track._srcTypeChapters?.srclang,src:track._srcTypeChapters?.src})))}if(captions.length){captions[0].default=true;tracks=[...captions]}if(descriptions.length){descriptions[0].default=true;tracks=[...tracks,...descriptions]}if(chapters.length){chapters[0].default=true;tracks=[...tracks,...chapters]}if(_media.mp4){sources.push({src:_media.mp4,type:"video/mp4"})}if(_media.webm){sources.push({src:_media.webm,type:"video/webm"})}return{type:"video",title:_media.title,sources:sources,tracks:tracks,poster:_media.poster}}getPlayerOptions(){let playerOptions={title:this.get("_media")?.title,debug:this.get("_debug"),chapters:{active:!this.get("_disabledChaptersRightSide"),language:Adapt$1.config.get("_defaultLanguage")||"en"},descriptions:{active:false,language:Adapt$1.config.get("_defaultLanguage")||"en"},controls:["play-large","play","progress","current-time","mute","volume","captions","chapters","descriptions","settings","fullscreen"],loop:{active:this.get("_loop")},resetOnEnd:this.get("_resetOnEnd"),settings:[],hideControls:false,tooltips:{controls:true},seekTime:3,invertTime:false,displayDuration:true,iconUrl:"libraries/plyr.svg"};let _media=this.get("_media");let transcript=_media.cc.filter((track=>track?._srcType==="transcript"&&(track?._srcAssetTranscript?.src!==""||track?._transcriptInline?.inlineTranscriptBody!=="")));if(transcript.length||this.get("_transcript")?.inlineTranscriptBody){playerOptions.controls.push("transcript")}const overrides=this.get("_playerOptions");if(overrides){playerOptions={...playerOptions,...overrides}}return playerOptions}});__AMD("components/adapt-laerdal-media/js/adapt-laerdal-media",components$1.register("laerdal-media",{model:LaerdalMediaModel,view:LaerdalMediaView$1}));class AMButtonModel extends Backbone.Model{initialize(){this.setupButtonSettings()}setupButtonSettings(){const courseBtn=Adapt$1.course.get("_additionalMaterial")?._button;const componentBtn=this.toJSON();if(!componentBtn._btnText){this.set("_btnText",courseBtn.text)}if(!componentBtn.iconClass){this.set("iconClass",courseBtn.iconClassName)}if(!componentBtn._btnAriaLabel){this.set("_btnAriaLabel",courseBtn.ariaLabel)}if(!componentBtn._btnType||componentBtn._btnType==="use-default-value"){this.set("_btnType",courseBtn._btnType)}}}var AMButtonModel$1=__AMD("extensions/adapt-additional-material/js/AMButtonModel",AMButtonModel);class AdditionMaterialDrawerView extends Backbone.View{className(){return"additional-material-drawer"}initialize(config){this.listenTo(Adapt$1,"remove",this.remove);this.config=config;this.preRender()}async preRender(){try{const viewTypeDrawer=this.model.get("_viewTypeDrawer");if(viewTypeDrawer?._drawerType){const{_drawerType:_drawerType}=viewTypeDrawer;let drawerTitle,drawerBody;if(_drawerType==="simpleViewInline"){const _simpleViewInline=this.model.get("_simpleViewInline")||{};drawerTitle=_simpleViewInline?.title;drawerBody=_simpleViewInline?.body}if(_drawerType==="simpleViewAsset"){const _simpleViewAsset=this.model.get("_simpleViewAsset")||{};const fileContents=await this.getAssetText(_simpleViewAsset?.src);drawerTitle=_simpleViewAsset?.title;drawerBody=fileContents}if(!drawerTitle||!drawerBody)return;this.title=drawerTitle;this.body=drawerBody}}catch(error){console.error("Error handling drawer:",error)}this.render()}render(){const template=Handlebars.templates["additional-material-drawer"];this.$el.html(template({title:this.title,body:this.body}))}async getAssetText(filePath){try{const response=await fetch(filePath);if(!response.ok){throw new Error("Failed to fetch asset")}const text=await response.text();const formattedText=`<pre class='format-text-amd'>${text}</pre>`;return formattedText}catch(error){console.log(error);return null}}}var AMDrawerView=__AMD("extensions/adapt-additional-material/js/AMDrawerView",AdditionMaterialDrawerView);class AMButtonView extends Backbone.View{tagName(){return"button"}events(){return{click:"onClick"}}className(){return["additional-material-btn js-additional-material-btn-click","btn-text",`btn-${this.model.get("_btnType")}`,this.model.get("_animationEffect")?`${this.model.get("_animationType")}`:""].join(" ")}attributes(){return{"aria-label":this.model.get("_btnAriaLabel"),"data-view-type":this.model.get("_viewType")}}initialize(options){this.listenTo(Adapt$1,"remove",this.remove);this.listenTo(options.componentView,"remove",this.remove);this.preRender();this.render()}preRender(){this.setupOnClickViews()}render(){const data=this.model.toJSON();const template=Handlebars.templates["additional-material-button"];this.$el.html(template(data))}async setupOnClickViews(){try{const viewType=this.model.get("_viewType");if(viewType==="drawer"){this.setupDrawerView()}}catch(error){console.error("Error setting up onClick views:",error)}}setupDrawerView(){this.drawerView=new AMDrawerView({model:this.model})}onClick(e){switch(this.model.get("_viewType")){case"modal":this.handleModal();break;case"drawer":this.handleDrawer();break;default:console.warn("btn type not handled")}}handleModal(){const options=this.model.get("_viewTypeModal");if(!options)return;const backgroundOpacity=options._backgroundTransparency;const popup=notify$1.popup({_classes:"additional-material-popup laerdal-life-popup",_id:options._viewId,_shouldRenderId:true});let validatedOpacity=typeof backgroundOpacity==="number"&&backgroundOpacity>=0&&backgroundOpacity<=1?backgroundOpacity:.5;popup.$el.find(".notify__shadow").css("background-color",`rgba(0, 0, 0, ${validatedOpacity})`)}handleDrawer(){drawer.openCustomView(this.drawerView.$el,true)}}var AMButtonView$1=__AMD("extensions/adapt-additional-material/js/AMButtonView",AMButtonView);class AMLinkView extends Backbone.View{tagName(){return"a"}events(){return{click:"handleLink"}}className(){return["additional-material-btn js-additional-material-link-click","btn-text",`btn-${this.model.get("_btnType")}`,this.model.get("_animationEffect")?`${this.model.get("_animationType")}`:""].join(" ")}attributes(){return{role:"link",href:this.model.get("_viewTypeLink")?._url,target:this.model.get("_viewTypeLink")?._target}}initialize(options){this.listenTo(Adapt$1,"remove",this.remove);this.listenTo(options.componentView,"remove",this.remove);this.render()}render(){const data=this.model.toJSON();const template=Handlebars.templates["additional-material-button"];this.$el.html(template(data))}handleLink(event){if(event)event.preventDefault();const item=this.model.get("_viewTypeLink");const{_url:url,_target:target="_blank"}=item;const isNewWindow=target!=="_self";if(isNewWindow){return target=="_popup"?window.open(url,target,"newwindow"):window.open(url,target)}const isRouterNavigation=url.substr(0,1)==="#";if(isRouterNavigation)return Backbone.history.navigate(url,{trigger:true});window.location.href=url}}var AMLinkView$1=__AMD("extensions/adapt-additional-material/js/AMLinkView",AMLinkView);class AMContainerView extends Backbone.View{className(){return"additional-material-btn-container"}initialize(options){this.componentView=options.componentView;this.listenTo(Adapt$1,"remove",this.remove);this.listenTo(this.componentView,"remove",this.remove);this.render();this.handleScroll=this.handleScroll.bind(this);$(window).on("scroll",this.handleScroll)}render(){_.defer((()=>{this.postRender()}));return this}postRender(){const componentItem=$(this.componentView.$el);if(componentItem.hasClass("laerdal-hotgraphic")){if(componentItem.find(".additional-material-btn").length==0){this.addButtons()}}else{this.addButtons()}}addButtons(){const items=this.model.get("_items");items.forEach((item=>item._viewType=="link"?this.$el.append(new AMLinkView$1({model:new AMButtonModel$1(item),componentView:this.componentView}).$el):this.$el.append(new AMButtonView$1({model:new AMButtonModel$1(item),componentView:this.componentView}).$el)))}handleScroll(){const componentBottom=this.componentView.$el.offset().top+this.componentView.$el.outerHeight();const scrollPosition=$(window).scrollTop()+$(window).height();const additionalMaterialBtn=this.$(".additional-material-btn");if(scrollPosition>=componentBottom&&additionalMaterialBtn.hasClass("ripple")){additionalMaterialBtn.addClass("ripple-effect")}}remove(){$(window).off("scroll",this.handleScroll);Backbone.View.prototype.remove.call(this)}}var AMContainerView$1=__AMD("extensions/adapt-additional-material/js/AMContainerView",AMContainerView);class AdditionalMaterialController extends Backbone.Controller{initialize(){this.listenTo(Adapt$1,"app:dataReady",this.onDataReady)}onDataReady(){const config=Adapt$1.config.get("_additionalMaterial");if(!config||!config._isEnabled)return;this.setUpEventListeners()}setUpEventListeners(){this.listenTo(Adapt$1,"componentView:postRender",this.onComponentPostRender)}onComponentPostRender(view){const componentConfig=view.model.get("_additionalMaterial");if(componentConfig&&componentConfig._isEnabled){view.$el.find(".component__inner").append(new AMContainerView$1({model:new Backbone.Model(componentConfig),componentView:view}).$el)}}}__AMD("extensions/adapt-additional-material/js/adapt-additional-material",new AdditionalMaterialController);class VersionBtnView extends Backbone.View{tagName(){return"button"}className(){return"nav__btn nav__cdn-btn js-cdn-nav-btn"}attributes(){return{"data-order":Adapt$1.course.get("_globals")?._extensions?._cdnConfig?._navOrder||100,"aria-label":Adapt$1.course._cdnDeployment?._btnAriaLabel||"Opens push notification and copies version information to clipboard.","data-tooltip-id":"cdn-version-button"}}events(){return{click:"onClick"}}initialize(){this.listenTo(Adapt$1,"remove",this.remove);this.setupClipboardText();this.registerTooltip();this.render()}setupClipboardText(){const template=Handlebars.templates.versionInfo;this.formattedVersionInfo=template(this.model.toJSON())}registerTooltip(){tooltips$1.register({_id:"cdn-version-button",_isEnabled:true,_position:"top middle right",text:Adapt$1.course._cdnDeployment?._btnTooltipText||"Copy version information to clipboard"})}render(){const{version:version}=this.model.get("cdnVersion");this.$el.html(`v${version}`)}onClick(){navigator.clipboard.writeText(this.formattedVersionInfo);notify$1.push({body:this.model.get("notifyText"),_timeout:3e4,_classes:"clipboard-label"})}}var VersionBtnView$1=__AMD("extensions/adapt-cdn-config/js/VersionBtnView",VersionBtnView);class CDNConfig extends Backbone__default["default"].Controller{initialize(){this.listenTo(Adapt$1,"app:dataReady",this.onDataReady)}async onDataReady(){this.config=Adapt$1.config.get("_cdnConfig");if(!this.config?._isEnabled)return;const data={};const cdnVersion=await this.fetchCDNVersion();data.cdnVersion=this.sanitizeVersionInfo(cdnVersion);data.package=this.getFrameworkInfo();const plugins=Adapt$1.build.get("plugins");data.components=plugins.filter((plugin=>plugin.component));data.extensions=plugins.filter((plugin=>plugin.extension));data.menu=plugins.filter((plugin=>plugin.menu));data.theme=plugins.filter((plugin=>plugin.theme));data.notifyText=this.getNotifyText();this.versionsModel=new Backbone__default["default"].Model(data);this.setupEventListeners();this.setupHelpers()}async fetchCDNVersion(){try{const response=await fetch("version.json");const result=await response.json();return result}catch(error){logging$1.debug("Could not find version.json")}}sanitizeVersionInfo(versionInfo){const courseDeployment=this.config._courseDeployment;let data=versionInfo||{};data.version=courseDeployment.version;data.fullVersion=versionInfo.fullVersion||courseDeployment.version;return data}getNotifyText(){return Adapt$1.course._cdnDeployment?._notifyText||"Version information copied to clipboard"}getFrameworkInfo(){return Adapt$1.build.get("package")}setupEventListeners(){this.listenTo(Adapt$1,{"router:contentObject":this.renderNavigationView})}setupHelpers(){Handlebars.registerHelper("plugin_info",(plugin=>`${plugin.name}, ${plugin.version}`))}renderNavigationView(){const versionBtnView=new VersionBtnView$1({model:this.versionsModel});versionBtnView.$el.appendTo(".nav__inner")}}__AMD("extensions/adapt-cdn-config/js/adapt-cdn-config",new CDNConfig);class CompletionNotifierView extends Backbone.View{events(){return{"click .snackbar__btn":"onClose"}}initialize(config){this.config=config;this.setUpEventListeners();this.render()}setUpEventListeners(){this.listenTo(this,"click .snackbar--btn-close_icon",this.onClose)}render(){var template=Handlebars.templates["completion-notifier"];this.$el.html(template({_message:this.config._message,_ariaLabel:this.config._ariaLabel}))}onClose(){$(".snackbar").removeClass("animate")}}var CompletionNotifierView$1=__AMD("extensions/adapt-completion-notifier/js/CompletionNotifierView",CompletionNotifierView);class CompletionNotifier extends Backbone.Controller{initialize(){this.listenTo(Adapt$1,"app:dataReady",this.onDataReady)}setUpEventListeners(){this.listenTo(Adapt$1,"tracking:complete",this.onCourseCompletion)}onDataReady(){this.config=Adapt$1.config.get("_completionNotifier");this.courseConfig=Adapt$1.course.get("_completionNotifier");if(!this.isEnabled(this.config))return;this.setUpEventListeners()}onCourseCompletion(completionData){var completionCriteria=Adapt$1.config.get("_completionCriteria");if(!completionCriteria)return;if(completionCriteria._requireAssessmentCompleted&&completionCriteria._requireContentCompleted){if(completionData.assessment.isPass)this.notifyCourseCompletion()}else if(completionCriteria._requireContentCompleted){if(Adapt$1.laerdalAssessment&&Adapt$1.laerdalAssessment._rounds>1)return;this.notifyCourseCompletion()}else if(completionCriteria._requireAssessmentCompleted){if(completionData.assessment.isPass)this.notifyCourseCompletion()}}notifyCourseCompletion(){let completionNotifierView=new CompletionNotifierView$1(this.courseConfig);$("#app").append(completionNotifierView.$el);setTimeout((()=>{$(".snackbar").addClass("animate");Adapt$1.a11y.focus($(".snackbar"))}),1e3)}isEnabled(config){return config&&config._isEnabled}}__AMD("extensions/adapt-completion-notifier/js/adapt-completion-notifier",new CompletionNotifier);const AssessmentView={postRender(){ArticleView$1.prototype.postRender.call(this);if(this.model.isAssessmentEnabled()){this._setupEventListeners();const config=this.model.getConfig();if(config?._questions?._canShowMarking===false){this.$el.addClass("has-no-marking")}}this.$el.addClass("is-assessment")},_setupEventListeners(){this.listenTo(Adapt$1,{"assessments:complete":this._onAssessmentComplete,"assessments:reset":this._onAssessmentReset,remove:this._onRemove})},_removeEventListeners(){this.stopListening(Adapt$1,{"assessments:complete":this._onAssessmentComplete,"assessments:reset":this._onAssessmentReset})},_onAssessmentComplete(state,model){if(state.id!==this.model.get("_assessment")._id)return;logging$1.info("assessment complete",state,model)},_onAssessmentReset(state,model){if(state.id!==this.model.get("_assessment")._id)return;logging$1.info("assessment reset",state,model)},_onRemove(){this._removeEventListeners()}};var AdaptAssessmentArticleView=__AMD("extensions/adapt-contrib-assessment/js/adapt-assessmentArticleView",AssessmentView);class QuestionBank{constructor(quizBankId,articleId){this._bankId=quizBankId;this._articleId=articleId;this._unusedQuestionBlocks=null;this._count=null}calculateAvailableQuestionBlocks(count){this._count=parseInt(count);const articleModel=data$1.findById(this._articleId);const children=articleModel.getAvailableChildModels();this._availableQuestionBlocks=children.map((blockModel=>{if(blockModel.get("_assessment")?._quizBankID!==this._bankId)return null;return blockModel})).filter(Boolean);const availableQuestionBlockIds=this._availableQuestionBlocks?.map((block=>block.get("_id")))||[];const unusedQuestionBlockIds=this._unusedQuestionBlocks?.map((block=>block.get("_id")))||[];const haveBlocksChanged=Boolean(_.difference(unusedQuestionBlockIds,availableQuestionBlockIds).length);if(!haveBlocksChanged)return;this._unusedQuestionBlocks=null}getRandomQuestionBlocks(){let count=this._count;if(count>this.unusedQuestionBlocks.length){logging$1.warn(`Bank ID ${this._bankId}: Attempting to display ${count} question(s), but only ${this.unusedQuestionBlocks.length} available`);count=this.unusedQuestionBlocks.length}const questionBlocks=[];let i=0;while(i++<count){const nextBlock=this.unusedQuestionBlocks.shift();questionBlocks.push(nextBlock)}return questionBlocks}get unusedQuestionBlocks(){const hasUnusedQuestion=Boolean(this._unusedQuestionBlocks?.length);if(!hasUnusedQuestion){this._unusedQuestionBlocks=_.shuffle(this._availableQuestionBlocks.slice(0))}return this._unusedQuestionBlocks}}var QuestionBank$1=__AMD("extensions/adapt-contrib-assessment/js/adapt-assessmentQuestionBank",QuestionBank);let givenIdCount=0;const assessmentConfigDefaults={_isEnabled:true,_questions:{_resetType:"soft",_canShowFeedback:false,_canShowMarking:false,_canShowModelAnswer:false},_suppressMarking:false,_isPercentageBased:true,_scoreToPass:100,_correctToPass:100,_includeInTotalScore:true,_assessmentWeight:1,_isResetOnRevisit:true,_reloadPageOnReset:true,_attempts:"infinite",_allowResetIfPassed:false};const AssessmentModel={_getCurrentQuestionComponents(){return this.findDescendantModels("block").filter((block=>block.get("_isAvailable"))).reduce(((questions,block)=>questions.concat(block.findDescendantModels("question"))),[])},_getAllQuestionComponents(){return this.findDescendantModels("question")},_postInitialize(){if(!this.isAssessmentEnabled())return;const assessmentConfig=this.getConfig();Object.assign(this,{_originalChildModels:null,_questionBanks:null,_forceResetOnRevisit:false});let attemptsLeft;switch(assessmentConfig._attempts){case"infinite":case 0:case undefined:case-1:case null:attemptsLeft="infinite";break;default:attemptsLeft=assessmentConfig._attempts;break}this.set({_assessmentCompleteInSession:false,_attemptInProgress:false,_isAssessmentComplete:false,_numberOfQuestionsAnswered:0,_lastAttemptScoreAsPercent:0,_attempts:attemptsLeft,_attemptsLeft:attemptsLeft,_attemptsSpent:0});this.listenToOnce(Adapt$1,"app:dataReady",this._onDataReady);this.listenTo(Adapt$1,"remove",this._onRemove)},init(){Object.defineProperty(this,"_originalChildModels",{get(){if(this._originalChildModelsStore){this._originalChildModelsStore=this._originalChildModelsStore.filter((model=>data$1.hasId(model.get("_id"))));return this._originalChildModelsStore}this._originalChildModelsStore=this.getChildren().models;this._setAssessmentOwnershipOnChildrenModels();return this._originalChildModelsStore}});this.setupCurrentQuestionComponents();this._updateQuestionsState()},setupCurrentQuestionComponents(){const assessmentQuestionsConfig=this.getConfig()._questions;this._getAllQuestionComponents().forEach((component=>{component.set({_canShowFeedback:assessmentQuestionsConfig._canShowFeedback,_canShowMarking:assessmentQuestionsConfig._canShowMarking,_canShowModelAnswer:assessmentQuestionsConfig._canShowModelAnswer})}))},_setAssessmentOwnershipOnChildrenModels(){const assessmentConfig=this.get("_assessment");const childConfig={_isPartOfAssessment:true,_assessmentId:assessmentConfig._id};for(const blockModel of this._originalChildModels){blockModel.set(childConfig);blockModel.setOnChildren(childConfig)}},checkIfResetOnRevisit(){},_onDataReady(){Adapt$1.assessment.register(this);const questions=this._getCurrentQuestionComponents();if(this.get("_attemptInProgress")&&questions.every((q=>q.get("_isSubmitted")))&&this.get("_requireCompletionOf")!==Number.POSITIVE_INFINITY){this.set("_attemptInProgress",false);logging$1.warn(`Assessment ${this.get("_id")} _attemptInProgress corrected as all questions are submitted`)}},_setupAssessmentData(force,callback){const assessmentConfig=this.getConfig();const state=this.getState();const hasAttemptsLeft=state.attemptsLeft>0||state.attemptsLeft==="infinite";const isFirstAttempt=state.attemptsSpent===0;const shouldResetOnRevisit=(isFirstAttempt||assessmentConfig._isResetOnRevisit)&&!this.get("_attemptInProgress");const shouldResetAssessment=shouldResetOnRevisit&&!state.isPass&&hasAttemptsLeft||force===true;const shouldResetQuestions=shouldResetOnRevisit&&(state.allowResetIfPassed||!state.isPass)||force===true;if(shouldResetAssessment||shouldResetQuestions){Adapt$1.trigger("assessments:preReset",this.getState(),this)}let quizModels;if(shouldResetAssessment){if(isFirstAttempt||assessmentConfig?._questions?._resetType==="hard"){this.set({_numberOfQuestionsAnswered:0,_isAssessmentComplete:false,_assessmentCompleteInSession:false,_score:0})}else{this.set({_assessmentCompleteInSession:false})}this.getChildren().reset(this._originalChildModels);this._resetFilter();if(assessmentConfig?._banks._isEnabled&&assessmentConfig?._banks._split.length>1){quizModels=this._setupBankedAssessment()}else if(assessmentConfig?._randomisation._isEnabled){quizModels=this._setupRandomisedAssessment()}}if(!quizModels){quizModels=this.getChildren().models}else if(quizModels.length===0){quizModels=this.getChildren().models;logging$1.warn("assessment: Not enough unique questions to create a fresh assessment, using last selection")}else{const outsideModels=this._originalChildModels.filter((model=>model.get("_type")!=="block"));quizModels=quizModels.concat(outsideModels)}this.getChildren().reset(quizModels);this.setupCurrentQuestionComponents();if(shouldResetAssessment||shouldResetQuestions){this._resetFilter();this._resetQuestions();this.set("_attemptInProgress",true);Adapt$1.trigger("assessments:reset",this.getState(),this)}if(!state.isComplete){this.set("_attemptInProgress",true)}this._overrideQuestionComponentSettings();this._setupQuestionListeners();this._checkNumberOfQuestionsAnswered();this._updateQuestionsState();Adapt$1.assessment.saveState();this.trigger("reset");if(shouldResetAssessment||shouldResetQuestions){Adapt$1.trigger("assessments:postReset",this.getState(),this)}},_setupBankedAssessment(){const assessmentConfig=this.getConfig();this._setupBanks();let blockModels=this._questionBanks.flatMap((questionBank=>questionBank.getRandomQuestionBlocks()));if(assessmentConfig._banks._randomisation){blockModels=_.shuffle(blockModels)}return blockModels},_setupBanks(){const assessmentConfig=this.getConfig();const bankSplits=assessmentConfig._banks._split.split(",");this.findDescendantModels("block").filter((block=>block.get("_isAvailable")&&block.findDescendantModels("question").length>0)).forEach((block=>{const quizBankId=block.get("_assessment")?._quizBankID;const isInvalidNumber=isNaN(quizBankId)||quizBankId<1;const isOutOfBounds=quizBankId>bankSplits.length;if(isInvalidNumber)logging$1.warn(`Bank ID ${quizBankId} is not a valid number`);if(isOutOfBounds)logging$1.warn(`Bank ID ${quizBankId} exceeds the number of available splits (${bankSplits.length})`)}));const hasBankSplitsChanged=bankSplits.length!==this._questionBanks?.length;if(hasBankSplitsChanged){this._questionBanks=[]}bankSplits.forEach(((count,index)=>{const bankId=index+1;const articleId=this.get("_id");this._questionBanks[bankId]=this._questionBanks[bankId]||new QuestionBank$1(bankId,articleId);this._questionBanks[bankId].calculateAvailableQuestionBlocks(count)}))},_setupRandomisedAssessment(){const assessmentConfig=this.getConfig();const randomisationModel=assessmentConfig._randomisation;const blockModels=this.findDescendantModels("block");let questionModels=_.shuffle(blockModels);if(randomisationModel._blockCount>0){questionModels=questionModels.slice(0,randomisationModel._blockCount)}return questionModels},_overrideQuestionComponentSettings(){const newSettings=this._getMarkingSettings();const questionConfig=this.getConfig()._questions;if(Object.prototype.hasOwnProperty.call(questionConfig,"_canShowFeedback")){newSettings._canShowFeedback=questionConfig._canShowFeedback}if(!_.isEmpty(newSettings)){const questionComponents=this._getAllQuestionComponents();questionComponents.forEach((model=>model.set(newSettings,{pluginName:"_assessment"})))}},_setupQuestionListeners(){this._removeQuestionListeners();this.listenTo(this,"bubble:change:_isInteractionComplete",this._onCompletionEvent)},_checkNumberOfQuestionsAnswered(){const questionComponents=this._getCurrentQuestionComponents();const numberOfQuestionsAnswered=questionComponents.filter((model=>model.get("_isInteractionComplete"))).length;this.set("_numberOfQuestionsAnswered",numberOfQuestionsAnswered)},_removeQuestionListeners(){this.stopListening(this,"bubble:change:_isInteractionComplete",this._onCompletionEvent)},_onCompletionEvent(event){if(event.target?.isTypeGroup("block"))return this._onBlockCompleted(event.target,event.value);if(event.target?.isTypeGroup("question"))return this._onQuestionCompleted(event.target,event.value)},_onBlockCompleted(blockModel,value){if(value===false)return;const questionModels=blockModel.findDescendantModels("question");questionModels.forEach((questionModel=>{this._onQuestionCompleted(questionModel,value)}));if(!blockModel.get("_isInteractionComplete"))return;this._checkAssessmentComplete()},_onQuestionCompleted(questionModel,value){if(value===false)return;if(!questionModel.get("_isInteractionComplete"))return;const numberOfQuestionsAnswered=this._getCurrentQuestionComponents().reduce(((count,question)=>count+=question.get("_isSubmitted")?1:0),0);this.set("_numberOfQuestionsAnswered",numberOfQuestionsAnswered);this._updateQuestionsState();Adapt$1.assessment.saveState();this._checkAssessmentComplete()},_checkAssessmentComplete(){const allQuestionsAdded=this.get("_requireCompletionOf")!==Number.POSITIVE_INFINITY;if(!allQuestionsAdded)return;const numberOfQuestionsAnswered=this.get("_numberOfQuestionsAnswered");const allQuestionsAnswered=numberOfQuestionsAnswered>=this._getCurrentQuestionComponents().length;if(!allQuestionsAnswered)return;this._onAssessmentComplete()},_onAssessmentComplete(){const wasAttemptInProgess=this.get("_attemptInProgress");if(!wasAttemptInProgess)return;this.set("_attemptInProgress",false);this._spendAttempt();const _scoreAsPercent=this._getScoreAsPercent();const _score=this._getScore();const _maxScore=this._getMaxScore();const _minScore=this._getMinScore();const _correctCount=this._getCorrectCount();const _correctAsPercent=this._getCorrectAsPercent();const _questionCount=this._getQuestionCount();this.set({_scoreAsPercent:_scoreAsPercent,_score:_score,_maxScore:_maxScore,_minScore:_minScore,_correctAsPercent:_correctAsPercent,_correctCount:_correctCount,_questionCount:_questionCount,_lastAttemptScoreAsPercent:_scoreAsPercent,_assessmentCompleteInSession:true,_isAssessmentComplete:true});this._updateQuestionsState();this._checkIsPass();this._removeQuestionListeners();if(this._isMarkingSuppressionEnabled()&&(!this._isAttemptsLeft()||this._isPassed())){_.defer((()=>{this._overrideMarkingSettings();this._refreshQuestions()}))}Adapt$1.trigger("assessments:complete",this.getState(),this)},_updateQuestionsState(){const questionComponents=this._getCurrentQuestionComponents();const questions=questionComponents.map((model=>({_id:model.get("_id"),_isCorrect:model.get("_isCorrect")??null})));this.set("_questions",questions)},_checkIsPass(){const assessmentConfig=this.getConfig();const isPercentageBased=assessmentConfig._isPercentageBased;const scoreToPass=assessmentConfig._scoreToPass;const correctToPass=assessmentConfig._correctToPass||0;const scoreAsPercent=this.get("_scoreAsPercent");const score=this.get("_score");const correctAsPercent=this.get("_correctAsPercent");const correctCount=this.get("_correctCount");const isPass=isPercentageBased?scoreAsPercent>=scoreToPass&&correctAsPercent>=correctToPass:score>=scoreToPass&&correctCount>=correctToPass;this.set("_isPass",isPass)},_getMarkingSettings(){let markingSettings={};if(this._shouldSuppressMarking()){markingSettings={_canShowMarking:false,_canShowModelAnswer:false}}else{const questionConfig=this.getConfig()._questions;if(Object.prototype.hasOwnProperty.call(questionConfig,"_canShowModelAnswer")){markingSettings._canShowModelAnswer=questionConfig._canShowModelAnswer}if(Object.prototype.hasOwnProperty.call(questionConfig,"_canShowMarking")){markingSettings._canShowMarking=questionConfig._canShowMarking}}return markingSettings},_overrideMarkingSettings(){const newMarkingSettings=this._getMarkingSettings();const questionComponents=this._getAllQuestionComponents();questionComponents.forEach((model=>model.set(newMarkingSettings,{pluginName:"_assessment"})))},_refreshQuestions(){const questionComponents=this._getCurrentQuestionComponents();questionComponents.forEach((model=>model.refresh()))},_shouldSuppressMarking(){return this._isMarkingSuppressionEnabled()&&this._isAttemptsLeft()&&!this._isPassed()},_isMarkingSuppressionEnabled(){const assessmentConfig=this.getConfig();return assessmentConfig._suppressMarking},_isAttemptsLeft(){if(this.get("_attemptsLeft")===0)return false;return true},_isPassed(){return this.get("_isAssessmentComplete")&&this.get("_isPass")},_spendAttempt(){if(!this._isAttemptsLeft())return false;let attemptsSpent=this.get("_attemptsSpent");this.set("_attemptsSpent",++attemptsSpent);if(this.get("_attempts")==="infinite")return true;let attemptsLeft=this.get("_attemptsLeft");this.set("_attemptsLeft",--attemptsLeft);return true},_getScore(){const questionComponents=this._getCurrentQuestionComponents();const score=questionComponents.reduce(((score,model)=>score+=model.score||0),0);return score},_getMaxScore(){const questionComponents=this._getCurrentQuestionComponents();const maxScore=questionComponents.reduce(((maxScore,model)=>maxScore+=model.maxScore||0),0);return maxScore},_getMinScore(){const questionComponents=this._getCurrentQuestionComponents();const minScore=questionComponents.reduce(((minScore,model)=>minScore+=model.minScore||0),0);return minScore},_getScoreAsPercent(){const minScore=this._getMinScore();const maxScore=this._getMaxScore();const score=this._getScore();const range=maxScore-minScore;return range===0?0:Math.round((score-minScore)/range*100)},_getCorrectCount(){return this._getCurrentQuestionComponents().reduce(((count,model)=>count+=model.get("_isCorrect")?1:0),0)},_getQuestionCount(){return this._getCurrentQuestionComponents().length},_getCorrectAsPercent(){const questionCount=this._getQuestionCount();return questionCount===0?0:Math.round(this._getCorrectCount()/questionCount*100)},_getLastAttemptScoreAsPercent(){return this.get("_lastAttemptScoreAsPercent")},_checkReloadPage(){if(!this.canResetInPage())return false;const parentId=this.getParent().get("_id");const currentLocation=location$1._currentId;if(currentLocation!==parentId)return false;if(!this.get("_isReady"))return false;return true},_reloadPage(callback){const assessmentConfig=this.getConfig();this._forceResetOnRevisit=true;this.listenToOnce(Adapt$1,"pageView:ready",(async()=>{if(assessmentConfig._scrollToOnReset){await router$1.navigateToElement(this.get("_id"))}callback()}));_.delay((()=>{Backbone.history.navigate("#/id/"+location$1._currentId,{replace:true,trigger:true})}),250)},_resetFilter(){const assessmentConfig=this.getConfig();if(!assessmentConfig?._questions?._resetIncorrectOnly)return;let blocks=this.getChildren().models;blocks=blocks.filter((model=>{const questions=model.findDescendantModels("question");if(!questions.length)return true;return questions.every((model=>!model.isCorrect()))}));this.getChildren().reset(blocks)},_resetQuestions(){const assessmentConfig=this.getConfig();const questionModels=this._getCurrentQuestionComponents();questionModels.forEach((model=>{if(assessmentConfig?._questions?._resetIncorrectOnly&&model?.isCorrect())return;model.reset(assessmentConfig._questions._resetType,true)}))},_onRemove(){this._removeQuestionListeners()},_setCompletionStatus(){this.set({_isComplete:true,_isInteractionComplete:true})},_checkIfQuestionsWereRestored(){if(this.get("_assessmentCompleteInSession"))return;if(!this.get("_isAssessmentComplete"))return;let wereQuestionsRestored=true;const questions=this.get("_questions");for(const question of questions){const questionModel=data$1.findById(question._id);if(questionModel.get("_isAvailable")&&!questionModel.get("_isSubmitted")){wereQuestionsRestored=false;break}}if(!wereQuestionsRestored){this.set("_assessmentCompleteInSession",true);return true}return false},isAssessmentEnabled(){if(this.get("_assessment")?._isEnabled)return true;return false},canResetInPage(){const assessmentConfig=this.getConfig();if(assessmentConfig._reloadPageOnReset===false)return false;return true},reset(force,callback){const assessmentConfig=this.getConfig();force=this._forceResetOnRevisit||force===true;this._forceResetOnRevisit=false;const isPageReload=this._checkReloadPage();if(this.get("_assessmentCompleteInSession")&&!assessmentConfig._isResetOnRevisit&&!isPageReload&&!force){if(typeof callback==="function")callback(false);return false}const wereQuestionsRestored=this._checkIfQuestionsWereRestored();force=force||wereQuestionsRestored;if(force&&!this._isAttemptsLeft()){this.set({_attemptsLeft:this.get("_attempts"),_attemptsSpent:0})}const allowResetIfPassed=this.get("_assessment")._allowResetIfPassed;if(!this._isAttemptsLeft()&&!force&&!allowResetIfPassed){if(typeof callback==="function")callback(false);return false}if(!isPageReload){this._setupAssessmentData(force);if(typeof callback==="function")callback(true)}else{this._reloadPage((()=>{if(typeof callback==="function")callback(true)}))}return true},getSaveState(){const state=this.getState();let blocks;const cfg=this.getConfig();const banksActive=cfg._banks?._isEnabled&&cfg._banks._split.length>1;const randomisationActive=cfg._randomisation?._isEnabled;if(!banksActive&&!randomisationActive){blocks=this.findDescendantModels("block")}else{blocks=state.questions.map((question=>data$1.findById(question._id).getParent()))}blocks=[...new Set(blocks)].filter((block=>block.trackingPosition));const blockTrackingPositions=blocks.map((block=>block.trackingPosition));const blockCompletion=blocks.map((block=>{const questions=block.findDescendantModels("question");return questions.map((question=>question.get("_isCorrect")||false))}));const blockData=[blockTrackingPositions,blockCompletion];const saveState=[state.isComplete?1:0,state.attemptsSpent,state.maxScore||0,state.score,state.attemptInProgress?1:0,state.minScore||0,state.correctAsPercent||0,state.correctCount||0,state.questionCount||0];const dataPackage=[saveState,blockData];return dataPackage},setRestoreState(dataPackage){const restoreState=dataPackage[0];const blockData=dataPackage[1];const _isAssessmentComplete=restoreState[0]===1;const attempts=this.get("_attempts");const _attemptsSpent=restoreState[1];const maxScore=restoreState[2];const score=restoreState[3];const _scoreAsPercent=score?Math.round(score/maxScore*100):0;const _attemptInProgress=restoreState[4]===1;const minScore=restoreState[5];const correctAsPercent=restoreState[6];const correctCount=restoreState[7];const questionCount=restoreState[8];const blocks=blockData[0].map((trackingPosition=>{if(typeof trackingPosition==="number"){return data$1.findWhere({_trackingId:trackingPosition})}return data$1.findByTrackingPosition(trackingPosition)}));if(blocks.length){const nonBlockChildren=this.getChildren().models.filter((model=>!model.isTypeGroup("block")));this.getChildren().reset(blocks.concat(nonBlockChildren))}const _questions=[];blocks.forEach(((block,blockIndex)=>{const blockQuestions=block.findDescendantModels("question");blockQuestions.forEach(((question,questionIndex)=>{_questions.push({_id:question.get("_id"),_isCorrect:blockData[1][blockIndex][questionIndex]})}))}));this.set({_isAssessmentComplete:_isAssessmentComplete,_assessmentCompleteInSession:false,_attemptsSpent:_attemptsSpent,_attemptInProgress:_attemptInProgress,_attemptsLeft:attempts==="infinite"?attempts:attempts-_attemptsSpent,_maxScore:maxScore||this._getMaxScore(),_minScore:minScore||this._getMinScore(),_score:score||0,_scoreAsPercent:_scoreAsPercent,_correctAsPercent:correctAsPercent||0,_correctCount:correctCount||0,_questions:_questions,_questionCount:questionCount||0,_lastAttemptScoreAsPercent:_scoreAsPercent});if(_isAssessmentComplete)this._checkIsPass();Adapt$1.trigger("assessments:restored",this.getState(),this)},getState(){const assessmentConfig=this.getConfig();const state={id:assessmentConfig._id,type:"article-assessment",pageId:this.getParent().get("_id"),articleId:this.get("_id"),isEnabled:assessmentConfig._isEnabled,isComplete:this.get("_isAssessmentComplete"),isPercentageBased:assessmentConfig._isPercentageBased,scoreToPass:assessmentConfig._scoreToPass,score:this.get("_score"),scoreAsPercent:this.get("_scoreAsPercent"),maxScore:this.get("_maxScore"),minScore:this.get("_minScore"),correctCount:this.get("_correctCount"),correctAsPercent:this.get("_correctAsPercent"),correctToPass:assessmentConfig._correctToPass,questionCount:this.get("_questionCount"),isPass:this.get("_isPass"),includeInTotalScore:assessmentConfig._includeInTotalScore,assessmentWeight:assessmentConfig._assessmentWeight,attempts:this.get("_attempts"),attemptsSpent:this.get("_attemptsSpent"),attemptsLeft:this.get("_attemptsLeft"),attemptInProgress:this.get("_attemptInProgress"),lastAttemptScoreAsPercent:this.get("_lastAttemptScoreAsPercent"),questions:this.get("_questions"),resetType:assessmentConfig._questions._resetType,allowResetIfPassed:assessmentConfig._allowResetIfPassed,questionModels:new Backbone.Collection(this._getCurrentQuestionComponents())};return state},getConfig(){let assessmentConfig=this.get("_assessment");if(!assessmentConfig){assessmentConfig=$.extend(true,{},assessmentConfigDefaults)}else{assessmentConfig=$.extend(true,{},assessmentConfigDefaults,assessmentConfig)}if(assessmentConfig._id===undefined){assessmentConfig._id="givenId"+givenIdCount++}this.set("_assessment",assessmentConfig);return assessmentConfig}};var AdaptAssessmentArticleModel=__AMD("extensions/adapt-contrib-assessment/js/adapt-assessmentArticleModel",AssessmentModel);const assessmentsConfigDefaults={_isPercentageBased:true,_scoreToPass:100,_isDefaultsLoaded:true};class Assessment extends Backbone.Controller{initialize(){this._assessments=Object.assign([],{_byPageId:{},_byAssessmentId:{}});this.listenTo(Adapt$1,{"assessments:complete":this._onAssessmentsComplete,"router:location":this._checkResetAssessmentsOnRevisit,"router:plugin":this._handleRoute,"app:dataReady":this._onDataReady});this.triggerAssessmentsRestored()}async triggerAssessmentsRestored(){await data$1.whenReady();Adapt$1.trigger("assessment:restored",this.getState())}_onAssessmentsComplete(state){const assessmentId=state.id;state.isComplete=true;if(assessmentId===undefined)return;if(!this._getStateByAssessmentId(assessmentId)){logging$1.warn("assessments: state was not registered when assessment was created")}this.saveState();this._setPageProgress();this._checkAssessmentsComplete()}_restoreModelState(assessmentModel){if(!this._saveStateModel){this._saveStateModel=offlineStorage$1.get("a")}if(this._saveStateModel){const state=assessmentModel.getState();if(this._saveStateModel[state.id]){assessmentModel.setRestoreState(offlineStorage$1.deserialize(this._saveStateModel[state.id]))}}}_handleRoute(plugin,id){if(plugin!=="assessment"&&plugin!=="article-assessment"||id===undefined){return}if(!data$1.findById(id)){const assessment=Adapt$1.assessment._assessments._byAssessmentId[id];if(assessment){id=assessment.get("_id")}else{logging$1.warn("Assessment not found with _id: "+id);return}}_.defer((()=>{Backbone.history.navigate("#/id/"+id,{trigger:true,replace:true})}))}_checkResetAssessmentsOnRevisit(toObject){if(toObject._contentType!=="page")return;const pageAssessmentModels=this._getAssessmentByPageId(toObject._currentId);if(pageAssessmentModels===undefined)return;Wait$1.for((function resetAllAssessments(allAssessmentHaveReset){const numberOfAssessments=pageAssessmentModels.length;let numberOfResetAssessments=0;const forceAssessmentReset=false;pageAssessmentModels.forEach((model=>{model.reset(forceAssessmentReset,(()=>{numberOfResetAssessments++;const haveAllModelsReset=numberOfResetAssessments===numberOfAssessments;if(!haveAllModelsReset){return}allAssessmentHaveReset()}))}))}));this._setPageProgress()}_onDataReady(){this._assessments=Object.assign([],{_byPageId:{},_byAssessmentId:{}});this._restoredCount=0}_checkAssessmentsComplete(){let allAssessmentsComplete=true;let assessmentToPostBack=0;const states=this._getStatesByAssessmentId();const assessmentStates=[];for(const id in states){const state=states[id];if(!state.includeInTotalScore)continue;if(!state.isComplete){allAssessmentsComplete=false;break}assessmentToPostBack++;assessmentStates.push(state)}if(!allAssessmentsComplete||assessmentToPostBack===0)return false;if(assessmentToPostBack===1){this._setupSingleAssessmentConfiguration(assessmentStates[0])}_.defer((()=>Adapt$1.trigger("assessment:complete",this.getState())));return true}_setupSingleAssessmentConfiguration(assessmentState){const assessmentsConfig=Adapt$1.course.get("_assessment");$.extend(true,assessmentsConfig,{_isPercentageBased:assessmentState.isPercentageBased,_scoreToPass:assessmentState.scoreToPass});Adapt$1.course.set("_assessment",assessmentsConfig)}_getAssessmentByPageId(pageId){return this._assessments._byPageId[pageId]}_getStateByAssessmentId(assessmentId){if(assessmentId===undefined){return null}return this._assessments._byAssessmentId[assessmentId].getState()}_getStatesByAssessmentId(){const states={};for(const assessmentModel of this._assessments){if(!assessmentModel.get("_isAvailable"))continue;const state=assessmentModel.getState();states[state.id]=state}return states}_setPageProgress(){for(const[id,assessments]of Object.entries(this._assessments._byPageId)){const availableAssessments=assessments.filter((model=>model.get("_isAvailable")));const assessmentsTotal=availableAssessments.length;let assessmentsPassed=0;for(const assessment of availableAssessments){const assessmentState=assessment.getState();if(assessmentState.includeInTotalScore&&!assessmentState.isPass)continue;if(assessmentState.isComplete){assessmentsPassed++}}const pageModel=data$1.findById(id);pageModel?.set({_subProgressTotal:assessmentsTotal,_subProgressComplete:assessmentsPassed})}}_addToAssessmentIdMap(id,model){if(id===undefined){logging$1.warn('An assessment has been registered with an undefined value for "_id"');return}if(id===""){logging$1.warn('An assessment has been registered with an empty value for "_id"')}if(!this._assessments._byAssessmentId[id]){this._assessments._byAssessmentId[id]=model}else{logging$1.warn('An assessment with an _id of "'+id+'" already exists!')}}_setupQuestionNumbering(){const getRelatedQuestions=data=>{const currentAssessmentId=data._assessmentId;const currentAssessment=Adapt$1.assessment.get(currentAssessmentId);return currentAssessment.getState().questions};Handlebars.registerHelper("questionNumber",(function getQuestionNumber(){const data=this.view?.model.toJSON()||this;if(!data._isPartOfAssessment)return;const related=_.pluck(getRelatedQuestions(data),"_id");return related.indexOf(data._id)+1}));Handlebars.registerHelper("questionCount",(function getTotalQuestions(){const data=this.view?this.view.model.toJSON():this;if(!data._isPartOfAssessment)return;return getRelatedQuestions(data).length}))}register(assessmentModel){const state=assessmentModel.getState();const assessmentId=state.id;const pageId=state.pageId;if(this._assessments._byPageId[pageId]===undefined){this._assessments._byPageId[pageId]=[]}this._assessments._byPageId[pageId].push(assessmentModel);this._addToAssessmentIdMap(assessmentId,assessmentModel);this._assessments.push(assessmentModel);this._restoreModelState(assessmentModel);this._restoredCount++;Adapt$1.trigger("assessments:register",state,assessmentModel);this._setPageProgress();this._setupQuestionNumbering()}get(id){return id===undefined?this._assessments.slice(0):this._assessments._byAssessmentId[id]}saveState(){this._saveStateModel={};for(const assessmentModel of this._assessments){const state=assessmentModel.getState();this._saveStateModel[state.id]=offlineStorage$1.serialize(assessmentModel.getSaveState())}offlineStorage$1.set("a",this._saveStateModel)}getConfig(){let assessmentsConfig=Adapt$1.course.get("_assessment");if(assessmentsConfig?._isDefaultsLoaded){return assessmentsConfig}if(assessmentsConfig===undefined){assessmentsConfig=$.extend(true,{},assessmentsConfigDefaults)}else{assessmentsConfig=$.extend(true,{},assessmentsConfigDefaults,assessmentsConfig)}Adapt$1.course.set("_assessment",assessmentsConfig);return assessmentsConfig}getState(){const assessmentsConfig=this.getConfig();let score=0;let maxScore=0;let minScore=0;let correctCount=0;let questionCount=0;let assessments=0;const states=this._getStatesByAssessmentId();let assessmentsComplete=0;for(const id in states){const state=states[id];if(!state.includeInTotalScore)continue;if(state.isComplete)assessmentsComplete++;assessments++;maxScore+=state.maxScore/state.assessmentWeight;minScore+=state.minScore/state.assessmentWeight;score+=state.score/state.assessmentWeight;correctCount+=state.correctCount/state.assessmentWeight;questionCount+=state.questionCount/state.assessmentWeight}const isComplete=assessmentsComplete===assessments;const scoreRange=maxScore-minScore;const scoreAsPercent=scoreRange===0?0:Math.round((score-minScore)/scoreRange*100);const correctAsPercent=questionCount===0?0:Math.round(correctCount/questionCount*100);if(assessmentsConfig._correctToPass===undefined){logging$1.warnOnce("Assessment course config is missing _correctToPass")}const scoreToPass=assessmentsConfig._scoreToPass;const correctToPass=assessmentsConfig._correctToPass||scoreToPass;const isPercentageBased=assessmentsConfig._isPercentageBased;const isPass=isComplete&&(isPercentageBased?scoreAsPercent>=scoreToPass&&correctAsPercent>=correctToPass:score>=scoreToPass&&correctCount>=correctToPass);const canRetry=Object.values(states).some((state=>{const isFailed=!state.isPass;const hasAttemptsLeft=state.attemptsLeft>0||state.attemptsLeft==="infinite";return isFailed&&hasAttemptsLeft}));return{isComplete:isComplete,isPercentageBased:isPercentageBased,isPass:isPass,maxScore:maxScore,minScore:minScore,score:score,scoreToPass:scoreToPass,scoreAsPercent:scoreAsPercent,correctCount:correctCount,correctAsPercent:correctAsPercent,correctToPass:correctToPass,questionCount:questionCount,assessmentsComplete:assessmentsComplete,assessments:assessments,canRetry:canRetry}}}__AMD("extensions/adapt-contrib-assessment/js/assessment",Adapt$1.assessment=new Assessment);const ArticleViewInitialize=ArticleView$1.prototype.initialize;ArticleView$1.prototype.initialize=function(options){if(this.model.get("_assessment")?._isEnabled===true){Object.assign(this,AdaptAssessmentArticleView)}return ArticleViewInitialize.apply(this,arguments)};const ArticleModelInitialize=ArticleModel$1.prototype.initialize;ArticleModel$1.prototype.initialize=function(options){if(this.get("_assessment")?._isEnabled===true){Object.assign(this,AdaptAssessmentArticleModel);const returnValue=ArticleModelInitialize.apply(this,arguments);this._postInitialize();return returnValue}return ArticleModelInitialize.apply(this,arguments)};class Completion extends Backbone.Controller{initialize(){___default["default"].bindAll(this,"calculatePercentageComplete");this.subProgressCompleted=0;this.subProgressTotal=0;this.nonAssessmentCompleted=0;this.nonAssessmentTotal=0;this.assessmentCompleted=0;this.assessmentTotal=0}calculateCompletion(contentObjectModel,setGlobal=false){const completion={};const perform=contentObjectModel=>{const viewType=contentObjectModel.get("_type");const isComplete=contentObjectModel.get("_isComplete")?1:0;let children;switch(viewType){case"page":{children=contentObjectModel.getAllDescendantModels().filter((model=>model.get("_isAvailable")&&!model.get("_isOptional")));const availableChildren=this.filterAvailableChildren(children);const components=this.getPageLevelProgressEnabledModels(availableChildren);const nonAssessmentComponents=this.getNonAssessmentComponents(components);completion.nonAssessmentTotal+=nonAssessmentComponents.length;completion.nonAssessmentCompleted+=this.getComponentsCompleted(nonAssessmentComponents).length;const assessmentComponents=this.getAssessmentComponents(components);completion.assessmentTotal+=assessmentComponents.length;completion.assessmentCompleted+=this.getComponentsInteractionCompleted(assessmentComponents).length;if(contentObjectModel.get("_pageLevelProgress")?._excludeAssessments!==true){completion.subProgressCompleted+=contentObjectModel.get("_subProgressComplete")||0;completion.subProgressTotal+=contentObjectModel.get("_subProgressTotal")||0}const showPageCompletionCourse=Adapt$1.course.get("_pageLevelProgress")?._showPageCompletion!==false;const showPageCompletionPage=contentObjectModel.get("_pageLevelProgress")?._showPageCompletion!==false;if(showPageCompletionCourse&&showPageCompletionPage){completion.nonAssessmentCompleted+=isComplete;completion.nonAssessmentTotal+=1}break}case"menu":case"course":{children=contentObjectModel.getChildren().models;children.forEach(perform);break}}};completion.subProgressCompleted=0;completion.subProgressTotal=0;completion.nonAssessmentTotal=0;completion.nonAssessmentCompleted=0;completion.assessmentTotal=0;completion.assessmentCompleted=0;perform(contentObjectModel);if(setGlobal)Object.assign(Adapt$1.completion,completion);return completion}getNonAssessmentComponents(models){return models.filter((model=>!model.get("_isPartOfAssessment")))}getAssessmentComponents(models){return models.filter((model=>model.get("_isPartOfAssessment")))}getComponentsCompleted(models){return models.filter((item=>item.get("_isComplete")))}getComponentsInteractionCompleted(models){return models.filter((item=>item.get("_isComplete")))}getPageLevelProgressEnabledModels(models){return models.filter((model=>{const config=model.get("_pageLevelProgress");return config?._isEnabled}))}unavailableInHierarchy(parents){if(!parents)return;return parents.some((parent=>!parent.get("_isAvailable")))}filterAvailableChildren(children){const availableChildren=[];for(let i=0,count=children.length;i<count;i++){const parents=children[i].getAncestorModels();if(this.unavailableInHierarchy(parents))continue;availableChildren.push(children[i])}return availableChildren}calculatePercentageComplete(model,setGlobal=false){const completionObject=this.calculateCompletion(model,setGlobal);const completed=completionObject.nonAssessmentCompleted+completionObject.assessmentCompleted+completionObject.subProgressCompleted;const total=completionObject.nonAssessmentTotal+completionObject.assessmentTotal+completionObject.subProgressTotal;const percentageComplete=Math.floor(completed/total*100);return percentageComplete}}var completionCalculations=__AMD("extensions/adapt-contrib-pageLevelProgress/js/completionCalculations",Adapt$1.completion=new Completion);var PageLevelProgressView=__AMD("extensions/adapt-contrib-pageLevelProgress/js/PageLevelProgressView",class PageLevelProgressView extends Backbone.View{className(){const config=Adapt$1.course.get("_pageLevelProgress");return["pagelevelprogress",config._showAtCourseLevel===true&&"is-course-level"].filter(Boolean).join(" ")}events(){return{"click .js-pagelevelprogress-item-click":"scrollToPageElement"}}initialize(){this.listenTo(Adapt$1,"remove",this.remove);this.render()}async scrollToPageElement(event){if(event&&event.preventDefault)event.preventDefault();const $target=$(event.currentTarget);if($target.is(".is-disabled"))return;const id=$target.attr("data-pagelevelprogress-id");const model=data$1.findById(id);const isNavigateToContentObject=model.isTypeGroup("contentobject");if(isNavigateToContentObject){router$1.navigateToElement(id,{duration:400});Adapt$1.trigger("drawer:closeDrawer");return}if(!model.get("_isRendered")){try{await Adapt$1.parentView.renderTo(id)}catch(err){return}}const currentComponentSelector=`.${id}`;Adapt$1.once("drawer:closed",(()=>{router$1.navigateToElement(currentComponentSelector,{duration:400})})).trigger("drawer:closeDrawer",$(currentComponentSelector))}render(){const Component=templates.pageLevelProgress;ReactDOM__default["default"].render(React__default["default"].createElement(Component,{_items:Array.isArray(this.collection)&&this.collection,_item:!Array.isArray(this.collection)&&this.collection,_globals:Adapt$1.course.get("_globals")}),this.el)}});class PageLevelProgressIndicatorView extends Backbone.View{tagName(){return"span"}initialize(options){options=options||{};this.parent=options.parent;this.calculatePercentage=options.calculatePercentage||this.calculatePercentage;this.ariaLabel=options.ariaLabel||"";this.type=options.type||this.model.get("_type");this.addClasses();this.setUpEventListeners();this.setPercentageComplete();this.render();this.refresh()}addClasses(){this.$el.addClass(["pagelevelprogress__indicator","is-"+this.type].join(" "))}checkAria(){if(!this.ariaLabel){this.$el.attr("aria-hidden",true);return}const data=this.getRenderData();this.$(".js-indicator-aria-label").html(Handlebars.compile(this.ariaLabel)(data))}setUpEventListeners(){if(this.parent){this.listenToOnce(this.parent,"postRemove",this.remove)}else{this.listenTo(Adapt$1,"remove",this.remove)}this.listenTo(Adapt$1.course,"bubble:change:_isComplete bubble:change:_isVisited",this.refresh)}setPercentageComplete(){const percentage=this.calculatePercentage();this.model.set("percentageComplete",percentage);return percentage}calculatePercentage(){const isPresentationComponentWithItems=!this.model.isTypeGroup("question")&&this.model instanceof ItemsComponentModel;if(isPresentationComponentWithItems){const children=this.model.getChildren();const visited=children.filter((child=>child.get("_isVisited")));return Math.round(visited.length/children.length*100)}return this.model.get("_isComplete")?100:0}render(){const data=this.getRenderData();const template=Handlebars.templates[this.constructor.template];this.$el.html(template(data))}getRenderData(){const data=this.model.toJSON();data.ariaLabel=this.ariaLabel;data.type=this.type;return data}refresh(){this.checkCompletion();this.checkAria();this.$(".js-indicator-bar").css({width:this.calculatePercentage()+"%"})}checkCompletion(){const percentage=this.setPercentageComplete();this.$el.toggleClass("is-complete",percentage===100).toggleClass("is-incomplete",percentage!==100)}}PageLevelProgressIndicatorView.template="pageLevelProgressIndicator";var PageLevelProgressIndicatorView$1=__AMD("extensions/adapt-contrib-pageLevelProgress/js/PageLevelProgressIndicatorView",PageLevelProgressIndicatorView);var getPageLevelProgressItems=__AMD("extensions/adapt-contrib-pageLevelProgress/js/getPageLevelProgressItems",(function getPageLevelProgressItemsJSON(parentModel){const{_showAtCourseLevel:_showAtCourseLevel}=Adapt$1.course.get("_pageLevelProgress");const isInAPage=parentModel.isTypeGroup("page");function addChildren(model){const allDescendants=model.getAllDescendantModels(true);const currentPageItems=allDescendants.filter((descendant=>{const isDescendantContentObject=descendant.isTypeGroup("contentobject");const isDescendantCurrentPage=model===parentModel;if(!isInAPage&&!isDescendantContentObject)return false;if(isInAPage&&!isDescendantCurrentPage&&!isDescendantContentObject)return false;const descendantParentModel=descendant.getParent();const isChildOfModel=descendantParentModel===model;if(isDescendantContentObject&&!isChildOfModel)return false;return descendant.get("_isAvailable")===true}));const availableItems=completionCalculations.filterAvailableChildren(currentPageItems);const enabledProgressItems=completionCalculations.getPageLevelProgressEnabledModels(availableItems);const modelPLP=model.get("_pageLevelProgress");if(modelPLP?.title){model.set("altTitle",modelPLP.title)}if(!enabledProgressItems.length){return{...model.toJSON(),_children:null}}const _children=enabledProgressItems.map((model=>addChildren(model)));return{...model.toJSON(),_children:_children}}const jsonOutput=_showAtCourseLevel?addChildren(Adapt$1.course):addChildren(parentModel)._children;return jsonOutput}));var PageLevelProgressNavigationView=__AMD("extensions/adapt-contrib-pageLevelProgress/js/PageLevelProgressNavigationView",class PageLevelProgressNavigationView extends NavigationButtonView{events(){return{click:"onProgressClicked"}}attributes(){const attributes=this.model.toJSON();return{name:attributes._id,role:attributes._role==="button"?undefined:attributes._role,"data-order":attributes._order,"data-tooltip-id":"pagelevelprogress","aria-expanded":false}}static get template(){return"pageLevelProgressNavigationButton.jsx"}initialize(options){super.initialize(options);this.pageModel=options.pageModel;_.bindAll(this,"updateProgressBar");this.refreshProgressBar=_.debounce(this.refreshProgressBar.bind(this),16);this.setUpEventListeners();this.render();this.addIndicator();this.deferredUpdate();tooltips$1.register({_id:"pagelevelprogress",...Adapt$1.course.get("_globals")?._extensions?._pageLevelProgress?._navTooltip||{}})}setUpEventListeners(){this.listenTo(Adapt$1,{remove:this.remove,"router:location":this.updateProgressBar,"view:childAdded pageLevelProgress:update":this.refreshProgressBar,"drawer:closed":this.drawerClosed});this.listenTo(data$1,"change:_isLocked change:_isComplete",this.refreshProgressBar)}addIndicator(){this.indicatorView=new PageLevelProgressIndicatorView$1({model:this.pageModel,calculatePercentage:this._getPageCompletionPercentage.bind(this),ariaLabel:this.model.get("ariaLabel")});const $wrapper=this.$el.find(".pagelevelprogress__indicator-wrapper");$wrapper.prepend(this.indicatorView.$el)}_getPageCompletionPercentage(){return completionCalculations.calculatePercentageComplete(this.pageModel,true)}deferredUpdate(){_.defer(this.updateProgressBar)}updateProgressBar(){this.indicatorView.refresh()}refreshProgressBar(){this.collection=getPageLevelProgressItems(this.pageModel);this.updateProgressBar()}drawerClosed(){this.$el.attr("aria-expanded",false)}onProgressClicked(event){if(event&&event.preventDefault)event.preventDefault();this.$el.attr("aria-expanded",true);drawer.openCustomView(new PageLevelProgressView({collection:this.collection}).$el,false,this.model.get("_drawerPosition"))}remove(){super.remove()}});class PageLevelProgress extends Backbone.Controller{initialize(){this.listenTo(Adapt$1,{"app:dataReady":this.onDataReady,"app:languageChanged":this.onLanguageChange})}static get globalsConfig(){return Adapt$1.course.get("_globals")?._extensions?._pageLevelProgress}static get courseConfig(){return Adapt$1.course.get("_pageLevelProgress")}onDataReady(){const coursePLPConfig=PageLevelProgress.courseConfig;if(!coursePLPConfig?._isEnabled)return;this.setUpEventListeners()}onLanguageChange(){this.stopListening();this.initialize()}setUpEventListeners(){const headerIndicatorTypes=["menu","menuItem","page","article","block","component"];const headerIndicatorEventNames=headerIndicatorTypes.concat([""]).join("View:render ");this.listenTo(Adapt$1,headerIndicatorEventNames,this.renderHeaderIndicatorView);this.listenTo(Adapt$1,{"menuItemView:postRender":this.renderMenuItemIndicatorView,"router:contentObject":this.renderNavigationView});this.listenTo(Adapt$1.course,"bubble:change:_isComplete bubble:change:_isVisited",this.onCompletionChange)}onCompletionChange(event){if(!location$1._currentId)return;const currentModel=data$1.findById(location$1._currentId);const completionState={currentLocation:completionCalculations.calculatePercentageComplete(currentModel),course:completionCalculations.calculatePercentageComplete(Adapt$1.course)};const hasChanged=!_.isMatch(this._previousCompletionState,completionState);if(!hasChanged)return;this._previousCompletionState=completionState;Adapt$1.trigger("pageLevelProgress:percentageCompleteChange",completionState)}renderHeaderIndicatorView(view){const model=view.model;const config=model.get("_pageLevelProgress");if(!config?._isEnabled||!config?._isCompletionIndicatorEnabled)return;const pageModel=model.findAncestor("contentobject");const pageConfig=pageModel&&pageModel.get("_pageLevelProgress");if(!pageConfig?._isEnabled)return;const $headings=view.$(".js-heading");$headings.each(((index,el)=>{const $el=$(el);const indicatorView=new PageLevelProgressIndicatorView$1({parent:view,model:model});const isBackwardCompatible=[...$el[0].classList].every((name=>!name.includes("-inner")));if(isBackwardCompatible){indicatorView.$el.insertAfter($el);return}indicatorView.$el.insertBefore($el)}))}renderMenuItemIndicatorView(view){if(view.model.get("_id")===location$1._currentId)return;const viewType=view.model.get("_type");if(viewType==="course")return;const pageLevelProgress=view.model.get("_pageLevelProgress");if(!pageLevelProgress?._isEnabled)return;view.$el.find(".js-menu-item-progress").append(new PageLevelProgressIndicatorView$1({parent:view,model:view.model,type:"menu-item",calculatePercentage:this._getMenuItemCompletionPercentage.bind(view),ariaLabel:PageLevelProgress.globalsConfig?.pageLevelProgressMenuBar}).$el)}_getMenuItemCompletionPercentage(){return completionCalculations.calculatePercentageComplete(this.model)}renderNavigationView(pageModel){const navigationConfig=Adapt$1.course.get("_navigation");if(navigationConfig?._isDefaultNavigationDisabled)return;const coursePLPConfig=PageLevelProgress.courseConfig;if(coursePLPConfig?._isShownInNavigationBar===false)return;const pagePLPConfig=pageModel.get("_pageLevelProgress");if(!pagePLPConfig?._isEnabled)return;const viewType=pageModel.get("_type");if(viewType==="course"&&coursePLPConfig._showAtCourseLevel!==true)return;const collection=getPageLevelProgressItems(pageModel);if(!collection)return;const{_navOrder:_navOrder=0,_showLabel:_showLabel=true,navLabel:navLabel="",pageLevelProgressIndicatorBar:pageLevelProgressIndicatorBar="",_drawerPosition:_drawerPosition="auto"}=PageLevelProgress.globalsConfig??{};const model=new NavigationButtonModel({_id:"pagelevelprogress",_order:_navOrder,_showLabel:_showLabel,_classes:"nav__pagelevelprogress-btn pagelevelprogress__nav-btn",_iconClasses:"",_role:"button",ariaLabel:pageLevelProgressIndicatorBar,text:navLabel,_drawerPosition:_drawerPosition});navigation.addButton(new PageLevelProgressNavigationView({model:model,pageModel:pageModel,collection:collection}))}}__AMD("extensions/adapt-contrib-pageLevelProgress/js/adapt-contrib-pageLevelProgress",Adapt$1.pageLevelProgress=new PageLevelProgress);const COMPLETION_STATE=ENUM(["UNKNOWN",["NOT ATTEMPTED","NOTATTEMPTED"],"NOT_ATTEMPTED","BROWSED","INCOMPLETE","COMPLETED"]);var COMPLETION_STATE$1=__AMD("extensions/adapt-contrib-spoor/js/enums/completionStateEnum",COMPLETION_STATE);const SUCCESS_STATUS=ENUM(["UNKNOWN","PASSED","FAILED"]);var SUCCESS_STATE=__AMD("extensions/adapt-contrib-spoor/js/enums/successStateEnum",SUCCESS_STATUS);class Logger{constructor(){this.logArr=[];this.registeredViews=[]}static getInstance(){if(Logger.instance===null){Logger.instance=new Logger}return Logger.instance}getEntries(){return this.logArr}getLastEntry(){return this.logArr[this.logArr.length-1]}info(str){this.logArr[this.logArr.length]={str:str,type:Logger.LOG_TYPE_INFO,time:Date.now()};this.updateViews()}warn(str){this.logArr[this.logArr.length]={str:str,type:Logger.LOG_TYPE_WARN,time:Date.now()};this.updateViews()}error(str){this.logArr[this.logArr.length]={str:str,type:Logger.LOG_TYPE_ERROR,time:Date.now()};this.updateViews()}debug(str){this.logArr[this.logArr.length]={str:str,type:Logger.LOG_TYPE_DEBUG,time:Date.now()};this.updateViews()}registerView(_view){this.registeredViews[this.registeredViews.length]=_view}unregisterView(_view){for(let i=0,l=this.registeredViews.length;i<l;i++){if(this.registeredViews[i]!==_view)continue;this.registeredViews.splice(i,1);i--}}updateViews(){for(let i=0,l=this.registeredViews.length;i<l;i++){if(!this.registeredViews[i])continue;this.registeredViews[i].update(this)}}}Logger.instance=null;Logger.LOG_TYPE_INFO=0;Logger.LOG_TYPE_WARN=1;Logger.LOG_TYPE_ERROR=2;Logger.LOG_TYPE_DEBUG=3;var Logger$1=__AMD("extensions/adapt-contrib-spoor/js/scorm/logger",window.Logger=Logger);class ScormError{constructor(name,data={}){this.name=name;this.data=data}}ScormError.CLIENT_COULD_NOT_CONNECT="CLIENT_COULD_NOT_CONNECT";ScormError.SERVER_STATUS_UNSUPPORTED="SERVER_STATUS_UNSUPPORTED";ScormError.CLIENT_STATUS_UNSUPPORTED="CLIENT_STATUS_UNSUPPORTED";ScormError.CLIENT_COULD_NOT_COMMIT="CLIENT_COULD_NOT_COMMIT";ScormError.CLIENT_NOT_CONNECTED="CLIENT_NOT_CONNECTED";ScormError.CLIENT_COULD_NOT_FINISH="CLIENT_COULD_NOT_FINISH";ScormError.CLIENT_COULD_NOT_GET_PROPERTY="CLIENT_COULD_NOT_GET_PROPERTY";ScormError.CLIENT_COULD_NOT_SET_PROPERTY="CLIENT_COULD_NOT_SET_PROPERTY";ScormError.CLIENT_INVALID_CHOICE_VALUE="CLIENT_INVALID_CHOICE_VALUE";ScormError.defaultMessages={title:"An error has occurred",pressOk:"Press 'OK' to view detailed debug information to send to technical support.",CLIENT_COULD_NOT_CONNECT:"The course could not connect to the Learning Management System",SERVER_STATUS_UNSUPPORTED:"An invalid lesson status of '{{{status}}}' was received from Learning Management System",CLIENT_STATUS_UNSUPPORTED:"The status '{{{status}}}' is not supported.",CLIENT_COULD_NOT_COMMIT:"There was a problem saving data to the Learning Management System\n\nError: {{errorCode}} - {{{errorInfo}}}\nLMS Error Info: {{{diagnosticInfo}}}",CLIENT_NOT_CONNECTED:"The course is not connected to the Learning Management System",CLIENT_COULD_NOT_FINISH:"The course was unable to terminate the learning session\n\nError: {{errorCode}} - {{{errorInfo}}}\nLMS Error Info: {{{diagnosticInfo}}}",CLIENT_COULD_NOT_GET_PROPERTY:"Unable to get the value of {{property}} from the Learning Management System\n\nError: {{errorCode}} - {{{errorInfo}}}\nLMS Error Info: {{{diagnosticInfo}}}",CLIENT_COULD_NOT_SET_PROPERTY:"Unable to set {{property}} to: '{{{value}}}'\n\nError: {{errorCode}} - {{{errorInfo}}}\nLMS Error Info: {{{diagnosticInfo}}}",CLIENT_INVALID_CHOICE_VALUE:"Numeric choice/matching response elements must use a value from 0 to 35 in SCORM 1.2"};var ScormError$1=__AMD("extensions/adapt-contrib-spoor/js/scorm/error",ScormError);var Connection=__AMD("extensions/adapt-contrib-spoor/js/scorm/Connection",class Connection{constructor({_isEnabled:_isEnabled=true,_silentRetryLimit:_silentRetryLimit=2,_silentRetryDelay:_silentRetryDelay=1e3,_testOnSetValue:_testOnSetValue=true}={},ScormWrapper){this.test=this.test.bind(this);this._isEnabled=_isEnabled;this._isInProgress=false;this._isSilentDisconnection=false;this._isDisconnected=false;this._silentRetryLimit=_silentRetryLimit;this._silentRetryDelay=_silentRetryDelay;this._silentRetryTimeout=null;this._silentRetryCount=0;this._testOnSetValue=_testOnSetValue;this._scorm=ScormWrapper}async test(){if(!this._isEnabled||this._isInProgress)return;this._isInProgress=true;try{const response=await fetch(`connection.txt?nocache=${Date.now()}`);if(response?.ok)return this.onConnectionSuccess()}catch(err){}this.onConnectionError()}async testOnSetValue(){if(!this._isEnabled||!this._testOnSetValue)return;return this.test()}reset(){this._silentRetryCount=0;this._isSilentDisconnection=false;if(this._silentRetryTimeout===null)return;window.clearTimeout(this._silentRetryTimeout);this._silentRetryTimeout=null}stop(){this.reset();this._isEnabled=false}onConnectionSuccess(){if(this._isDisconnected){this._scorm.commit();if(!this._isSilentDisconnection)Adapt$1.trigger("tracking:connectionSuccess")}this._isInProgress=false;this._isDisconnected=false;this.reset()}onConnectionError(){if(!this._isEnabled)return;this._isInProgress=false;this._isDisconnected=true;if(this._silentRetryCount<this._silentRetryLimit){this._isSilentDisconnection=true;this._silentRetryCount++;this._silentRetryTimeout=window.setTimeout(this.test,this._silentRetryDelay);return}this.reset();this._scorm.handleConnectionError(this.test)}});const{CLIENT_COULD_NOT_CONNECT:CLIENT_COULD_NOT_CONNECT,SERVER_STATUS_UNSUPPORTED:SERVER_STATUS_UNSUPPORTED,CLIENT_STATUS_UNSUPPORTED:CLIENT_STATUS_UNSUPPORTED,CLIENT_COULD_NOT_COMMIT:CLIENT_COULD_NOT_COMMIT,CLIENT_NOT_CONNECTED:CLIENT_NOT_CONNECTED,CLIENT_COULD_NOT_FINISH:CLIENT_COULD_NOT_FINISH,CLIENT_COULD_NOT_GET_PROPERTY:CLIENT_COULD_NOT_GET_PROPERTY,CLIENT_COULD_NOT_SET_PROPERTY:CLIENT_COULD_NOT_SET_PROPERTY,CLIENT_INVALID_CHOICE_VALUE:CLIENT_INVALID_CHOICE_VALUE}=ScormError$1;class ScormWrapper{constructor(){this.setCompletedWhenFailed=true;this.commitOnStatusChange=true;this.commitOnAnyChange=false;this.timedCommitFrequency=10;this.maxCommitRetries=5;this.commitRetryDelay=1e3;this.commitRetryPending=false;this.commitRetries=0;this.lastCommitSuccessTime=null;this.exitStateIfIncomplete="auto";this.exitStateIfComplete="auto";this.timedCommitIntervalID=null;this.retryCommitTimeoutID=null;this.logOutputWin=null;this.startTime=null;this.endTime=null;this.lmsConnected=false;this.finishCalled=false;this.logger=Logger$1.getInstance();this.scorm=pipwerks__default["default"].SCORM;this.maxCharLimitOverride=null;this.scorm.handleExitMode=false;this.suppressErrors=false;this.commit=this.commit.bind(this);this.doRetryCommit=this.doRetryCommit.bind(this);this.debouncedCommit=_.debounce(this.commit,100);if(window.__debug)this.showDebugWindow();this._connection=null;if(!(window.API?.__offlineAPIWrapper&&window?.API_1484_11?.__offlineAPIWrapper))return;this.logger.error("Offline SCORM API is being used. No data will be reported to the LMS!")}static getInstance(){if(ScormWrapper.instance===null){ScormWrapper.instance=new ScormWrapper}return ScormWrapper.instance}getVersion(){return this.scorm.version}setVersion(value){this.logger.debug(`ScormWrapper::setVersion: ${value}`);this.scorm.version=value}initialize(settings){if(settings){if(settings._showDebugWindow){this.showDebugWindow()}this.setVersion(settings._scormVersion||"1.2");if(_.isBoolean(settings._suppressErrors)){this.suppressErrors=settings._suppressErrors}if(_.isBoolean(settings._commitOnStatusChange)){this.commitOnStatusChange=settings._commitOnStatusChange}if(_.isBoolean(settings._commitOnAnyChange)){this.commitOnAnyChange=settings._commitOnAnyChange}if(_.isFinite(settings._timedCommitFrequency)){this.timedCommitFrequency=settings._timedCommitFrequency}if(_.isFinite(settings._maxCommitRetries)){this.maxCommitRetries=settings._maxCommitRetries}if(_.isFinite(settings._commitRetryDelay)){this.commitRetryDelay=settings._commitRetryDelay}if("_exitStateIfIncomplete"in settings){this.exitStateIfIncomplete=settings._exitStateIfIncomplete}if("_exitStateIfComplete"in settings){this.exitStateIfComplete=settings._exitStateIfComplete}if(_.isBoolean(settings._setCompletedWhenFailed)){this.setCompletedWhenFailed=settings._setCompletedWhenFailed}if(!_.isNaN(settings._maxCharLimitOverride)&&settings._maxCharLimitOverride>0){this.maxCharLimitOverride=settings._maxCharLimitOverride}}this.logger.debug("ScormWrapper::initialize");this.lmsConnected=this.scorm.init();if(!this.lmsConnected){this.handleInitializeError();return this.lmsConnected}if(settings?._connectionTest?._isEnabled!==false){this._connection=new Connection(settings?._connectionTest,this)}this.startTime=new Date;this.initTimedCommit();return this.lmsConnected}isFirstSession(){return this.getValue(this.isSCORM2004()?"cmi.entry":"cmi.core.entry")==="ab-initio"}setIncomplete(){this.setValue(this.isSCORM2004()?"cmi.completion_status":"cmi.core.lesson_status",COMPLETION_STATE$1.INCOMPLETE.asLowerCase);if(this.commitOnStatusChange&&!this.commitOnAnyChange)this.commit()}setCompleted(){this.setValue(this.isSCORM2004()?"cmi.completion_status":"cmi.core.lesson_status",COMPLETION_STATE$1.COMPLETED.asLowerCase);if(this.commitOnStatusChange&&!this.commitOnAnyChange)this.commit()}setPassed(){if(this.isSCORM2004()){this.setValue("cmi.completion_status",COMPLETION_STATE$1.COMPLETED.asLowerCase);this.setValue("cmi.success_status",SUCCESS_STATE.PASSED.asLowerCase)}else{this.setValue("cmi.core.lesson_status",SUCCESS_STATE.PASSED.asLowerCase)}if(this.commitOnStatusChange&&!this.commitOnAnyChange)this.commit()}setFailed(){if(this.isSCORM2004()){this.setValue("cmi.success_status",SUCCESS_STATE.FAILED.asLowerCase);if(this.setCompletedWhenFailed)this.setValue("cmi.completion_status",COMPLETION_STATE$1.COMPLETED.asLowerCase)}else{this.setValue("cmi.core.lesson_status",SUCCESS_STATE.FAILED.asLowerCase)}if(this.commitOnStatusChange&&!this.commitOnAnyChange)this.commit()}getStatus(){const status=this.getValue(this.isSCORM2004()?"cmi.completion_status":"cmi.core.lesson_status");if(this.isValidCompletionStatus(status))return status;this.handleDataError(new ScormError$1(SERVER_STATUS_UNSUPPORTED,{status:status}));return null}setStatus(status){switch(status.toLowerCase()){case COMPLETION_STATE$1.INCOMPLETE.asLowerCase:this.setIncomplete();break;case COMPLETION_STATE$1.COMPLETED.asLowerCase:this.setCompleted();break;case SUCCESS_STATE.PASSED.asLowerCase:this.setPassed();break;case SUCCESS_STATE.FAILED.asLowerCase:this.setFailed();break;default:this.handleDataError(new ScormError$1(CLIENT_STATUS_UNSUPPORTED,{status:status}))}}getScore(){return this.getValue(this.isSCORM2004()?"cmi.score.raw":"cmi.core.score.raw")}setScore(score,minScore=0,maxScore=100,isPercentageBased=true){const cmiPrefix=this.isSCORM2004()?"cmi":"cmi.core";this.recordScore(cmiPrefix,...arguments)}getLessonLocation(){return this.getValue(this.isSCORM2004()?"cmi.location":"cmi.core.lesson_location")}setLessonLocation(location){this.setValue(this.isSCORM2004()?"cmi.location":"cmi.core.lesson_location",location)}getSuspendData(){return this.getValue("cmi.suspend_data")}setSuspendData(data){this.setValue("cmi.suspend_data",data)}getStudentName(){return this.getValue(this.isSCORM2004()?"cmi.learner_name":"cmi.core.student_name")}getStudentId(){return this.getValue(this.isSCORM2004()?"cmi.learner_id":"cmi.core.student_id")}setLanguage(lang){if(this.isSCORM2004()){this.setValue("cmi.learner_preference.language",lang);return}this.setValueIfChildSupported("cmi.student_preference.language",lang)}commit(){this.logger.debug("ScormWrapper::commit");if(!this.lmsConnected){this.handleConnectionError();return}if(this.commitRetryPending){this.logger.debug("ScormWrapper::commit: skipping this commit call as one is already pending.");return}if(this.scorm.save()){this.commitRetries=0;this.lastCommitSuccessTime=new Date;if(this._connection)this._connection.test();Adapt$1.trigger("spoor:commit",this);return}if(this.commitRetries<this.maxCommitRetries&&!this.finishCalled){this.commitRetries++;this.initRetryCommit();return}const errorCode=this.scorm.debug.getCode();this.handleDataError(new ScormError$1(CLIENT_COULD_NOT_COMMIT,{errorCode:errorCode,errorInfo:this.scorm.debug.getInfo(errorCode),diagnosticInfo:this.scorm.debug.getDiagnosticInfo(errorCode)}))}finish(){this.logger.debug("ScormWrapper::finish");if(!this.lmsConnected||this.finishCalled){this.handleConnectionError();return}this.finishCalled=true;if(this.timedCommitIntervalID!==null){window.clearInterval(this.timedCommitIntervalID)}if(this.commitRetryPending){window.clearTimeout(this.retryCommitTimeoutID);this.commitRetryPending=false}if(this.logOutputWin&&!this.logOutputWin.closed){this.logOutputWin.close()}this.endTime=new Date;if(this.isSCORM2004()){this.scorm.set("cmi.session_time",this.convertToSCORM2004Time(this.endTime.getTime()-this.startTime.getTime()));this.scorm.set("cmi.exit",this.getExitState())}else{this.scorm.set("cmi.core.session_time",this.convertToSCORM12Time(this.endTime.getTime()-this.startTime.getTime()));this.scorm.set("cmi.core.exit",this.getExitState())}if(this._connection){this._connection.stop();this._connection=null}this.lmsConnected=false;if(this.scorm.quit())return;const errorCode=this.scorm.debug.getCode();this.handleFinishError(new ScormError$1(CLIENT_COULD_NOT_FINISH,{errorCode:errorCode,errorInfo:this.scorm.debug.getInfo(errorCode),diagnosticInfo:this.scorm.debug.getDiagnosticInfo(errorCode)}))}recordInteraction(id,response,correct,latency,type){if(!this.isChildSupported("cmi.interactions.n.id")||!this.isSupported("cmi.interactions._count"))return;switch(type){case"choice":this.recordInteractionMultipleChoice(...arguments);break;case"matching":this.recordInteractionMatching(...arguments);break;case"numeric":this.isSCORM2004()?this.recordInteractionScorm2004(...arguments):this.recordInteractionScorm12(...arguments);break;case"fill-in":this.recordInteractionFillIn(...arguments);break;default:console.error(`ScormWrapper.recordInteraction: unknown interaction type of '${type}' encountered...`)}}getValue(property){this.logger.debug(`ScormWrapper::getValue: _property=${property}`);if(this.finishCalled){this.logger.debug("ScormWrapper::getValue: ignoring request as 'finish' has been called");return}if(!this.lmsConnected){this.handleConnectionError();return}const value=this.scorm.get(property);const errorCode=this.scorm.debug.getCode();switch(errorCode){case 0:break;case 403:this.logger.warn("ScormWrapper::getValue: data model element not initialized");break;default:this.handleDataError(new ScormError$1(CLIENT_COULD_NOT_GET_PROPERTY,{property:property,errorCode:errorCode,errorInfo:this.scorm.debug.getInfo(errorCode),diagnosticInfo:this.scorm.debug.getDiagnosticInfo(errorCode)}))}this.logger.debug(`ScormWrapper::getValue: returning ${value}`);return value+""}setValue(property,value){this.logger.debug(`ScormWrapper::setValue: _property=${property} _value=${value}`);if(this.finishCalled){this.logger.debug("ScormWrapper::setValue: ignoring request as 'finish' has been called");return}if(!this.lmsConnected){this.handleConnectionError();return}const success=this.scorm.set(property,value);if(success){this._connection?.testOnSetValue()}else{const errorCode=this.scorm.debug.getCode();if(errorCode!==0){this.handleDataError(new ScormError$1(CLIENT_COULD_NOT_SET_PROPERTY,{property:property,value:value,errorCode:errorCode,errorInfo:this.scorm.debug.getInfo(errorCode),diagnosticInfo:this.scorm.debug.getDiagnosticInfo(errorCode)}));return success}this.logger.warn("ScormWrapper::setValue: LMS reported that the 'set' call failed but then said there was no error!")}if(this.commitOnAnyChange)this.debouncedCommit();return success}setValueIfChildSupported(property,value){if(!this.isChildSupported(property))return;this.setValue(property,value)}isSupported(property){this.logger.debug(`ScormWrapper::isSupported: _property=${property}`);if(this.finishCalled){this.logger.debug("ScormWrapper::isSupported: ignoring request as 'finish' has been called");return}if(!this.lmsConnected){this.handleConnectionError();return false}this.scorm.get(property);const isSupported=!this.isUnsupportedLastError();if(!isSupported)this.logUnsupported(property);return isSupported}isChildSupported(property){if(property.includes("_children"))return this.isSupported(property);this.logger.debug(`ScormWrapper::isChildSupported: _property=${property}`);if(this.finishCalled){this.logger.debug("ScormWrapper::isChildSupported: ignoring request as 'finish' has been called");return}if(!this.lmsConnected){this.handleConnectionError();return false}const paths=property.split(".");const element=paths.pop();if(/^\d+$|^n$/.test(paths[paths.length-1]))paths.pop();const parentPath=paths.join(".");const children=this.scorm.get(`${parentPath}._children`);const isSupported=!this.isUnsupportedLastError()&&children.includes(element);if(!isSupported)this.logUnsupported(property);return isSupported}isUnsupportedErrorCode(code){return code===401}isUnsupportedLastError(){return this.isUnsupportedErrorCode(this.scorm.debug.getCode())}logUnsupported(property){property=property.replace(/\d+/g,"n");this.logger.info(`ScormWrapper::${property} not supported by this LMS...`)}initTimedCommit(){this.logger.debug("ScormWrapper::initTimedCommit");if(!this.commitOnAnyChange&&this.timedCommitFrequency>0){const delay=this.timedCommitFrequency*(60*1e3);this.timedCommitIntervalID=window.setInterval(this.commit,delay)}}initRetryCommit(){this.logger.debug(`ScormWrapper::initRetryCommit ${this.commitRetries} out of ${this.maxCommitRetries}`);this.commitRetryPending=true;this.retryCommitTimeoutID=window.setTimeout(this.doRetryCommit,this.commitRetryDelay)}doRetryCommit(){this.logger.debug("ScormWrapper::doRetryCommit");this.commitRetryPending=false;this.commit()}async handleInitializeError(){if(!data$1.isReady)await data$1.whenReady();Adapt$1.trigger("tracking:initializeError");this.handleError(new ScormError$1(CLIENT_COULD_NOT_CONNECT))}async handleConnectionError(callback=null){if(!data$1.isReady)await data$1.whenReady();Adapt$1.trigger("tracking:connectionError",callback);this.handleError(new ScormError$1(CLIENT_NOT_CONNECTED))}async handleDataError(error){if(!data$1.isReady)await data$1.whenReady();if(!this.isUnsupportedErrorCode(error.data.errorCode))Adapt$1.trigger("tracking:dataError");this.handleError(error)}async handleFinishError(error){if(!data$1.isReady)await data$1.whenReady();Adapt$1.trigger("tracking:terminationError");this.handleError(error)}async handleError(error){if(!data$1.isReady)await data$1.whenReady();if("value"in error.data){if(error.data.value.length&&error.data.value.length>80)error.data.value=error.data.value.slice(0,80)+"...";if(error.data.value==="")error.data.value="''"}const config=Adapt$1.course.get("_spoor");const messages=Object.assign({},ScormError$1.defaultMessages,config&&config._messages);const message=Handlebars.compile(messages[error.name])(error.data);this.logger.error(message);if(this.isUnsupportedErrorCode(error.data.errorCode))return;switch(error.name){case CLIENT_COULD_NOT_CONNECT:_.defer((()=>{if(!notify$1.isOpen){Wait$1.begin();router$1.hideLoading();notify$1.popup({_isCancellable:false,title:messages.title,body:message})}}))}if(!this.suppressErrors&&(!this.logOutputWin||this.logOutputWin.closed)&&confirm(`${messages.title}:\n\n${message}\n\n${messages.pressOk}`)){this.showDebugWindow()}}recordScore(cmiPrefix,score,minScore=0,maxScore=100,isPercentageBased=true){if(this.isSCORM2004()){const range=score<0?Math.abs(minScore):maxScore;const scaledScore=score/range;this.setValue(`${cmiPrefix}.score.scaled`,parseFloat(scaledScore.toFixed(7)))}else if(isPercentageBased){score=score<0?0:Math.round(score/maxScore*100);minScore=0;maxScore=100}else{const validate=(attribute,value)=>{const isValid=value>=0&&score<=100;if(!isValid)this.logger.warn(`${attribute} must be between 0-100.`)};validate(`${cmiPrefix}.score.raw`,score);validate(`${cmiPrefix}.score.min`,minScore);validate(`${cmiPrefix}.score.max`,maxScore)}this.setValue(`${cmiPrefix}.score.raw`,score);this.setValueIfChildSupported(`${cmiPrefix}.score.min`,minScore);this.setValueIfChildSupported(`${cmiPrefix}.score.max`,maxScore)}getInteractionCount(){const count=this.getValue("cmi.interactions._count");return count===""?0:count}recordInteractionScorm12(id,response,correct,latency,type){id=id.trim();const cmiPrefix=`cmi.interactions.${this.getInteractionCount()}`;this.setValue(`${cmiPrefix}.id`,id);this.setValueIfChildSupported(`${cmiPrefix}.type`,type);this.setValueIfChildSupported(`${cmiPrefix}.student_response`,response);this.setValueIfChildSupported(`${cmiPrefix}.result`,correct?"correct":"wrong");if(latency!==null&&latency!==undefined)this.setValueIfChildSupported(`${cmiPrefix}.latency`,this.convertToSCORM12Time(latency));this.setValueIfChildSupported(`${cmiPrefix}.time`,this.getCMITime())}recordInteractionScorm2004(id,response,correct,latency,type){id=id.trim();const cmiPrefix=`cmi.interactions.${this.getInteractionCount()}`;this.setValue(`${cmiPrefix}.id`,id);this.setValue(`${cmiPrefix}.type`,type);this.setValue(`${cmiPrefix}.learner_response`,response);this.setValue(`${cmiPrefix}.result`,correct?"correct":"incorrect");if(latency!==null&&latency!==undefined)this.setValue(`${cmiPrefix}.latency`,this.convertToSCORM2004Time(latency));this.setValue(`${cmiPrefix}.timestamp`,this.getISO8601Timestamp())}recordInteractionMultipleChoice(id,response,correct,latency,type){if(this.isSCORM2004()){response=response.replace(/,|#/g,"[,]")}else{response=response.replace(/#/g,",");response=this.checkResponse(response,"choice")}const scormRecordInteraction=this.isSCORM2004()?this.recordInteractionScorm2004:this.recordInteractionScorm12;scormRecordInteraction.call(this,id,response,correct,latency,type)}recordInteractionMatching(id,response,correct,latency,type){response=response.replace(/#/g,",");if(this.isSCORM2004()){response=response.replace(/,/g,"[,]").replace(/\./g,"[.]")}else{response=this.checkResponse(response,"matching")}const scormRecordInteraction=this.isSCORM2004()?this.recordInteractionScorm2004:this.recordInteractionScorm12;scormRecordInteraction.call(this,id,response,correct,latency,type)}recordInteractionFillIn(id,response,correct,latency,type){let maxLength=this.isSCORM2004()?250:255;maxLength=this.maxCharLimitOverride??maxLength;if(response.length>maxLength){response=response.substr(0,maxLength);this.logger.warn(`ScormWrapper::recordInteractionFillIn: response data for ${id} is longer than the maximum allowed length of ${maxLength} characters; data will be truncated to avoid an error.`)}const scormRecordInteraction=this.isSCORM2004()?this.recordInteractionScorm2004:this.recordInteractionScorm12;scormRecordInteraction.call(this,id,response,correct,latency,type)}getObjectiveCount(){const count=this.getValue("cmi.objectives._count");return count===""?0:count}hasObjectiveById(id){const count=this.getObjectiveCount();for(let i=0;i<count;i++){const storedId=this.getValue(`cmi.objectives.${i}.id`);if(storedId===id)return true}return false}getObjectiveIndexById(id){const count=this.getObjectiveCount();for(let i=0;i<count;i++){const storedId=this.getValue(`cmi.objectives.${i}.id`);if(storedId===id)return i}return count}recordObjectiveDescription(id,description){if(!this.isSCORM2004()||!description)return;id=id.trim();const hasObjective=this.hasObjectiveById(id);const index=this.getObjectiveIndexById(id);const cmiPrefix=`cmi.objectives.${index}`;if(!hasObjective)this.setValue(`${cmiPrefix}.id`,id);this.setValue(`${cmiPrefix}.description`,description)}recordObjectiveScore(id,score,minScore=0,maxScore=100,isPercentageBased=true){if(!this.isChildSupported("cmi.objectives.n.id")||!this.isSupported("cmi.objectives._count"))return;id=id.trim();const hasObjective=this.hasObjectiveById(id);const index=this.getObjectiveIndexById(id);const cmiPrefix=`cmi.objectives.${index}`;if(!hasObjective)this.setValue(`${cmiPrefix}.id`,id);this.recordScore(cmiPrefix,score,minScore,maxScore,isPercentageBased)}recordObjectiveStatus(id,completionStatus,successStatus=SUCCESS_STATE.UNKNOWN.asLowerCase){if(!this.isChildSupported("cmi.objectives.n.id")||!this.isSupported("cmi.objectives._count"))return;if(!this.isValidCompletionStatus(completionStatus)){this.handleDataError(new ScormError$1(CLIENT_STATUS_UNSUPPORTED,{completionStatus:completionStatus}));return}if(this.isSCORM2004()&&!this.isValidSuccessStatus(successStatus)){this.handleDataError(new ScormError$1(CLIENT_STATUS_UNSUPPORTED,{successStatus:successStatus}));return}id=id.trim();const hasObjective=this.hasObjectiveById(id);const index=this.getObjectiveIndexById(id);const cmiPrefix=`cmi.objectives.${index}`;if(!hasObjective)this.setValue(`${cmiPrefix}.id`,id);if(this.isSCORM2004()){this.setValue(`${cmiPrefix}.completion_status`,completionStatus);this.setValue(`${cmiPrefix}.success_status`,successStatus);return}if(!this.isChildSupported(`${cmiPrefix}.status`))return;if(completionStatus===COMPLETION_STATE$1.COMPLETED.asLowerCase&&successStatus!==SUCCESS_STATE.UNKNOWN.asLowerCase)completionStatus=successStatus;this.setValue(`${cmiPrefix}.status`,completionStatus)}isValidCompletionStatus(status){status=status.toLowerCase();if(this.isSCORM2004()){switch(status){case COMPLETION_STATE$1.UNKNOWN.asLowerCase:case COMPLETION_STATE$1.NOTATTEMPTED.asLowerCase:case COMPLETION_STATE$1.NOT_ATTEMPTED.asLowerCase:case COMPLETION_STATE$1.INCOMPLETE.asLowerCase:case COMPLETION_STATE$1.COMPLETED.asLowerCase:return true}}else{switch(status){case COMPLETION_STATE$1.NOTATTEMPTED.asLowerCase:case COMPLETION_STATE$1.BROWSED.asLowerCase:case COMPLETION_STATE$1.INCOMPLETE.asLowerCase:case COMPLETION_STATE$1.COMPLETED.asLowerCase:case SUCCESS_STATE.PASSED.asLowerCase:case SUCCESS_STATE.FAILED.asLowerCase:return true}}return false}isValidSuccessStatus(status){status=status.toLowerCase();if(this.isSCORM2004()){switch(status){case SUCCESS_STATE.UNKNOWN.asLowerCase:case SUCCESS_STATE.PASSED.asLowerCase:case SUCCESS_STATE.FAILED.asLowerCase:return true}}return false}showDebugWindow(){if(this.logOutputWin&&!this.logOutputWin.closed){this.logOutputWin.close()}this.logOutputWin=window.open("log_output.html","Log","width=600,height=300,status=no,scrollbars=yes,resizable=yes,menubar=yes,toolbar=yes,location=yes,top=0,left=0");if(!this.logOutputWin)return;this.logOutputWin.focus()}convertToSCORM12Time(msConvert){const msPerSec=1e3;const msPerMin=msPerSec*60;const msPerHour=msPerMin*60;const ms=msConvert%msPerSec;msConvert=msConvert-ms;let secs=msConvert%msPerMin;msConvert=msConvert-secs;secs=secs/msPerSec;let mins=msConvert%msPerHour;msConvert=msConvert-mins;mins=mins/msPerMin;const hrs=msConvert/msPerHour;if(hrs>9999){return"9999:99:99.99"}const str=[this.padWithZeroes(hrs,4),this.padWithZeroes(mins,2),this.padWithZeroes(secs,2)].join(":");return`${str}.${Math.floor(ms/10)}`}convertToSCORM2004Time(msConvert){let csConvert=Math.floor(msConvert/10);const csPerSec=100;const csPerMin=csPerSec*60;const csPerHour=csPerMin*60;const csPerDay=csPerHour*24;let days=Math.floor(csConvert/csPerDay);csConvert-=days*csPerDay;days=days?days+"D":"";let hours=Math.floor(csConvert/csPerHour);csConvert-=hours*csPerHour;hours=hours?hours+"H":"";let mins=Math.floor(csConvert/csPerMin);csConvert-=mins*csPerMin;mins=mins?mins+"M":"";let secs=Math.floor(csConvert/csPerSec);csConvert-=secs*csPerSec;secs=secs||"0";let cs=csConvert;cs=cs?"."+cs:"";const seconds=secs+cs+"S";const hms=[hours,mins,seconds].join("");return"P"+days+"T"+hms}getCMITime(){const date=new Date;const hours=this.padWithZeroes(date.getHours(),2);const min=this.padWithZeroes(date.getMinutes(),2);const sec=this.padWithZeroes(date.getSeconds(),2);return[hours,min,sec].join(":")}getISO8601Timestamp(){const date=(new Date).toISOString();return date.replace(/.\d\d\dZ/,"")}padWithZeroes(numToPad,padBy){let len=padBy;while(--len){numToPad="0"+numToPad}return numToPad.slice(-padBy)}isSCORM2004(){return this.scorm.version==="2004"}checkResponse(response,responseType){if(!response)return response;if(responseType!=="choice"&&responseType!=="matching")return response;response=response.split(/,|#/);const self=this;if(responseType==="choice"){response=response.map(checkIdentifier)}else{response=response.map((r=>{const identifiers=r.split(".");return checkIdentifier(identifiers[0])+"."+checkIdentifier(identifiers[1])}))}function checkIdentifier(r){if(r.length===1&&r>="0"&&r<="9")return r;if(r.length===1&&r>="a"&&r<="z")return r;const i=parseInt(r);if(isNaN(i)||i<10||i>35){self.handleError(new ScormError$1(CLIENT_INVALID_CHOICE_VALUE))}return Number(i).toString(36)}return response.join(",")}getExitState(){const completionStatus=this.scorm.data.completionStatus;const isIncomplete=completionStatus===COMPLETION_STATE$1.INCOMPLETE.asLowerCase||completionStatus===COMPLETION_STATE$1.UNKNOWN.asLowerCase;const exitState=isIncomplete?this.exitStateIfIncomplete:this.exitStateIfComplete;if(exitState!=="auto")return exitState;if(this.isSCORM2004())return isIncomplete?"suspend":"normal";return""}}ScormWrapper.instance=null;var ScormWrapper$1=__AMD("extensions/adapt-contrib-spoor/js/scorm/wrapper",ScormWrapper);const LZMAWorker=window.LZMAFactory("./libraries/lzma_worker-min.js");const ZeroString={};function makeZeroString(length){ZeroString[length]=ZeroString[length]||new Array(length+1).join("0");return ZeroString[length]}for(let i=1,l=64;i<=l;i++){makeZeroString(i)}function zeroPadRightToLength(string,length){const padLength=length-string.length;if(padLength>0){string+=makeZeroString(padLength)}return string}function zeroPadLeftToLength(string,length){const padLength=length-string.length;if(padLength>0){string=makeZeroString(padLength)+string}return string}function zeroPadRightToMultiple(string,multiple){const padLength=multiple-string.length%multiple;if(padLength!==multiple){string+=makeZeroString(padLength)}return string}function binaryToUnsignedInteger(binary,binaryLength){if(binaryLength===0){return 0}binary=zeroPadLeftToLength(binary,binaryLength);const integer=parseInt(binary.slice(0,binaryLength),2);return integer}function shiftUnsignedIntegerFromBinary(binary,binaryLength){if(binaryLength===0){return[0,binary]}binary=zeroPadLeftToLength(binary,binaryLength);const integer=parseInt(binary.slice(0,binaryLength),2);binary=binary.slice(binaryLength);return[integer,binary]}function shiftBinary(binary,binaryLength){if(binaryLength===0){return["",binary]}binary=zeroPadLeftToLength(binary,binaryLength);const shifted=binary.slice(0,binaryLength);binary=binary.slice(binaryLength);return[shifted,binary]}function unsignedIntegerToBinary(integer,binaryLength){if(binaryLength===0){return""}let binary=Math.abs(integer).toString(2);if(typeof binaryLength==="undefined"){return binary}const length=binary.length;if(length>binaryLength){throw new Error(`Integer too big for specified binary length. integer: ${integer} binarylen: ${binaryLength}`)}binary=zeroPadLeftToLength(binary,binaryLength);return binary}function byteArrayToString(array){const arrayLength=array.length;let string=new Array(arrayLength);for(let i=0,l=arrayLength;i<l;i++){string[i]=String.fromCharCode(array[i])}string=string.join("");return string}function stringToByteArray(string){const stringLength=string.length;const array=new Array(stringLength);for(let i=0,l=stringLength;i<l;i++){array[i]=string.charCodeAt(i)}return array}const BYTE_BIT_LENGTH=8;function binaryToBase64(binary){binary=___default["default"].flatten(binary).join("");binary=zeroPadRightToMultiple(binary,BYTE_BIT_LENGTH);const bytesCount=binary.length/BYTE_BIT_LENGTH;const charCodes=new Array(bytesCount);for(let i=0,l=bytesCount;i<l;i++){[charCodes[i],binary]=shiftUnsignedIntegerFromBinary(binary,BYTE_BIT_LENGTH)}let base64=btoa(byteArrayToString(charCodes));base64=base64.replace(/=/g,"");base64=base64.replace(/\+/g,"-");return base64}function base64ToBinary(base64){base64=base64.replace(/-/g,"+");const charCodes=stringToByteArray(atob(base64));const bytesCount=charCodes.length;let binary=new Array(bytesCount);for(let i=0,l=bytesCount;i<l;i++){binary[i]=unsignedIntegerToBinary(charCodes[i],BYTE_BIT_LENGTH)}binary=binary.join("");return binary}const logs={usedTypes:{},typeLengths:{},binarySamples:{}};class AbstractValueType{constructor(options){Object.assign(this,options);this.binaryTypeLength=this.binaryType.length}log(binary){const name=this.name;logs.usedTypes[name]=logs.usedTypes[name]||0;logs.usedTypes[name]++;logs.binarySamples[name]=logs.binarySamples[name]||[];logs.binarySamples[name].push(binary)}}class FixedIntegerType extends AbstractValueType{constructor(options){super(options);this.esType="number";if(!this.valueBinaryLength){return}this.minValue=options.minValue||0;this.maxValue=options.maxValue||Math.pow(2,this.valueBinaryLength)-1}valueToBinary(integer,logStats=null){let binary=unsignedIntegerToBinary(integer,this.valueBinaryLength);if(logStats){this.log(binary)}binary=[binary];return binary}shiftValueFromBinary(binary){let integer;[integer,binary]=shiftUnsignedIntegerFromBinary(binary,this.valueBinaryLength);return[integer,binary]}}class FixedBooleanType extends FixedIntegerType{constructor(options){options.valueBinaryLength=1;super(options);this.esType="boolean"}shiftValueFromBinary(binary){const bool=binary[0]==="1";binary=binary.slice(1);return[bool,binary]}}class LengthAndValueBinary{constructor(parent,name,bitSizes){this.parent=parent;this.name=name;this.bitSizes=bitSizes;this.maxValues=___default["default"].flatten(this.bitSizes).map((value=>Math.pow(2,value)-1));this.maxValue=this.maxValues[this.maxValues.length-1];this.sizeBinaryLength=unsignedIntegerToBinary(this.bitSizes.length-1).length}valueToBinary(integer,logStats=null){const parentName=this.parent.name;const sizeIndex=this.maxValues.findIndex((maxValue=>integer<=maxValue));if(sizeIndex===-1){throw new Error(`Value is too large for type: ${parentName} value: ${integer} max: ${this.maxValue}`)}const sizeBinary=unsignedIntegerToBinary(sizeIndex,this.sizeBinaryLength);const valueLength=this.bitSizes[sizeIndex];const name=this.name;if(logStats){logs.typeLengths[parentName]=logs.typeLengths[parentName]||{};logs.typeLengths[parentName][name]=logs.typeLengths[parentName][name]||{};logs.typeLengths[parentName][name][valueLength]=logs.typeLengths[parentName][name][valueLength]||0;logs.typeLengths[parentName][name][valueLength]++}const integerBinary=unsignedIntegerToBinary(integer,valueLength);const binary=[sizeBinary,integerBinary];return binary}shiftValueFromBinary(binary){let sizeBinary;[sizeBinary,binary]=shiftBinary(binary,this.sizeBinaryLength);const sizeIndex=binaryToUnsignedInteger(sizeBinary);const valueLength=this.bitSizes[sizeIndex];let integer;[integer,binary]=shiftUnsignedIntegerFromBinary(binary,valueLength);return[integer,binary]}}class VariableIntegerType extends FixedIntegerType{constructor(options){super(options);this.isNegative=this.minValue<0&&this.maxValue===0;this.integer=new LengthAndValueBinary(this,"integer",options.integerBitSizes)}valueToBinary(integer,logStats=null){integer=integer.toFixed(0);const binary=this.integer.valueToBinary(Math.abs(integer),logStats);if(logStats){this.log(binary)}return binary}shiftValueFromBinary(binary){let integer;[integer,binary]=this.integer.shiftValueFromBinary(binary);if(this.isNegative){integer=-integer}return[integer,binary]}}class VariableArrayType extends VariableIntegerType{constructor(options){super(options);this.esType="array"}valueToBinary(array,logStats=null){const arrayLength=array.length;const binary=super.valueToBinary(arrayLength);if(arrayLength){const valueType=findValueTypeFromValues(array);binary.push(valueType.binaryType);binary.type=valueType.name;binary.push(array.map((value=>valueType.valueToBinary(value,logStats))))}if(logStats){this.log(binary)}return binary}shiftValueFromBinary(binary){let arrayLength;[arrayLength,binary]=super.shiftValueFromBinary(binary);const value=new Array(arrayLength);if(arrayLength){let valueType;[valueType,binary]=shiftValueTypeFromBinary(binary);for(let i=0,l=arrayLength;i<l;i++){[value[i],binary]=valueType.shiftValueFromBinary(binary)}}return[value,binary]}}class VariableSignedIntegerType extends VariableIntegerType{valueToBinary(integer,logStats=null){integer=integer.toFixed(0);const isNegative=integer<0;const signBinary=isNegative?"1":"0";const integerBinary=this.integer.valueToBinary(Math.abs(integer),logStats);const binary=[signBinary,integerBinary];if(logStats){this.log(binary)}return binary}shiftValueFromBinary(binary){let isNegative;[isNegative,binary]=shiftUnsignedIntegerFromBinary(binary,1);let integer;[integer,binary]=this.integer.shiftValueFromBinary(binary);if(isNegative){integer=-integer}return[integer,binary]}}class VariableDecimalType extends VariableIntegerType{constructor(options){super(options);this.isFloat=true;this.decimal=new LengthAndValueBinary(this,"decimal",options.decimalBitSizes)}valueToBinary(float,logStats=null){float=float.toFixed(2);const isNegative=float<0;float=Math.abs(float);const parts=String(float).split(".");const higherInteger=parseInt(parts[0]);const lowerInteger=parseInt(zeroPadRightToLength(parts[1]||0,2));const signBinary=isNegative?"1":"0";const integerValueBinary=this.integer.valueToBinary(higherInteger,logStats);const decimalValueBinary=this.decimal.valueToBinary(lowerInteger,logStats);const binary=[signBinary,integerValueBinary,decimalValueBinary];if(logStats){this.log(binary)}return binary}shiftValueFromBinary(binary){let isNegative;[isNegative,binary]=shiftUnsignedIntegerFromBinary(binary,1);let higherInteger;[higherInteger,binary]=this.integer.shiftValueFromBinary(binary);let lowerInteger;[lowerInteger,binary]=this.decimal.shiftValueFromBinary(binary);lowerInteger=zeroPadLeftToLength(String(lowerInteger),2);let float=parseFloat(higherInteger+"."+lowerInteger);if(isNegative){float=-float}return[float,binary]}}const arrayType=new VariableArrayType({name:"array",binaryType:"10",integerBitSizes:[4,16]});const booleanType=new FixedBooleanType({name:"boolean",binaryType:"0"});const integerTypes=[new FixedIntegerType({name:"uint3",binaryType:"1110",valueBinaryLength:3}),new VariableIntegerType({name:"vint8+",binaryType:"110",minValue:0,maxValue:255,integerBitSizes:[2,8]}),new VariableIntegerType({name:"vint8-",binaryType:"111100",minValue:-255,maxValue:0,integerBitSizes:[2,8]}),new VariableSignedIntegerType({name:"sint32",binaryType:"111110",minValue:-4294967295,maxValue:4294967295,integerBitSizes:[2,4,16,32]})];const decimalTypes=[new VariableDecimalType({name:"sdec15",binaryType:"111101",minValue:-255.99,maxValue:255.99,integerBitSizes:[2,8],decimalBitSizes:[0,7]}),new VariableDecimalType({name:"sdec39",binaryType:"111111",minValue:-4294967295.99,maxValue:4294967295.99,integerBitSizes:[2,4,16,32],decimalBitSizes:[0,7]})];const ValueTypes=[booleanType,arrayType].concat(integerTypes).concat(decimalTypes);ValueTypes.nameIndex={};ValueTypes.forEach((valueType=>ValueTypes.nameIndex[valueType.name]=valueType));function esTypeOf(value){if(Array.isArray(value)){return"array"}if(value===null){return"null"}return typeof value}function findValueTypeFromName(name){return ValueTypes.nameIndex[name.toLowerCase()]}function findValueTypeFromValue(value){const esType=esTypeOf(value);switch(esType){case"array":return arrayType;case"boolean":return booleanType}value=value.toFixed(2);const isFloat=!Number.isInteger(value);const isValueInValueTypeRange=valueType=>value>=valueType.minValue&&value<=valueType.maxValue;const valueType=isFloat?decimalTypes.find(isValueInValueTypeRange):integerTypes.find(isValueInValueTypeRange);if(!valueType){throw new Error(`Cannot find type from value: ${value}`)}return valueType}function findValueTypeFromValues(values){if(!values.length){return}let minValue=0;let maxValue=0;let isFloat=false;const esTypes=values.map((value=>{const valueType=findValueTypeFromValue(value);if(valueType.esType==="number"){minValue=Math.min(value,minValue);maxValue=Math.max(value,maxValue);isFloat=isFloat||!Number.isInteger(value)}return valueType.esType}));const uniqESTypes=[...new Set(esTypes)];if(uniqESTypes.length>1){throw new Error(`Cannot resolve array to one type: ${uniqESTypes.join()}`)}const esType=uniqESTypes[0];switch(esType){case"array":return arrayType;case"boolean":return booleanType}const isRangeInValueTypeRange=valueType=>minValue>=valueType.minValue&&maxValue<=valueType.maxValue;const valueType=isFloat?decimalTypes.find(isRangeInValueTypeRange):integerTypes.find(isRangeInValueTypeRange);if(!valueType){throw new Error(`Cannot find type from value. min: ${minValue} max: ${maxValue} isfloat: ${isFloat}`)}return valueType}function shiftValueTypeFromBinary(binary){const valueType=ValueTypes.find((valueType=>{const binaryType=binary.slice(0,valueType.binaryTypeLength);return binaryType===valueType.binaryType}));if(!valueType){throw new Error(`Cannot find type from binary: ${binary.slice(0,6)}...`)}binary=binary.slice(valueType.binaryTypeLength);return[valueType,binary]}function convertValuesToNumbers(value){const esType=esTypeOf(value);switch(esType){case"array":return value.map(convertValuesToNumbers);case"undefined":case"null":return value?1:0;case"boolean":case"number":return value}throw new Error(`Cannot convert ${esType} to number`)}class Converter{getInvalidTypeError(value){try{value=convertValuesToNumbers(value);esTypeOf(value)==="array"?findValueTypeFromValues(value):findValueTypeFromValue(value);return}catch(err){return err}}valueToBinary(value,typeName=null,logStats=null){this.clearLog();const hasInitialType=typeof typeName==="string";value=convertValuesToNumbers(value);const valueType=hasInitialType?findValueTypeFromName(typeName):findValueTypeFromValue(value);if(!valueType){throw new Error(`Could not find value type from ${hasInitialType?`name ${typeName}`:`value ${value}`} accepts: ${Object.keys(ValueTypes.nameIndex)}. Leave typeName empty for auto-detect.`)}const binary=valueType.valueToBinary(value,logStats);if(!hasInitialType){binary.unshift(valueType.binaryType)}if(logStats){this.printLog()}return binary}valueFromBinary(binary,typeName=null){binary=___default["default"].flatten(binary).join("");const hasInitialType=typeof typeName==="string";let valueType;if(hasInitialType){valueType=findValueTypeFromName(typeName)}else{[valueType,binary]=shiftValueTypeFromBinary(binary)}if(!valueType||!(valueType instanceof AbstractValueType)){throw new Error(`Could not find value type from ${hasInitialType?`name "${typeName}"`:`binary "${binary.slice(0,8)}"...`} accepts: ${Object.keys(ValueTypes.nameIndex)}. Leave typeName empty for auto-detect.`)}const[value]=valueType.shiftValueFromBinary(binary);return value}clearLog(){logs.usedTypes={};logs.typeLengths={};logs.binarySamples={}}printLog(){console.log("Types used count:",logs.usedTypes);console.log("Type lengths used count:",logs.typeLengths);console.log("Type binary samples:",logs.binarySamples)}serialize(value,typeName=null,logStats=null){const binary=this.valueToBinary(value,typeName,logStats);const base64=binaryToBase64(binary);return base64}async serializeAsync(value,typeName=null,logStats=null){const binary=this.valueToBinary(value,null,null);const base64=binaryToBase64(binary);const isLargeArray=Array.isArray(value)&&value.length>10;if(isLargeArray){return new Promise((resolve=>{LZMAWorker.compress(JSON.stringify(value),1,(data=>{const compressedBase64=`#${window.btoa(data.map((i=>String.fromCharCode(i+128))).join("")).replace(/=/g,"")}`;const isCompressedSmaller=compressedBase64.length<base64.length;if(isCompressedSmaller)return resolve(compressedBase64);return resolve(base64)}))}))}return base64}deserialize(base64,typeName=null){const isLZMACompressed=base64[0]==="#";if(isLZMACompressed)return JSON.parse(window.LZMA.decompress(window.atob(base64.slice(1)).split("").map((c=>c.charCodeAt(0)-128))));const binary=base64ToBinary(base64);const value=this.valueFromBinary(binary,typeName);return value}}var SCORMSuspendData=__AMD("extensions/adapt-contrib-spoor/js/serializers/SCORMSuspendData",window.SCORMSuspendData=new Converter);var ComponentSerializer=__AMD("extensions/adapt-contrib-spoor/js/serializers/ComponentSerializer",class ComponentSerializer extends Backbone.Controller{initialize(trackingIdType,shouldCompress){this.trackingIdType=trackingIdType;this.shouldCompress=shouldCompress}async serialize(shouldStoreResponses,shouldStoreAttempts){if(shouldStoreAttempts&&!shouldStoreResponses){logging$1.warnOnce("SPOOR configuration error, cannot use '_shouldStoreAttempts' without '_shouldStoreResponses'")}const states=[];data$1.each((model=>{if(model.get("_type")!==this.trackingIdType){return}const trackingId=model.get("_trackingId");if(typeof trackingId==="undefined"){return}const isContainer=model.hasManagedChildren;let components=isContainer?model.findDescendantModels("component"):[model];components=components.filter((component=>component.get("_isTrackable")!==false));components.forEach(((component,index)=>{if(component.get("_isTrackable")===false){return}if(!shouldStoreResponses){const state=[[trackingId,index],[component.get("_isComplete")]];states.push(state);return}let modelState=null;if(!component.getAttemptState){modelState=component.get("_isQuestionType")?[[component.get("_score")||0,component.get("_attemptsLeft")||0],[component.get("_isComplete")||false,component.get("_isInteractionComplete")||false,component.get("_isSubmitted")||false,component.get("_isCorrect")||false],[component.get("_userAnswer")]]:[[],[component.get("_isComplete")||false,component.get("_isInteractionComplete")||false],[component.get("_userAnswer")]]}else{modelState=component.getAttemptState()}const userAnswer=modelState[2][0];const hasUserAnswer=typeof userAnswer!=="undefined"&&userAnswer!==null;const isUserAnswerArray=Array.isArray(userAnswer);if(!hasUserAnswer){modelState[2][0]=[]}else if(!isUserAnswerArray){modelState[2][0]=[modelState[2][0]]}const attemptStates=component.get("_attemptStates");const hasAttemptStates=shouldStoreAttempts&&Array.isArray(attemptStates);if(hasAttemptStates){modelState[2][1]=attemptStates}const state=[[trackingId,index],[hasUserAnswer,isUserAnswerArray,hasAttemptStates],modelState];states.push(state)}))}));if(this.shouldCompress)return await SCORMSuspendData.serializeAsync(states);return SCORMSuspendData.serialize(states)}deserialize(binary){const trackingIdMap=data$1.toArray().reduce(((trackingIdMap,model)=>{const trackingId=model.get("_trackingId");if(typeof trackingId==="undefined")return trackingIdMap;trackingIdMap[trackingId]=model;return trackingIdMap}),{});const states=SCORMSuspendData.deserialize(binary);const shouldStoreResponses=states[0].length>2;states.forEach((state=>{const[trackingId,index]=state[0];const model=trackingIdMap[trackingId];if(!model){return}const isContainer=model.hasManagedChildren;let components=isContainer?model.findDescendantModels("component"):[model];components=components.filter((component=>component.get("_isTrackable")!==false));const component=components[index];if(!component){logging$1.warn(`SPOOR could not restore tracking id: ${trackingId}, index: ${index}`);return}if(!shouldStoreResponses){const isComplete=state[1][0];component.set("_isComplete",isComplete);return}const[hasUserAnswer,isUserAnswerArray,hasAttemptStates]=state[1];const modelState=state[2];if(!hasUserAnswer){modelState[2][0]=null}else if(!isUserAnswerArray){modelState[2][0]=modelState[2][0][0]}if(!hasAttemptStates){modelState[2][1]=null}if(component.setAttemptObject){component.set("_attemptStates",modelState[2][1]);const attemptObject=component.getAttemptObject(modelState);component.setAttemptObject(attemptObject,false);return}component.get("_isQuestionType")?component.set({_score:modelState[0][0],_attemptsLeft:modelState[0][1],_isComplete:modelState[1][0],_isInteractionComplete:modelState[1][1],_isSubmitted:modelState[1][2],_isCorrect:modelState[1][3],_userAnswer:modelState[2][0],_attemptStates:modelState[2][1]}):component.set({_isComplete:modelState[1][0],_isInteractionComplete:modelState[1][1],_userAnswer:modelState[2][0],_attemptStates:modelState[2][1]})}))}});var StatefulSession=__AMD("extensions/adapt-contrib-spoor/js/adapt-stateful-session",class StatefulSession extends Backbone.Controller{initialize(){_.bindAll(this,"beginSession","onVisibilityChange","endSession");this.debouncedSaveSession=_.debounce(this.saveSessionState.bind(this),1);this.scorm=ScormWrapper$1.getInstance();this._trackingIdType="block";this._componentSerializer=null;this._shouldCompress=false;this._shouldStoreResponses=true;this._shouldStoreAttempts=false;this._shouldRecordInteractions=true;this._shouldRecordObjectives=true;this._uniqueInteractionIds=false;this.beginSession()}get shouldRecordInteractions(){return this._shouldRecordInteractions}get shouldRecordObjectives(){return this._shouldRecordObjectives}beginSession(){this.listenTo(Adapt$1,{"app:dataReady":this.restoreSession,"adapt:start":this.onAdaptStart});this._trackingIdType=Adapt$1.build.get("trackingIdType")||"block";if(window.location.search.indexOf("nolmserrors")!==-1){this.scorm.suppressErrors=true}const config=Adapt$1.spoor.config;if(!config)return;const tracking=config._tracking;this._shouldStoreResponses=tracking&&tracking._shouldStoreResponses||false;this._shouldStoreAttempts=tracking&&tracking._shouldStoreAttempts||false;this._shouldCompress=tracking&&tracking._shouldCompress||false;this._componentSerializer=new ComponentSerializer(this._trackingIdType,this._shouldCompress);if(tracking?._shouldRecordInteractions===false){this._shouldRecordInteractions=false}if(tracking?._shouldRecordObjectives===false){this._shouldRecordObjectives=false}const settings=config._advancedSettings;if(!settings){this.scorm.setVersion("1.2");this.scorm.initialize();return}this._uniqueInteractionIds=settings._uniqueInteractionIds||false;this.scorm.initialize(settings)}restoreSession(){this.setupLearnerInfo();this.restoreSessionState()}setupLearnerInfo(){const globals=Adapt$1.course.get("_globals");if(!globals._learnerInfo){globals._learnerInfo={}}Object.assign(globals._learnerInfo,offlineStorage$1.get("learnerinfo"))}restoreSessionState(){const sessionPairs=offlineStorage$1.get();const hasNoPairs=!Object.keys(sessionPairs).length;if(hasNoPairs)return;if(sessionPairs.c){const[_isComplete,_isAssessmentPassed]=SCORMSuspendData.deserialize(sessionPairs.c);Adapt$1.course.set({_isComplete:_isComplete,_isAssessmentPassed:_isAssessmentPassed})}if(!sessionPairs.q)return;this._componentSerializer?.deserialize(sessionPairs.q)}setupEventListeners(){this.removeEventListeners();this.listenTo(Adapt$1.components,"change:_isComplete",this.debouncedSaveSession);this.listenTo(Adapt$1.contentObjects,"change:_isComplete",this.onContentObjectCompleteChange);this.listenTo(Adapt$1.course,"change:_isComplete",this.debouncedSaveSession);if(this._shouldStoreResponses){this.listenTo(data$1,"change:_isSubmitted change:_userAnswer",this.debouncedSaveSession)}this.listenTo(Adapt$1,{"app:dataReady":this.restoreSession,"adapt:start":this.onAdaptStart,"app:languageChanged":this.onLanguageChanged,"pageView:ready":this.onPageViewReady,"questionView:recordInteraction":this.onQuestionRecordInteraction,"tracking:complete":this.onTrackingComplete});const config=Adapt$1.spoor.config;const advancedSettings=config._advancedSettings;const shouldCommitOnVisibilityChange=!advancedSettings||advancedSettings._commitOnVisibilityChangeHidden!==false;if(shouldCommitOnVisibilityChange){document.addEventListener("visibilitychange",this.onVisibilityChange)}$(window).on("beforeunload unload pagehide",this.endSession)}async saveSessionState(){const isMidRender=!Adapt$1.parentView?.model.get("_isReady");if(isMidRender)return this.debouncedSaveSession();const courseState=SCORMSuspendData.serialize([Boolean(Adapt$1.course.get("_isComplete")),Boolean(Adapt$1.course.get("_isAssessmentPassed"))]);const componentStates=await(this._componentSerializer?.serialize(this._shouldStoreResponses,this._shouldStoreAttempts));const sessionPairs={c:courseState,q:componentStates};offlineStorage$1.set(sessionPairs);this.printCompletionInformation(sessionPairs)}printCompletionInformation(suspendData){if(typeof suspendData==="string"){suspendData=JSON.parse(suspendData)}const courseState=SCORMSuspendData.deserialize(suspendData.c);const courseComplete=courseState[0];const assessmentPassed=courseState[1];const trackingIdModels=data$1.filter((model=>model.get("_type")===this._trackingIdType&&model.has("_trackingId")));const trackingIds=trackingIdModels.map((model=>model.get("_trackingId")));if(!trackingIds.length){logging$1.info(`course._isComplete: ${courseComplete}, course._isAssessmentPassed: ${assessmentPassed}, ${this._trackingIdType} completion: no tracking ids found`);return}const completionData=SCORMSuspendData.deserialize(suspendData.q);const max=Math.max(...completionData.map((item=>item[0][0])));const shouldStoreResponses=completionData[0].length===3;const completionString=completionData.reduce(((markers,item)=>{const trackingId=item[0][0];const isComplete=shouldStoreResponses?item[2][1][0]:item[1][0];const mark=isComplete?"1":"0";markers[trackingId]=markers[trackingId]==="-"||markers[trackingId]==="1"?mark:"0";return markers}),new Array(max+1).fill("-")).join("");logging$1.info(`course._isComplete: ${courseComplete}, course._isAssessmentPassed: ${assessmentPassed}, ${this._trackingIdType} completion: ${completionString}`)}initializeContentObjectives(){if(!this.shouldRecordObjectives)return;Adapt$1.contentObjects.forEach((model=>{if(model.isTypeGroup("course"))return;const id=model.get("_id");const description=model.get("title")||model.get("displayTitle");offlineStorage$1.set("objectiveDescription",id,description);if(model.get("_isVisited"))return;const completionStatus=COMPLETION_STATE$3.NOTATTEMPTED.asLowerCase;offlineStorage$1.set("objectiveStatus",id,completionStatus)}))}onAdaptStart(){this.setupEventListeners();this.initializeContentObjectives()}onLanguageChanged(){this.stopListening(Adapt$1.contentObjects,"change:_isComplete",this.onContentObjectCompleteChange);const config=Adapt$1.spoor.config;if(config?._reporting?._resetStatusOnLanguageChange!==true)return;const completionStatus=COMPLETION_STATE$3.INCOMPLETE.asLowerCase;offlineStorage$1.set("status",completionStatus)}onVisibilityChange(){if(document.visibilityState==="hidden")this.scorm.commit()}onPageViewReady(view){if(!this.shouldRecordObjectives)return;const model=view.model;if(model.get("_isComplete"))return;const id=model.get("_id");const completionStatus=COMPLETION_STATE$3.INCOMPLETE.asLowerCase;offlineStorage$1.set("objectiveStatus",id,completionStatus)}onQuestionRecordInteraction(questionView){if(!this.shouldRecordInteractions)return;if(!this.scorm.isSupported("cmi.interactions._count"))return;const questionModel=questionView.model;const responseType=questionModel.getResponseType?questionModel.getResponseType():questionView.getResponseType();if(_.isEmpty(responseType))return;const id=this._uniqueInteractionIds?`${this.scorm.getInteractionCount()}-${questionModel.get("_id")}`:questionModel.get("_id");const response=questionModel.getResponse?questionModel.getResponse():questionView.getResponse();const result=questionModel.isCorrect?questionModel.isCorrect():questionView.isCorrect();const latency=questionModel.getLatency?questionModel.getLatency():questionView.getLatency();offlineStorage$1.set("interaction",id,response,result,latency,responseType)}onContentObjectCompleteChange(model){if(!this.shouldRecordObjectives)return;if(model.isTypeGroup("course"))return;const id=model.get("_id");const completionStatus=(model.get("_isComplete")?COMPLETION_STATE$3.COMPLETED:COMPLETION_STATE$3.INCOMPLETE).asLowerCase;offlineStorage$1.set("objectiveStatus",id,completionStatus)}onTrackingComplete(completionData){const config=Adapt$1.spoor.config;this.saveSessionState();let completionStatus=completionData.status.asLowerCase;switch(completionData.status){case COMPLETION_STATE$3.COMPLETED:case COMPLETION_STATE$3.PASSED:{if(!config?._reporting?._onTrackingCriteriaMet){logging$1.warn(`No value defined for '_onTrackingCriteriaMet', so defaulting to '${completionStatus}'`)}else{completionStatus=config._reporting._onTrackingCriteriaMet}break}case COMPLETION_STATE$3.FAILED:{if(!config?._reporting?._onAssessmentFailure){logging$1.warn(`No value defined for '_onAssessmentFailure', so defaulting to '${completionStatus}'`)}else{completionStatus=config._reporting._onAssessmentFailure}}}offlineStorage$1.set("status",completionStatus)}endSession(){if(!this.scorm.finishCalled){this.scorm.finish()}this.removeEventListeners()}removeEventListeners(){$(window).off("beforeunload unload pagehide",this.endSession);document.removeEventListener("visibilitychange",this.onVisibilityChange);this.stopListening()}});var OfflineStorage=__AMD("extensions/adapt-contrib-spoor/js/adapt-offlineStorage-scorm",class OfflineStorageScorm extends Backbone.Controller{initialize(statefulSession){this.offlineStorage=offlineStorage$1;this.scorm=ScormWrapper$1.getInstance();this.statefulSession=statefulSession;this.temporaryStore={};this.suspendDataStore={};this.suspendDataRestored=false;offlineStorage$1.initialize(this)}save(){this.statefulSession.saveSessionState();this.scorm.commit()}serialize(...args){return SCORMSuspendData.serialize(...args)}deserialize(...args){return SCORMSuspendData.deserialize(...args)}get(name){if(name===undefined){if(this.useTemporaryStore())return this.temporaryStore;this.suspendDataStore=this.getCustomStates();const data=Object.assign(_.clone(this.suspendDataStore),{location:this.scorm.getLessonLocation(),score:this.scorm.getScore(),status:this.scorm.getStatus(),student:this.scorm.getStudentName(),learnerInfo:this.getLearnerInfo()});this.suspendDataRestored=true;return data}if(this.useTemporaryStore())return this.temporaryStore[name];let courseState;switch(name.toLowerCase()){case"location":return this.scorm.getLessonLocation();case"score":return this.scorm.getScore();case"status":return this.scorm.getStatus();case"student":return this.scorm.getStudentName();case"learnerinfo":return this.getLearnerInfo();case"coursestate":{courseState=this.getCustomState("c");const stateArray=courseState&&SCORMSuspendData.deserialize(courseState)||[];return{_isCourseComplete:Boolean(stateArray.slice(0,1).map(Number)[0]),_isAssessmentPassed:Boolean(stateArray.slice(1,2).map(Number)[0]),completion:stateArray.slice(2).map(Number).map(String).join("")||""}}case"completion":courseState=this.getCustomState("c");return courseState&&SCORMSuspendData.deserialize(courseState).slice(2).map(Number).map(String).join("")||"";case"_iscoursecomplete":courseState=this.getCustomState("c");return Boolean(courseState&&SCORMSuspendData.deserialize(courseState).slice(0,1).map(Number)[0]);case"_isassessmentpassed":courseState=this.getCustomState("c");return Boolean(courseState&&SCORMSuspendData.deserialize(courseState).slice(1,2).map(Number)[0]);case"questions":{const questionsState=this.getCustomState("q");return questionsState||""}default:return this.getCustomState(name)}}set(name,value){const args=[...arguments].slice(1);const isObject=typeof name==="object";if(isObject){value=name;name="suspendData"}if(this.useTemporaryStore()){if(isObject){Object.assign(this.temporaryStore,value)}else{this.temporaryStore[name]=value}return true}switch(name.toLowerCase()){case"interaction":if(!this.statefulSession.shouldRecordInteractions)return;return this.scorm.recordInteraction(...args);case"objectivedescription":if(!this.statefulSession.shouldRecordObjectives)return;return this.scorm.recordObjectiveDescription(...args);case"objectivestatus":if(!this.statefulSession.shouldRecordObjectives)return;return this.scorm.recordObjectiveStatus(...args);case"objectivescore":if(!this.statefulSession.shouldRecordObjectives)return;return this.scorm.recordObjectiveScore(...args);case"location":return this.scorm.setLessonLocation(...args);case"score":return this.scorm.setScore(...args);case"status":return this.scorm.setStatus(...args);case"student":case"learnerinfo":return false;case"lang":this.scorm.setLanguage(value);break}if(isObject){Object.assign(this.suspendDataStore,value)}else{this.suspendDataStore[name]=value}const dataAsString=JSON.stringify(this.suspendDataStore);return this.suspendDataRestored?this.scorm.setSuspendData(dataAsString):false}clear(){this.temporaryStore={};this.suspendDataStore={};const dataAsString=JSON.stringify(this.suspendDataStore);this.scorm.setSuspendData(dataAsString)}getCustomStates(){const isSuspendDataStoreEmpty=_.isEmpty(this.suspendDataStore);if(!isSuspendDataStoreEmpty&&this.suspendDataRestored){return _.clone(this.suspendDataStore)}const dataAsString=this.scorm.getSuspendData();if(dataAsString===""||dataAsString===" "||dataAsString===undefined){return{}}const dataAsJSON=JSON.parse(dataAsString);if(!isSuspendDataStoreEmpty&&!this.suspendDataRestored){Object.assign(dataAsJSON,this.suspendDataStore)}return dataAsJSON}getCustomState(name){const dataAsJSON=this.getCustomStates();return dataAsJSON[name]}useTemporaryStore(){const cfg=Adapt$1.config.get("_spoor");if(!this.scorm.lmsConnected||cfg?._isEnabled===false)return true;return false}getLearnerInfo(){const id=this.scorm.getStudentId();let name=this.scorm.getStudentName();let firstname="";let lastname="";let hasName=name&&name!=="undefined";const isNameCommaSeparated=hasName&&name.includes(",");const isNameSpaceSeparated=hasName&&name.includes(" ");hasName=hasName&&(isNameCommaSeparated||isNameSpaceSeparated);if(!hasName){console.log("SPOOR: LMS learner_name not in 'lastname, firstname' or 'firstname lastname' format");return{id:id,name:name,firstname:firstname,lastname:lastname}}const separator=isNameCommaSeparated?",":" ";const nameParts=name.split(separator);if(isNameCommaSeparated){nameParts.reverse()}[firstname,lastname]=nameParts.map((part=>part.trim()));name=`${firstname} ${lastname}`;return{id:id,name:name,firstname:firstname,lastname:lastname}}});const shouldStart=Object.prototype.hasOwnProperty.call(window,"ISCOOKIELMS")&&window.ISCOOKIELMS!==null;const isStoringData=window.ISCOOKIELMS===true;const set=(object,path,value)=>{const keys=path.split(".");const initialKeys=keys.slice(0,-1);const lastKey=keys[keys.length-1];const finalObject=initialKeys.reduce(((object,key)=>object[key]=object?.[key]||{}),object);finalObject[lastKey]=value};const get=(object,path)=>{const keys=path.split(".");return keys.reduce(((object,key)=>object?.[key]),object)};function createResetButton(){const resetButtonStyle='<style id="spoor-clear-button">.spoor-reset-button { position:fixed; right:0px; bottom:0px; } </style>';const resetButton='<button class="spoor-reset-button btn-text">Reset</button>';$("body").append($(resetButtonStyle));const $button=$(resetButton);$("body").append($button);$button.on("click",(e=>{if(!e.shiftKey){Cookies__default["default"].remove("_spoor");alert("SCORM tracking cookie has been deleted! Tip: shift-click reset to preserve cookie.")}window.location=window.location.pathname}))}function configure(){if(!isStoringData)return;const spoorConfig=Adapt$1.config.get("_spoor");if(spoorConfig?._showCookieLmsResetButton)createResetButton();if(!spoorConfig?._shouldPersistCookieLMSData){Cookies__default["default"].defaults={sameSite:"strict"}}}function postStorageWarning(){if(postStorageWarning.__storageWarningTimeoutId!==null)return;postStorageWarning.__storageWarningTimeoutId=setTimeout((()=>{const notificationMethod=Adapt$1.config.get("_spoor")?._advancedSettings?._suppressErrors===true?console.error:alert;postStorageWarning.__storageWarningTimeoutId=null;notificationMethod("Warning: possible cookie storage limit exceeded - tracking may malfunction")}),1e3)}function start(){const GenericAPI={__offlineAPIWrapper:true,store(force){if(!isStoringData)return;if(!force&&Cookies__default["default"].get("_spoor")===undefined)return;Cookies__default["default"].set("_spoor",this.data);if(Cookies__default["default"].get("_spoor").length!==JSON.stringify(this.data).length)postStorageWarning()},initialize(defaults={}){if(!isStoringData){this.data={};Object.entries(defaults).forEach((([path,value])=>set(this.data,path,value)));return}this.data=Cookies__default["default"].getJSON("_spoor");if(!this.data){this.data={};Object.entries(defaults).forEach((([path,value])=>set(this.data,path,value)));this.store(true);return false}const entries=Object.entries(this.data);const isUsingLegacyKeys=entries[0][0].includes(".");if(isUsingLegacyKeys){const reworked={};Object.entries(defaults).forEach((([path,value])=>set(reworked,path,value)));Object.entries(entries).forEach((([path,value])=>set(reworked,path,value)));this.data=reworked;this.store(true)}return true}};const SCORM1_2=window.API={...GenericAPI,LMSInitialize(){configure();this.initialize({"cmi.interactions":[],"cmi.objectives":[],"cmi.core.lesson_status":"not attempted","cmi.suspend_data":"","cmi.core.student_name":"Surname, Sam","cmi.core.student_id":"sam.surname@example.org"});return"true"},LMSFinish(){return"true"},LMSGetValue(path){const value=get(this.data,path);const keys=path.split(".");const firstKey=keys[0];const lastKey=keys[keys.length-1];if(firstKey==="cmi"&&lastKey==="_count"){const arrayPath=keys.slice(0,-1).join(".");return get(this.data,arrayPath)?.length??0}return value},LMSSetValue(path,value){const keys=path.split(".");const firstKey=keys[0];const lastKey=keys[keys.length-1];if(firstKey==="cmi"&&lastKey==="_count"){return"true"}set(this.data,path,value);this.store();return"true"},LMSCommit(){return"true"},LMSGetLastError(){return 0},LMSGetErrorString(){return"Fake error string."},LMSGetDiagnostic(){return"Fake diagnostic information."}};window.API_1484_11={...GenericAPI,Initialize(){configure();this.initialize({"cmi.interactions":[],"cmi.objectives":[],"cmi.completion_status":"not attempted","cmi.suspend_data":"","cmi.learner_name":"Surname, Sam","cmi.learner_id":"sam.surname@example.org"});return"true"},Terminate:SCORM1_2.LMSFinish,GetValue:SCORM1_2.LMSGetValue,SetValue:SCORM1_2.LMSSetValue,Commit:SCORM1_2.LMSCommit,GetLastError:SCORM1_2.LMSGetLastError,GetErrorString:SCORM1_2.LMSGetErrorString,GetDiagnostic:SCORM1_2.LMSGetDiagnostic}}class Spoor extends Backbone.Controller{initialize(){this.config=null;if(shouldStart)start();this.scorm=ScormWrapper$1.getInstance();this.listenToOnce(Adapt$1,"offlineStorage:prepare",this._prepare)}_prepare(){this.config=Adapt$1.config.get("_spoor");if(!this.isEnabled){offlineStorage$1.setReadyStatus();return}this.statefulSession=new StatefulSession;this.offlineStorage=new OfflineStorage(this.statefulSession);offlineStorage$1.get();offlineStorage$1.setReadyStatus();$.onKeyCombo([68,69,86],(()=>{Adapt$1.spoor.scorm.showDebugWindow()}))}get isEnabled(){return this.config&&this.config._isEnabled}}Adapt$1.spoor=new Spoor;__AMD("extensions/adapt-contrib-spoor/js/adapt-contrib-spoor",Adapt$1.spoor);var CourseTitleView=Backbone.View.extend({className:"course-title",attributes:{},initialize:function(){this.listenTo(Adapt$1,"remove",this.remove);this.render()},render:function(){var template=Handlebars.templates["coursemenu-title"];var parent=this.getParentIfExists(this.model);if(parent){this.model.set("_parentTitle",parent.get("displayTitle"));var parentParent=this.getParentIfExists(parent);if(parentParent){this.model.set("_parentParentTitle",parentParent.get("displayTitle"));var parentParentParent=this.getParentIfExists(parentParent);if(parentParentParent){this.model.set("_parentParentParentTitle",parentParentParent.get("displayTitle"));var parentParentParentParent=this.getParentIfExists(parentParentParent);if(parentParentParentParent){this.model.set("_parentParentParentParentTitle",parentParentParentParent.get("displayTitle"))}}}}var data=this.model.toJSON();this.$el.html(template(data))},getParentIfExists:function(model){var parent=null;if(model.get("_type")!="course"){parent=model.getParent()}return parent}});var CourseTitleView$1=__AMD("extensions/adapt-course-menu/js/CourseTitleView",CourseTitleView);class CourseMenuItemView extends Backbone.View{tagName(){return"li"}events(){return{"click .course-item__button":"onClick","keydown .course-item__button":"onKeydown"}}className(){return["course-item","course-item-"+this.model.get("_type"),this.model.get("_classes"),this.model.get("_isVisited")?"visited":"",this.model.get("_isComplete")?"completed":"",this.model.get("_isLocked")?"locked":"",Adapt$1.location._currentId==this.model.get("_id")?"active":""].join(" ")}attributes(){return{role:"menuitem","data-index":this.model.get("_menuItemIndex"),"data-navigate-to":this.model.get("_id"),"aria-current":Adapt$1.location._currentId===this.model.get("_id")?"true":"false"}}initialize(){this.preRender();this.render();this.postRender();this.listenTo(this.model,{"change:_isComplete":this.onIsCompleteChange})}onIsCompleteChange(model){this.$el.find(".course-item__button").addClass("is-complete")}preRender(){this.model.set("_childContainterSelector","item-child-container")}render(){const data=this.model.toJSON();data.view=this;const template=Handlebars.templates["coursemenu-item"];this.$el.html(template(data))}postRender(){if(this.model.get("_type")==="menu"){this.addChildren()}Adapt$1.trigger("CourseMenuItemView:postRender",this)}addChildren(){var nthChild=0;var children=this.model.getChildren();var models=children.models;this.childViews={};for(var i=0,len=models.length;i<len;i++){var model=models[i];if(!model.get("_isAvailable"))continue;nthChild++;model.set("_menuItemIndex",nthChild);var $parentContainer=this.$(".item-child-container");this.$parentContainer=$parentContainer;var childView=new CourseMenuSubItemView({model:model});this.childViews[model.get("_id")]=childView;$parentContainer.append(childView.$el)}}onClick(event){if(event&&event.preventDefault){event.preventDefault();event.stopPropagation()}var $btn=$(event.currentTarget);switch($btn.attr("data-option")){case"course":Adapt$1.router.navigateToHomeRoute();this.markCurrentMenuItem("course");break;case"menu":this.toggleMenu($btn);break;case"page":this.navigateToPage($btn.parent().attr("data-navigate-to"));break;default:console.info("button type not supported")}}onKeydown(event){this.markCurrentMenuItem(Adapt$1.location._currentId);var $btn=$(event.currentTarget);var type=$btn.attr("data-option");var index=parseInt(this.$el.attr("data-index"));var siblings=this.$el.parent().children();var numberOfSiblings=siblings.length;var firstSiblingBtn=siblings.first().find(".course-item__button")[0];var lastSiblingBtn=siblings.last().find(".course-item__button")[0];switch(event.keyCode){case 37:event.preventDefault();event.stopPropagation();if(type==="menu"&&$btn.attr("aria-expanded")=="true"){this.toggleMenu($btn,{changeTo:"closed"})}else{var $listParent=$btn.parent().parent().parent();$btn=$($listParent.find(".course-item__button")[0]);this.toggleMenu($btn,{changeTo:"closed"})}break;case 39:if(type==="menu"){this.toggleMenu($btn,{changeTo:"opened"});event.preventDefault();event.stopPropagation()}break;case 38:event.preventDefault();event.stopPropagation();if(type==="menu"){this.toggleMenu($btn,{changeTo:"closed"})}if(index===1){Adapt$1.a11y.focus(lastSiblingBtn)}else{var prevSiblingBtn=this.$el.prev().find(".course-item__button")[0];Adapt$1.a11y.focus(prevSiblingBtn)}break;case 40:event.preventDefault();event.stopPropagation();if(type==="menu"){this.toggleMenu($btn,{changeTo:"closed"})}if(index===numberOfSiblings){Adapt$1.a11y.focus(firstSiblingBtn)}else{var nextSiblingBtn=this.$el.next().find(".course-item__button")[0];Adapt$1.a11y.focus(nextSiblingBtn)}break;default:return}}toggleMenu($btn,options){this.markCurrentMenuItem(Adapt$1.location._currentId);var $parentContainer=$btn.siblings(".child-container");var isOpen=$btn.attr("aria-expanded");var shouldFocusFirstChild=true;var changeTo=isOpen=="true"?"closed":"opened";if(options&&options.changeTo){shouldFocusFirstChild=false;changeTo=options.changeTo;if(changeTo=="closed"&&isOpen=="false"){return}}if(changeTo==="opened"){$parentContainer.slideDown();$btn.attr("aria-expanded","true")}if(changeTo==="closed"){shouldFocusFirstChild=false;$parentContainer.slideUp();$btn.attr("aria-expanded","false")}if(shouldFocusFirstChild){Adapt$1.a11y.focus($parentContainer.find(".course-item__button")[0])}else{Adapt$1.a11y.focus($btn)}}markCurrentMenuItem(pageId){var items=document.querySelectorAll("[data-navigate-to]");if(items){items.forEach((item=>{var currentItemId=$(item).attr("data-navigate-to");if(!(currentItemId||pageId))return;if(currentItemId===pageId){$(item).attr("aria-current","true");$(item).addClass("active")}else{$(item).attr("aria-current","false");$(item).removeClass("active")}}))}}navigateToPage(pageId){this.markCurrentMenuItem(pageId);var pageModel=Adapt$1.findById(pageId);if(pageModel.get("_isLocked"))return;Backbone.history.navigate("#/id/"+pageModel.get("_id"),{trigger:true})}}class CourseMenuSubItemView extends CourseMenuItemView{preRender(){this.model.set("_childContainterSelector","sub-item-child-container");this.model.set("_parentLocked",this.model.getParent().get("_isLocked"))}addChildren(){var nthChild=0;var children=this.model.getChildren();var models=children.models;this.childViews={};for(var i=0,len=models.length;i<len;i++){var model=models[i];if(!model.get("_isAvailable"))continue;nthChild++;model.set("_menuItemIndex",nthChild);var $parentContainer=this.$(".sub-item-child-container");this.$parentContainer=$parentContainer;var childView=new CourseMenuSubSubItemView({model:model});this.childViews[model.get("_id")]=childView;$parentContainer.append(childView.$el)}}}class CourseMenuSubSubItemView extends CourseMenuItemView{preRender(){this.model.set("_childContainterSelector","sub-sub-item-child-container");this.model.set("_parentLocked",this.model.getParent().get("_isLocked"))}addChildren(){var nthChild=0;var children=this.model.getChildren();var models=children.models;this.childViews={};for(var i=0,len=models.length;i<len;i++){var model=models[i];if(!model.get("_isAvailable"))continue;nthChild++;model.set("_menuItemIndex",nthChild);var $parentContainer=this.$(".sub-sub-item-child-container");this.$parentContainer=$parentContainer;var childView=new CourseMenuSubSubSubItemView({model:model});this.childViews[model.get("_id")]=childView;$parentContainer.append(childView.$el)}}}class CourseMenuSubSubSubItemView extends CourseMenuItemView{preRender(){this.model.set("_parentLocked",this.model.getParent().get("_isLocked"))}}var CourseMenuItemView$1=__AMD("extensions/adapt-course-menu/js/CourseMenuItemView",CourseMenuItemView);class CourseMenuView extends Backbone.View{tagName(){return"nav"}className(){return"course-menu"}attributes(){return{"aria-label":"Course Menu"}}initialize(config){this.config=config;this.preRender();this.render();this.postRender()}preRender(){}render(){var template=Handlebars.templates["coursemenu"];this.$el.html(template(this.config))}postRender(){var menuItemIndex=1;if(Adapt$1.course.has("_start")){var startController=Adapt$1.course.get("_start");if(startController._isEnabled==false||startController._isMenuDisabled==false){Adapt$1.course.set("_menuItemIndex",menuItemIndex);menuItemIndex++;this.$(".course-children").append(new CourseMenuItemView$1({model:Adapt$1.course}).$el)}}const self=this;this.model.getChildren().each((function(item,index){if(item.get("_isAvailable")&&!item.get("_isHidden")){item.set("_menuItemIndex",menuItemIndex);self.$(".course-children").append(new CourseMenuItemView$1({model:item}).$el);menuItemIndex++}if(item.get("_isHidden")){item.set("_isReady",true)}}))}}var CourseMenuView$1=__AMD("extensions/adapt-course-menu/js/CourseMenuView",CourseMenuView);let MenuButton=Backbone.View.extend({className:"btn-icon nav__btn nav__menu-btn js-nav-menu-btn",tagName:"button",events:{click:"onClickMenuButton"},attributes:{"aria-label":Adapt$1.course?.get("_globals")?._extensions?._courseMenu?._courseMenuLabel||"Open Menu","aria-expanded":false,"data-tooltip-id":"openMenu"},initialize:function(){this.registerTooltip();this.listenTo(Adapt$1,"remove",this.remove);this.listenTo(Adapt$1,"hyper:menu-toggle",this.isOpen);this.render()},registerTooltip(){tooltips$1.register({_id:"openMenu",text:Adapt$1.course?.get("_globals")?._extensions?._courseMenu?._courseMenuLabel||"Open Menu"})},render:function(){let template=Handlebars.templates["menu-button"];let menuLabel="Menu";this.$el.html(template({menuLabel:menuLabel}))},onClickMenuButton:function(event){if(event&&event.preventDefault)event.preventDefault();if(Adapt$1.lifeHelper&&Adapt$1.lifeHelper.isHyperOpen&&!Adapt$1.lifeHelper.isHyperMenuDisabled){Adapt$1.trigger("hyper:menu",null)}else{Adapt$1.menudrawer.triggerCustomView(new CourseMenuView$1({model:Adapt$1.course}).$el,false)}},isOpen:function(isOpen){var label=isOpen?"Close menu.":"Open menu.";this.$el.attr("aria-label",label);this.$el.attr("aria-expanded",isOpen);this.$el.attr("aria-current",isOpen)}});var MenuButtonView=__AMD("extensions/adapt-course-menu/js/menuButtonView",MenuButton);class MenuDrawerView extends Backbone.View{className(){return"menu-drawer drawer u-display-none"}attributes(){return{role:"navigation","aria-labelledby":"course-menu-heading","aria-hidden":"true"}}initialize(){this.disableAnimation=Adapt$1.config.has("_disableAnimation")?Adapt$1.config.get("_disableAnimation"):false;this._isVisible=false;this.drawerDir="left";if(Adapt$1.config.get("_defaultDirection")==="rtl"){this.drawerDir="right"}this.setupEventListeners();this.render();this.drawerDuration=Adapt$1.config.get("_drawer")._duration;this.drawerDuration=this.drawerDuration?this.drawerDuration:400;this.$wrapper=$("#wrapper");this.isPinned=false}setupEventListeners(){this.listenTo(Adapt$1,{"navigation:toggleDrawer":this.toggleDrawer,"menudrawer:triggerCustomView":this.openCustomView,"drawer:closeDrawer":this.onCloseDrawerMenu,remove:this.onRemove,"drawer:remove":this.remove});this.onKeyUp=this.onKeyUp.bind(this);this.setupEscapeKey()}onKeydown(e){const focusableElements='button:not([tabindex="-1"]), a[href], input, select, textarea, [tabindex]:not([tabindex="-1"])';const modal=document.getElementsByClassName("menu-drawer drawer")[0];const focusableContent=modal.querySelectorAll(focusableElements);const firstFocusableElement=focusableContent[0];const lastFocusableElement=focusableContent[focusableContent.length-1];var isTabPressed=e.key==="Tab";if(!this.isPinned){if(!isTabPressed){return}if(e.shiftKey){if(document.activeElement===firstFocusableElement){lastFocusableElement.focus();e.preventDefault()}}else{if(document.activeElement===lastFocusableElement){firstFocusableElement.focus();e.preventDefault()}}}}setupEscapeKey(){$(window).on("keyup",this.onKeyUp)}onKeyUp(event){if(event.which!==27)return;event.preventDefault();Adapt$1.trigger("popup:closed");this.onCloseDrawerMenu()}events(){return{"click .drawer__back":"onBackButtonClicked","click .drawer__close-menu":"onCloseClicked","click .pin__btn":"onPinBtnClicked",keydown:"onKeydown"}}render(){const template=Handlebars.templates["menudrawer"];$(this.el).html(template({_globals:Adapt$1.course.get("_globals"),_pinMenuOption:Adapt$1.config.get("_courseMenu"),_pinMenuBtnText:Adapt$1.course.get("_courseMenu")})).prependTo("body");const shadowTemplate=Handlebars.templates["shadow"];$(shadowTemplate()).prependTo("body");_.defer(this.postRender.bind(this));var tooltip=Adapt$1.course.get("_laerdaltooltip");if(tooltip&&tooltip._isEnabled&&tooltip.closebuttontooltip){$(".drawer__close-menu").attr("data-title",tooltip.closebuttontooltip).attr("data-rel","tooltip").attr("onmouseenter","tooltip.call(this)")}return this}postRender(){this.$("a[href], button, input, select, textarea").attr("tabindex",-1);this.checkIfDrawerIsAvailable();Adapt$1.trigger("menuDrawerView:postRender",this)}openCustomView(view,hasBackButton){this._hasBackButton=hasBackButton;this._isCustomViewVisible=true;Adapt$1.trigger("drawer:empty");this.showDrawer();this.$(".drawer__holder").html(view)}checkIfDrawerIsAvailable(){const isEmptyDrawer=this.collection.length===0;var navDrawer=$.find(".js-nav-drawer-btn");if(navDrawer.length>0){var tooltip=Adapt$1.course.get("_laerdaltooltip");if(tooltip&&tooltip._isEnabled&&tooltip.resourcetooltip){$(".js-nav-drawer-btn").attr("data-title",tooltip.resourcetooltip).attr("data-rel","tooltip").attr("onmouseenter","tooltip.call(this)")}this._isResourceViewVisible=true}if(isEmptyDrawer){Adapt$1.trigger("drawer:noItems")}}onBackButtonClicked(event){event.preventDefault();this.showDrawer(true)}onCloseClicked(event){event.preventDefault();this.hideDrawer();var config=Adapt$1.config.get("_courseMenu");if(!config?._pinnedMenu?._isEnabled){Adapt$1.trigger("popup:closed")}this.onCloseDrawerMenu()}onPinBtnClicked(event){$("#app").addClass("slide-out");$(".js-shadow").addClass("u-display-none");$(".nav").addClass("pinned-nav");$(".menu-drawer").addClass("pinned-menu");$(".pin__menu").addClass("u-display-none");$(".drawer__close-menu").removeClass("u-display-none");$(".nav__menu-btn").addClass("u-display-none");Adapt$1.a11y.scrollEnable("body");Adapt$1.trigger("popup:closed");this.isPinned=true;$(".pin-menu-close").attr("tabindex",0)}onCloseDrawerMenu($toElement){this.hideDrawer($toElement);$("#app").removeClass("slide-out");$(".nav").removeClass("pinned-nav");$(".menu-drawer").removeClass("pinned-menu");$(".pin__menu").removeClass("u-display-none");let config=Adapt$1.config.get("_courseMenu");if(config?._pinnedMenu?._isEnabled){$(".drawer__close-menu").addClass("u-display-none")}$(".nav__menu-btn").removeClass("u-display-none");$(".pin-menu-close").attr("tabindex",-1)}onRemove(){var pinnedToggle=$(".pinned-menu");if(pinnedToggle.length==0){this.hideDrawer()}}toggleDrawer(){if(this._isVisible&&this._isCustomViewVisible===false||this._isResourceViewVisible===true){var pinnedToggle=$(".pinned-menu");if(pinnedToggle.length==0){this.hideDrawer()}}else{this.showDrawer(true)}}showDrawer(emptyDrawer){this.$el.removeClass("u-display-none").removeAttr("aria-hidden");if(!this._isVisible){Adapt$1.a11y.popupOpened(this.$el);Adapt$1.a11y.scrollDisable("body");this._isVisible=true}this.$("a[href], button, input, select, textarea").attr("tabindex",0);let config=Adapt$1.config.get("_courseMenu");if(config?._pinnedMenu?._isEnabled){this.$(".pin-menu-close").attr("tabindex",-1)}if(emptyDrawer){this.$(".drawer__back").addClass("u-display-none");this._isCustomViewVisible=false;this.emptyDrawer();if(this.collection.models.length===1){Adapt$1.trigger(this.collection.models[0].get("eventCallback"));this._isCustomViewVisible=false}else{this.renderItems();Adapt$1.trigger("drawer:openedItemView")}}else{const hideDrawerBackButton=!this._hasBackButton||this.collection.models.length<=1;this.$(".drawer__back").toggleClass("u-display-none",hideDrawerBackButton);Adapt$1.trigger("drawer:openedCustomView")}const complete=()=>{this.addShadowEvent();Adapt$1.trigger("drawer:opened");Adapt$1.a11y.focusFirst(this.$el,{defer:true})};const direction={};if(this.disableAnimation){$(".js-shadow").removeClass("u-display-none");$(".js-drawer-holder").scrollTop(0);direction[this.drawerDir]=0;this.$el.css(direction);complete()}else{$(".js-shadow").velocity({opacity:1},{duration:this.drawerDuration,begin:()=>{$(".js-shadow").removeClass("u-display-none");$(".js-drawer-holder").scrollTop(0);complete()}});const showEasingAnimation=Adapt$1.config.get("_drawer")._showEasing;const easing=showEasingAnimation||"easeOutQuart";direction[this.drawerDir]=0;this.$el.velocity(direction,this.drawerDuration,easing)}}emptyDrawer(){this.$(".drawer__holder").empty()}renderItems(){Adapt$1.trigger("drawer:empty");this.emptyDrawer();const models=this.collection.models;for(let i=0,len=models.length;i<len;i++){const item=models[i];new DrawerItemView$1({model:item})}}hideDrawer($toElement){const direction={};if(this._isVisible){this.setTrickleButtonPopupCounter();Adapt$1.a11y.popupClosed($toElement);this._isVisible=false;Adapt$1.a11y.scrollEnable("body")}else{return}if(this.disableAnimation){direction[this.drawerDir]=-this.$el.width();this.$el.css(direction).addClass("u-display-none").attr("aria-hidden","true");$(".js-shadow").addClass("u-display-none");Adapt$1.trigger("drawer:closed")}else{const showEasingAnimation=Adapt$1.config.get("_drawer")._hideEasing;const easing=showEasingAnimation||"easeOutQuart";direction[this.drawerDir]=-this.$el.width();this.$el.velocity(direction,this.drawerDuration,easing,_.bind((function(){this.$el.addClass("u-display-none").attr("aria-hidden","true");Adapt$1.trigger("drawer:closed");Adapt$1.a11y.focus(".nav__menu-btn")}),this));$(".js-shadow").velocity({opacity:1},{duration:this.drawerDuration,complete(){$(".js-shadow").addClass("u-display-none")}})}this._isCustomViewVisible=false;this.removeShadowEvent()}setTrickleButtonPopupCounter(){if(this.isPinned){Adapt$1.trigger("popup:opened");this.isPinned=false}}addShadowEvent(){$(".js-shadow").one("click touchstart",(()=>{var pinnedToggle=$(".pinned-menu");if(pinnedToggle.length==0){this.onCloseDrawerMenu()}}))}removeShadowEvent(){$(".js-shadow").off("click touchstart")}remove(){Backbone.View.prototype.remove.apply(this,arguments);$(window).off("keyup",this.onKeyUp);Adapt$1.trigger("drawer:empty");this.collection.reset();$(".js-shadow").remove()}}Object.assign(MenuDrawerView,{childContainer:".js-drawer-holder",childView:DrawerItemView$1});var MenuDrawerView$1=__AMD("extensions/adapt-course-menu/js/menuDrawerView",MenuDrawerView);const DrawerCollection=new Backbone.Collection(null,{comparator:"drawerOrder"});const Drawer={};Drawer.addItem=function(drawerObject,eventCallback){drawerObject.eventCallback=eventCallback;DrawerCollection.add(drawerObject)};Drawer.triggerCustomView=function(view,hasBackButton){if(hasBackButton!==false){hasBackButton=true}Adapt$1.trigger("menudrawer:triggerCustomView",view,hasBackButton)};Adapt$1.on({"adapt:start"(){new MenuDrawerView$1({collection:DrawerCollection})},"app:languageChanged"(){Adapt$1.trigger("drawer:remove")}});__AMD("extensions/adapt-course-menu/js/menuDrawer",Adapt$1.menudrawer=Drawer);class CourseMenu extends Backbone.Controller{initialize(){Adapt$1.on({"app:dataReady":this.onDataReady.bind(this),"app:languageChanged":function(){this.stopListening()}.bind(this)})}onDataReady(){let config=Adapt$1.config.get("_courseMenu");if(config?._isEnabled){this.setUpEventListeners()}}setUpEventListeners(){this.listenTo(Adapt$1,{"router:menu":this.renderMenuViews,"router:page":this.renderPageViews})}renderMenuViews(view){new CourseTitleView$1({model:view}).$el.insertAfter(".nav__back-btn");(new MenuButtonView).$el.insertAfter(".nav__back-btn")}renderPageViews(view){new CourseTitleView$1({model:view}).$el.insertAfter(".nav__back-btn");(new MenuButtonView).$el.insertAfter(".nav__back-btn")}}__AMD("extensions/adapt-course-menu/js/adapt-course-menu",new CourseMenu);class ImageEnlargePopupView extends Backbone.View{events(){return{"click .image-enlarge-popup__text-btn":"onClick","click .image-enlarge-popup__zoom-btn":"dropDownClick","click .zoom-view":"dropDownOptionClick","keyup .zoom-view":"dropDownOptionFocus"}}className(){return"image-enlarge-popup__inner enlarge-popup"}initialize(config){this.listenTo(Adapt$1,"remove",this.remove);this.courseConfig=Adapt$1.course.get("_imageEnlarge");this.componentConfig=this.model.get("_imageEnlarge");this.graphicConfig=this.model.get("_graphic")||this.model.getActiveItem()?.get("_graphic");this.config=this.componentConfig;if(!this.config?._imageTextBtn){this.config._imageTextBtn=this.courseConfig?._imageTextBtn.text}if(!this.config?._dropDownText){this.config._dropDownText=this.courseConfig?._dropDownAriaLabelForZoom?.text}if(this.graphicConfig?.attribution||this.graphicConfig?.longdescription){this.config._isIncludeAttribution=true}if(this.componentConfig?._text?._isAttributionIncluded||this.componentConfig?._text?._isDescriptionIncluded){this.config._isIncludeAttributionBtn=true}this.render()}onClick(event){const $btn=$(event.currentTarget);this.toggleItem($btn)}toggleItem($btn){let $parentContainer=$btn.parent().siblings(".image-enlarge-popup__text");let isOpen=$btn.attr("aria-expanded");let changeTo=isOpen=="true"?"closed":"opened";if(changeTo==="opened"){$parentContainer.slideDown();$btn.attr("aria-expanded","true");$parentContainer.removeClass("slide-down");Adapt$1.trigger("drawer:opened")}if(changeTo==="closed"){$parentContainer.slideUp();$btn.attr("aria-expanded","false");$parentContainer.addClass("slide-down");Adapt$1.trigger("drawer:closed")}}dropDownClick(event){const $btn=$(event.currentTarget);this.toggleDropdown($btn)}toggleDropdown($btn){let $parentContainer=$btn.siblings(".image-enlarge-popup__zoom-drop-down-list");let isOpen=$btn.attr("aria-expanded");let changeTo=isOpen=="true"?"closed":"opened";if(changeTo==="opened"){$parentContainer.slideDown();$btn.attr("aria-expanded","true");$btn.parent().addClass("slideUp").removeClass("slideDown");$parentContainer.removeClass("u-display-none");Adapt$1.trigger("drawer:opened")}if(changeTo==="closed"){$parentContainer.slideUp();$btn.attr("aria-expanded","false");$btn.parent().addClass("slideDown").removeClass("slideUp");$parentContainer.addClass("u-display-none");Adapt$1.trigger("drawer:closed")}}dropDownOptionClick(e){let fitType=$(e.target).attr("data-view");this.imageEnlargezoom(e,fitType)}dropDownOptionFocus(e){if(e.which==13){this.dropDownOptionClick(e)}}imageEnlargezoom(element,itemValue){$(element.target).closest(".image-enlarge-popup__inner").attr("data-image-zoom",itemValue).addClass(itemValue);$(element.target).closest(".image-enlarge-popup__inner").removeClass((function(index,className){return(className.match(/(^|\s)fit-\S+/g)||[]).join("")})).addClass(itemValue);$(".drop-value").show().text($(element.target).attr("data-display"));this.toggleDropdown($(element.target).closest(".image-enlarge-popup__zoom-drop-down").find(".image-enlarge-popup__zoom-btn"));$(element.target).parent().addClass("selected").siblings().removeClass("selected");let data={};data.zoomLevel=$(element.target).attr("data-display");data.category="resize";Adapt$1.trigger("image:resize",data)}render(){const data=this.model.toJSON();if(!this.model.get("_graphic")){data._graphic=this.model.getActiveItem()?.get("_graphic");data._graphic.large=data._graphic.src}const template=Handlebars.templates["image-enlarge-popup"];this.$el.html(template(data));if(this.config?._text?._isAttributionIncluded||this.config?._text?._isDescriptionIncluded){this.$el.addClass("has-image-text")}}}var ImageEnlargePopupView$1=__AMD("extensions/adapt-image-enlarge/js/ImageEnlargePopupView",ImageEnlargePopupView);class ImageEnlargeView extends Backbone.View{initialize(options){this._isPopupOpen=false;this.listenTo(Adapt$1,{remove:this.remove,"device:changed":this.reRender});this.parentView=options.view;this.courseConfig=Adapt$1.course.get("_imageEnlarge");this.componentConfig=this.model.get("_imageEnlarge");this.config=this.componentConfig;if(this.config?._text?._isAttributionIncluded||this.config?._text?._isDescriptionIncluded){if(this.model.get("_component")==="graphic"&&this.config?._text?._isAttributionIncluded&&!this.config?._text?._isDescriptionIncluded){this.$el.find(".graphic__image-container").addClass("hover-image")}else{this.$el.find(".graphic__widget").addClass("hover-image");this.$el.find(".narrative__slider-image-container, .accordion-item__image").parent().addClass("hover-image");this.$el.find(".laerdal-narrative__slider-image-container, .laerdal-image-slider__slider-image").addClass("hover-image")}}else{this.$el.find(".graphic__image, .laerdal-narrative__slider-image, .narrative__slider-image, .accordion-item__image, .laerdal-image-slider__slider-image").addClass("hover-image")}this.$el.addClass("image-enlarge");this.setupClickableGraphic()}reRender(){if(device$1.screenSize=="small"){if(this._isPopupOpen){Adapt$1.trigger("notify:close");this._isPopupOpen=false}this.$el.find(".graphic__widget, .laerdal-narrative__slider-image-container, .narrative__slider-image-container, .accordion-item__image-container, laerdal-image-slider__slider-image-container").addClass("disable-popup")}else{this.$el.find(".graphic__widget, .laerdal-narrative__slider-image-container, .narrative__slider-image-container, .accordion-item__image-container, .laerdal-image-slider__slider-image-container").removeClass("disable-popup")}}setupClickableGraphic(){this.reRender();this.$(".laerdal-narrative__slider-image-container").attr("role","button").attr("aria-label",this.componentConfig?._ariaLabel).on("click",this.onNarrativeClicked.bind(this)).on("keydown",this.onNarrativeKeydown.bind(this));this.$(".graphic__widget").attr("tabindex",0).attr("role","button").attr("aria-label",this.componentConfig?._ariaLabel).on("click",this.onGraphicClicked.bind(this)).on("keydown",this.onGraphicKeydown.bind(this));this.$(".accordion-item__image-container").attr("tabindex",0).attr("role","button").attr("aria-label",this.componentConfig?._ariaLabel).on("click",this.onAccordionGraphicClicked.bind(this)).on("keydown",this.onAccordionGraphicKeydown.bind(this));this.$(".narrative__slider-image-container").attr("role","button").attr("aria-label",this.componentConfig?._ariaLabel).on("click",this.onNarrativeClicked.bind(this)).on("keydown",this.onNarrativeKeydown.bind(this)).filter(".is-active").attr("tabindex",0);this.$(".laerdal-image-slider__slider-image-container").attr("role","button").attr("aria-label",this.componentConfig?._ariaLabel).on("click",this.onImageSliderClicked.bind(this)).on("keydown",this.onImageSliderKeydown.bind(this)).filter(".is-active").attr("tabindex",0)}onGraphicKeydown(event){if(event.keyCode===13||event.keyCode===32){this.onGraphicClicked()}}onNarrativeKeydown(event){if(event.keyCode===13||event.keyCode===32){this.onNarrativeClicked()}}onGraphicClicked(event){this._isPopupOpen=true;notify$1.popup({_classes:"image-enlarge-popup image-enlarge-graphic",title:this.model.get("_graphic").alt,_view:new ImageEnlargePopupView$1({model:this.model})})}onNarrativeClicked(event){this._isPopupOpen=true;const active=this.model.getActiveItem();if(!active)return;let mediaGraphic=active.get("_graphic");mediaGraphic.large=mediaGraphic.small||mediaGraphic.src;const graphicTitle=active.get("title");this.model.set("_graphic",mediaGraphic);notify$1.popup({_classes:"image-enlarge-popup image-enlarge-narrative-popup",title:graphicTitle,_view:new ImageEnlargePopupView$1({model:this.model})})}onAccordionGraphicClicked(event){const graphic=this.model.getActiveItem()?.get("_graphic");this._isPopupOpen=true;notify$1.popup({_classes:"image-enlarge-popup image-enlarge-accordion",title:graphic?.alt||"",_view:new ImageEnlargePopupView$1({model:this.model})})}onAccordionGraphicKeydown(event){if(event.keyCode===13||event.keyCode===32){this.onAccordionGraphicClicked()}}onImageSliderClicked(event){this._isPopupOpen=true;const active=this.model.getActiveItem();if(!active)return;let mediaGraphic=active.get("_graphic");mediaGraphic.large=mediaGraphic.small||mediaGraphic.src;const graphicTitle=active.get("title");this.model.set("_graphic",mediaGraphic);notify$1.popup({_classes:"image-enlarge-popup image-enlarge-image-slider-popup",title:graphicTitle,_view:new ImageEnlargePopupView$1({model:this.model})})}onImageSliderKeydown(event){if(event.keyCode===13||event.keyCode===32){this.onImageSliderClicked()}}}var ImageEnlargeView$1=__AMD("extensions/adapt-image-enlarge/js/ImageEnlargeView",ImageEnlargeView);class ImageEnlargeController extends Backbone.Controller{initialize(){this.listenTo(Adapt$1,"app:dataReady",this.onDataReady)}onDataReady(){const config=Adapt$1.config.get("_imageEnlarge");if(!config||!config._isEnabled)return;this.setUpEventListeners()}setUpEventListeners(){this.listenTo(Adapt$1,"componentView:postRender",this.onComponentPostRender)}onComponentPostRender(view){const componentConfig=view.model.get("_imageEnlarge");if(componentConfig&&componentConfig._isEnabled){new ImageEnlargeView$1({model:view.model,el:view.$el})}if(!view||view.model.get("_component")!=="narrative")return;const model=view.model;if(componentConfig._isEnabled===true){view.listenTo(model.getChildren(),"change:_isActive",this.onItemsActiveChange)}}onItemsActiveChange(item,_isActive){const index=item.get("_index");const indexSelector=`[data-index="${index}"]`;if(_isActive===true){this.$(".narrative__slider-image-container").attr("tabindex","-1").filter(indexSelector).attr("tabindex",0)}}}__AMD("extensions/adapt-image-enlarge/js/adapt-image-enlarge",new ImageEnlargeController);Adapt$1.on("questionView:showFeedback componentView:postRender",(function(view){if(!view.model.get("feedbackMessage")){return}if(view.model.get("_userAnswer")?.length==0){return}var feedbackView=new FeedbackView({model:view.model,parentView:view});view.$(".inline-feedback").remove();let answerSpecificFeedbackSupportedComponents=["gmcq","laerdal-checklist","mcq"];if(answerSpecificFeedbackSupportedComponents.includes(view.model.get("_component"))&&view.model.isSingleSelect()&&!view.model.get("_isCorrect")){let selectedOptions=view.model.getActiveItem();let index=selectedOptions.get("_index");if(selectedOptions.get("feedback")===null||selectedOptions.get("feedback")===""){customAppend(view,".component__widget",feedbackView.$el)}else{customAppend(view,"label[data-adapt-index="+index+"]",feedbackView.$el)}}else{customAppend(view,".component__widget",feedbackView.$el)}}));function customAppend(view,selector,element){let elements=selector!=".component__widget"?view.$(selector).closest(".component__widget"):view.$(selector);elements.each((function(){$(this).append(element)}))}class FeedbackView extends Backbone.View{className(){let config=Adapt$1.config.get("_inlineFeedback");let hidePartiallyFeedback=Adapt$1?.course?.get("themeVariables")?._components?._hidePartiallyFeedback;return["inline-feedback",this.model.get("_isCorrect")?"is-correct":"",this.model.get("_isAtLeastOneCorrectSelection")?hidePartiallyFeedback&&!this.model.get("_isCorrect")&&this.model.get("_isPartlyCorrect")?"is-incorrect":"is-partially-correct":"is-incorrect",config?._useSemanticColors&&!(this.model.get("_inlineFeedback")&&this.model.get("_inlineFeedback").disableSemanticColors)?"use-semantic-colors":""].join(" ")}initialize(options){this.parentView=options.parentView;this.setupListeners();this.render();this.postRender()}setupListeners(){this.listenTo(this.model,"change:_isSubmitted remove",this.remove)}render(){let hidePartiallyFeedback=Adapt$1?.course?.get("themeVariables")?._components?._hidePartiallyFeedback;let data=this.model.toJSON();if(hidePartiallyFeedback&&data?._isPartlyCorrect&&!data?._isCorrect){let attemptsLeft=data._attemptsLeft||0;let feedback=data._feedback?._incorrect;let finalFeedback=feedback?.final;let notFinalFeedback=feedback?.notFinal;data.feedbackMessage=attemptsLeft===0?finalFeedback:notFinalFeedback}let template=Handlebars.templates["inline-feedback"];this.$el.html(template(data));return this}postRender(){}remove(){super.remove()}}__AMD("extensions/adapt-inline-feedback/js/adapt-inline-feedback",FeedbackView);$("head").append('<link rel="stylesheet" type="text/css" href="libraries/plyr.css">');require(["core/js/adapt","libraries/vimeo-plyr","Plyr"],(function(Adapt,VimeoPlayer,Plyr){window.Vimeo={};window.Vimeo.Player=VimeoPlayer;window.Plyr=Plyr;Adapt.trigger("plyr:ready")}));class NavigationHelper{constructor(pageModel){this.pageModel=pageModel;this.loopStyle="allPages"}getReturnToPreviousLocation(){return Adapt$1.location._previousId?Adapt$1.findById(Adapt$1.location._previousId):null}getCurrentMenu(){var parents=this.pageModel.getAncestorModels();for(var i=0,l=parents.length;i<l;i++){var model=parents[i];switch(model.get("_type")){case"menu":case"course":return model}}}getSiblingPages(){var currentMenu=this.getCurrentMenu();var siblingModels=currentMenu.getAllDescendantModels(true);siblingModels=_.filter(siblingModels,(function(model){return model.get("_type")==="page"&&model.get("_isAvailable")}));return siblingModels}getPrevPage(){var currentPageId=this.pageModel.get("_id");var pages=this.getPages();var hasFoundCurrentPage=false;for(var i=pages.length-1;i>-1;i--){var page=pages[i];var isNotAvailable=!page.get("_isAvailable");if(isNotAvailable)continue;if(!hasFoundCurrentPage&&page.get("_id")===currentPageId){hasFoundCurrentPage=true;continue}if(hasFoundCurrentPage){return page}}return}getNextPage(){var currentPageId=this.pageModel.get("_id");var pages=this.getPages();var hasFoundCurrentPage=false;for(var i=0,l=pages.length;i<l;i++){var page=pages[i];var isNotAvailable=!page.get("_isAvailable");if(isNotAvailable)continue;if(!hasFoundCurrentPage&&page.get("_id")===currentPageId){hasFoundCurrentPage=true;continue}if(hasFoundCurrentPage){return page}}return}getPrevPage(){var currentPageId=this.pageModel.get("_id");var pages=this.getPages();var hasFoundCurrentPage=false;for(var i=pages.length-1;i>-1;i--){var page=pages[i];var isNotAvailable=!page.get("_isAvailable");if(isNotAvailable)continue;if(!hasFoundCurrentPage&&page.get("_id")===currentPageId){hasFoundCurrentPage=true;continue}if(hasFoundCurrentPage){return page}}return}getPages(){if(!this.loopStyle)return[];var loop=false;var descendants;switch(this.loopStyle){case"allPages":loop=true;descendants=Adapt$1.course.getAllDescendantModels(true);break;case"siblings":loop=true;default:var currentMenu=this.getCurrentMenu();descendants=currentMenu.getAllDescendantModels(true)}if(loop){descendants=descendants.concat(descendants)}return _.filter(descendants,(function(model){return model.get("_type")==="page"}))}}var NavigationHelper$1=__AMD("extensions/adapt-navigation-footer/js/navigationHelper",NavigationHelper);class NavigationFooterView extends Backbone.View{className(){return"navigation-footer"}events(){return{"click .btn-home":"onHomeClick","click .btn-up":"onUpClick","click .btn-previous":"onPreviousClick","click .btn-next":"onNextClick","click .btn-close":"onCloseClick","click .btn-custom":"onCustomClick"}}initialize(options){this.parent=options.parent;this.pageConfig=this.model.get("_navigationFooter");this.courseConfig=Adapt$1.course.get("_navigationFooter");this.config=this.pageConfig;this.updateOverrideValues();this.nextPage=new NavigationHelper$1(this.model).getNextPage();this.prevPage=new NavigationHelper$1(this.model).getPrevPage();this.parentMenu=new NavigationHelper$1(this.model).getCurrentMenu();this.setupListeners();this.render();this.postRender()}updateOverrideValues(){this.config._footerText.text=this.pageConfig._footerText.text?this.pageConfig._footerText.text:this.courseConfig._footerText.text;this.config._buttons._home._isEnabled=this.getOverrideValue(this.pageConfig._buttons._home,this.courseConfig._buttons._home);this.config._buttons._up._isEnabled=this.getOverrideValue(this.pageConfig._buttons._up,this.courseConfig._buttons._up);this.config._buttons._up.btnText=this.pageConfig._buttons._up.btnText?this.pageConfig._buttons._up.btnText:this.courseConfig._buttons._up.btnText;this.config._buttons._up._classes=this.pageConfig._buttons._up._classes?this.pageConfig._buttons._up._classes:this.courseConfig._buttons._up._classes;this.config._buttons._previous._isEnabled=this.getOverrideValue(this.pageConfig._buttons._previous,this.courseConfig._buttons._previous);this.config._buttons._previous.btnText=this.pageConfig._buttons._previous.btnText?this.pageConfig._buttons._previous.btnText:this.courseConfig._buttons._previous.btnText;this.config._buttons._previous._classes=this.pageConfig._buttons._previous._classes?this.pageConfig._buttons._previous._classes:this.courseConfig._buttons._previous._classes;this.config._buttons._next._isEnabled=this.getOverrideValue(this.pageConfig._buttons._next,this.courseConfig._buttons._next);this.config._buttons._next.btnText=this.pageConfig._buttons._next.btnText?this.pageConfig._buttons._next.btnText:this.courseConfig._buttons._next.btnText;this.config._buttons._next._classes=this.pageConfig._buttons._next._classes?this.pageConfig._buttons._next._classes:this.courseConfig._buttons._next._classes;this.config._buttons._close._isEnabled=this.getOverrideValue(this.pageConfig._buttons._close,this.courseConfig._buttons._close);this.config._buttons._close.btnText=this.pageConfig._buttons._close.btnText?this.pageConfig._buttons._close.btnText:this.courseConfig._buttons._close.btnText;this.config._buttons._close._classes=this.pageConfig._buttons._close._classes?this.pageConfig._buttons._close._classes:this.courseConfig._buttons._close._classes;if(this.config._buttons._custom){this.config._buttons._custom._isEnabled=this.getOverrideValue(this.pageConfig._buttons._custom,this.courseConfig._buttons._custom);this.config._buttons._custom.btnText=this.pageConfig._buttons._custom.btnText?this.pageConfig._buttons._custom.btnText:this.courseConfig._buttons._custom.btnText;this.config._buttons._custom._classes=this.pageConfig._buttons._custom._classes?this.pageConfig._buttons._custom._classes:this.courseConfig._buttons._custom._classes;this.config._buttons._custom._id=this.pageConfig._buttons._custom._id?this.pageConfig._buttons._custom._id:this.courseConfig._buttons._custom._id;if(this.config._buttons._custom._isEnabled==true){this.config._buttons._close._isEnabled=false;this.config._buttons._next._isEnabled=false;this.config._buttons._previous._isEnabled=false;this.config._buttons._up._isEnabled=false;this.config._buttons._home._isEnabled=false}}}getOverrideValue(pageButton,globalButton){if(pageButton._enableOverride==="enable"){return true}if(pageButton._enableOverride==="disable"){return false}return globalButton._isEnabled}setupListeners(){if(this.parent){this.listenToOnce(this.parent,"postRemove",this.remove)}else{this.listenTo(Adapt$1,"remove",this.remove)}this.listenTo(this.model,"change:_isComplete",this.refresh);this.listenTo(Adapt$1.contentObjects,"change:_isLocked",this.refresh)}render(){this.config._isPageComplete=this.model.get("_isComplete");var template=Handlebars.templates["navigation-footer"];this.$el.html(template(this.config))}postRender(){this.refresh();Adapt$1.trigger(`${this.constructor.type}View:postRender view:postRender`,this)}refresh(){this.nextPage=new NavigationHelper$1(this.model).getNextPage();const lockType=this.model._parentModel.get("_lockType");const nextPageLockType=this.nextPage._parentModel?.get("_lockType");let isDisabled=this.nextPage.get("_isLocked");if(lockType==="lockLast"&&nextPageLockType!="lockLast"){this.model.set("_isDisabled",true)}if(lockType==="unlockFirst"&&nextPageLockType!="unlockFirst"){this.model.set("_isDisabled",true)}if(lockType==="custom"&&nextPageLockType!="custom"){this.model.set("_isDisabled",true)}if(lockType==="sequential"){isDisabled=this.nextPage.get("_isLocked")||!this.model.get("_isComplete")}if(lockType==="unlockFirst"&&this.model.get("_isDisabled")&&!this.model.get("_isComplete")){isDisabled=this.model.get("_isDisabled")}if(lockType==="lockLast"&&this.model.get("_isDisabled")&&!this.model.get("_isComplete")){isDisabled=this.model.get("_isDisabled")}if(lockType==="custom"&&this.model.get("_isDisabled")&&!this.model.get("_isComplete")){isDisabled=this.model.get("_isDisabled")}this.$(".btn-next").toggleClass("is-disabled",isDisabled);if(this.nextPage.get("_isComplete")&&this.nextPage.get("_isInteractionComplete")){this.nextPage.set("_isLocked",false)}if(this.model.get("_isComplete")&&this.model.get("_isInteractionComplete")){this.nextPage.set("_isLocked",false)}if(this.model.get("_isComplete")){this.$(".is-disabled").removeAttr("aria-label")}else{if(this.model.get("_navigationFooter")){if(this.model.get("_navigationFooter")._buttons._next._isEnabled){var buttonText=this.model.get("_navigationFooter")._buttons._next.btnText}else if(this.model.get("_navigationFooter")._buttons._previous._isEnabled){var buttonText=this.model.get("_navigationFooter")._buttons._previous.btnText}else if(this.model.get("_navigationFooter")._buttons._close._isEnabled){var buttonText=this.model.get("_navigationFooter")._buttons._close.btnText}else if(this.model.get("_navigationFooter")._buttons._custom._isEnabled){var buttonText=this.model.get("_navigationFooter")._buttons._custom.btnText}else{var buttonText="Next unavailable"}}else{var buttonText="Next unavailable"}this.$(".is-disabled").attr("aria-label",buttonText+" "+"unavailable")}}onHomeClick(){Adapt$1.router.navigateToHomeRoute()}onPreviousClick(){const isLogicalBackNavigation=this.courseConfig?._toggleNavigation?._isLogicalBackNavigation;if(isLogicalBackNavigation){Backbone.history.navigate("#/id/"+this.prevPage?.get("_id"),{trigger:true,replace:false})}else{Adapt$1.router.navigateToPreviousRoute()}}onUpClick(){Backbone.history.navigate("#/id/"+this.parentMenu.get("_id"),{trigger:true,replace:false})}onNextClick(){const lockType=this.model._parentModel.get("_lockType");let isLocked=this.nextPage.get("_isLocked");if(lockType==="sequential"){isLocked=this.nextPage.get("_isLocked")||!this.model.get("_isComplete")}else{if(Adapt$1.config.get("_caaRound")>0&&!this.model.get("_isInteractionComplete"))isLocked=true}if(lockType==="lockLast"||lockType==="unlockFirst"||lockType==="custom"){isLocked=this.$(".btn-next").hasClass("is-disabled")?true:false}if(isLocked){Adapt$1.notify.push({body:"<span>"+this.courseConfig?._footerText?._btnNotifyPopupText+"</span>"});this.$el.parents().find(".js-notify-push-close-btn").focus()}else{Backbone.history.navigate("#/id/"+this.nextPage.get("_id"),{trigger:true,replace:false})}}onCustomClick(){if(this.pageConfig&&(this.pageConfig._buttons._custom._id==""||this.pageConfig._buttons._custom._id==undefined)){Adapt$1.router.navigateToHomeRoute()}else{Backbone.history.navigate("#/id/"+this.pageConfig._buttons._custom._id,{trigger:true})}}onCloseClick(){Adapt$1.trigger("course:close");top.window.close()}}NavigationFooterView.type="navigationfooter";var NavigationFooterView$1=__AMD("extensions/adapt-navigation-footer/js/NavigationFooterView",NavigationFooterView);class NavigationFooterController extends Backbone.Controller{initialize(){Adapt$1.on({"app:dataReady":this.onDataReady.bind(this),"app:languageChanged":function(){this.stopListening()}.bind(this)})}onDataReady(){var config=Adapt$1.config.get("_navigationFooter");if(!config||!config._isEnabled)return;this.setUpEventListeners(config)}setUpEventListeners(config){this.listenTo(Adapt$1,"pageView:postRender",this.addFooterView)}addFooterView(view){const pageConfig=view.model.get("_navigationFooter");if(!pageConfig||pageConfig._enableOverride==="disable"){return}view.$el.find(".page__inner").append(new NavigationFooterView$1({model:view.model,parent:view}).$el)}}__AMD("extensions/adapt-navigation-footer/js/adapt-navigation-footer",new NavigationFooterController);class MenuItemView extends AdaptView$1{attributes(){return AdaptView$1.resultExtend("attributes",{role:"listitem","aria-labelledby":this.model.get("_id")+"-heading"},this)}className(){return["menu-item",this.constructor.className,this.model.get("_id"),this.model.get("_classes"),this.setVisibility(),this.setHidden(),this.model.get("_isVisited")?"is-visited":"",this.model.get("_isComplete")?"is-complete":"",this.model.get("_isLocked")?"is-locked":"",this.model.get("_isOptional")?"is-optional":""].join(" ")}preRender(){this.model.checkCompletionStatus();this.model.checkInteractionCompletionStatus()}postRender(){this.$el.imageready(this.setReadyStatus.bind(this))}}MenuItemView.type="menuItem";var MenuItemView$1=__AMD("core/js/views/menuItemView",MenuItemView);class MenuView extends ContentObjectView{}Object.assign(MenuView,{childContainer:".js-children",childView:MenuItemView$1,type:"menu",template:"menu"});var MenuView$1=__AMD("core/js/views/menuView",MenuView);var LifeMenuItemView=MenuItemView$1.extend({events:{"click .js-btn-click":"onClickMenuItemButton","keydown .js-btn-click":"onKeydown"},onKeydown:function(event){if(event.keyCode===13||event.keyCode===32){this.onClickMenuItemButton()}},onClickMenuItemButton:function(event){if(event&&event.preventDefault)event.preventDefault();if(this.model.get("_isLocked"))return;Backbone.history.navigate("#/id/"+this.model.get("_id"),{trigger:true})}},{className:"lifemenu-item",template:"lifeMenuItem"});var LifeMenuItemView$1=__AMD("menu/adapt-lifeMenu/js/adapt-lifeMenuItemView",LifeMenuItemView);var LifeMenuGroupView=MenuItemView$1.extend({postRender:function(){_.defer(this.addChildren.bind(this));this.$el.imageready(this.setReadyStatus.bind(this));this.$el.parents(".lifemenu__item-container").addClass("has-groups")}},{childContainer:".js-group-children",childView:LifeMenuItemView$1,className:"menu-group lifemenu-group",template:"lifeMenuGroup"});var LifeMenuGroupView$1=__AMD("menu/adapt-lifeMenu/js/adapt-lifeMenuGroupView",LifeMenuGroupView);var LifeMenuView=MenuView$1.extend({initialize:function(){MenuView$1.prototype.initialize.apply(this);this.setStyles();this.listenTo(Adapt$1,{"device:changed":this.onDeviceResize})},onDeviceResize:function(){this.setStyles()},addChildren:function(){var nthChild=0;var models=this.model.getChildren().models;var childViews=[];models.forEach(function(model){if(!model.get("_isAvailable"))return;nthChild++;model.set("_nthChild",nthChild);var ChildView=model.get("_type")==="menu"&&model.get("_lifeMenu")&&model.get("_lifeMenu")._renderAsGroup?LifeMenuGroupView$1:LifeMenuItemView$1;var $parentContainer=this.$(this.constructor.childContainer);var childView=new ChildView({model:model});childViews.push(childView);$parentContainer.append(childView.$el)}.bind(this));this.setChildViews(childViews)},setStyles:function(){this.setBackgroundImage();this.setBackgroundStyles();this.processHeader()},setBackgroundImage:function(){var config=this.model.get("_lifeMenu");var backgroundImages=config&&config._backgroundImage;if(!backgroundImages)return;var backgroundImage;switch(Adapt$1.device.screenSize){case"xlarge":backgroundImage=backgroundImages._xlarge;break;case"large":backgroundImage=backgroundImages._large;break;case"medium":backgroundImage=backgroundImages._medium;break;default:backgroundImage=backgroundImages._small}if(backgroundImage){this.$el.addClass("has-bg-image").css("background-image","url("+backgroundImage+")")}else{this.$el.removeClass("has-bg-image").css("background-image","")}},setBackgroundStyles:function(){var config=this.model.get("_lifeMenu");var styles=config&&config._backgroundStyles;if(!styles)return;this.$el.css({"background-repeat":styles._backgroundRepeat,"background-size":styles._backgroundSize,"background-position":styles._backgroundPosition})},processHeader:function(){var config=this.model.get("_lifeMenu");var header=config&&config._menuHeader;if(!header)return;let $header;if(header._displayAboveHeader){let $backgroundPlaceholder=this.$(".menu__header-background");if(!$backgroundPlaceholder.length){this.$(".menu__inner").prepend('<div class="menu__header-background"></div>');$backgroundPlaceholder=this.$(".menu__header-background")}$header=this.$(".menu__header-background")}else{$header=this.$(".menu__header")}this.setHeaderBackgroundImage(header,$header);this.setHeaderBackgroundStyles(header,$header);this.setHeaderMinimumHeight(header,$header)},setHeaderBackgroundImage:function(config,$header){var backgroundImages=config._backgroundImage;if(!backgroundImages)return;var backgroundImage;switch(Adapt$1.device.screenSize){case"xlarge":backgroundImage=backgroundImages._xlarge;break;case"large":backgroundImage=backgroundImages._large;break;case"medium":backgroundImage=backgroundImages._medium;break;default:backgroundImage=backgroundImages._small}if(backgroundImage){$header.addClass("has-bg-image").css("background-image","url("+backgroundImage+")")}else{$header.removeClass("has-bg-image").css("background-image","")}},setHeaderBackgroundStyles:function(config,$header){var styles=config._backgroundStyles;if(!styles)return;$header.css({"background-repeat":styles._backgroundRepeat,"background-size":styles._backgroundSize,"background-position":styles._backgroundPosition})},setHeaderMinimumHeight:function(config,$header){var minimumHeights=config._minimumHeights;if(!minimumHeights)return;var minimumHeight;switch(Adapt$1.device.screenSize){case"xlarge":minimumHeight=minimumHeights._xlarge;break;case"large":minimumHeight=minimumHeights._large;break;case"medium":minimumHeight=minimumHeights._medium;break;default:minimumHeight=minimumHeights._small}if(minimumHeight){$header.addClass("has-min-height").css("min-height",minimumHeight+"px")}else{$header.removeClass("has-min-height").css("min-height","")}}},{className:"lifemenu",template:"lifemenu"});components$1.register("course menu",{view:LifeMenuView});components$1.register("lifeMenu",{view:LifeMenuView,model:MenuModel$1.extend({})});var ThemeView=__AMD("theme/6130a5fd5ff6d107661a236f/js/themeView",class ThemeView extends Backbone.View{className(){}initialize(){this.setStyles();this.listenTo(Adapt$1,{"device:changed":this.onDeviceResize,remove:this.remove})}onDeviceResize(){this.setStyles()}remove(){Backbone.View.prototype.remove.call(this);this.onRemove()}setStyles(){this.setClasses();this.setTextAlignment();this.addBackgroundLayer();this.setBackgroundImage();this.setBackgroundStyles();this.setMinimumHeight();this.setResponsiveClasses();this.setCustomStyles()}setClasses(){this.$el.addClass(this.className())}setTextAlignment(){const textAlignment=this.model.get("_textAlignment");if(!textAlignment)return;if(textAlignment._title)this.$el.addClass(`title-align-${textAlignment._title}`);if(textAlignment._body)this.$el.addClass(`body-align-${textAlignment._body}`);if(textAlignment._instruction)this.$el.addClass(`instruction-align-${textAlignment._instruction}`)}addBackgroundLayer(){if(this.$el.find(" > .background").length)return;this.$background=$('<div class="background" aria-hidden="true"></div>').prependTo(this.$el)}setBackgroundImage(){const backgroundImages=this.model.get("_backgroundImage");if(!backgroundImages)return;const backgroundImage=backgroundImages[`_${Adapt$1.device.screenSize}`]??backgroundImages._small;this.$el.toggleClass("has-bg-image",Boolean(backgroundImage));this.$background.css("background-image",backgroundImage?"url("+backgroundImage+")":"")}setBackgroundStyles(){const styles=this.model.get("_backgroundStyles");if(!styles)return;this.$background.css({"background-repeat":styles._backgroundRepeat,"background-size":styles._backgroundSize,"background-position":styles._backgroundPosition})}setMinimumHeight(){const minimumHeights=this.model.get("_minimumHeights");if(!minimumHeights)return;const minimumHeight=minimumHeights[`_${Adapt$1.device.screenSize}`]??minimumHeights._small;this.$el.toggleClass("has-min-height",Boolean(minimumHeight)).css("min-height",minimumHeight?minimumHeight+"px":"")}setResponsiveClasses(){const responsiveClasses=this.model.get("_responsiveClasses");if(!responsiveClasses)return;this.$el.removeClass(Object.values(responsiveClasses)).addClass(responsiveClasses[`_${Adapt$1.device.screenSize}`])}setCustomStyles(){}onRemove(){}});var ThemePageView=__AMD("theme/6130a5fd5ff6d107661a236f/js/themePageView",class ThemePageView extends ThemeView{className(){}setCustomStyles(){this.processHeader()}processHeader(){var header=this.model.get("_pageHeader");if(!header)return;var $header=this.$(".page__header");this.setHeaderTextAlignment(header);this.addHeaderBackgroundLayer($header);this.setHeaderBackgroundImage(header,$header);this.setHeaderBackgroundStyles(header,$header);this.setHeaderMinimumHeight(header,$header)}setHeaderTextAlignment(config){const textAlignment=config._textAlignment;if(!textAlignment)return;if(textAlignment._title)this.$el.addClass(`title-align-${textAlignment._title}`);if(textAlignment._body)this.$el.addClass(`body-align-${textAlignment._body}`);if(textAlignment._instruction)this.$el.addClass(`instruction-align-${textAlignment._instruction}`)}addHeaderBackgroundLayer($header){if($header.find(" > .background").length)return;this.$headerBackground=$('<div class="background" aria-hidden="true"></div>').prependTo($header)}setHeaderBackgroundImage(config,$header){var backgroundImages=config._backgroundImage;if(!backgroundImages)return;const backgroundImage=backgroundImages[`_${Adapt$1.device.screenSize}`]??backgroundImages._small;$header.toggleClass("has-bg-image",Boolean(backgroundImage));this.$headerBackground?.css("background-image",backgroundImage?"url("+backgroundImage+")":"")}setHeaderBackgroundStyles(config,$header){var styles=config._backgroundStyles;if(!styles)return;this.$headerBackground.css({"background-repeat":styles._backgroundRepeat,"background-size":styles._backgroundSize,"background-position":styles._backgroundPosition})}setHeaderMinimumHeight(config,$header){var minimumHeights=config._minimumHeights;if(!minimumHeights)return;const minimumHeight=minimumHeights[`_${Adapt$1.device.screenSize}`]??minimumHeights._small;$header.toggleClass("has-min-height",Boolean(minimumHeight)).css("min-height",minimumHeight?minimumHeight+"px":"")}});var ThemeArticleView=__AMD("theme/6130a5fd5ff6d107661a236f/js/themeArticleView",class ThemeArticleView extends ThemeView{className(){}setCustomStyles(){}onRemove(){}});var ThemeBlockView=__AMD("theme/6130a5fd5ff6d107661a236f/js/themeBlockView",class ThemeBlockView extends ThemeView{className(){return this.model.get("_isDividerBlock")?"is-divider-block":""}setCustomStyles(){this.setPaddingTop();this.setPaddingBottom();this.setComponentVerticalAlignment();this.setComponentHorizontalAlignment();this.setBlockColor()}setPaddingTop(){const themeConfigPaddingTop=Adapt$1.course.get("themeVariables")?._blocks?._paddingTop;const blockLevelPaddingTop=this.model.get("_paddingTop");this.applyPadding(this.$el,themeConfigPaddingTop,blockLevelPaddingTop,"padding-top")}setPaddingBottom(){const themeConfigPaddingBottom=Adapt$1.course.get("themeVariables")?._blocks?._paddingBottom;const blockLevelPaddingBottom=this.model.get("_paddingBottom");this.applyPadding(this.$el,themeConfigPaddingBottom,blockLevelPaddingBottom,"padding-bottom")}applyPadding($element,themeConfigValue,blockLevelValue,paddingSide){if(blockLevelValue==="default"){if(themeConfigValue){$element.addClass(`${themeConfigValue}-${paddingSide}`)}}else{if(blockLevelValue){$element.addClass(`${blockLevelValue}-${paddingSide}`)}}}setBlockColor(){const blockColorVariables=this.model.get("_blockColors")||{};if(!blockColorVariables)return;const{"block-bg-color":blockBgColor,"block-font-color":blockFontColor,"block-header-color":blockHeaderColor}=blockColorVariables;if(blockBgColor){this.$el.css("background",blockBgColor)}if(blockFontColor){const selectors=".block, .block__title, .block__body, .block__instruction";this.$el.find(selectors).css("color",blockFontColor)}if(blockHeaderColor){this.$el.find(".block__title").css("color",blockHeaderColor)}}setComponentVerticalAlignment(){const componentVerticalAlignment=this.model.get("_componentVerticalAlignment");if(!componentVerticalAlignment)return;switch(componentVerticalAlignment){case"center":this.$el.addClass("align-vert-center");break;case"bottom":this.$el.toggleClass("align-vert-bottom");break;default:this.$el.toggleClass("align-vert-top");break}}setComponentHorizontalAlignment(){const componentHorizontalAlignment=this.model.get("_componentHorizontalAlignment");if(!componentHorizontalAlignment)return;this.$el.addClass(`align-horz-${componentHorizontalAlignment}`)}onRemove(){}});var ThemeComponentView=__AMD("theme/6130a5fd5ff6d107661a236f/js/themeComponentView",class ThemeComponentView extends ThemeView{className(){}setCustomStyles(){this.handleTitleIcons();this.setComponentColors();this.setupEventListeners();this.checkCanShowFinalMarking()}setupEventListeners(){const componentModel=this.model.get("viewModel");if(componentModel.get("_isQuestionType")){this.listenTo(componentModel,{"change:_isSubmitted":this.onQuestionSubmitted.bind(this)})}}onQuestionSubmitted(){this.hideFeedbackOnFirstAttempt();_.defer(this.checkCanShowFinalMarking.bind(this))}hideFeedbackOnFirstAttempt(){const hideFeedbackOnFirstAttempt=Adapt$1.course.get("themeVariables")._components?._hideFeedbackFirstAttempt;if(!hideFeedbackOnFirstAttempt)return;Adapt$1.articles?.models?.forEach((article=>{if(!article?.isAssessmentEnabled?.()||article?.get("_attemptsSpent")!==0)return;Adapt$1.components?.models?.forEach((item=>{item.set("_previousCompCanShowFeedback",item.get("_canShowFeedback"));item.set("_canShowFeedback",false)}))}))}checkCanShowFinalMarking(){const canShowFinalMarking=Adapt$1.course.get("themeVariables")._components?._canShowFinalMarking;if(!canShowFinalMarking){return}const componentModel=this.model.get("viewModel");if(!componentModel.get("_isQuestionType")){return}const isSubmitted=componentModel.get("_isSubmitted");if(isSubmitted&&componentModel.get("_canShowMarking")){componentModel.set("_shouldShowMarking",true);this.$el.find(".component__widget").addClass("show-user-answer can-show-final-marking")}}setComponentColors(){const componentColorVariables=this.model.get("_componentColors")||{};if(!componentColorVariables)return;const{"component-bg-color":componentBgColor,"component-font-color":componentFontColor,"component-header-color":componentHeaderColor}=componentColorVariables;if(componentBgColor){this.$el.find(".component__inner").css("background",componentBgColor)}if(componentFontColor){const selectors=".component, .component__title, .component__body, .component__instruction";this.$el.find(selectors).css("color",componentFontColor)}if(componentHeaderColor){this.$el.find(".component__title").css("color",componentHeaderColor)}}handleTitleIcons(){const classes=this.model.get("_classes")?.split(" ");let titleIcon=classes?.find((className=>className.includes("title-icon")));if(titleIcon){const template=Handlebars.templates["title-icon"];this.$el.find(".component__title-inner").prepend(template({icon:titleIcon.replace("title-","")}));this.$el.addClass("has-title-icon")}}onRemove(){}});class Theme extends Backbone.Controller{initialize(){this.listenTo(Adapt$1,{"app:dataReady":this.onDataReady,"pageView:postRender articleView:postRender blockView:postRender componentView:postRender":this.onPostRender})}onDataReady(){$("html").addClass(Adapt$1.course.get("_courseStyle"));this.addFavIcon();this.setupHeadingLevelClass();this.setupSpriteSheets();this.setupCustomIconTemplates();this.setupGlobalStyles()}addFavIcon(){const theme=Adapt$1.course.get("_life");if(!theme?._favIcon?._src)return;const $linkStandard=$(`<link rel="icon" href="${theme._favIcon._src}" size="192x192" />`);const $linkApple=$(`<link rel="apple-touch-icon" href="${theme._favIcon._src}" />`);$("head").append($linkStandard).append($linkApple)}setupHeadingLevelClass(){const headerIndicatorTypes=["menu","menuItem","page","article","block","component"];const headerIndicatorEventNames=headerIndicatorTypes.concat([""]).join("View:render ");this.listenTo(Adapt$1,headerIndicatorEventNames,this.addHeadingLevelClass)}async setupSpriteSheets(){const themeConfig=Adapt$1.course.get("themeVariables");const spriteSheets=themeConfig?._course?._svgSpriteSheets;if(!spriteSheets?.length)return;for(const spriteSheet of spriteSheets){const id=spriteSheet._spriteSheetId;const response=await fetch(spriteSheet.src);const blob=await response.blob();const spriteSheetURL=URL.createObjectURL(blob);Adapt$1.set(`custom-icons_${id}`,spriteSheetURL)}}setupCustomIconTemplates(){Handlebars.registerHelper("icon-single",(function(iconName){const themeConfig=Adapt$1.course.get("themeVariables");const iconMap=themeConfig?._course?._singleIcons;if(!iconMap?.length)return;const foundIcon=iconMap.find((iconRef=>iconRef.iconId===iconName));if(!foundIcon)return;return new Handlebars.SafeString(`<span class="custom-icon-container inline-icon" aria-hidden='true'>\n        <img src="${foundIcon.src}" class="custom-icon single"/>\n        </span>`)}));Handlebars.registerHelper("icon-sprite",(function(iconSetName,iconName){const foundSpriteSheet=Adapt$1.get(`custom-icons_${iconSetName}`);if(!foundSpriteSheet)return;return new Handlebars.SafeString(`<span class="custom-icon-container inline-icon" aria-hidden='true'>\n        <svg class="custom-icon sprite">\n        <use xlink:href="${foundSpriteSheet}#${iconName}"></use>\n        </svg>\n        </span>`)}))}setupGlobalStyles(){const themeVariables=Adapt$1.course.get("themeVariables");if(!themeVariables)return;const root=document.documentElement;const blockStyles=themeVariables._blockStyles;const blockBgColor=blockStyles?blockStyles["block-bg-color"]:null;if(blockBgColor){$("html").addClass("has-block-bg-color");const blockBgColorInverted=this.getInvertedColor(blockBgColor);root.style.setProperty("--block-bg-color",blockBgColor);root.style.setProperty("--block-bg-color-inverted",blockBgColorInverted)}const componentStyles=themeVariables._items;const componentBgColor=componentStyles?componentStyles["component-bg-color"]:null;if(componentBgColor){$("html").addClass("has-component-bg-color");const componentBgColorInverted=this.getInvertedColor(componentBgColor);root.style.setProperty("--component-bg-color",componentBgColor);root.style.setProperty("--component-bg-color-inverted",componentBgColorInverted)}}getInvertedColor(hexColor){const r=parseInt(hexColor.substr(1,2),16);const g=parseInt(hexColor.substr(3,2),16);const b=parseInt(hexColor.substr(5,2),16);const luminance=(.299*r+.587*g+.114*b)/255;return luminance>.5?"#000000":"#FFFFFF"}addHeadingLevelClass(view){_.defer((function(){const titleSelector="."+view.model.get("_type")+"__title";const subTitlesSelector="."+view.model.get("_type")+"__subtitle-inner";const $subTitles=$(view.$(subTitlesSelector));const $title=$(view.$(titleSelector));if($title.length>0){const ariaHeadingLevel=$title.find(".js-heading-inner").attr("aria-level");const $headings=$subTitles.find("[role='heading']");if($headings.length>0){$headings.addClass("some-class")}$title.addClass("aria-heading-"+ariaHeadingLevel);if($subTitles.length>0){if($($subTitles).attr("role")=="heading"){$subTitles.attr("aria-level",parseInt(ariaHeadingLevel)+1)}}}}))}onPostRender(view){const viewModel=view.model;const el=view.$el;const theme=viewModel.get("_life");if(!theme)return;const model=new Backbone.Model(theme);model.set("viewModel",viewModel);try{switch(viewModel.get("_type")){case"page":new ThemePageView({model:model,el:el});break;case"article":new ThemeArticleView({model:model,el:el});break;case"block":new ThemeBlockView({model:model,el:el});break;case"component":new ThemeComponentView({model:model,el:el});break;default:new ThemeView({model:model,el:el})}}catch(error){console.error("Error handling theme:",error)}}}__AMD("theme/6130a5fd5ff6d107661a236f/js/theme",new Theme);register("header",(function Header(props){const jsxHeading=React.useRef(null);const{_id:_id,displayTitle:displayTitle,body:body,instruction:instruction,mobileBody:mobileBody,mobileInstruction:mobileInstruction,_type:_type,_component:_component,_extension:_extension,_isA11yComponentDescriptionEnabled:_isA11yComponentDescriptionEnabled,classNamePrefixes:classNamePrefixes=[_type&&_type.toLowerCase(),_component&&_component.toLowerCase(),_extension&&_extension.toLowerCase()].filter(Boolean)}=props;const sizedBody=mobileBody&&!device$1.isScreenSizeMin("medium")?mobileBody:body;const sizedInstruction=mobileInstruction&&!device$1.isScreenSizeMin("medium")?mobileInstruction:instruction;const _globals=Adapt$1.course.get("_globals");const ariaRegion=_globals?._components?.[`_${_component}`]?.ariaRegion??_globals?._extensions?.[`_${_extension}`]?.ariaRegion;const isSet=displayTitle||body||sizedInstruction;if(!isSet&&_isA11yComponentDescriptionEnabled&&ariaRegion){return React__default["default"].createElement("div",{className:"aria-label",dangerouslySetInnerHTML:{__html:compile(ariaRegion)}})}if(!isSet)return null;return React__default["default"].createElement("div",{id:`${_id}-header`,className:classes([prefixClasses(classNamePrefixes,["__header"]),props.classes])},React__default["default"].createElement("div",{className:prefixClasses(classNamePrefixes,["__header-inner"])},displayTitle&&React__default["default"].createElement("div",{className:prefixClasses(classNamePrefixes,["__title"])},React__default["default"].createElement("div",{className:prefixClasses(classNamePrefixes,["__title-inner"])+" js-heading",ref:jsxHeading})),_isA11yComponentDescriptionEnabled&&ariaRegion&&React__default["default"].createElement("div",{className:"aria-label",dangerouslySetInnerHTML:{__html:compile(ariaRegion,props)}}),sizedBody&&React__default["default"].createElement("div",{className:prefixClasses(classNamePrefixes,["__body"])},React__default["default"].createElement("div",{className:prefixClasses(classNamePrefixes,["__body-inner"]),dangerouslySetInnerHTML:{__html:compile(sizedBody,props)}})),sizedInstruction&&React__default["default"].createElement("div",{className:prefixClasses(classNamePrefixes,["__instruction"])},React__default["default"].createElement("span",{className:"icon","aria-hidden":"true"}),React__default["default"].createElement("div",{className:prefixClasses(classNamePrefixes,["__instruction-inner"]),dangerouslySetInnerHTML:{__html:compile(sizedInstruction,props)}}))))}));register("image",(function Image(props){const hasMatchingSetting=Object.hasOwn(props,`_${device$1.screenSize}`)||Object.hasOwn(props,device$1.screenSize);const screenSize=hasMatchingSetting?device$1.screenSize:device$1.isScreenSizeMin("medium")?"large":"small";const src=props[`_${screenSize}`]||props[`${screenSize}`]||props._src||props.src;const hasSource=Boolean(src);if(!hasSource)return null;const classNamePrefixSeparator=props.classNamePrefixSeparator||"__";const attributionClassNamePrefixes=props.attributionClassNamePrefixes||props.classNamePrefixes;return React__default["default"].createElement("span",{id:props.id,className:classes([prefixClasses(props.classNamePrefixes,[`${classNamePrefixSeparator}image-container`]),props.classes,props.attribution&&"has-attribution"])},React__default["default"].createElement("img",{className:classes([prefixClasses(props.classNamePrefixes,[`${classNamePrefixSeparator}image`]),props?._srcFocalPoint&&`object-position-${props?._srcFocalPoint}`]),src:src,"aria-label":a11y$1.normalize(props.alt),"aria-hidden":!props.alt,loading:"eager","aria-describedby":props.longdescription?props.longDescriptionId:undefined,draggable:props.draggable??null}),props.attribution&&React__default["default"].createElement("span",{className:prefixClasses(attributionClassNamePrefixes,["__attribution"])},React__default["default"].createElement("span",{className:prefixClasses(attributionClassNamePrefixes,["__attribution-inner"]),dangerouslySetInnerHTML:{__html:compile(props.attribution,props)}})))}));register("navButton",(function NavButton(props){const{text:text,_iconClasses:_iconClasses}=props;return React__default["default"].createElement(React__default["default"].Fragment,null,React__default["default"].createElement("span",{className:classes(["icon",_iconClasses]),"aria-hidden":"true"}),React__default["default"].createElement("span",{className:"nav__btn-label","aria-hidden":"true"},compile(text,props)))}));register("tooltip",(function Tooltip(props){const{text:text,disabledText:disabledText,isDisabled:isDisabled,ariaHidden:ariaHidden}=props;return React__default["default"].createElement(React__default["default"].Fragment,null,React__default["default"].createElement("div",{className:classes(["tooltip__arrow"]),"aria-hidden":"true"}),React__default["default"].createElement("div",{className:classes(["tooltip__body"]),"aria-hidden":ariaHidden},React__default["default"].createElement("div",{className:"tooltip__body-inner",dangerouslySetInnerHTML:{__html:compile((isDisabled?disabledText:text)||"",props)}})))}));function _extends(){_extends=Object.assign?Object.assign.bind():function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return _extends.apply(this,arguments)}const LinkWrapper=({href:href,children:children,target:target,className:className,role:role})=>href?React__default["default"].createElement("a",{href:href,target:target,className:className,role:role},children):children;register("graphic",(function Graphic(props){const{_id:_id,_isScrollable:_isScrollable,_scrollPercent:_scrollPercent,_graphic:_graphic,_globals:_globals}=props;const scrollableProperties=_isScrollable?{role:"slider",className:"component__widget graphic__widget js-graphic-scrollbar","aria-controls":`graphic__scroll__container__${_id}`,"aria-orientation":"horizontal","aria-valuemax":"100","aria-valuemin":"0","aria-valuenow":_scrollPercent,"aria-label":Handlebars.compile(_globals._components._graphic.scrollAriaLabel)(props),"aria-describedby":_graphic.longdescription?`graphic__longdescription__${_id}`:undefined,tabIndex:"0"}:{};return React__default["default"].createElement("div",{className:"component__inner graphic__inner"},React__default["default"].createElement(templates.header,props),React__default["default"].createElement("div",_extends({className:"component__widget graphic__widget"},scrollableProperties),React__default["default"].createElement(LinkWrapper,{href:_graphic._url,target:_graphic._target,className:"graphic__link js-graphic-link",role:"link"},React__default["default"].createElement(templates.image,_extends({},_graphic,{"aria-hidden":_isScrollable,id:`graphic__scroll__container__${_id}`,longDescriptionId:`graphic__longdescription__${_id}`,classes:"js-graphic-scroll-container",classNamePrefixes:["component","graphic"]})),_graphic.longdescription&&React__default["default"].createElement("div",{id:`graphic__longdescription__${_id}`,className:"graphic__longdescription"},React__default["default"].createElement("div",{className:"graphic__longdescription-inner"},_graphic.longdescription)))))}));register("mcq",(function Mcq(props){const ariaLabels=Adapt$1.course.get("_globals")._accessibility._ariaLabels;const{_id:_id,_isEnabled:_isEnabled,_isInteractionComplete:_isInteractionComplete,_isCorrect:_isCorrect,_isCorrectAnswerShown:_isCorrectAnswerShown,_shouldShowMarking:_shouldShowMarking,_isRadio:_isRadio,displayTitle:displayTitle,body:body,instruction:instruction,ariaQuestion:ariaQuestion,onKeyPress:onKeyPress,onItemSelect:onItemSelect,onItemFocus:onItemFocus,onItemBlur:onItemBlur}=props;return React__default["default"].createElement("div",{className:"component__inner mcq__inner"},React__default["default"].createElement(templates.header,props),React__default["default"].createElement("div",{className:classes(["component__widget","mcq__widget",!_isEnabled&&"is-disabled",_isInteractionComplete&&"is-complete is-submitted show-user-answer",_isCorrect&&"is-correct"]),role:_isRadio?"radiogroup":"group","aria-labelledby":ariaQuestion?null:(displayTitle||body||instruction)&&`${_id}-header`,"aria-label":ariaQuestion||null},props._items.map((({text:text,altText:altText,_index:_index,_isActive:_isActive,_shouldBeSelected:_shouldBeSelected,_isHighlighted:_isHighlighted},index)=>React__default["default"].createElement("div",{className:classes([`mcq-item item-${index}`,_shouldShowMarking&&_shouldBeSelected&&"is-correct",_shouldShowMarking&&!_shouldBeSelected&&"is-incorrect"]),key:_index},React__default["default"].createElement("input",{className:"mcq-item__input",id:`${_id}-${index}-input`,name:_isRadio?`${_id}-item`:null,type:_isRadio?"radio":"checkbox",disabled:!_isEnabled,checked:_isActive,"aria-label":!_shouldShowMarking?a11y$1.normalize(altText||text):`${_shouldBeSelected?ariaLabels.correct:ariaLabels.incorrect}, ${_isActive?ariaLabels.selectedAnswer:ariaLabels.unselectedAnswer}. ${a11y$1.normalize(altText||text)}`,"data-adapt-index":_index,onKeyPress:onKeyPress,onChange:onItemSelect,onFocus:onItemFocus,onBlur:onItemBlur}),React__default["default"].createElement("label",{className:classes(["mcq-item__label","u-no-select",!_isEnabled&&"is-disabled",_isHighlighted&&"is-highlighted",(_isCorrectAnswerShown?_shouldBeSelected:_isActive)&&"is-selected"]),"aria-hidden":true,htmlFor:`${_id}-${index}-input`,"data-adapt-index":_index},React__default["default"].createElement("span",{className:"mcq-item__state"},React__default["default"].createElement("span",{className:classes(["mcq-item__icon","mcq-item__answer-icon",_isRadio?"is-radio":"is-checkbox"])},React__default["default"].createElement("span",{className:"icon"})),React__default["default"].createElement("span",{className:"mcq-item__icon mcq-item__correct-icon"},React__default["default"].createElement("span",{className:"icon"})),React__default["default"].createElement("span",{className:"mcq-item__icon mcq-item__incorrect-icon"},React__default["default"].createElement("span",{className:"icon"}))),React__default["default"].createElement("span",{className:"mcq-item__text"},React__default["default"].createElement("span",{className:"mcq-item__text-inner",dangerouslySetInnerHTML:{__html:compile(text)}}))))))),React__default["default"].createElement("div",{className:"btn__container"}))}));register("text",(function Text(props){return React__default["default"].createElement("div",{className:"component__inner text__inner"},React__default["default"].createElement(templates.header,props))}));register("pageLevelProgress",(function PageLevelProgress(props){const{_items:_items,_item:_item,_globals:_globals}=props;return React__default["default"].createElement("div",{className:"pagelevelprogress__inner"},React__default["default"].createElement("span",{className:"aria-label"},compile(_globals._extensions._pageLevelProgress.pageLevelProgress)),React__default["default"].createElement("div",{role:"list",className:"js-children"},_items&&_items.map((item=>React__default["default"].createElement(templates.pageLevelProgressItem,_extends({},item,{_globals:_globals,key:item._id})))),_item&&React__default["default"].createElement(templates.pageLevelProgressItem,_extends({},_item,{_globals:_globals,key:_item._id}))))}));register("pageLevelProgressItem",(function PageLevelProgressItem(props){const{_globals:_globals,_isOptional:_isOptional,_isLocked:_isLocked,_isVisible:_isVisible,_isComplete:_isComplete,title:title,altTitle:altTitle,_id:_id,_type:_type,_children:_children}=props;const indicatorSeat=React__default["default"].createRef();React.useEffect((()=>{if(_isOptional)return;const model=data$1.findById(_id);const item=new PageLevelProgressIndicatorView$1({model:model,calculatePercentage:model.isTypeGroup("contentobject")&&completionCalculations.calculatePercentageComplete.bind(this,model,true)});$(indicatorSeat.current).append(item.$el)}));return React__default["default"].createElement("div",{className:classes(["pagelevelprogress__item drawer__item",`${_type}__indicator`,location$1._currentModel.get("_id")===_id&&"is-current-location"]),role:"listitem"},React__default["default"].createElement("button",{className:classes(["pagelevelprogress__item-btn drawer__item-btn","js-indicator js-pagelevelprogress-item-click",`is-${_type}-indicator`,_isComplete&&"is-complete",_isOptional&&"is-optional",_isLocked&&"is-locked",(_isLocked||!_isVisible)&&"is-disabled"]),ref:indicatorSeat,"data-pagelevelprogress-id":_id,"aria-label":classes([(_isLocked||!_isVisible)&&`${_globals._accessibility._ariaLabels.locked}.`,_isOptional&&`${_globals._extensions._pageLevelProgress.optionalContent}.`,!_isOptional&&_isComplete&&`${_globals._accessibility._ariaLabels.complete}.`,!_isOptional&&!_isComplete&&`${_globals._accessibility._ariaLabels.incomplete}.`,compile(a11y$1.normalize(altTitle||title))])},React__default["default"].createElement("span",{className:"pagelevelprogress__item-title drawer__item-title"},React__default["default"].createElement("span",{className:"pagelevelprogress__item-title-inner drawer__item-title-inner",dangerouslySetInnerHTML:{__html:compile(altTitle||title,props)}})),_isOptional&&React__default["default"].createElement("span",{className:"pagelevelprogress__item-optional"},React__default["default"].createElement("span",{className:"pagelevelprogress__item-optional-inner"},_globals._extensions._pageLevelProgress.optionalContent)),React__default["default"].createElement("span",{className:"pagelevelprogress__item-icon"},React__default["default"].createElement("span",{className:"icon","aria-hidden":"true"}))),React__default["default"].createElement("div",{className:"pagelevelprogress__item-children"},React__default["default"].createElement("div",{role:"list",className:"js-children"},_children&&_children.map((item=>React__default["default"].createElement(PageLevelProgressItem,_extends({},item,{key:item._id,_globals:_globals})))))))}));register("pageLevelProgressNavigationButton",(function PageLevelProgressNavigationButton(props){const{text:text,_iconClasses:_iconClasses}=props;return React__default["default"].createElement(React__default["default"].Fragment,null,React__default["default"].createElement("span",{className:classes(["icon",_iconClasses]),"aria-hidden":"true"}),React__default["default"].createElement("div",{className:"pagelevelprogress__indicator-wrapper"}),React__default["default"].createElement("span",{className:"nav__btn-label","aria-hidden":"true"},compile(text,props)))}));register("gmcq",(function Gmcq(props){const ariaLabels=Adapt$1.course.get("_globals")._accessibility._ariaLabels;const{_id:_id,_isEnabled:_isEnabled,_isInteractionComplete:_isInteractionComplete,_isCorrect:_isCorrect,_isCorrectAnswerShown:_isCorrectAnswerShown,_shouldShowMarking:_shouldShowMarking,_isRadio:_isRadio,_columns:_columns,_isRound:_isRound,displayTitle:displayTitle,body:body,instruction:instruction,ariaQuestion:ariaQuestion,onKeyPress:onKeyPress,onItemSelect:onItemSelect,onItemFocus:onItemFocus,onItemBlur:onItemBlur}=props;const hasColumnLayout=device$1.isScreenSizeMin("medium");return React__default["default"].createElement("div",{className:"component__inner gmcq__inner"},React__default["default"].createElement(templates.header,props),React__default["default"].createElement("div",{className:classes(["component__widget","gmcq__widget",!_isEnabled&&"is-disabled",_isInteractionComplete&&"is-complete is-submitted show-user-answer",_isCorrect&&"is-correct",_columns&&hasColumnLayout&&"has-column-layout"]),role:_isRadio?"radiogroup":"group","aria-labelledby":ariaQuestion?null:(displayTitle||body||instruction)&&`${_id}-header`,"aria-label":ariaQuestion||null},props._items.map((({text:text,_index:_index,altText:altText,_isActive:_isActive,_shouldBeSelected:_shouldBeSelected,_graphic:_graphic},index)=>React__default["default"].createElement("div",{className:classes([`gmcq-item item-${index}`,_isRound&&"is-round",_shouldShowMarking&&_shouldBeSelected?"is-correct":null,_shouldShowMarking&&!_shouldBeSelected?"is-incorrect":null]),style:_columns&&hasColumnLayout?{width:`${100/_columns}%`}:null,key:_index},React__default["default"].createElement("input",{className:"gmcq-item__input",id:`${_id}-${index}-input`,name:_isRadio?`${_id}-item`:null,type:_isRadio?"radio":"checkbox",disabled:!_isEnabled,defaultChecked:_isActive,"aria-label":!_shouldShowMarking?`${a11y$1.normalize(altText||text)} ${_graphic?.alt||""}`:`${_shouldBeSelected?ariaLabels.correct:ariaLabels.incorrect}, ${_isActive?ariaLabels.selectedAnswer:ariaLabels.unselectedAnswer}. ${a11y$1.normalize(altText||text)} ${_graphic?.alt||""}`,"data-adapt-index":_index,onKeyPress:onKeyPress,onChange:onItemSelect,onFocus:onItemFocus,onBlur:onItemBlur}),React__default["default"].createElement("label",{className:classes(["gmcq-item__label","js-item-label",!_isEnabled&&"is-disabled",(_isCorrectAnswerShown?_shouldBeSelected:_isActive)&&"is-selected"]),"aria-hidden":true,htmlFor:`${_id}-${index}-input`,"data-adapt-index":_index},React__default["default"].createElement(templates.image,_extends({},_graphic,{classNamePrefixes:["gmcq-item"],attributionClassNamePrefixes:["component","gmcq"]})),React__default["default"].createElement("span",{className:"gmcq-item__option"},React__default["default"].createElement("div",{className:"gmcq-item__state-container"},React__default["default"].createElement("span",{className:"gmcq-item__state"},React__default["default"].createElement("span",{className:classes(["gmcq-item__icon","gmcq-item__answer-icon",_isRadio?"is-radio":"is-checkbox"])},React__default["default"].createElement("span",{className:"icon"})),React__default["default"].createElement("span",{className:"gmcq-item__icon gmcq-item__correct-icon"},React__default["default"].createElement("span",{className:"icon"})),React__default["default"].createElement("span",{className:"gmcq-item__icon gmcq-item__incorrect-icon"},React__default["default"].createElement("span",{className:"icon"})))),text&&React__default["default"].createElement("span",{className:"gmcq-item__text"},React__default["default"].createElement("span",{className:"gmcq-item__text-inner",dangerouslySetInnerHTML:{__html:compile(text)}})))))))),React__default["default"].createElement("div",{className:"btn__container"}))}));register("matching",(function Matching(props){const{_id:_id,_isEnabled:_isEnabled,_isInteractionComplete:_isInteractionComplete,_isCorrect:_isCorrect,_shouldShowMarking:_shouldShowMarking,_isCorrectAnswerShown:_isCorrectAnswerShown,_items:_items,_options:_options,_globals:_globals,displayTitle:displayTitle,body:body,instruction:instruction,ariaQuestion:ariaQuestion}=props;const displayAsCorrect=_isInteractionComplete&&_isCorrect;const showCorrectAnswer=_isInteractionComplete&&_isCorrectAnswerShown;return React__default["default"].createElement("div",{className:"component__inner matching__inner"},React__default["default"].createElement(templates.header,props),React__default["default"].createElement("div",{className:classes(["component__widget matching__widget",!_isEnabled&&"is-disabled",_isInteractionComplete&&"is-complete is-submitted show-user-answer",displayAsCorrect&&"is-correct-test",showCorrectAnswer&&"show-correct-answer"]),"aria-labelledby":ariaQuestion?null:(displayTitle||body||instruction)&&`${_id}-header`,"aria-label":ariaQuestion||null},_items.map((({text:text,_index:_index},index)=>{const activeOption=_options.find((option=>option._itemIndex===_index&&option._isActive));const displayItemAsCorrect=!_isEnabled&&_shouldShowMarking&&(_isCorrectAnswerShown||activeOption?._shouldBeSelected);return React__default["default"].createElement("div",{key:_index,className:classes(["matching-item","item",`item-${index}`,"js-matching-item",_shouldShowMarking&&(displayItemAsCorrect?"is-correct":"is-incorrect")])},text&&React__default["default"].createElement("div",{className:"matching-item__title"},React__default["default"].createElement("div",{className:"matching-item__title_inner",dangerouslySetInnerHTML:{__html:compile(text)}})),React__default["default"].createElement("div",{className:"matching-item__select-container js-matching-item-select-container"},React__default["default"].createElement(templates.matchingDropDown,_extends({},props,{_itemIndex:_index})),React__default["default"].createElement("div",{className:"matching-item__select-state"},React__default["default"].createElement("div",{className:"matching-item__select-icon matching-item__select-correct-icon","aria-label":_globals._accessibility._ariaLabels.correct},React__default["default"].createElement("div",{className:"icon","aria-hidden":"true"})),React__default["default"].createElement("div",{className:"matching-item__select-icon matching-item__select-incorrect-icon","aria-label":_globals._accessibility._ariaLabels.incorrect},React__default["default"].createElement("div",{className:"icon","aria-hidden":"true"})))))}))),React__default["default"].createElement("div",{className:"btn__container"}))}));register("mcq",(function Mcq(props){const ariaLabels=Adapt$1.course.get("_globals")._accessibility._ariaLabels;const{_id:_id,_isEnabled:_isEnabled,_isInteractionComplete:_isInteractionComplete,_isCorrect:_isCorrect,_isCorrectAnswerShown:_isCorrectAnswerShown,_shouldShowMarking:_shouldShowMarking,_isRadio:_isRadio,displayTitle:displayTitle,body:body,instruction:instruction,ariaQuestion:ariaQuestion,onKeyPress:onKeyPress,onItemSelect:onItemSelect,onItemFocus:onItemFocus,onItemBlur:onItemBlur}=props;return React__default["default"].createElement("div",{className:"component__inner mcq__inner"},React__default["default"].createElement(templates.header,props),React__default["default"].createElement("div",{className:classes(["component__widget","mcq__widget",!_isEnabled&&"is-disabled",_isInteractionComplete&&"is-complete is-submitted show-user-answer",_isCorrect&&"is-correct"]),role:_isRadio?"radiogroup":"group","aria-labelledby":ariaQuestion?null:(displayTitle||body||instruction)&&`${_id}-header`,"aria-label":ariaQuestion||null},props._items.map((({text:text,_index:_index,altText:altText,_isActive:_isActive,_shouldBeSelected:_shouldBeSelected,_isHighlighted:_isHighlighted},index)=>React__default["default"].createElement("div",{className:classes([`mcq-item item-${index}`,_shouldShowMarking&&_shouldBeSelected&&"is-correct",_shouldShowMarking&&!_shouldBeSelected&&"is-incorrect"]),key:_index},React__default["default"].createElement("input",{className:"mcq-item__input",id:`${_id}-${index}-input`,name:_isRadio?`${_id}-item`:null,type:_isRadio?"radio":"checkbox",disabled:!_isEnabled,defaultChecked:_isActive,"aria-label":!_shouldShowMarking?a11y$1.normalize(altText||text):`${_shouldBeSelected?ariaLabels.correct:ariaLabels.incorrect}, ${_isActive?ariaLabels.selectedAnswer:ariaLabels.unselectedAnswer}. ${a11y$1.normalize(altText||text)}`,"data-adapt-index":_index,onKeyPress:onKeyPress,onChange:onItemSelect,onFocus:onItemFocus,onBlur:onItemBlur}),React__default["default"].createElement("label",{className:classes(["mcq-item__label",!_isEnabled&&"is-disabled",_isHighlighted&&"is-highlighted",(_isCorrectAnswerShown?_shouldBeSelected:_isActive)&&"is-selected"]),"aria-hidden":true,htmlFor:`${_id}-${index}-input`,"data-adapt-index":_index},React__default["default"].createElement("div",{className:"mcq-item__state-container"},React__default["default"].createElement("span",{className:"mcq-item__state"},React__default["default"].createElement("span",{className:classes(["mcq-item__icon","mcq-item__answer-icon",_isRadio?"is-radio":"is-checkbox"])},React__default["default"].createElement("span",{className:"icon"})),React__default["default"].createElement("span",{className:"mcq-item__icon mcq-item__correct-icon"},React__default["default"].createElement("span",{className:"icon"})),React__default["default"].createElement("span",{className:"mcq-item__icon mcq-item__incorrect-icon"},React__default["default"].createElement("span",{className:"icon"})))),React__default["default"].createElement("span",{className:"mcq-item__text"},React__default["default"].createElement("span",{className:"mcq-item__text-inner",dangerouslySetInnerHTML:{__html:compile(text)}}))))))),React__default["default"].createElement("div",{className:"btn__container"}))}));$("body").append(Handlebars.templates.loading());data$1.on("ready",(()=>{logging$1.debug("Calling Adapt.init");Adapt$1.init();Adapt$1.off("adaptCollection:dataLoaded courseModel:dataLoaded")})).init()}));window.__AMD=function(id,value){window.define(id,(function(){return value}));window.require([id]);return value};
