define([
    'core/js/adapt'
], function(Adapt) {

    var NavigationView = Backbone.View.extend({

        className: "nav",

        initialize: function() {
            this.listenToOnce(Adapt, {
                'courseModel:dataLoading': this.remove
            });
            this.listenTo(Adapt, 'router:menu router:page', this.hideNavigationButton);
            this.template = "nav";
            this.preRender();
        },

        events: {
            'click [data-event]': 'triggerEvent'            
        },
 
       
        exitCourse: function(e) {
            e.preventDefault(); 
            if (window.parent) {
                window.parent.close();
            } else {
                window.close();
            }
        },

        attributes: {
            'role': ''
        },

        preRender: function() {
            Adapt.trigger('navigationView:preRender', this);
            this.render();
        },

        render: function() {
            
            var template = Handlebars.templates[this.template];
            $(".nav").remove();
            this.$el.html(template({
                _globals: Adapt.course.get("_globals"),
                _accessibility: Adapt.config.get("_accessibility")
            })).insertBefore('#app');

            _.defer(_.bind(function() {
                Adapt.trigger('navigationView:postRender', this);

               // this.$('.go_back').on('click', this.goToMenu); 
                this.$('.exit').on('click', this.exitCourse);
            }, this));

            return this;
        },

        triggerEvent: function(event) {
            event.preventDefault();
            var currentEvent = $(event.currentTarget).attr('data-event');
            Adapt.trigger('navigation:' + currentEvent);
        },

        hideNavigationButton: function(model) {
            
            if (model.get('_type') === "course") {
                $('.nav__back-btn, .nav__home-btn').addClass('u-display-none');


            //     setTimeout(function() {
            //     $('.menu-item').find(".boxmenu-item__button-container").first().find('.boxmenu-item__button').removeClass('user-select-none');
            //     $('.menu-item').find(".boxmenu-item__button-container").first().find('.boxmenu-item__button').find('.icon').removeClass('icon-padlock-locked').addClass('icon-padlock-unlocked');
            // }, 200);
                setTimeout(function() {
                    if($(".co-01").hasClass("is-complete")==true && $(".co-02").hasClass("is-complete")==true && $(".co-03").hasClass("is-complete")==true && $(".co-04").hasClass("is-complete")==true){
                       $(".clickToSummaryBtn").css("display", "block");
                    } 

                }, 200);
   

                $(".nav").hide();
            } else {
                this.showNavigationButton();
            }
        },

        showNavigationButton: function() {
            $('.nav__back-btn, .nav__home-btn').removeClass('u-display-none');

            $(".nav").show();
        }

    });

    return NavigationView;

});