define([
    'core/js/adapt'
  ], function (Adapt) {
  
    var CoronaView = Backbone.View.extend({
  
      attributes: function () {
        return {
          'data-corona-view': 'true'
        }
      },
      events:{
        'click .disclaimer_btn':'handleStartBtn'
      },
      handleStartBtn:function(){
        Backbone.history.navigate('/welcome', {trigger: true, replace: false})
  
      },
  
      className: function () {
        return 'corna-view-page'
      },
  
      preRender: function () {
      },
   
      initialize: function() {
        this.render();
      },
      render: function () {
        var data = this.model.attributes.corona;
        var template = Handlebars.templates.corona;
        this.$el.html(template(data));
        Adapt.trigger('coronaView:ready');
        $('.nav').show();  
      }
    });
  
    return CoronaView;
  
  });
  