require([
  'core/js/adapt',
  'core/js/accessibility',
  'core/js/data',
  'core/js/offlineStorage',
  'core/js/logging',
  'core/js/tracking',
  'core/js/device',
  'core/js/drawer',
  'core/js/notify',
  'core/js/router',
  'core/js/models/lockingModel',
  'core/js/helpers',
  'core/js/scrolling',
  'core/js/headings',
  'core/js/navigation',
  'plugins'
], function (Adapt) {  
  
   // Detect Mobile Device
   window.isMobile = {
    Android: function() {
        return navigator.userAgent.match(/Android/i);
    },
    BlackBerry: function() {
        return navigator.userAgent.match(/BlackBerry/i);
    },
    iOS: function() {
        return navigator.userAgent.match(/iPhone|iPad|iPod/i);
    },
    Opera: function() {
        return navigator.userAgent.match(/Opera Mini/i);
    },
    Windows: function() {
        return navigator.userAgent.match(/IEMobile/i) || navigator.userAgent.match(/WPDesktop/i);
    },
    any: function() {
        return (isMobile.Android() || isMobile.BlackBerry() || isMobile.iOS() || isMobile.Opera() || isMobile.Windows());
    }
};



 

function fn_isPortrait(){
  
  var w=$(window).width();
  var h=$(window).height();
  if(w>h){
    $("html").addClass("mr-is-landscape").removeClass("mr-is-portrait");      
    if(isMobile.any()=='iPad' || isMobile.any()=='iPad'){
      $("html").addClass("mr-is-tablet-landscape").removeClass("mr-is-tablet-portrait")
      $("html").removeClass("mr-is-mobile-landscape, mr-is-mobile-portrait")
    }
    if(isMobile.any()=='Android' || isMobile.any()=='iPhone'){
      $("html").addClass("mr-is-mobile-landscape").removeClass("mr-is-mobile-portrait")
      $("html").removeClass("mr-is-tablet-landscape mr-is-tablet-portrait")
    }    
    if(isMobile.any()==null){
      $("html").removeClass("mr-is-tablet-landscape mr-is-tablet-portrait")
      
      $("html").removeClass("mr-is-mobile-landscape mr-is-mobile-portrait")
    }
  }
  else{  
    if(isMobile.any()=='iPad' || isMobile.any()=='iPod'){
      $("html").addClass("mr-is-tablet-portrait").removeClass("mr-is-tablet-landscape")
      $("html").removeClass("mr-is-mobile-landscape mr-is-mobile-portrait")
    }
    if(isMobile.any()=='Android' || isMobile.any()=='iPhone'){
      $("html").addClass("mr-is-mobile-portrait").removeClass("mr-is-mobile-landscape")
      $("html").removeClass("mr-is-tablet-landscape mr-is-tablet-portrait")
    }

    if(isMobile.any()==null){
      $("html").removeClass("mr-is-tablet-landscape mr-is-tablet-portrait")
      $("html").removeClass("mr-is-mobile-landscape mr-is-mobile-portrait")
    }

    $("html").addClass("mr-is-portrait").removeClass("mr-is-landscape");
  }
}
fn_isPortrait();

   setTimeout(function () {
     var InnerHeight= window.top.innerHeight;
    var InnerWidth=window.top.innerWidth;
     document.documentElement.style.setProperty('--vh', (InnerHeight * 0.01) + 'px');
    window.addEventListener('resize', function(){
       console.warn("Inner Hight::::", InnerHeight + "Inner width::::", InnerWidth);
       if (window.orientation == 0 || window.orientation == 180) {
         document.documentElement.style.setProperty('--vh', (InnerHeight * 0.01) + 'px');
     } else {
       document.documentElement.style.setProperty('--vh', (InnerWidth * 0.01) + 'px');
     }  
     
     fn_isPortrait()
    });
 }, 100);  

  
  $(window).on("orientationchange", function (event) {
      setTimeout(function () {
          window.dispatchEvent(new Event('resize'));
      }, 555);   
  });

  $('body').append(Handlebars.templates.loading());
  Adapt.data.on('ready', function triggerInit() {
    Adapt.log.debug('Calling Adapt.init');   
    Adapt.init();
    fn_isPortrait(); 
    Adapt.off('adaptCollection:dataLoaded courseModel:dataLoaded');
  }).init();
});
 