define([
  'core/js/adapt',
  'core/js/views/componentView',
  'core/js/models/componentModel'
], function(Adapt, ComponentView, ComponentModel) {

   

  var TextViewRadioOptionsMCQscenario = ComponentView.extend({


    events: {
      'click .mr_submit_button': 'onPinClicked',
      'click .btn1' :'onConfirmClick',
      'click .btn2' :'onConfirmsClick',
      'click .closeBtn' :'hidepopUp',
      'click .shadow_bg' :'hidepopUp',
      'click .select_button' :'onConfirmClick',   
      'change input':'optioClicked'
    },
    optionSelect:"",

    optioClicked:function(e)
    {    
      
      this.optionSelect='';
    
      this.optionSelect =$(e.currentTarget).attr("jump-to");  
      $(e.currentTarget).closest(".container-title_survey_mcq").find(".mr_submit_button").removeClass("disablebuttonSubmit");
      $(e.currentTarget).closest(".container-title_survey_mcq").find(".textrd_question01").find(".lab_container").addClass("selected");
    },

   

    scenarioSubmit:function(e)
    {      
        // Adapt.trigger("trickle:unwait");
        var jumpto = "." +this.optionSelect;
        var block = $(e.currentTarget).attr("data-block");
        $("."+block).find(jumpto).show();
        $("."+block).find(jumpto).find(".nextProceed_inner").show();       
        $('html,body').animate({
          scrollTop: $(jumpto).offset().top},
          'slow');
         $(e.currentTarget).closest("."+block).find(".textradiooptionsmcqscenario").find('.staticPageWrapper').find(".lab_container").find(".redkBox").prop("disabled",true); 
         $(e.currentTarget).closest("."+block).find(".textradiooptionsmcqscenario").find('.staticPageWrapper').find(".lab_container").find(".redkBox").css("cursor","default");   

        
    },


  
    onConfirmsClick: function(){      
      $('#shohide').show();      
      },
    onPinClicked: function(e){  
  
      this.scenarioSubmit(e)
      this.$el.find(".showDive").show()  ; 
     
      $(e.currentTarget).addClass("disablebuttonSubmit");
    },    
    preRender: function() {    
      $(".btn1").hide();  
      var extUrl = this.model.get('_parent').get('_parent').get('extranalUrl');
      if(extUrl) this.model.set('extranalUrl',extUrl);     
      this.checkIfResetOnRevisit();
   },
    postRender: function() {
      this.setReadyStatus();
      this.setupInview();

      

      if(this.model.get('isIntro')){
        var charLen = this.$('.text__title-inner').text().trim().length
        var winWidth = $('html').width();
        if(winWidth>800){          
          var setFont= ((winWidth/charLen)*1.15).toFixed(2);
          setFont = setFont>66?66:setFont<48?48:setFont;
          this.$('.text__title-inner').closest('.component__title').attr('style','font-size:'+setFont+'px !important')
        }
        
      }

      var script = document.createElement('script');
      script.type = 'text/javascript';
      script.async = true;
      script.src = 'https://cdnjs.cloudflare.com/ajax/libs/jspdf/1.2.61/jspdf.min.js';
      document.querySelector('head').appendChild(script);

     // $('.select_button').on('click',pdf)
      this.$('.user_textare').on('keyup',function(e){
       
        if($(this).val() != ''){
          $(e.currentTarget).closest(".staticPageWrapper").find('.select_button').removeClass('disabledbtn');
        }else{
          $(e.currentTarget).closest(".staticPageWrapper").find('.select_button').addClass('disabledbtn');
        }
        //$(this).val()
        //$('.select_bg_popup').show();
      })
      
    },
    setupInview: function() {     
      console.log(this.model.get('_id'))
      var selector = this.getInviewElementSelector();
      if (!selector) {       
        this.setCompletionStatus();
        return;
      }

      this.setupInviewCompletion(selector);
    },

    /**
     * determines which element should be used for inview logic - body, instruction or title - and returns the selector for that element
     */
    getInviewElementSelector: function() {
      if (this.model.get('body')) return '.component__body';

      if (this.model.get('instruction')) return '.component__instruction';

      if (this.model.get('displayTitle')) return '.component__title';

      return null; 
    },

    checkIfResetOnRevisit: function() {
      var isResetOnRevisit = this.model.get('_isResetOnRevisit');      
      // If reset is enabled set defaults
      if (isResetOnRevisit) {
        this.model.reset(isResetOnRevisit);
       
      }
    }, 
  },
  

  {
    template: 'textRadioOptionsMCQscenario'
  });

  



  return Adapt.register('textRadioOptionsMCQscenario', {  
    model: ComponentModel.extend({}),// create a new class in the inheritance chain so it can be extended per component type if necessary later
    view: TextViewRadioOptionsMCQscenario
  });
});
