// const { partial } = require("underscore");

define([
  'core/js/adapt',
  'core/js/views/componentView',
  './modeEnum'
], function(Adapt, ComponentView, MODE) {
  'use strict';

  var NarrativeViewMMCQ = ComponentView.extend({

    _isInitial: true,
    _isvisited:[0,0,0,0,0],
    MMCQ_Answer:[],
    MMCQ_UserAnswer:[],
    _attemptQuestion:0,
    globaindex:0,
    MMCQ_Question_Options:0,
    ResultArr:[],

   
    

    events: {
      'click .js-narrative-strapline-open-popup': 'openPopup',
      'click .js-narrative-controls-click': 'onNavigationClicked',
      'click .js-narrative-progress-click': 'onProgressClicked',
      'click .submitBtn': 'onPinClicked',
      'click .showAnswer': 'onPinClicked',
      'click .showAnswerMMCQ': 'showAnswerPopup',
      'click .closeBtn_CYU':'closeCYUpopUp',
      'change .cyu-option':'optioClicked'
    },

    preRender: function() {      
      this.listenTo(Adapt, {
        'device:changed device:resize': this.reRender,
        'notify:closed': this.closeNotify
      });
      this.renderMode();
      

      this.listenTo(this.model.get('_children'), {        
        'change:_isActive': this.onItemsActiveChange,
        'change:_isVisited': this.onItemsVisitedChange
      });

      $(".feedback-container").hide();
      this.checkIfResetOnRevisit();
      this.calculateWidths();
    },

    onItemsActiveChange: function(item, _isActive) {
      if (_isActive === true) {
        this.setStage(item);
      }
    },

    onItemsVisitedChange: function(item, isVisited) {
      
      if (!isVisited) return;
      this.$('[data-index="' + item.get('_index') + '"]').addClass('is-visited');
    },

    calculateMode: function() {
      var mode = Adapt.device.screenSize === 'large' ?
          MODE.LARGE :
          MODE.LARGE;
      this.model.set('_mode', mode);
    },

    renderMode: function() {
      this.calculateMode();
      if (this.isLargeMode()) {
        this.$el.addClass('mode-large').removeClass('mode-small');
      } else {
        this.$el.addClass('mode-small').removeClass('mode-large');
      }
    },

    isLargeMode: function() {
      return this.model.get('_mode') === MODE.LARGE;
    },

    postRender: function() {
      
      this.renderMode();
      this.setupNarrative();

      this.$('.narrative__slider').imageready(this.setReadyStatus.bind(this));

      if (Adapt.config.get('_disableAnimation')) {
        this.$el.addClass('disable-animation');
      }
    },

    checkIfResetOnRevisit: function() {
      var isResetOnRevisit = this.model.get('_isResetOnRevisit');
      // If reset is enabled set defaults
      if (isResetOnRevisit) {
        this.model.reset(isResetOnRevisit);
      }
    },

    setupNarrative: function() {
      
      this.renderMode();
      var items = this.model.get('_children');
      if (!items || !items.length) return;

      var activeItem = this.model.getActiveItem();
      if (!activeItem) {
        activeItem = this.model.getItem(0);
        activeItem.toggleActive(true);
      } else {
        // manually trigger change as it is not fired on reentry
        items.trigger('change:_isActive', activeItem, true);
      }

      this.calculateWidths();

      if (!this.isLargeMode() && !this.model.get('_wasHotgraphic')) {
        this.replaceInstructions();
      }
      this.setupEventListeners();
      this._isInitial = false;
    },

    calculateWidths: function() {
      var itemCount = this.model.get('_children').length;
      this.model.set({
        '_totalWidth': 100 * itemCount,
        '_itemWidth': 100 / itemCount
      });
    },

    resizeControl: function() {
      
      var previousMode = this.model.get('_mode');
      this.renderMode();
      if (previousMode !== this.model.get('_mode')) this.replaceInstructions();
      this.evaluateNavigation();
      var activeItem = this.model.getActiveItem();
      //if (activeItem) this.setStage(activeItem);//bipin
    },

    reRender: function() {
      if (this.model.get('_wasHotgraphic') && this.isLargeMode()) {
        this.replaceWithHotgraphic();
      } else {      
        this.resizeControl();
      }
    },

    closeNotify: function() {      
      this.evaluateCompletion();
      
    },

    replaceInstructions: function() {
      if (this.isLargeMode()) {
        this.$('.narrative__instruction-inner').html(this.model.get('instruction'));
      } else if (this.model.get('mobileInstruction') && !this.model.get('_wasHotgraphic')) {
        this.$('.narrative__instruction-inner').html(this.model.get('mobileInstruction'));
      }
    },

    replaceWithHotgraphic: function() {
      if (!Adapt.componentStore.hotgraphic) throw "Hotgraphic not included in build";
      var HotgraphicView = Adapt.componentStore.hotgraphic.view;

      var model = this.prepareHotgraphicModel();
      var newHotgraphic = new HotgraphicView({ model: model });
      var $container = $(".component__container", $("." + this.model.get("_parentId")));

      $container.append(newHotgraphic.$el);
      this.remove();
      $.a11y_update();
      _.defer(function() {
        Adapt.trigger('device:resize');
      });
    },

    prepareHotgraphicModel: function() {
      var model = this.model;
      model.resetActiveItems();
      model.set({
        '_isPopupOpen': false,
        '_component': 'hotgraphic',
        'body': model.get('originalBody'),
        'instruction': model.get('originalInstruction')
      });

      return model;
    },

    moveSliderToIndex: function(itemIndex) {
      var offset = this.model.get('_itemWidth') * itemIndex;
      if (Adapt.config.get('_defaultDirection') === 'ltr') {
        offset *= -1;
      }
      var cssValue = 'translateX('+offset+'%)';
      var $sliderElm = this.$('.narrative__slider');
      var $straplineHeaderElm = this.$('.narrative__strapline-header-inner');

      //$sliderElm.css('transform', cssValue);
      $straplineHeaderElm.css('transform', cssValue);

      if (Adapt.config.get('_disableAnimation') || this._isInitial) {
        this.onTransitionEnd();
      } else {
        $sliderElm.one('transitionend', this.onTransitionEnd.bind(this));
      }
    },

    onTransitionEnd: function() {
      if (this._isInitial) return;

      var index = this.model.getActiveItem().get('_index');
      if (this.isLargeMode()) {
        this.$('.narrative__content-item[data-index="'+index+'"]').a11y_focus();
      } else {
        this.$('.narrative__strapline-btn').a11y_focus();
      }
    },

    setStage: function(item) {
      
      var index = item.get('_index');
      this.globaindex = index
      if (this.isLargeMode()) {
        // Set the visited attribute for large screen devices
        item.toggleVisited(true);     }

        //this.MMCQ_UserAnswer =[0, 0, 0, 0]
     
      // if(index==2){
      //   $(".narrative__slide-container").hide();
      //   $(".narrative__content").addClass("full_layout")
      // }
      // else{
      //   $(".narrative__slide-container").show();
      //   $(".narrative__content").removeClass("full_layout")
      // }
      //  alert("dfdf") 
      var $slideGraphics = this.$('.narrative__slider-image-container');     
      $slideGraphics.removeClass("is-selected").eq(index).addClass("is-selected");      
      $slideGraphics.removeClass("is-selected").eq(index).addClass("is-selected");      

      if(this.model.get("_classes")=="MMCQ_Carosel")
      {
      
        this._attemptQuestion = 2; 
        var optLength=  this.$('.narrative__slider-image-container.is-selected').find(".cyu-options").find(".cyu-option").length;
        this.MMCQ_Question_Options = optLength
        this.MMCQ_Answer = [];
        this.MMCQ_UserAnswer = [];
        for(var i=0;i<optLength; i++)
        {
            this.MMCQ_UserAnswer[i] = false;
            this.MMCQ_Answer[i] = this.$('.narrative__slider-image-container.is-selected').find(".cyu-options").find(".cyu-option").eq(i).find(".redkBox").attr("data-correct")
            //this.MMCQ_Answer[i] = this.$('.narrative__slider-image-container.is-selected').find(".cyu-option").eq(i).find(".redkBox").attr("data-correct");
            // console.log(this.$('.narrative__slider-image-container.is-selected').find(".cyu-options").find(".cyu-option").eq(i).attr("data-index"))
        }       

         console.log(this.MMCQ_UserAnswer);
         console.log(this.MMCQ_Answer) ;


      }
           
      this.$('.narrative__progress:visible').removeClass('is-selected').filter('[data-index="'+index+'"]').addClass('is-selected');
      $slideGraphics.children('.controls').a11y_cntrl_enabled(false);
      $slideGraphics.filter('[data-index="'+index+'"]').children('.controls').a11y_cntrl_enabled(true);
      this.$('.narrative__slider-image-container').addClass('u-display-none').a11y_on(false).filter('[data-index="'+index+'"]').removeClass('u-display-none').a11y_on(true); 
      this.$('.narrative__content-item').removeClass("is-selected").eq(index).addClass("is-selected")
      this.$('.narrative__content-item').addClass('u-visibility-hidden u-display-none').a11y_on(false).filter('[data-index="'+index+'"]').removeClass('u-visibility-hidden u-display-none').a11y_on(true); 
 
      this.$('.narrative__strapline-btn').a11y_cntrl_enabled(false).filter('[data-index="'+index+'"]').a11y_cntrl_enabled(true);
 
      if(this.$('.narrative__content-item.is-selected').hasClass("mcqcomplete")){
        $slideGraphics.eq(index).find(".showAnswer").show()
        $slideGraphics.eq(index).find('.submitBtn').addClass("disabled");        
        $slideGraphics.eq(index).find(".cyu-option").addClass("disabledoption");
        this.$('.narrative__controls-right').removeClass('nextDisabled')
        if( $slideGraphics.eq(index).find(".cyu-option.correctAns").length>0){
          $slideGraphics.eq(index).find(".cyu-option.correctAns").addClass("abc");
          this.$('.narrative__content-item.is-selected').find(".correct").show();
          this.$('.narrative__content-item.is-selected').find(".incorrect").hide();
        }
        if($slideGraphics.eq(index).find(".cyu-option.incorrectAns").length>0){
          $slideGraphics.eq(index).find(".cyu-option.incorrectAns").addClass("abc");
          this.$('.narrative__content-item.is-selected').find(".correct").hide();
          this.$('.narrative__content-item.is-selected').find(".incorrect").show();
        }
       }else{
       
        this.$('.narrative__controls-right').addClass('nextDisabled');       
        this.$('.narrative__content-item.is-selected').find('.correct, .incorrect').hide();
        $slideGraphics.eq(index).find('.submitBtn').addClass("disabled");
        $slideGraphics.eq(index).find(".cyu-option").removeClass("selected");
        $slideGraphics.eq(index).find(".showAnswer").hide();
       
        // $(".narrative__content-item").find(".closeBtn_CYU").hide();
       
       }
       
        this.$('.narrative__content-item.is-selected .closeBtn_MMCQ').on('click',function(){
         
             $('.narrative__content-item.is-selected').find(".feedback-container").hide();                   
                    
              if($(this).attr("data-buttontype")=="incorrect"){                
                $('.narrative__content-item.is-selected').find('.correct, .incorrect').hide();                
                //$slideGraphics.eq(index).find(".cyu-option").removeClass("selected");
              }
            else
            {
              //$slideGraphics.eq(index).find(".cyu-option").removeClass("disabledoption");
              $('.narrative__content-item.is-selected').find('.correct, .incorrect').hide();
              //$slideGraphics.eq(index).find(".cyu-option").removeClass("selected");
            }
       
       })


      //  this.$('.narrative__content-item.is-selected .feedback_Close_correct').on('click',function(){
        
        
      //  })



       
      this.evaluateNavigation();
      //this.evaluateCompletion(); 
      //this.moveSliderToIndex(index);
    },

    evaluateNavigation: function() { 
     

      var active = this.model.getActiveItem();
      if (!active) return;

      var currentStage = active.get('_index');
      var itemCount = this.model.get('_children').length;

      var isAtStart = currentStage === 0;
      var isAtEnd = currentStage === itemCount - 1;

      this.$('.narrative__controls-left').toggleClass('u-visibility-hidden', isAtStart);
      this.$('.narrative__controls-right').toggleClass('u-visibility-hidden', isAtEnd);
      if(isAtEnd==true){
          //if(this.$el.find(".main-container").find(".mcqcomplete").length!= this.$el.find(".main-container").find(".narrative__content-item").length){
          this.$el.closest(".block").find(".trickle-button").find(".trickle-button__inner").hide();
          if(this.$el.find(".main-container").find(".mcqcomplete").length==this.$el.find(".main-container").find(".narrative__content-item").length){
            this.$el.closest(".block").find(".trickle-button").find(".trickle-button__inner").show();
          } 
  // }
      }
   
    },

    evaluateCompletion: function() {      
      if(this.model.areAllItemsCompleted()) {
        this.trigger('allItems');
      }
    },

    openPopup: function(event) {
      event && event.preventDefault();
      var currentItem = this.model.getActiveItem();
      Adapt.trigger('notify:popup', {
        title: currentItem.get('title'),
        body: currentItem.get('body')
      });

      Adapt.on('popup:opened', function() {
        // Set the visited attribute for small and medium screen devices
        currentItem.toggleVisited(true);
      });
    },
    optioClicked: function(e){
      
       if($(e.currentTarget).find('input[type="checkbox"]').is(':checked'))
       {
        this.MMCQ_UserAnswer[$(e.currentTarget).index()]=  true
        //this.MMCQ_UserAnswer.push($(e.currentTarget).closest(".cyu-option").attr("data-index")); 
       }
       else{
        this.MMCQ_UserAnswer[$(e.currentTarget).index()]= false;
        // this.MMCQ_UserAnswer.splice($(e.currentTarget).index(),1 )
       
       }  
       
       if($(e.currentTarget).closest(".narrative__slider-image-container.is-selected").find('.cyu-option').find('input:checked').length>0)
       {
        $(e.currentTarget).closest(".narrative__slider-image-container.is-selected").find(".submitBtn").removeClass("disabledbtn");
       }
       else
       {
        $(e.currentTarget).closest(".narrative__slider-image-container.is-selected").find(".submitBtn").addClass("disabledbtn");
       }
       
        
      
        $(e.currentTarget).closest(".narrative__slider-image-container.is-selected").find('.cyu-option').removeClass('selected');
        $(e.currentTarget).closest(".cyu-option").addClass("selected");
        $(e.currentTarget).find("input").attr("checked", true)
        //$(e.currentTarget).closest(".narrative__slider-image-container.is-selected").find(".submitBtn").removeClass("disabledbtn");
        
    },

    onPinClicked: function(e){ 
      e.preventDefault()
        $(".narrative__content-item").find(".correct, .incorrect, .partial, .incorrect_firstAttempt").hide();
        $(".narrative__content-item").find(".closeBtn_CYU").show();
        $(e.currentTarget).closest(".narrative__slider-image-container.is-selected").find(".submitBtn").addClass("disabledbtn");
        $(e.currentTarget).closest(".narrative__slider-image-container.is-selected").find(".cyu-option").addClass("disabledoption");
       
        // $(e.currentTarget).closest(".main_slider_container").find('.narrative__controls-right').removeClass('nextDisabled');
        // $(e.currentTarget).closest(".main_slider_container").find(".narrative__indicators").find(".is-selected").removeClass("nextDisabled");
        // $(e.currentTarget).closest(".main_slider_container").find(".narrative__indicators").find(".is-selected").next().removeClass("nextDisabled");
        $(e.currentTarget).closest(".main-container").find(".narrative__content-item.is-selected").find(".feedback-container").show();


      //----------------Code written for MMCQ_Carosel ------------------ 
     
         
        if(this.MMCQ_Answer.join(",")==this.MMCQ_UserAnswer.join(","))
        {  
          this.$('.narrative__slider-image-container').eq(this.globaindex).find(".showAnswerMMCQ").show();        
          $(e.currentTarget).closest(".main-container").find(".narrative__content-item.is-selected").find(".correct").show();
         // $(e.currentTarget).closest(".narrative__slider-image-container.is-selected").find(".cyu-option.selected").addClass("correctAns");
           //$(e.currentTarget).closest(".narrative__slider-image-container.is-selected").find(".cyu-option.selected").parents(".cyu-options").find("input[data-correct='true']").siblings(".correctIncorrectIcon").addClass("correctIcon");           
           //$(".narrative__slider-image-container.is-selected").find("input[data-correct='true']").closest(".cyu-options").find(".cyu-option.selected").addClass("correctAns");           
           $(e.currentTarget).closest(".narrative__slider-image-container.is-selected").find(".cyu-options").find("input[data-correct='true']").parent(".lab_container").parent(".cyu-option").addClass("correctAns");
          //$(e.currentTarget).closest(".narrative__slider-image-container.is-selected").find(".cyu-option.selected").find(".correctIncorrectIcon").addClass("correctIcon");
          $(e.currentTarget).closest(".narrative__slider-image-container.is-selected").find(".cyu-option.selected").parents(".cyu-options").find("input[data-correct='false']").siblings(".correctIncorrectIcon").addClass("IncorrectIcon")
          $(e.currentTarget).closest(".narrative__slider-image-container.is-selected").find(".cyu-option.selected").parents(".cyu-options").find("input[data-correct='true']").siblings(".correctIncorrectIcon").addClass("correctIcon");
          $(e.currentTarget).closest(".main_slider_container").find('.narrative__controls-right').removeClass('nextDisabled');          
          this.$('.narrative__controls-left').removeClass('nextDisabled');
          $(e.currentTarget).closest(".main_slider_container").find(".narrative__indicators").find(".is-selected").removeClass("nextDisabled");
          $(e.currentTarget).closest(".main_slider_container").find(".narrative__indicators").find(".is-selected").next().removeClass("nextDisabled");
          this.ResultArr[this.globaindex] = "correct";
          $(e.currentTarget).closest(".main-container").find(".narrative__content-item.is-selected").addClass("mcqcomplete");
          // alert("dfdfd")
        }
        else {
          var ispartialAns = false;
          this._attemptQuestion = this._attemptQuestion-1;        
          for(var i = 0; i<this.MMCQ_Answer.length;i++){ 
            if(this.MMCQ_Answer[i].toString() == this.MMCQ_UserAnswer[i].toString() ){               
                ispartialAns= true
                break;               
            }
            else{
              ispartialAns = false;
            }          
          }
          if(ispartialAns){            
            $(e.currentTarget).closest(".main-container").find(".narrative__content-item.is-selected").find(".partial").show();
            if(this._attemptQuestion==1){
              $(e.currentTarget).closest(".narrative__slider-image-container.is-selected").find(".cyu-option.selected").addClass("incorrectAns");
              $(e.currentTarget).closest(".narrative__slider-image-container.is-selected").find(".cyu-option.selected").parents(".cyu-options").find('input[type=checkbox]').prop('checked',false);             
              this.$('.narrative__slider-image-container').eq(this.globaindex).find(".cyu-option").removeClass("disabledoption selected incorrectAns");
              //$(e.currentTarget).closest(".narrative__slider-image-container.is-selected").find(".cyu-option.selected").find(".correctIncorrectIcon").addClass("IncorrectIcon"); 
              for(var i=0;i<this.MMCQ_Question_Options; i++){
                this.MMCQ_UserAnswer[i] = false;                
              } 
                          
            }
            else{             
              $(e.currentTarget).closest(".narrative__slider-image-container.is-selected").find(".cyu-option.selected").parents(".cyu-options").find("input[data-correct='true']").siblings(".correctIncorrectIcon").addClass("correctIcon"); 
              $(e.currentTarget).closest(".narrative__slider-image-container.is-selected").find(".cyu-option.selected").parents(".cyu-options").find("input[data-correct='false']").siblings(".correctIncorrectIcon").addClass("IncorrectIcon") 
              this.$('.narrative__slider-image-container').eq(this.globaindex).find(".showAnswerMMCQ").show(); 
              $(e.currentTarget).closest(".main_slider_container").find('.narrative__controls-right').removeClass('nextDisabled');  
              $(e.currentTarget).closest(".main_slider_container").find(".narrative__indicators").find(".is-selected").removeClass("nextDisabled");
               $(e.currentTarget).closest(".main_slider_container").find(".narrative__indicators").find(".is-selected").next().removeClass("nextDisabled");
               this.$('.narrative__controls-left').removeClass('nextDisabled');
               $(e.currentTarget).closest(".narrative__slider-image-container.is-selected").find(".cyu-option.selected").addClass("incorrectAns");
               this.ResultArr[this.globaindex] = this.MMCQ_UserAnswer;
               this.ResultArr[this.globaindex] = "partial";
               $(e.currentTarget).closest(".main-container").find(".narrative__content-item.is-selected").addClass("mcqcomplete");
            }  
                 
          }
          else
          {            
            if( this._attemptQuestion==1){            
              $(e.currentTarget).closest(".narrative__slider-image-container.is-selected").find(".cyu-option.selected").parents(".cyu-options").find('input[type=checkbox]').prop('checked',false);
              $(e.currentTarget).closest(".main-container").find(".narrative__content-item.is-selected").find(".incorrect_firstAttempt").show();
              $(e.currentTarget).closest(".main-container").find(".narrative__content-item.is-selected").find(".incorrect").show();              
              this.$('.narrative__slider-image-container').eq(this.globaindex).find(".cyu-option").removeClass("disabledoption selected incorrectAns");  

              for(var i=0;i<this.MMCQ_Question_Options; i++){
                this.MMCQ_UserAnswer[i] = false;                
             }                   
            }  
            else{
              $(e.currentTarget).closest(".main-container").find(".narrative__content-item.is-selected").find(".incorrect").show();
              $(e.currentTarget).closest(".narrative__slider-image-container.is-selected").find(".cyu-option.selected").addClass("incorrectAns");
              $(e.currentTarget).closest(".narrative__slider-image-container.is-selected").find(".cyu-option.selected").find(".correctIncorrectIcon").addClass("IncorrectIcon");
              $(e.currentTarget).closest(".narrative__slider-image-container.is-selected").find(".cyu-option.selected").parents(".cyu-options").find("input[data-correct='true']").siblings(".correctIncorrectIcon").addClass("correctIcon")
              this.$('.narrative__slider-image-container').eq(this.globaindex).find(".showAnswerMMCQ").show();
              $(e.currentTarget).closest(".main_slider_container").find('.narrative__controls-right').removeClass('nextDisabled'); 
              $(e.currentTarget).closest(".main_slider_container").find(".narrative__indicators").find(".is-selected").removeClass("nextDisabled");
               $(e.currentTarget).closest(".main_slider_container").find(".narrative__indicators").find(".is-selected").next().removeClass("nextDisabled");$(e.currentTarget).closest(".main_slider_container").find(".narrative__indicators").find(".is-selected").removeClass("nextDisabled");
               $(e.currentTarget).closest(".main_slider_container").find(".narrative__indicators").find(".is-selected").next().removeClass("nextDisabled"); 
               this.$('.narrative__controls-left').removeClass('nextDisabled') 
               this.ResultArr[this.globaindex] = "incorrect";
               $(e.currentTarget).closest(".main-container").find(".narrative__content-item.is-selected").addClass("mcqcomplete");
            } 
           
          }
          
        }  
         
        
     if($(e.currentTarget).closest(".main-container").find(".mcqcomplete").length== $(e.currentTarget).closest(".main-container").find(".narrative__content-item").length){
      this.$el.closest(".block").find(".trickle-button").find(".trickle-button__inner").show();
      this.evaluateCompletion();
      }
     }, 

    showAnswerPopup: function(e){
      this.$(".narrative__content-item").find(".feedback-container").show()
      this.$(".narrative__content-item").find(".correct, .incorrect .partial").hide();
      alert(this.ResultArr[this.globaindex])
      if( this.ResultArr[this.globaindex]=="correct"){
           $(e.currentTarget).closest(".main-container").find(".narrative__content-item.is-selected").find(".correct").show();
           //$(e.currentTarget).closest(".narrative__slider-image-container.is-selected").find(".cyu-option.selected").addClass("correctAns");
      }
      else if(this.ResultArr[this.globaindex]=="partial")
      {
        $(e.currentTarget).closest(".main-container").find(".narrative__content-item.is-selected").find(".partial").show();
       // $(e.currentTarget).closest(".narrative__slider-image-container.is-selected").find(".cyu-option.selected").addClass("correctAns");
      }
      else
      {
        $(e.currentTarget).closest(".main-container").find(".narrative__content-item.is-selected").find(".incorrect").show();
       // $(e.currentTarget).closest(".narrative__slider-image-container.is-selected").find(".cyu-option.selected").addClass("correctAns");
      }
      // $(".narrative__content-item").find(".feedback-container").show()
      // $(".narrative__content-item").find(".correct, .incorrect").hide();
      // //$(".narrative__content-item").find(".closeBtn_CYU").show();
      // $(e.currentTarget).closest(".main-container").find(".narrative__content-item.is-selected").find(".correct").show();
      // $(e.currentTarget).closest(".narrative__slider-image-container.is-selected").find(".cyu-option.selected").addClass("correctAns");
    },
    onNavigationClicked: function(event) {
      
      var stage = this.model.getActiveItem().get('_index');
      // alert( $(".narrative__slider-image-container").find(".narrative__progress ").length);
      // $(".narrative__content-item").find(".closeBtn_CYU").hide();
      
      this.$(".narrative__content-item").find(".feedback-container").hide();
      if ($(event.currentTarget).hasClass('narrative__controls-right')) {
        this.model.setActiveItem(++stage);        
      } else if ($(event.currentTarget).hasClass('narrative__controls-left')) {
        this.model.setActiveItem(--stage);
      }
    },

    onProgressClicked: function(event) {    
      this.$(".narrative__content-item").find(".feedback-container").hide()
      event && event.preventDefault();
      var clickedIndex = $(event.target).data('index');
      this.model.setActiveItem(clickedIndex);
      // if(clickedIndex==2){
      //   $(".narrative__slide-container").hide();
      //   $(".narrative__content").addClass("full_layout")
      // }
      // else{
      //   $(".narrative__slide-container").show();
      //   $(".narrative__content").removeClass("full_layout")
      // }
    },

    setupEventListeners: function() {      
      if (this.model.get('_setCompletionOn') === 'inview') {
        this.setupInviewCompletion('.component__widget');
      }
    },

    closeCYUpopUp: function(e){
      $(e.currentTarget).closest(".main-container").find(".feedback-container").hide();
      $(e.currentTarget).closest(".main-container").find(".showAnswer").show();   
      // alert($(e.currentTarget).attr("data-buttontype"));
       
    
     
    }
  });

  return NarrativeViewMMCQ;

});
