define([
  'core/js/adapt',
  'core/js/views/componentView',
  'core/js/models/componentModel',
  'core/js/views/VimeoPlayer'
], function (Adapt, ComponentView, ComponentModel, VimeoPlayer) {
  var vimeoCustom = ComponentView.extend({


    events: {
      'click .mr_submit_button': 'onPinClicked',
      'click .trnascriptBtn': 'openTranscript'
    },


    openTranscript: function (e) {
      $(e.currentTarget).closest(".vid_transcriptArea").find('.transcript_text').slideToggle();
      // var toggletext=$(e.currentTarget).text().toLocaleLowerCase();
      // if(toggletext=='transcript'){
      //   $(e.currentTarget).text("HIDE TRANSCRIPT")
      // }else{
      //   $(e.currentTarget).text("TRANSCRIPT")
      // }
    },

    preRender: function () {
      $(".btn1").hide();
      var extUrl = this.model.get('_parent').get('_parent').get('extranalUrl');
      if (extUrl) this.model.set('extranalUrl', extUrl);

      //   var script = document.createElement('script');
      //   script.type = 'text/javascript';
      //  // script.async = true;
      //   script.src = 'https://player.vimeo.com/api/player.js';
      //   document.querySelector('head').appendChild(script);
      //   this.checkIfResetOnRevisit();
    },
    postRender: function () {

      this.setReadyStatus();
      if(this.model.get("_setCompletionOn")=="inview"){
        this.setupInview();
      }
       var $that=this;

      if (this.model.get('isIntro')) {
      }



      setTimeout(function () {  
        
        //var seconds="50";    
        const iframe = document.querySelector('iframe');
         window.player = new VimeoPlayer(iframe);

         window.player.on('play', function () {    
          console.log('played the video!');
          $('video').each(function(i, ele) {
            $(ele).is('video') && $(ele)[0].pause();
        })
        $('audio').each(function(i, ele) {
            $(ele).is('audio') && $(ele)[0].pause();
        })
          if($that.model.get("_setCompletionOn")=="play"){
            $that.setupInview();
          }
              
        });

        window.player.getVideoTitle().then(function (title) {
          console.log('title:', title);
        });
        window.player.on('ended', function () {
          console.log('played the video end!');
          if($that.model.get("_setCompletionOn")=="ended"){
            $that.setupInview();
          }
        });
        window.player.on('pause', function () {
          console.log('Pause');
        });
       // window.player.setCurrentTime(seconds);
        
      }, 10)

   
    },
    setupInview: function () {
      console.log(this.model.get('_id'))
      var selector = this.getInviewElementSelector();
      if (!selector) {
        this.setCompletionStatus();
        return;
      }

      this.setupInviewCompletion(selector);
    },

    /**
     * determines which element should be used for inview logic - body, instruction or title - and returns the selector for that element
     */
    getInviewElementSelector: function () {
      if (this.model.get('body')) return '.component__body';

      if (this.model.get('instruction')) return '.component__instruction';

      if (this.model.get('displayTitle')) return '.component__title';

      return null;
    },

    checkIfResetOnRevisit: function () {
      var isResetOnRevisit = this.model.get('_isResetOnRevisit');
      // If reset is enabled set defaults
      if (isResetOnRevisit) {
        this.model.reset(isResetOnRevisit);

      }
    },

  },

    {
      template: 'vimeoCustom'
    });
  return Adapt.register('vimeoCustom', {
    model: ComponentModel.extend({}),// create a new class in the inheritance chain so it can be extended per component type if necessary later
    view: vimeoCustom
  });
});
