define([
    'core/js/adapt',
    'core/js/views/questionView'
], function(Adapt, QuestionView) {

    var McqView = QuestionView.extend({

        

        events: {
            'focus .js-item-input': 'onItemFocus',
            'blur .js-item-input': 'onItemBlur',
            'change .js-item-input': 'onItemSelect',
            'keyup .js-item-input': 'onKeyPress',
            "click .support-btn-container": "handlesupportClick",
            "click .close-support": "handlesupportClick",
            "click .mr_submit_button": "submitFeedback_",
            "click .mr_showfeedback_button": "submitFeedback_Popup",
            'click .closeBtn_CYU':'closeReset',
            'focus   .focusareatoClosBtn': 'closebtnFocus',
            //"click .btn__container":"containerClick", 
        },

        isCorrectAnswerShown: false,
        containerClick: function(e) {
            e.preventDefault();
            e.stopPropagation();
        },
        handlesupportClick: function(event) {
            if ($(event.currentTarget).is(".close-support")) {
                this.$(".support-popup-container").hide();
                this.$(".popup-btn-container").show();
                setTimeout(function() {

                    $this.$(".support-popup-container close-support").focus()

                }, 100);

            } else {

                this.$(".support-popup-container").show();

                // $(event.ta
                this.$(".popup-btn-container").hide();
                setTimeout(function() {
                    // alert("hi");
                    $this.$(".support-popup-container").focus()

                }, 1000);

            }

        },

        initialize: function() {
            
            QuestionView.prototype.initialize.apply(this, arguments);
            this.update = _.debounce(this.update.bind(this), 1);
            this.listenTo(this.model, {
                "change:_isEnabled change:_isComplete change:_isSubmitted": this.update
            });
            this.listenTo(this.model.getChildren(), {
                "change:_isActive": this.update
            });
        },

        closebtnFocus: function(event){
            $(event.currentTarget).removeAttr(":focus")
            $(event.currentTarget).closest(".MCQ_feedback").find(".closeBtn_CYU").attr("tabindex", "0")
            setTimeout(function(){
              $(event.currentTarget).closest(".MCQ_feedback").find(".closeBtn_CYU").focus();
            }, 200)
        },

        closeReset: function(e){
            window.resetValue=true;
            var $currentPanel = this.$el;
            $currentPanel.find('.MMCQ_feedbackcontainer').hide();
            this.$el.find(".js-btn-action").click();            
            var attempt=this.model.get("_attemptsLeft");
            var isComplete=this.model.get("_isComplete");
            if(attempt>0 && isComplete!==true){
                if($(e.currentTarget).closest(".gmcq").find(".textHeading").length>0){
                    $(e.currentTarget).closest(".gmcq").find(".textHeading").attr("tabindex", "0")
                }
                else{
                    $(e.currentTarget).closest(".gmcq").find(".question_top_text").find(".qTextFocuse").removeAttr("tabindex");
                }
                 setTimeout(function(){

                    if($(e.currentTarget).closest(".gmcq").find(".textHeading").length>0){
                        $(e.currentTarget).closest(".gmcq").find(".textHeading").focus()
                    }
                    else{
                        $(e.currentTarget).closest(".gmcq").find(".question_top_text").find(".qTextFocuse").attr("tabindex", "0")
                        $(e.currentTarget).closest(".gmcq").find(".question_top_text").find(".qTextFocuse").focus()
                    }
                 }, 150)
            }
            else{
                if(attempt!=0 && isComplete!=true){
                    if($(e.currentTarget).closest(".gmcq").find(".textHeading").length>0){
                        $(e.currentTarget).closest(".gmcq").find(".textHeading").attr("tabindex", "0")
                        setTimeout(function(){
                            $(e.currentTarget).closest(".gmcq").find(".textHeading").focus()
                        }, 200);                        
                    }
                }
                 else if(attempt!=0 && isComplete==true){
                    if($(e.currentTarget).attr("attr-correct")=="false"){  
                        
                          if( $(e.currentTarget).closest(".gmcq").find(".textHeading").length>0){
                            $(e.currentTarget).closest(".gmcq").find(".textHeading").attr("tabindex", "0")
                            setTimeout(function(){
                                $(e.currentTarget).closest(".gmcq").find(".textHeading").focus()
                            }, 200);   
                          }else{
                            $(e.currentTarget).closest(".gmcq").find(".question_top_text").attr("tabindex", "0")
                            setTimeout(function(){
                                $(e.currentTarget).closest(".gmcq").find(".question_top_text").focus()
                            }, 200); 
                        }
                    }
                    else{
                        $(e.currentTarget).closest(".block").find(".mr_showfeedback_button").focus();
                    }                       
                 }
                else{
                    $(e.currentTarget).closest(".block").find(".mr_showfeedback_button").focus();
                }  
            }
       },

        resetQuestionOnRevisit: function() {
            this.resetQuestion();  
        },

        setupQuestion: function() {
            this.model.setupRandomisation();
        },

        onQuestionRendered: function() {
            this.$(".button_show").hide();
            this.setReadyStatus();
            this.update();
        },

        onKeyPress: function(event) {
            if (event.which !== 13) return;
            //<ENTER> keypress
            this.onItemSelect(event);
        },

        onItemFocus: function(event) {
            if (!this.model.isInteractive()) return;

            $('.js-item-label[for=' + $(event.currentTarget).attr('id') + ']').addClass('is-highlighted');
        },

        onItemBlur: function(event) {
            $('.js-item-label[for=' + $(event.currentTarget).attr('id') + ']').removeClass('is-highlighted');
        },

        onItemSelect: function(event) {

           
            this.onselectOption()

            if (!this.model.isInteractive()) return;

            var index = $(event.currentTarget).data('adapt-index');
            var itemModel = this.model.getItem(index);
            var shouldSelect = !itemModel.get("_isActive");

            if (this.model.isSingleSelect()) {
                // Assume a click is always a selection
                shouldSelect = true;
                this.model.resetActiveItems();
            } else if (shouldSelect && this.model.isAtActiveLimit()) {
                // At the selection limit, deselect the last item
                this.model.getLastActiveItem().toggleActive(false);
            }

            // Select or deselect accordingly
            itemModel.toggleActive(shouldSelect);
        },

        onselectOption: function(event) {
            event = event || window.event;            
           var $currentPanel33 = this.$(".btn__container");
            if (this.$('input:checked').length > 0) {
                this.$(".support-container").hide();
                this.$(".button_show").show();
                $currentPanel33.find('.mr_submit_button').removeClass('diablebutton');
            } else {
                this.$(".support-container").show();
                this.$(".button_show").hide();
                $currentPanel33.find(".mr_submit_button").addClass('diablebutton'); 
            }
           
        },

        setupQuesFeedback: function() {
            
            var $currentPanel = this.$(".pos-relative");
            var optItems = this.model.get('_items');

            if (this.model.get("_selectable") > 1) {
                var ansOptions = this.model.get("_userAnswer")
                optItems.forEach(function(v, i) {
                    if (ansOptions[i] == true && v._shouldBeSelected == true) {
                        $currentPanel.find("#mmcq_correct").find("h4").html(optItems[i].feedback_text)
                        $currentPanel.find("#mmcq_correct").find(".feedback-body").append('<p mark="' + optItems[i]._option_text + ':">' + optItems[i].feedback_msg + '</p>')
                        $currentPanel.find(".options-container").find(".item-" + i + " .mcq__item-label").css("background-color", "rgba(6, 255, 9, 0.11)")
                    } else if (ansOptions[i] == true && v._shouldBeSelected == false) {
                        $currentPanel.find("#mmcq_incorrect").find("h4").html(optItems[i].feedback_text)
                        $currentPanel.find("#mmcq_incorrect").find(".feedback-body").append('<p mark="' + optItems[i]._option_text + ':">' + optItems[i].feedback_msg + '</p>')
                        $currentPanel.find(".options-container").find(".item-" + i + " .mcq__item-label").css("background-color", "rgba(255, 84, 79, 0.22)")
                    } else if (v._shouldBeSelected == true) {
                        $currentPanel.find(".options-container").find(".item-" + i + " .mcq__item-state .mcq__item-correct-icon").css("display", "block")
                        $currentPanel.find(".options-container").find(".item-" + i + " .mcq__item-label").css("background-color", "rgba(6, 255, 9, 0.11)");
                    }
                });
            } else {
                var ansOptions = this.model.get("_userAnswer")
                optItems.forEach(function(v, i) {
                    if (ansOptions[i] == true && v._shouldBeSelected == true) {
                        $currentPanel.find(".feedback-container").find("h4").html(optItems[i].feedback_text)
                        $currentPanel.find(".feedback-container").find(".feedback-body").append('<p mark="' + optItems[i]._option_text + ':">' + optItems[i].feedback_msg + '</p>')
                        $currentPanel.find(".options-container").find(".item-" + i + " .mcq__item-label").css("background-color", "rgba(6, 255, 9, 0.11)")
                    } else if (ansOptions[i] == true && v._shouldBeSelected == false) {
                        $currentPanel.find(".feedback-container").find("h4").html(optItems[i].feedback_text)
                        $currentPanel.find(".feedback-container").find(".feedback-body").append('<p mark="' + optItems[i]._option_text + ':">' + optItems[i].feedback_msg + '</p>')
                        $currentPanel.find(".options-container").find(".item-" + i + " .mcq__item-label").css("background-color", "rgba(255, 84, 79, 0.22)")
                    } else if (v._shouldBeSelected == true) {
                        $currentPanel.find(".options-container").find(".item-" + i + " .mcq__item-state .mcq__item-correct-icon").css("display", "block")
                        $currentPanel.find(".options-container").find(".item-" + i + " .mcq__item-label").css("background-color", "rgba(6, 255, 9, 0.11)");
                    }
                })
            }
        },
        submitFeedback_Popup: function(){    
                    
           this.$el.find(".MMCQ_feedbackcontainer").show();
           this.$el.find(".MMCQ_feedbackcontainer").find(".completQuest").addClass("showImage");
          var $that=this;
           setTimeout(function(){
            
            $that.$el.find(".MMCQ_feedbackcontainer").find(".completQuest").find(".feedbackhead").find("strong").focus();
        }, 100)
        },

        onSubmitted: function() {
      
             
           
            // this.setupQuesFeedback();
            this.$(".feedback-container").show();
            var $that = this
            // setTimeout(function() {

            //    // $that.$(".feedback-container h4").focus()

            // }, 80);
            // $(event.target).hide();
            //this.$('.btn__response-container').hide();
            var $currentPanel33 = this.$el;
            var $currentPanel = this.$el;
            var $currentPanel2 = this.$(".mr_wrapper_container");
            var isCorrect = Boolean(this.model.get("_isCorrect"));
            var isPartial = Boolean(this.model.isPartlyCorrect());
            var attempLeft = this.model.get('_attemptsLeft');
            // alert(this.model.get('_attemptsLeft') +"===="+isCorrect +"--"+this.model.get('ariaQuestion'));            
            $currentPanel.find('.gmcq__widget_image').addClass('hidePopup');           
            // ;
            
           
            //------MMCQ_

            $currentPanel.find('.MMCQ_feedbackcontainer').find(".feedbackhead").find("strong").attr("tabindex", "0")
            setTimeout(function(){
                
                $currentPanel.find('.MMCQ_feedbackcontainer').find(".feedbackhead").find("strong").focus();
            }, 50)
           
            if(this.model.get('ariaQuestion')=="MMCQ"){ 
                
                $currentPanel.find('.MCQ_feedback.incorrect_firstAttempt').addClass('hidePopup');
                $currentPanel.find('.MCQ_feedback.incorrect').addClass('hidePopup');
                $currentPanel.find('.MCQ_feedback.correct').addClass('hidePopup');
                $currentPanel.find('.MCQ_feedback.partial').addClass('hidePopup');
                if(isCorrect && isPartial){
                    $currentPanel.find('.MMCQ_feedbackcontainer').show();
                    $currentPanel.find('.MCQ_feedback.correct').addClass('showImage');
                    $currentPanel.find('.MCQ_feedback.correct').addClass('completQuest');
                    $currentPanel.find('.MCQ_feedback.incorrect').addClass('hidePopup');
                    $currentPanel.find('.MCQ_feedback.partial').addClass('hidePopup');
                    $currentPanel.find('#mmcq_correct').show();
                    $currentPanel.find('#mmcq_incorrect').hide();  
                    $currentPanel.find(".mr_showfeedback_button").show();   

                    $currentPanel.find(".mr_showfeedback_button").removeClass("is-disabled");
                    $currentPanel.find(".mr_showfeedback_button").removeAttr("disabled");  

                    $currentPanel.find(".mr_showfeedback_button").attr("tabindex", "0")
                    $currentPanel.find(".mr_showfeedback_button").removeAttr("aria-hidden")
                    $currentPanel.find(".mr_submit_button").addClass('diablebutton');
                    
                    for(var i=0; i< this.$el.find(".gmcq__item-label").length; i++){
                        if(this.model.attributes._items[i]._shouldBeSelected==true){
                            this.$el.find(".gmcq__item-label").eq(i).addClass("correctOpt")
                            }else{
                                this.$el.find(".gmcq__item-label").eq(i).addClass("inCorrectOpt")
                            } 
                    }
                  
                }
                else if(!isCorrect && this.model.isPartlyCorrect())
                {  
                    if(attempLeft==1){
                        $currentPanel.find('.MMCQ_feedbackcontainer').show();                       
                        $currentPanel.find('.MCQ_feedback.correct').addClass('hidePopup');
                        $currentPanel.find('.MCQ_feedback.partial').addClass('hidePopup');
                         $currentPanel.find('.MCQ_feedback.incorrect_firstAttempt').addClass('showImage');
                        $currentPanel2.find('#mmcq_correct').hide();
                        $currentPanel2.find('#mmcq_incorrect').show();
                    }
                    else {
                        $currentPanel.find('.MMCQ_feedbackcontainer').show();
                        // alert("this is partial feedback")
                        $currentPanel.find('.MCQ_feedback.incorrect').addClass('hidePopup');
                        $currentPanel.find('.MCQ_feedback.correct').addClass('hidePopup');
                        $currentPanel.find('.MCQ_feedback.partial').addClass('showImage');

                        $currentPanel.find(".mr_showfeedback_button").show(); 
                        $currentPanel.find(".mr_showfeedback_button").removeClass("is-disabled");
                        $currentPanel.find(".mr_showfeedback_button").removeAttr("disabled");
                        $currentPanel.find('.MCQ_feedback.partial').addClass('completQuest');
                        $currentPanel.find(".mr_showfeedback_button").attr("tabindex", "0")
                        $currentPanel.find(".mr_showfeedback_button").removeAttr("aria-hidden")
                        for(var i=0; i< this.$el.find(".gmcq__item-label").length; i++){
                            if(this.model.attributes._items[i]._shouldBeSelected==true){
                                this.$el.find(".gmcq__item-label").eq(i).addClass("correctOpt")
                                }else{
                                    this.$el.find(".gmcq__item-label").eq(i).addClass("inCorrectOpt")
                                }   
                        }
                    }
                }
                else {
                    if(attempLeft==1)
                    {
                        $currentPanel.find('.MMCQ_feedbackcontainer').show();                       
                        $currentPanel.find('.MCQ_feedback.correct').addClass('hidePopup');
                        $currentPanel.find('.MCQ_feedback.partial').addClass('hidePopup');
                         $currentPanel.find('.MCQ_feedback.incorrect_firstAttempt').addClass('showImage');
                        $currentPanel2.find('#mmcq_correct').hide();
                        $currentPanel2.find('#mmcq_incorrect').show();
                    }else
                    {
                       
                        $currentPanel.find('.MMCQ_feedbackcontainer').show();                        
                        $currentPanel.find('.MCQ_feedback.correct').addClass('hidePopup');
                        $currentPanel.find('.MCQ_feedback.partial').addClass('hidePopup');
                        $currentPanel.find('.MCQ_feedback.incorrect_firstAttempt').addClass('hidePopup');
                        $currentPanel.find('.MCQ_feedback.incorrect').addClass('showImage');
                        $currentPanel.find('.MCQ_feedback.incorrect').addClass('completQuest');
                        $currentPanel2.find('#mmcq_correct').hide();
                        $currentPanel2.find('#mmcq_incorrect').show();
                        $currentPanel.find(".mr_showfeedback_button").show(); 
                        $currentPanel.find(".mr_showfeedback_button").removeClass("is-disabled");
                        $currentPanel.find(".mr_showfeedback_button").removeAttr("disabled");    
                        $currentPanel.find(".mr_showfeedback_button").attr("tabindex", "0") 
                        $currentPanel.find(".mr_showfeedback_button").removeAttr("aria-hidden")                  
                        $currentPanel.find(".mr_submit_button").addClass('diablebutton'); 

                        for(var i=0; i< this.$el.find(".gmcq__item-label").length; i++){
                            if(this.model.attributes._items[i]._shouldBeSelected==true){
                                this.$el.find(".gmcq__item-label").eq(i).addClass("correctOpt")
                                }else{
                                    this.$el.find(".gmcq__item-label").eq(i).addClass("inCorrectOpt")
                                }   
                        }                       
                    }                    
                }
            }
            else
            {
               //MCQ
               $currentPanel.find('.MCQ_feedback.incorrect_firstAttempt').addClass('hidePopup');
               $currentPanel.find('.MCQ_feedback.incorrect').addClass('hidePopup');
               $currentPanel.find('.MCQ_feedback.correct').addClass('hidePopup');
               $currentPanel.find('.MCQ_feedback.partial').addClass('hidePopup');
               if(isCorrect && isPartial){
                   $currentPanel.find('.MMCQ_feedbackcontainer').show();
                   $currentPanel.find('.MCQ_feedback.correct').addClass('showImage');
                   $currentPanel.find('.MCQ_feedback.correct').addClass('completQuest');
                   $currentPanel.find('.MCQ_feedback.incorrect').addClass('hidePopup');
                   $currentPanel.find('.MCQ_feedback.partial').addClass('hidePopup');
                   $currentPanel.find('#mmcq_correct').show();
                   $currentPanel.find('#mmcq_incorrect').hide();  
                   $currentPanel.find(".mr_showfeedback_button").show();   
                   $currentPanel.find(".mr_showfeedback_button").removeClass("is-disabled");
                   $currentPanel.find(".mr_showfeedback_button").removeAttr("disabled");  
                   $currentPanel.find(".mr_showfeedback_button").attr("tabindex", "0")
                   $currentPanel.find(".mr_showfeedback_button").removeAttr("aria-hidden")
                   $currentPanel.find(".mr_submit_button").addClass('diablebutton');
                   
                   for(var i=0; i< this.$el.find(".gmcq__item-label").length; i++){
                       if(this.model.attributes._items[i]._shouldBeSelected==true){
                           this.$el.find(".gmcq__item-label").eq(i).addClass("correctOpt")
                           }else{
                               this.$el.find(".gmcq__item-label").eq(i).addClass("inCorrectOpt")
                           } 
                   }
                 
               }
               else if(!isCorrect && this.model.isPartlyCorrect())
               {  
                   if(attempLeft==1){
                       $currentPanel.find('.MMCQ_feedbackcontainer').show();                       
                       $currentPanel.find('.MCQ_feedback.correct').addClass('hidePopup');
                       $currentPanel.find('.MCQ_feedback.partial').addClass('hidePopup');
                        $currentPanel.find('.MCQ_feedback.incorrect_firstAttempt').addClass('showImage');
                       $currentPanel2.find('#mmcq_correct').hide();
                       $currentPanel2.find('#mmcq_incorrect').show();
                   }
                   else {
                       $currentPanel.find('.MMCQ_feedbackcontainer').show();
                       // alert("this is partial feedback")
                       $currentPanel.find('.MCQ_feedback.incorrect').addClass('hidePopup');
                       $currentPanel.find('.MCQ_feedback.correct').addClass('hidePopup');
                       $currentPanel.find('.MCQ_feedback.partial').addClass('showImage');

                       $currentPanel.find(".mr_showfeedback_button").show(); 
                       $currentPanel.find(".mr_showfeedback_button").removeClass("is-disabled");
                       $currentPanel.find(".mr_showfeedback_button").removeAttr("disabled");
                       $currentPanel.find('.MCQ_feedback.partial').addClass('completQuest');
                       $currentPanel.find(".mr_showfeedback_button").attr("tabindex", "0")
                       $currentPanel.find(".mr_showfeedback_button").removeAttr("aria-hidden")
                       for(var i=0; i< this.$el.find(".gmcq__item-label").length; i++){
                           if(this.model.attributes._items[i]._shouldBeSelected==true){
                               this.$el.find(".gmcq__item-label").eq(i).addClass("correctOpt")
                               }else{
                                   this.$el.find(".gmcq__item-label").eq(i).addClass("inCorrectOpt")
                               }   
                       }
                   }
               }
               else {
                   if(attempLeft==1)
                   {
                       $currentPanel.find('.MMCQ_feedbackcontainer').show();                       
                       $currentPanel.find('.MCQ_feedback.correct').addClass('hidePopup');
                       $currentPanel.find('.MCQ_feedback.partial').addClass('hidePopup');
                        $currentPanel.find('.MCQ_feedback.incorrect_firstAttempt').addClass('showImage');
                       $currentPanel2.find('#mmcq_correct').hide();
                       $currentPanel2.find('#mmcq_incorrect').show();
                   }else
                   {                      
                       $currentPanel.find('.MMCQ_feedbackcontainer').show();                        
                       $currentPanel.find('.MCQ_feedback.correct').addClass('hidePopup');
                       $currentPanel.find('.MCQ_feedback.partial').addClass('hidePopup');
                       $currentPanel.find('.MCQ_feedback.incorrect_firstAttempt').addClass('hidePopup');
                       $currentPanel.find('.MCQ_feedback.incorrect').addClass('showImage');
                       $currentPanel.find('.MCQ_feedback.incorrect').addClass('completQuest');
                       $currentPanel2.find('#mmcq_correct').hide();
                       $currentPanel2.find('#mmcq_incorrect').show();
                       $currentPanel.find(".mr_showfeedback_button").show(); 
                       $currentPanel.find(".mr_showfeedback_button").removeClass("is-disabled");
                       $currentPanel.find(".mr_showfeedback_button").removeAttr("disabled");                       
                       $currentPanel.find(".mr_submit_button").addClass('diablebutton'); 
                       $currentPanel.find(".mr_showfeedback_button").attr("tabindex", "0")
                       $currentPanel.find(".mr_showfeedback_button").removeAttr("aria-hidden")
                       for(var i=0; i< this.$el.find(".gmcq__item-label").length; i++){
                           if(this.model.attributes._items[i]._shouldBeSelected==true){
                               this.$el.find(".gmcq__item-label").eq(i).addClass("correctOpt")
                               }else{
                                   this.$el.find(".gmcq__item-label").eq(i).addClass("inCorrectOpt")
                               }   
                       }                       
                   }                    
               }

            }  

               
         
            //scroll down
            //window.scrollTo(0, document.body.scrollHeight);
         },
        // Blank method to add functionality for when the user cannot submit
        // Could be used for a popup or explanation dialog/hint
        onCannotSubmit: function() {},

        // This is important and should give the user feedback on how they answered the question
        // Normally done through ticks and crosses by adding classes
        showMarking: function() {
            this.update();
        },

        // Used by the question view to reset the look and feel of the component.
        resetQuestion: function() {
           
            var $currentPanel33 = this.$el;
            $currentPanel33.find('.mr_submit_button').addClass('diablebutton');        

            var $currentPanel = this.$(".gmcq__body-inner");
            var $currentPanel2 = this.$(".mr_wrapper_container");           

            // $currentPanel.find('.mr_submit_button').css("display","none")
            
            this.model.resetActiveItems();
            this.model.resetItems();
           
           $currentPanel33.find('.MMCQ_feedbackcontainer').hide();  
            
            // ;
           setTimeout(function(){
            
               //  ;
            //    alert("+++")
                // $currentPanel.find('.mr_submit_button').addClass('diablebutton');
                $currentPanel33.find('.MCQ_feedback.incorrect').addClass('hidePopup');
                 $currentPanel33.find('.MMCQ_feedbackcontainer').hide();                 
                 $currentPanel33.find('.gmcq__widget_image').removeClass('hidePopup');
                 $currentPanel33.find('.MCQ_feedback').removeClass('showImage hidePopup');
                 $currentPanel33.find('.feedback-container.matching').hide();
                 $currentPanel33.find('.mr_submit_button').addClass('diablebutton'); 
                }, 100)
        },

       

        showCorrectAnswer: function() {
            this.isCorrectAnswerShown = true;
            this.update();
        },

        hideCorrectAnswer: function() {
            this.isCorrectAnswerShown = false;
            this.update();
        },

        update: function() {
            // 
            this.updateSelection();
            this.updateMarking();
        },



        updateSelection: function() {
           var $currentPanel = this.$(".btn__container");
           
            var isEnabled = this.model.get("_isEnabled");  


            this.model.getChildren().each(function(itemModel) {

                var isSelected = this.isCorrectAnswerShown ?
                    itemModel.get("_shouldBeSelected") :
                    itemModel.get("_isActive");

                var index = itemModel.get('_index');
                this.$('.js-item-label').filter('[data-adapt-index="' + index + '"]')
                    .toggleClass('is-selected', isSelected)
                    .toggleClass('is-disabled', !isEnabled);

                this.$('.js-item-input').filter('[data-adapt-index="' + index + '"]')
                    .prop('checked', isSelected)
                    .prop('disabled', !isEnabled);

            }.bind(this));

        },

        updateMarking: function() {
            var isInteractive = this.model.isInteractive();
            var canShowMarking = this.model.get('_canShowMarking');
            var ariaLabels = Adapt.course.get('_globals')._accessibility._ariaLabels;

            this.model.getChildren().each(function(itemModel) {

                var index = itemModel.get('_index');
                var $itemInput = this.$('.js-item-input').filter('[data-adapt-index="' + index + '"]');
                var $item = $itemInput.parents('.js-mcq-item');

                if (isInteractive || !canShowMarking) {
                    // Remove item marking
                    $item.removeClass('is-correct is-incorrect');
                    $itemInput.attr('aria-label', $.a11y_normalize(itemModel.get("text")));
                    return;
                }

                // Mark item
                var shouldBeSelected = itemModel.get("_shouldBeSelected");
                var isCorrect = Boolean(itemModel.get("_isCorrect"));
                var isActive = Boolean(itemModel.get("_isActive"));



                $item.
                toggleClass('is-correct', isCorrect).
                toggleClass('is-incorrect', !isCorrect);
                if (this.model.get("_isComplete") == true) {
                    if (shouldBeSelected) {
                        $item.find(".mcq__item-label").css("background-color", "rgba(6, 255, 9, 0.11)");
                        $item.find(".mcq__item-state .mcq__item-correct-icon").css("display", "block")
                    } else {
                        if (this.model.get("_userAnswer")[index] == true && shouldBeSelected == false) {
                            $item.find(".mcq__item-label").css("background-color", "rgba(255, 84, 79, 0.22)");
                        }
                    }
                }

                $itemInput.attr('aria-label', [
                    (shouldBeSelected ? ariaLabels.correct : ariaLabels.incorrect),
                    ", ",
                    (isActive ? ariaLabels.selectedAnswer : ariaLabels.unselectedAnswer),
                    ". ",
                    $.a11y_normalize(itemModel.get("text"))
                ].join(""));

            }.bind(this));

        }

    });

    return McqView;

});