define([
  "core/js/adapt",
  "./themePageView",
  "./themeArticleView",
  "./themeBlockView",
  "./themeView"
], function(Adapt, ThemePageView, ThemeArticleView, ThemeBlockView, ThemeView) {

  function onDataReady() {
    $("html").addClass(Adapt.course.get("_courseStyle"));
  }

  function onPostRender(view) {
    var model = view.model;
    var theme = model.get("_vanilla");

    if (!theme) return;

    switch (model.get("_type")) {
      case "page":
        new ThemePageView({ model: new Backbone.Model(theme), el: view.$el });
        break;
      case "article":
        new ThemeArticleView({ model: new Backbone.Model(theme), el: view.$el });
        break;
      case "block":
        new ThemeBlockView({ model: new Backbone.Model(theme), el: view.$el });
        break;
      default:
        new ThemeView({ model: new Backbone.Model(theme), el: view.$el });
    }
  }

  Adapt.on({
    "app:dataReady": onDataReady,
    "pageView:postRender articleView:postRender blockView:postRender": onPostRender
  });
});
