(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports) :
  typeof define === 'function' && define.amd ? define(['exports'], factory) :
  (global = global || self, factory(global.mixme = {}));
}(this, function (exports) { 'use strict';

  function _typeof(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function (obj) {
        return typeof obj;
      };
    } else {
      _typeof = function (obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }

    return _typeof(obj);
  }

  // Generated by CoffeeScript 2.4.1
  var _snake_case;

  exports.merge = function merge() {
    return exports.mutate.apply(void 0, [{}].concat(Array.prototype.slice.call(arguments)));
  };

  exports.clone = function clone(target) {
    if (Array.isArray(target)) {
      return target.map(function (element) {
        return exports.clone(element);
      });
    } else if (target && _typeof(target) === 'object') {
      return exports.mutate({}, target);
    } else {
      return target;
    }
  };

  exports.mutate = function mutate() {
    var i, j, name, ref, source, target, v;
    target = arguments[0];

    for (i = j = 1, ref = arguments.length; 1 <= ref ? j < ref : j > ref; i = 1 <= ref ? ++j : --j) {
      source = arguments[i];

      if (exports.is_object_literal(source)) {
        if (!exports.is_object_literal(target)) {
          target = {};
        }

        for (name in source) {
          target[name] = exports.mutate(target[name], source[name]);
        }
      } else if (Array.isArray(source)) {
        target = function () {
          var k, len, results;
          results = [];

          for (k = 0, len = source.length; k < len; k++) {
            v = source[k];
            results.push(exports.mutate(void 0, v));
          }

          return results;
        }();
      } else if (source !== void 0) {
        target = source;
      }
    }

    return target;
  };

  exports.snake_case = function snake_case(source) {
    var convert = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
    var name, src, target, u;
    target = {};

    if (exports.is_object_literal(source)) {
      u = typeof convert === 'number' && convert > 0 ? convert - 1 : convert;

      for (name in source) {
        src = source[name];

        if (convert) {
          name = _snake_case(name);
        }

        target[name] = exports.snake_case(src, u);
      }
    } else {
      target = source;
    }

    return target;
  };

  _snake_case = function _snake_case(str) {
    return str.replace(/([A-Z])/g, function (_, match, index) {
      return '_' + match.toLowerCase();
    });
  };

  exports.is_object = function is_object(obj) {
    return obj && _typeof(obj) === 'object' && !Array.isArray(obj);
  };

  exports.is_object_literal = function is_object_literal(obj) {
    var test;
    test = obj;

    if (_typeof(obj) !== 'object' || obj === null) {
      return false;
    } else {
      while (!false) {
        if (Object.getPrototypeOf(test = Object.getPrototypeOf(test)) === null) {
          break;
        }
      }

      return Object.getPrototypeOf(obj) === test;
    }
  };

  Object.defineProperty(exports, '__esModule', { value: true });

}));
