## Change Log

### v3.11.2 (2020-06-01)
- [#3498](https://github.com/less/less.js/pull/3498) Remove tree caching in import manager (#3498) (@matthew-dean)
- [#3482](https://github.com/less/less.js/pull/3482) issue#3481 ignore missing debugInfo (#3482) (@5UtJAjiRWj1q)
- [#3494](https://github.com/less/less.js/pull/3494) Additional check to avoid evaluating an expression if it is a comment (#3494) (@rgroothuijsen)
- [#3490](https://github.com/less/less.js/pull/3490) fix: Use make-dir instead of mkdirp (#3490) (@eps1lon)
- [#3493](https://github.com/less/less.js/pull/3493) Properly exit calc mode after use (#3493) (@rgroothuijsen)
- [#3477](https://github.com/less/less.js/pull/3477) Convert to auto-changelog (#3477) (@matthew-dean)

### v3.11.1 (2020-02-11)
- [#3475](https://github.com/less/less.js/pull/3475) Fixes #3469  - Include tslib dependency (#3475) (@matthew-dean)

### v3.11.0 (2020-02-09)
- [#3468](https://github.com/less/less.js/pull/3468) 3.11.0 (#3468) (@matthew-dean)
- [#3453](https://github.com/less/less.js/pull/3453) Import file with dots in file name (#3453) (@life777)
- [#3460](https://github.com/less/less.js/pull/3460) - Fixed replacer when visitor returns array of nodes (#3460) (@lmartorella)
- [#3454](https://github.com/less/less.js/pull/3454) Added financial contributors to the README (#3454) (@monkeywithacupcake)
- [#3431](https://github.com/less/less.js/pull/3431) Fixes #3430: Removed unnecessary 'important' from NamespaceValue. (#3431) (@batchunag)
- [#3426](https://github.com/less/less.js/pull/3426) Fixes #3405 (#3426) (@matthew-dean)

### v3.10.3 (2019-08-23)
- [#3424](https://github.com/less/less.js/pull/3424) Fixes #3423 #3420 (#3424) (@matthew-dean)
- [#3421](https://github.com/less/less.js/pull/3421) Rollup changed for Node 4 compatibility (#3421) (@matthew-dean)

### v3.10.0 (2019-08-17)
- [#3413](https://github.com/less/less.js/pull/3413) Release v3.10.0 (#3413) (@matthew-dean)

### v3.10.0-beta.2 (2019-08-07)
- [#3412](https://github.com/less/less.js/pull/3412) v3.10.0-beta.2 -- Cleanup NPM and git included files (#3412) (@matthew-dean)

### v3.10.0-beta (2019-08-03)
- [#3411](https://github.com/less/less.js/pull/3411) Conversion of Less to ES6 w/ TypeScript type linting support (#3411) (@matthew-dean)
- [#3363](https://github.com/less/less.js/pull/3363) Fixes #3346 #3338 #3345 (#3363) (@matthew-dean)
- [#3364](https://github.com/less/less.js/pull/3364) Operation.prototype.accept Issues#3327 (#3364) (@legu2009)
- [#3360](https://github.com/less/less.js/pull/3360) Ignore undefined content in generating source maps (#3360) (@cthrax)
- [#3305](https://github.com/less/less.js/pull/3305) Avoid Buffer constructor on newer Node.js (#3305) (#3307) (@gabrielschulhof)
- [#3352](https://github.com/less/less.js/pull/3352) Do not pollute window object in less-browser bootstrap (#3352) (@gaiazov)
- [#3337](https://github.com/less/less.js/pull/3337) Use the correct mime type when loading a plugin (#3337) (@g3rv4)

### v3.9.0 (2018-11-29)
- [#3334](https://github.com/less/less.js/pull/3334) Adds range() function for lists (#3334) (@matthew-dean)
- [#3333](https://github.com/less/less.js/pull/3333) Fixes #3325 #3313 #3328 - each() function fixes (#3333) (@matthew-dean)
- [#3335](https://github.com/less/less.js/pull/3335) Prevent Browserify from bundling Buffer (#3335) (@matthew-dean)

### v3.8.1 (2018-08-08)
- [#3302](https://github.com/less/less.js/pull/3302) v3.8.1 (#3302) (@matthew-dean)
- [#3301](https://github.com/less/less.js/pull/3301) Fixes: #3300 (#3301) (@matthew-dean)
- [#3292](https://github.com/less/less.js/pull/3292) Demonstrate 3.7 fixes #3160 (#3292) (@matthew-dean)
- [#3291](https://github.com/less/less.js/pull/3291) Color function updates - #RRGGBBAA and CSS Variables (#3291) (@matthew-dean)

### v3.8.0 (2018-07-23)
- [#3293](https://github.com/less/less.js/pull/3293) v3.8.0 (#3293) (@matthew-dean)
- [#3248](https://github.com/less/less.js/pull/3248) Feature/rewrite urls (#3248) (@matthew-dean)

### v3.7.1 (2018-07-11)
- [#3284](https://github.com/less/less.js/pull/3284) Release v3.7.1 (#3284) (@matthew-dean)
- [#3283](https://github.com/less/less.js/pull/3283) Fix #3281: console.warning → console.warn (#3283) (@calvinjuarez)

### v3.7.0 (2018-07-11)
- [#3279](https://github.com/less/less.js/pull/3279) v3.7.0 (#3279) (@matthew-dean)
- [#3274](https://github.com/less/less.js/pull/3274) Fixes #1880 - Adds two new math modes and deprecates strictMath (@matthew-dean)
- [#3258](https://github.com/less/less.js/pull/3258) Fixes #2824 - Expressions require a delimiter of some kind in mixin args (@matthew-dean)
- [#3263](https://github.com/less/less.js/pull/3263) Fixes #2270 - Adds each() function to Less functions (@calvinjuarez, @matthew-dean)

### v3.6.0 (2018-07-10)
- [#3278](https://github.com/less/less.js/pull/3278) v3.6.0 (@matthew-dean)
- [#3252](https://github.com/less/less.js/pull/3252) Removes `less-rhino` (broken for a long time) - Fixes #3241 (@matthew-dean)
- [#3259](https://github.com/less/less.js/pull/3259) Removes "double paren" issue for boolean / if function (@matthew-dean)
- [#3276](https://github.com/less/less.js/pull/3276) Bump Jasmine version (@matthew-dean)
- [#3275](https://github.com/less/less.js/pull/3275) Adds Promise polyfill for PhantomJS under Node 9 (@matthew-dean)
- [#3261](https://github.com/less/less.js/pull/3261) Fixes #2791 - svg-gradient() not working in Firefox (@matthew-dean)
- [#3270](https://github.com/less/less.js/pull/3270) Fixes #3231 - Adds UIKit, Bootstrap 3, and Bootstrap 4 to verified tests (@matthew-dean)

### v3.5.3 (2018-07-06)
- [#3272](https://github.com/less/less.js/pull/3272) Reverts operations not being performed in media queries (@matthew-dean)
- [#3257](https://github.com/less/less.js/pull/3257) Fixes #3182 (@matthew-dean)

### v3.5.1 (2018-07-05)
- [#3267](https://github.com/less/less.js/pull/3267) Fixes issue with parentheses following variable in expressions (@matthew-dean)

### v3.5.0 (2018-07-05)
- [#3264](https://github.com/less/less.js/pull/3264) Release v3.5.0 (@matthew-dean)

### v3.5.0-beta.7 (2018-07-04)
- [#3260](https://github.com/less/less.js/pull/3260) Release v3.5.0-beta.7 (#3260) (@matthew-dean)
- [#3256](https://github.com/less/less.js/pull/3256) Allow [] to resolve to last declaration's value (#3256) (@matthew-dean)

### v3.5.0-beta.6 (2018-07-03)
- [#3255](https://github.com/less/less.js/pull/3255) v3.5.0-beta.6 (#3255) (@matthew-dean)
- [#3247](https://github.com/less/less.js/pull/3247) Plugins: If minVersion >= 3.0.0, don't "pre-run" .setOptions() (#3247) (@calvinjuarez)
- [#3254](https://github.com/less/less.js/pull/3254) Tests and parser fixes for namespace values in MQ and mixin args (#3254) (@matthew-dean)

### v3.5.0-beta.5 (2018-07-02)
- [#3251](https://github.com/less/less.js/pull/3251) Bugfix -  namespace values (#3251) (@matthew-dean)
- [#3250](https://github.com/less/less.js/pull/3250) Added small breakpoints example with namespaced values (#3250) (@matthew-dean)

### v3.5.0-beta.4 (2018-06-30)
- [#3242](https://github.com/less/less.js/pull/3242) [Feature] Namespaced values (#3242) (@matthew-dean)
- [#3246](https://github.com/less/less.js/pull/3246) Release/v3.5.0 beta.3 (#3246) (@matthew-dean)
- [#3229](https://github.com/less/less.js/pull/3229) Fixes #3187 (couldn't repo, but found bugs) (#3229) (@matthew-dean)
- [#3237](https://github.com/less/less.js/pull/3237) Fixes #3235 (#3237) (@matthew-dean)

### v3.5.0-beta.3 (2018-06-29)
- [#3239](https://github.com/less/less.js/pull/3239) fix: browser cache is always considered stale if .modifyVars wasn't set (#3239) (@balpha)

### v3.5.0-beta.2 (2018-06-27)
- [#3236](https://github.com/less/less.js/pull/3236) v3.5.0-beta.2 (#3236) (@matthew-dean)
- [#3228](https://github.com/less/less.js/pull/3228) Fixes #3205, partial 3.0 math regression #1880 (#3228) (@matthew-dean)
- [#3227](https://github.com/less/less.js/pull/3227) Fixes #1421 - re-parses variable-interpolated elements to selectors (no.2) (#3227) (@matthew-dean)
- [#3223](https://github.com/less/less.js/pull/3223) Fixes #3191 (#3223) (@matthew-dean)

### v3.5.0-beta (2018-06-25)
- [#3230](https://github.com/less/less.js/pull/3230) Release v3.5.0 beta (#3230) (@matthew-dean)
- [#3219](https://github.com/less/less.js/pull/3219) Invalidate less-node file cache if modified (#3219) (@matthew-dean)
- [#3213](https://github.com/less/less.js/pull/3213) Fixes #3147 #2715 (#3213) (@matthew-dean)
- [#3220](https://github.com/less/less.js/pull/3220) Revert "Fixes #1421 - re-parses variable-interpolated elements to selectors" (@matthew-dean)
- [#3217](https://github.com/less/less.js/pull/3217) Revert "Fixes #1421 - re-parses variable-interpolated elements to selectors (#3217)" (@matthew-dean)
- [#3212](https://github.com/less/less.js/pull/3212) Revert "Pull missed code merged into 3.x branch (#3212)" (@matthew-dean)
- [#3215](https://github.com/less/less.js/pull/3215) Revert "Fixes #3195 (#3215)" (@matthew-dean)
- [#3215](https://github.com/less/less.js/pull/3215) Fixes #3195 (#3215) (@matthew-dean)
- [#3212](https://github.com/less/less.js/pull/3212) Pull missed code merged into 3.x branch (#3212) (@matthew-dean)
- [#3217](https://github.com/less/less.js/pull/3217) Fixes #1421 - re-parses variable-interpolated elements to selectors (#3217) (@matthew-dean)
- [#3207](https://github.com/less/less.js/pull/3207) update changelog for 3.0.4 (@akkumar)
- [#3206](https://github.com/less/less.js/pull/3206) Release v3.0.4 (@matthew-dean)

### v3.0.4 (2018-05-07)
- [#3180](https://github.com/less/less.js/pull/3180) update source_map to 0.6.x (@akkumar)
- [#3172](https://github.com/less/less.js/pull/3172) Type checking length units (@jacobwarduk)
- [#3200](https://github.com/less/less.js/pull/3200) Fixes #3181 (@matthew-dean)

### v3.0.3 (2018-04-18)
- [#1](https://github.com/less/less.js/pull/1) Type checking length units (@jacobwarduk)
- [#3177](https://github.com/less/less.js/pull/3177) chore(package): update request to 2.83.0 (@Kartoffelsalat)
- [#3170](https://github.com/less/less.js/pull/3170) `inline` and `less` imports of the same name = race condition (@thorn0)
- [#3168](https://github.com/less/less.js/pull/3168) Fixes #3116 - lessc not loading plugins in 3.0 (@matthew-dean)

### v3.0.1 (2018-02-15)
- [#3163](https://github.com/less/less.js/pull/3163) Merge 3.x into master (@matthew-dean, @barnabycolby, @kirillrogovoy, @maxbrunsfeld, @seven-phases-max, @ryysud, @bdsomer, @wiinci, @nikeee, @anthony-redFox)

### v3.0.0-RC.2 (2018-02-11)
- [#3161](https://github.com/less/less.js/pull/3161) Remove legacy upgrade (@matthew-dean)
- [#3159](https://github.com/less/less.js/pull/3159) Bump to 3.0.0-RC.1 (@matthew-dean)

### v3.0.0-RC.1 (2018-02-04)
- [#3150](https://github.com/less/less.js/pull/3150) Drop node 0.10 and 0.12 and added node 9 matrix testing (@anthony-redFox)

### v2.7.3 (2017-10-24)
- [#3122](https://github.com/less/less.js/pull/3122) Mime update (@nikeee)
- [#3120](https://github.com/less/less.js/pull/3120) Issue3115 ext in node path (@robhuzzey)
- [#3119](https://github.com/less/less.js/pull/3119) Update © year (@wiinci)
- [#3107](https://github.com/less/less.js/pull/3107) pinned request dep to v2.81.0 (@MarkSG93)

### v3.0.0-alpha.3 (2017-10-09)
- [#3096](https://github.com/less/less.js/pull/3096) Switch from request to phin! (@bdsomer)
- [#3082](https://github.com/less/less.js/pull/3082) Add Node.js v8 to Travis CI and AppVeyor (@ryysud)
- [#3079](https://github.com/less/less.js/pull/3079) Initial support for custom parsed functions (`boolean`, `if` etc.) (@seven-phases-max)
- [#3076](https://github.com/less/less.js/pull/3076) Update mergeRules (@seven-phases-max)

### v2.7.2 (2017-01-05)
- [#2908](https://github.com/less/less.js/pull/2908) Added 'request' as optional dependency. (@maxrd2)
- [#2955](https://github.com/less/less.js/pull/2955) Allow less imports of paths like 'dir/css' (@maxbrunsfeld)
- [#2975](https://github.com/less/less.js/pull/2975) Refactor LessError and lesscHelper.formatError (@kirillrogovoy)
- [#2988](https://github.com/less/less.js/pull/2988) Fixes #2987, --source-map-map-inline works as expected (@nicoschoenmaker)
- [#2946](https://github.com/less/less.js/pull/2946) Fixed sourceMapBasepath bug as the option had no affect on the sourceMapURL value. (@barnabycolby)
- [#2941](https://github.com/less/less.js/pull/2941) CI Build Fixes. (@bd82)
- [#2905](https://github.com/less/less.js/pull/2905) Download PhantomJS from CDN (@abrobston)
- [#2866](https://github.com/less/less.js/pull/2866) Changed octals to hex for ES6 strict mode (@mlowijs)
- [#2891](https://github.com/less/less.js/pull/2891) Fix error reporting of lessc executable II (@jhnns)

### v2.7.0 (2016-05-08)
- [#2894](https://github.com/less/less.js/pull/2894) Update my name. (@nex3)
- [#2892](https://github.com/less/less.js/pull/2892) Fix invalid extraction of the host part from URL (@Taritsyn)
- [#2874](https://github.com/less/less.js/pull/2874) removed dependency to unused package "request" (@jeremyVignelles)
- [#2830](https://github.com/less/less.js/pull/2830) make --depends generate no CSS output (@gtalusan)
- [#2860](https://github.com/less/less.js/pull/2860) Remove unreachable code (@shkdee)
- [#2859](https://github.com/less/less.js/pull/2859) Fix typos found by codespell (@stweil)
- [#2858](https://github.com/less/less.js/pull/2858) Fix AST to include text for single line comments (@zzzzBov)
- [#2853](https://github.com/less/less.js/pull/2853) bin/lessc: Make sure path.dirname gets passed strings (@addaleax)
- [#2754](https://github.com/less/less.js/pull/2754) Update contrast function and tests, fixes #2743 (@Synchro)
- [#2785](https://github.com/less/less.js/pull/2785) Allows root (non-value) functions in Less (@seven-phases-max)
- [#2834](https://github.com/less/less.js/pull/2834) Make sourcemap generation a bit faster (@Medium)

### v2.6.1 (2016-03-04)
- [#2827](https://github.com/less/less.js/pull/2827) Revert "Update jit-grunt to version 0.10.0" (@seven-phases-max)
- [#2821](https://github.com/less/less.js/pull/2821) Update jit-grunt to version 0.10.0 (@greenkeeperio-bot)
- [#2797](https://github.com/less/less.js/pull/2797) Disallow whitespace in variable calls (i.e "DR"-calls) (@seven-phases-max)
- [#2820](https://github.com/less/less.js/pull/2820) update grunt-contrib-concat to version 1.0.0 (@greenkeeperio-bot)
- [#2819](https://github.com/less/less.js/pull/2819) Guard expressions regression in 2.6.0 (#2798) (@SomMeri)
- [#2804](https://github.com/less/less.js/pull/2804) use instanceof operator instead of class comparison optimization (@marijaselakovic)
- [#2817](https://github.com/less/less.js/pull/2817) Update grunt-contrib-jshint to version 1.0.0 🚀 (@greenkeeperio-bot)
- [#2815](https://github.com/less/less.js/pull/2815) Update grunt-contrib-clean to version 1.0.0 🚀 (@greenkeeperio-bot)
- [#2813](https://github.com/less/less.js/pull/2813) Fix typo on and/or change (@mbrodala)
- [#2811](https://github.com/less/less.js/pull/2811) Update CHANGELOG.md (@Justineo)
- [#2806](https://github.com/less/less.js/pull/2806) Fix comments after named color regression (@seven-phases-max)
- [#2794](https://github.com/less/less.js/pull/2794) Update grunt-jscs to version 2.7.0 🚀 (@greenkeeperio-bot)
- [#2784](https://github.com/less/less.js/pull/2784) Update grunt-contrib-jasmine to version 1.0.0 🚀 (@greenkeeperio-bot)
- [#2773](https://github.com/less/less.js/pull/2773) Update all dependencies 🌴 (@lukeapage, @greenkeeperio-bot)

### v2.6.0 (2016-01-29)
- [#2788](https://github.com/less/less.js/pull/2788) Update license year in README.md (@pra85)
- [#2735](https://github.com/less/less.js/pull/2735) Fix for #2384 and caching enabled with modifyVars set (@less)
- [#2783](https://github.com/less/less.js/pull/2783) Allow unknown non-{}-block at-rules (@seven-phases-max)
- [#2779](https://github.com/less/less.js/pull/2779) Logical operator and now has higher precedence then logical operator or. (@SomMeri)
- [#2775](https://github.com/less/less.js/pull/2775) Parsing Error "Unrecognised input" for color operations with color names #2124 (@SomMeri)
- [#2763](https://github.com/less/less.js/pull/2763) Added "or" keyword and allowed arbitrary logical expression in guards. (@SomMeri)
- [#2731](https://github.com/less/less.js/pull/2731) Faster builds and update npm versions to test against (@paladox)
- [#2759](https://github.com/less/less.js/pull/2759) Fixed extend leaking through nested parent selector. (@SomMeri)
- [#2738](https://github.com/less/less.js/pull/2738) Fail when image-size functions are used in browser-less. (@niom)
- [#2485](https://github.com/less/less.js/pull/2485) Allow underscore in a dimension unit (@seven-phases-max)
- [#2729](https://github.com/less/less.js/pull/2729) Fixing import by reference (@SomMeri)

### v2.5.2 (2015-09-24)
- [#2609](https://github.com/less/less.js/pull/2609) Skip missing optional imports (@mmelvin0)
- [#2644](https://github.com/less/less.js/pull/2644) `percentage` function should throw error if result would be `NaN` (@SomMeri)
- [#2646](https://github.com/less/less.js/pull/2646) Parametric mixins: parameters don't match error (@SomMeri)
- [#2688](https://github.com/less/less.js/pull/2688) Converted CLRFs in error tests (@mishal)
- [#2687](https://github.com/less/less.js/pull/2687) Updated test data files (@mishal)
- [#2642](https://github.com/less/less.js/pull/2642) Fixes import by reference inlines source's inline imports - 2620 (@SomMeri)
- [#2643](https://github.com/less/less.js/pull/2643) Keep shorthand color form the same way as named colors are kept. (@SomMeri)
- [#2677](https://github.com/less/less.js/pull/2677) Reference inline comments. (@betaorbust)
- [#2685](https://github.com/less/less.js/pull/2685) Update travis Node.js version & remove io.js (@demohi)
- [#2637](https://github.com/less/less.js/pull/2637) Undefined source map should result in an empty map file. (@SomMeri)
- [#2607](https://github.com/less/less.js/pull/2607) Remove moot `version` property from bower.json (@kkirsche)

### v2.5.1 (2015-05-21)
- [#2591](https://github.com/less/less.js/pull/2591) Update license attribute (@pdehaan)
- [#2575](https://github.com/less/less.js/pull/2575) Fix synchronously loading/applying stylesheets on page load. (@chipx86)
- [#2568](https://github.com/less/less.js/pull/2568) Add a Gitter chat badge to README.md (@gitter-badger)
- [#2559](https://github.com/less/less.js/pull/2559) Fix for #2558 (@seven-phases-max)
- [#2574](https://github.com/less/less.js/pull/2574) Fix `Ruleset.prototype.find` failing for certain frames (@seven-phases-max)
- [#2550](https://github.com/less/less.js/pull/2550) Update CHANGELOG.md (@chharvey)

### v2.5.0 (2015-04-03)
- [#2530](https://github.com/less/less.js/pull/2530) Proper non-primitive value replacement for `%` and `replace` (@seven-phases-max)
- [#2526](https://github.com/less/less.js/pull/2526) Image size (@bassjobsen)
- [#2533](https://github.com/less/less.js/pull/2533) Fix formatting to meet jscs settings (@seven-phases-max)
- [#2525](https://github.com/less/less.js/pull/2525) Add browser field (@whitecolor)
- [#2522](https://github.com/less/less.js/pull/2522) Fix `@plugin` scoping rules (@rjgotten)
- [#2527](https://github.com/less/less.js/pull/2527) Fix grunt shell:benchmark command (@seven-phases-max)
- [#2520](https://github.com/less/less.js/pull/2520) Fix 2440 (@lukeapage)
- [#2517](https://github.com/less/less.js/pull/2517) Quick fix for naked `url` imports (@seven-phases-max, @wahuneke, @bassjobsen)
- [#2515](https://github.com/less/less.js/pull/2515) re: #2508 - revert #2510 - undo all fixes. issue == WONTFIX (@wahuneke)
- [#2504](https://github.com/less/less.js/pull/2504) optional relative amounts for color functions, see#975 (@bassjobsen)
- [#2512](https://github.com/less/less.js/pull/2512) Fix selectors folding into directives (@rjgotten)
- [#2510](https://github.com/less/less.js/pull/2510) Fix issue 2508 (@wahuneke)
- [#2505](https://github.com/less/less.js/pull/2505) fix for issue #2500 (@bassjobsen)
- [#2479](https://github.com/less/less.js/pull/2479) Import plugin (@rjgotten, @bassjobsen)
- [#2497](https://github.com/less/less.js/pull/2497) Allow detached rulesets as mixin argument defaults (@calvinjuarez)
- [#2488](https://github.com/less/less.js/pull/2488) add jit-grunt to the build chain (@bassjobsen)
- [#2489](https://github.com/less/less.js/pull/2489) add browser postProcessor Plugin test (@bassjobsen)
- [#2473](https://github.com/less/less.js/pull/2473) Bubbling of nested directives (@SomMeri)
- [#2445](https://github.com/less/less.js/pull/2445) allow a list of colors as argument for the svg-gradient function (@bassjobsen)

### v2.4.0 (2015-02-08)
- [#2439](https://github.com/less/less.js/pull/2439) Fix empty sourcemaps (@OhJeez)
- [#2429](https://github.com/less/less.js/pull/2429) Implementing preprocessing plugins (@Justineo, @lukeapage)
- [#2427](https://github.com/less/less.js/pull/2427) Nested mixin changing important 2421 (@SomMeri)
- [#2423](https://github.com/less/less.js/pull/2423) Bug: extend doesn't work when appended on nested selector with & (@SomMeri)
- [#2420](https://github.com/less/less.js/pull/2420) endlines and comments (@bassjobsen)

### v2.3.1 (2015-01-28)
- [#2400](https://github.com/less/less.js/pull/2400) Nested parent selectors &:not(&)  - 2026 (@SomMeri)

### v2.3.0 (2015-01-27)
- [#2401](https://github.com/less/less.js/pull/2401) Allow selector interpolation inside pseudoselectors. #1294 (@SomMeri)
- [#2404](https://github.com/less/less.js/pull/2404) Important on parametrized mixin (@SomMeri)
- [#2414](https://github.com/less/less.js/pull/2414) explain inline maps (@bassjobsen)
- [#2392](https://github.com/less/less.js/pull/2392) add support for `isruleset` (@Justineo)
- [#2390](https://github.com/less/less.js/pull/2390) message when sourcemap has been written (@bassjobsen)
- [#2391](https://github.com/less/less.js/pull/2391) Remove BOM in imports. (@DotNetSparky)
- [#2387](https://github.com/less/less.js/pull/2387) Data uri support for include-path (@lukeapage)
- [#2385](https://github.com/less/less.js/pull/2385) checking for doubles when warning for empty extends (@ddprrt)
- [#2380](https://github.com/less/less.js/pull/2380) Colour keyword as variable name reference (@seven-phases-max)
- [#2369](https://github.com/less/less.js/pull/2369) making sure :extend warning does not bubble up, fixes #1618 (@ddprrt)

### v2.2.0 (2015-01-04)
- [#2363](https://github.com/less/less.js/pull/2363) Change error message when caching fails (@bassjobsen)
- [#2337](https://github.com/less/less.js/pull/2337) Better output for the warning when file size exceeds (@bassjobsen)
- [#2319](https://github.com/less/less.js/pull/2319) Expose Less parsing as a top level feature of the less package (@jackwanders)

### v2.1.2 (2014-12-20)
- [#2315](https://github.com/less/less.js/pull/2315) Support non-JSON script attributes (@guybedford)
- [#2313](https://github.com/less/less.js/pull/2313) Remove second 'env:' in .travis.yml. (@vsn4ik)

### v2.1.1 (2014-11-27)
- [#2312](https://github.com/less/less.js/pull/2312) Fix double handling of exceptions (@ForbesLindesay)
- [#2311](https://github.com/less/less.js/pull/2311) Pass this from promise based calling (@ForbesLindesay)
- [#2309](https://github.com/less/less.js/pull/2309) Improve keyword and anonymous input for replace function (fixes #2308). (@seven-phases-max)

### v2.1.0 (2014-11-23)
- [#2298](https://github.com/less/less.js/pull/2298) Small improve in README.md and bower.json. (@vsn4ik)
- [#2297](https://github.com/less/less.js/pull/2297) Package: Updates request to 2.48.0 (@am11)
- [#2296](https://github.com/less/less.js/pull/2296) Fix getting of character at index (@Taritsyn)
- [#2279](https://github.com/less/less.js/pull/2279) Remove livereload cache buster param in extractId (@cgross)

### v2.0.0 (2014-11-09)
- [#2277](https://github.com/less/less.js/pull/2277) create index and browser scripts in root as require targets (@jackwanders, @lukeapage, @seven-phases-max, @Justineo, @lejenome)
- [#2269](https://github.com/less/less.js/pull/2269) Fix for wrong check in abstractFileManager.getPath (@dexif, @lukeapage, @seven-phases-max, @Justineo, @lejenome)
- [#2267](https://github.com/less/less.js/pull/2267) CLI: Fixes source-map-url description (#2264) (@am11)
- [#2268](https://github.com/less/less.js/pull/2268) typo fixes (@vlajos)
- [#2264](https://github.com/less/less.js/pull/2264) CLI: Fixes source-map-url description. (#2264) (@am11)

### v2.0.0-b3 (2014-11-01)
- [#2254](https://github.com/less/less.js/pull/2254) Fix for import relative path for url with parameters (@dexif)

### v2.0.0-b2 (2014-10-26)
- [#2246](https://github.com/less/less.js/pull/2246) Attempt to fix import sequencing (@lukeapage)
- [#2247](https://github.com/less/less.js/pull/2247) Add support for rebeccapurple (#663399) (@le717)
- [#663399](https://github.com/less/less.js/pull/663399) Add rebeccapurple (#663399) (Triangle717)
- [#2243](https://github.com/less/less.js/pull/2243) Support reading less options from its script tag data attributes (@lejenome)
- [#2241](https://github.com/less/less.js/pull/2241) Update CHANGELOG.md (@Justineo)

### v2.0.0-b1 (2014-10-19)
- [#1902](https://github.com/less/less.js/pull/1902) 2.0.0 Pull Request (@lukeapage, @seven-phases-max, @XhmikosR, @levithomason)
- [#2233](https://github.com/less/less.js/pull/2233) Method to scan for and register stylesheets (@levithomason)
- [#2226](https://github.com/less/less.js/pull/2226) Notify when less.js is done processing (@levithomason)
- [#2209](https://github.com/less/less.js/pull/2209) Remove unnecessary semicolon (@joscha)
- [#2217](https://github.com/less/less.js/pull/2217) Fix interpolated selector match regression (@seven-phases-max)
- [#2185](https://github.com/less/less.js/pull/2185) Use SVGs for all readme badges (@theodorejb)
- [#2182](https://github.com/less/less.js/pull/2182) Fixes #1973 (@seven-phases-max)
- [#2181](https://github.com/less/less.js/pull/2181) Case insensitive units parsing and comparison (@lukeapage)

### v1.7.5 (2014-09-03)
- [#2173](https://github.com/less/less.js/pull/2173) Property interpolation fix for `@*` values (@seven-phases-max)
- [#2169](https://github.com/less/less.js/pull/2169) Accept comments in @keyframe and after rule name - merging for next patch release. (@SomMeri)
- [#1921](https://github.com/less/less.js/pull/1921) Pass options object to parser.parse in less.render (@rback)
- [#2136](https://github.com/less/less.js/pull/2136) Fragment handling in data-uri function 1959 (@SomMeri)
- [#2135](https://github.com/less/less.js/pull/2135) Charsets should float on top #2126 (@SomMeri)
- [#2128](https://github.com/less/less.js/pull/2128) Mixin wrongly called (@SomMeri, @obecker, @dhaber)
- [#2144](https://github.com/less/less.js/pull/2144) Updating request dependency (@pdehaan)
- [#2123](https://github.com/less/less.js/pull/2123) Import into media 1645 (@SomMeri, @obecker, @dhaber)

### v1.7.4 (2014-07-27)
- [#2100](https://github.com/less/less.js/pull/2100) Update bower for 1.7.3 (@joscha)
- [#2121](https://github.com/less/less.js/pull/2121) Properties merging should work also inside directives #2035 (@SomMeri)
- [#2120](https://github.com/less/less.js/pull/2120) Misleading error message 2069 (@SomMeri, @obecker, @dhaber)
- [#2117](https://github.com/less/less.js/pull/2117) Fix ordering of @import and @charset rules #1954 #2013 (@SomMeri)

### v1.7.3 (2014-06-22)
- [#2062](https://github.com/less/less.js/pull/2062) Don't round values returned by colour query functions. (@seven-phases-max)

### v1.7.2 (2014-06-22)
- [#2045](https://github.com/less/less.js/pull/2045) Base64 encode source maps (@tim-smart)

### v1.7.1 (2014-06-08)
- [#2022](https://github.com/less/less.js/pull/2022) 2.0.0 refactor chunker and less error (@ForbesLindesay)
- [#2021](https://github.com/less/less.js/pull/2021) 2.0.0 promises (@ForbesLindesay)
- [#1976](https://github.com/less/less.js/pull/1976) Added condition to check if HEX code contain only valid characters (issue #1015) (@peruginni)
- [#2019](https://github.com/less/less.js/pull/2019) Remove the "done" message displayed at the end of the compilation with Rhino. (@gdelhumeau)
- [#2031](https://github.com/less/less.js/pull/2031) Fix a bug: if the less file end line is comments, the lessc command option "modify-var" will have no effect. (@chenboxiang)
- [#2046](https://github.com/less/less.js/pull/2046) window.ActiveXObject in IE11: fix boolean casting (@dkrnl)
- [#2016](https://github.com/less/less.js/pull/2016) e("") fix (@seven-phases-max)
- [#2000](https://github.com/less/less.js/pull/2000) Set CSS text after style element is added to DOM, to fix crash on IE < 9... (@David-Hari)
- [#2002](https://github.com/less/less.js/pull/2002) Fixes #2001 (@seven-phases-max)
- [#1981](https://github.com/less/less.js/pull/1981) fix bug with ../.. paths joining (@kolipka)
- [#1974](https://github.com/less/less.js/pull/1974) Change paths determination for CLI (@dominicbarnes)
- [#1929](https://github.com/less/less.js/pull/1929) Recursive mixin calls regression fix. (@seven-phases-max)
- [#1936](https://github.com/less/less.js/pull/1936) Fix error message when using cleancss with sourcemap (@danielchatfield)
- [#1919](https://github.com/less/less.js/pull/1919) Usage info for url-args option (@bcluca)
- [#1907](https://github.com/less/less.js/pull/1907) Remove trailing spaces from the license header. (@XhmikosR)
- [#1906](https://github.com/less/less.js/pull/1906) Remove twitter-bootstrap tag from SO link (@zdroid)

### v1.7.0 (2014-02-27)
- [#1890](https://github.com/less/less.js/pull/1890) Let `luma` follow spec (@roelvanduijnhoven, @seven-phases-max, @lukeapage)
- [#1859](https://github.com/less/less.js/pull/1859) detached rulesets (@lukeapage)
- [#1884](https://github.com/less/less.js/pull/1884) Minor `replace` and `%` funcs improvement. (@seven-phases-max)
- [#1855](https://github.com/less/less.js/pull/1855) Adding replace function (@jakebellacera, @mouyang)
- [#1866](https://github.com/less/less.js/pull/1866) Fixed empty args matching for named variadics. (@seven-phases-max)
- [#1860](https://github.com/less/less.js/pull/1860) Support for variables in certain at-rules. (@seven-phases-max)
- [#1847](https://github.com/less/less.js/pull/1847) Property merge with `+_` (replaces #1788) (@seven-phases-max, @mouyang)

### v1.6.3 (2014-02-08)
- [#1844](https://github.com/less/less.js/pull/1844) fix broken test case (@mouyang)

### v1.6.2 (2014-02-02)
- [#1841](https://github.com/less/less.js/pull/1841) Improved missing `(` and `{` error detection. (@seven-phases-max)
- [#1828](https://github.com/less/less.js/pull/1828) Updates bower.json for current version (@ruyadorno)
- [#1823](https://github.com/less/less.js/pull/1823) Improved multiple `default()` guards conflict detection. (@seven-phases-max)
- [#1822](https://github.com/less/less.js/pull/1822) Normalize require-calls for Browserify (@pateketrueke)
- [#1814](https://github.com/less/less.js/pull/1814) Rounding of output numbers. (@seven-phases-max)
- [#1806](https://github.com/less/less.js/pull/1806) rhino version not up to date (#1405) (@obecker, @dhaber)
- [#1815](https://github.com/less/less.js/pull/1815) Correct arguments for tree.Element (@oyejorge)
- [#16](https://github.com/less/less.js/pull/16) Don't lint source-map since its owned by another project (@dhaber)
- [#17](https://github.com/less/less.js/pull/17) Fix empty test (@dhaber)
- [#1803](https://github.com/less/less.js/pull/1803) ability to insert uppercase color names (@wareczek)
- [#1804](https://github.com/less/less.js/pull/1804) small compatibility fix for prototype.js (@cettox)
- [#13](https://github.com/less/less.js/pull/13) Add Support-Map Tests for Rhino (@dhaber)
- [#12](https://github.com/less/less.js/pull/12) Fix for some tests that were failing on my Mac (@dhaber)
- [#11](https://github.com/less/less.js/pull/11) Fix for issue #3: Tests should automatically take latest rhino file (@dhaber)

### v1.6.1 (2014-01-12)
- [#1780](https://github.com/less/less.js/pull/1780) #1778 standardised using starting index, to fix incorrectly mapped sourcemaps (@brenmar)
- [#1797](https://github.com/less/less.js/pull/1797) Updated .jshintrc to highlight for ... in without isOwnProperty (@DHainzl)
- [#1795](https://github.com/less/less.js/pull/1795) Fix for running test cases in a regular browser like Firefox or Chrome (@dhaber)
- [#1773](https://github.com/less/less.js/pull/1773) Fixes "function" test against regular expressions (@matthew-dean)

### v1.6.0 (2014-01-01)
- [#1737](https://github.com/less/less.js/pull/1737) Clamped rgba format color output (@seven-phases-max)
- [#1769](https://github.com/less/less.js/pull/1769) If result of evaluated javascript is a number return it as Dimension. (@lesswtf)
- [#1766](https://github.com/less/less.js/pull/1766) Improved error message for undefined variable in js eval statement. (@seven-phases-max)
- [#1758](https://github.com/less/less.js/pull/1758) Removed redundant code from tree.Selector.match() (@seven-phases-max)
- [#1757](https://github.com/less/less.js/pull/1757) Tree functions cleanup + CSS Guards `default` error. (@seven-phases-max)
- [#1624](https://github.com/less/less.js/pull/1624) Experimental support for mixins with interpolated selectors (@seven-phases-max)
- [#1743](https://github.com/less/less.js/pull/1743) Interleaved property merge fix (@seven-phases-max)
- [#1744](https://github.com/less/less.js/pull/1744) Fix CHANGELOG broken link in README. (@jeffslofish)
- [#1733](https://github.com/less/less.js/pull/1733) Remove alpha from contrast calc (@Synchro)
- [#1704](https://github.com/less/less.js/pull/1704) Color blending functions with transparency. (@seven-phases-max)
- [#1708](https://github.com/less/less.js/pull/1708) Updated Readme for full examples (@SomMeri, @Synchro)
- [#1717](https://github.com/less/less.js/pull/1717) Minifier complains about annotation in non-JSDoc tag (@joscha)
- [#1714](https://github.com/less/less.js/pull/1714) Fix for math expr/ops error messages line/column numbers. (@seven-phases-max)

### v1.5.1 (2013-11-17)
- [#1658](https://github.com/less/less.js/pull/1658) Fixes #1619 (@joshuaspence)
- [#1643](https://github.com/less/less.js/pull/1643) Check location.port for truthiness (@matthewp)
- [#1655](https://github.com/less/less.js/pull/1655) Support specifying custom variables when calling lessc and less.js. (@chipx86)
- [#1628](https://github.com/less/less.js/pull/1628) update bower.json main script (@tomfuertes)

### v1.5.0 (2013-10-21)
- [#1570](https://github.com/less/less.js/pull/1570) proposed solution to #1568: percentage as attribute (@MSamman, @danielfttorres)
- [#1572](https://github.com/less/less.js/pull/1572) util.error is deprecated (@robocoder)
- [#1542](https://github.com/less/less.js/pull/1542) Added `length` function (#1542). Added scalar value handling for `extract` and `length` (#1576). (@seven-phases-max)
- [#1558](https://github.com/less/less.js/pull/1558) Bower package: purge unnecessary files (@danielfttorres)

### v1.5.0-b3 (2013-09-17)
- [#1552](https://github.com/less/less.js/pull/1552) Replace deprecated sys.puts with console.log, resolve #1529 (@picomancer)
- [#1543](https://github.com/less/less.js/pull/1543) Sourcemap basepath option (@andjo)
- [#1412](https://github.com/less/less.js/pull/1412) Allow imports from self-signed SSL hosts (@christopherobin)

### v1.5.0-b2 (2013-09-09)
- [#1537](https://github.com/less/less.js/pull/1537) Fix Changelog link (@radium-v)

### v1.5.0-b1 (2013-09-03)
- [#1519](https://github.com/less/less.js/pull/1519) Update main property value of bower.json (@JacopKane)
- [#1](https://github.com/less/less.js/pull/1) Refactoring browser unit tests into grunt-contrib-jasmine (@SomMeri)
- [#1449](https://github.com/less/less.js/pull/1449) resolves #964 (@jonschlinkert)

### v1.4.2 (2013-07-20)
- [#1425](https://github.com/less/less.js/pull/1425) Windows path fixes (@SLaks)
- [#1388](https://github.com/less/less.js/pull/1388) Add .gitattributes to .npmignore (@dpatti)

### v1.4.0-b3 (2013-04-30)
- [#1278](https://github.com/less/less.js/pull/1278) Better fix for local path (cross-platform) (@losnir)
- [#1277](https://github.com/less/less.js/pull/1277) contributing.md updates. Fellow nerds! please wrap words with `@` signs in backticks! (@jonschlinkert)
- [#1273](https://github.com/less/less.js/pull/1273) Fix for local paths (@losnir)
- [#1244](https://github.com/less/less.js/pull/1244) Add Less license to package.json (@theoreticaLee)
- [#1236](https://github.com/less/less.js/pull/1236) Fixes small typo in command prompt usage text (@buley)

### v1.4.0-b2 (2013-03-18)
- [#1230](https://github.com/less/less.js/pull/1230) package.json edited (@jonschlinkert)

### v1.4.0-b1 (2013-03-08)
- [#1197](https://github.com/less/less.js/pull/1197) Updates copyright year in README.md (@Starefossen)
- [#1148](https://github.com/less/less.js/pull/1148) Better implementation of luma (@Synchro)
- [#1147](https://github.com/less/less.js/pull/1147) HSV support for #1143 (@Synchro)
- [#1145](https://github.com/less/less.js/pull/1145) Contrast percentage fix for #1144 (@Synchro)
- [#933](https://github.com/less/less.js/pull/933) Allow flexible naming for amd support (#933) (@guybedford)

### v1.3.1 (2012-10-18)
- [#889](https://github.com/less/less.js/pull/889) Add dppx and dpcm units to parser dimensions (@feelepxyz)
- [#890](https://github.com/less/less.js/pull/890) Add vmin unit to parser dimensions (@feelepxyz)
- [#879](https://github.com/less/less.js/pull/879) Allow numbers and underscores in attribute selectors (@dmcass)
- [#857](https://github.com/less/less.js/pull/857) Revert adding "transparent" as a color name (@clmsnskr)
- [#753](https://github.com/less/less.js/pull/753) Adding "dpi" as a valid dimensions for media queries (@clarkni5)
- [#800](https://github.com/less/less.js/pull/800) Added 'transparent' as a named color (@SpadarShut)
- [#804](https://github.com/less/less.js/pull/804) Fix for unnamed parameters test fail & failing test for import-once (@jreading)
- [#796](https://github.com/less/less.js/pull/796) fixed issue #795 (@comfuture)
- [#268](https://github.com/less/less.js/pull/268) Implemented named arguments (@jamesfoster)

### v1.3.0 (2012-03-10)
- [#673](https://github.com/less/less.js/pull/673) mocha found a couple global variable leaks. Here's the fix. (@andrewjstone)
- [#634](https://github.com/less/less.js/pull/634) Add @media bubbling/nesting/merging (@sirlantis)
- [#631](https://github.com/less/less.js/pull/631) Fixed spelling error on benchmark/less-benchmark.js (@highergroundstudio)
- [#601](https://github.com/less/less.js/pull/601) Make parse error handler more robust (@adrianheine)
- [#595](https://github.com/less/less.js/pull/595) Fix callback called two times (@hokaccha, @cloudhead, @chrizel, @CasualSuperman, @fat)
- [#604](https://github.com/less/less.js/pull/604) Fixes #602 (@treshugart)
- [#585](https://github.com/less/less.js/pull/585) newline all selectors whose combined length is greater than 25 chars (@fat)
- [#479](https://github.com/less/less.js/pull/479) CommonJS/AMD module support (@CasualSuperman)
- [#516](https://github.com/less/less.js/pull/516) Improve Windows path support in lessc (@chrizel)
- [#557](https://github.com/less/less.js/pull/557) Fix for issue #466 (@kmchugh)
- [#515](https://github.com/less/less.js/pull/515) Shift the type setting in order to work with Webkit, and fix typo for IE (@imcotton)
- [#527](https://github.com/less/less.js/pull/527) Add function `percentage` (@hokaccha)

### 1.1.5-extend_patch (2011-12-13)
- [#496](https://github.com/less/less.js/pull/496) Removed call to put header into minified build, because it's already there. (@freeeve)
- [#379](https://github.com/less/less.js/pull/379) Accept 2xx statuses even for file requests (@khalsah)
- [#494](https://github.com/less/less.js/pull/494) Adding support for absolute paths on Windows. (@jmcclell)
- [#514](https://github.com/less/less.js/pull/514) Fix java.io.FileNotFoundException when @importing from LESS in subdirectory (@eager)
- [#461](https://github.com/less/less.js/pull/461) require 'util' instead of 'sys' in lessc and less-benchmark.js (@dmcass)
- [#506](https://github.com/less/less.js/pull/506) Issue #393 Add support for "rem" dimensions (@feelepxyz)
- [#507](https://github.com/less/less.js/pull/507) Fixed lessc require('sys') for nodejs 0.6.* (@garth)
- [#492](https://github.com/less/less.js/pull/492) fix comments in operations (ex: *height: 2px * 4 /* ie hack */) (@fat)
- [#458](https://github.com/less/less.js/pull/458) Assignment entities (@fat, @cloudhead, @asolove)

### 1.1.4-lastest (2011-11-14)
- [#445](https://github.com/less/less.js/pull/445) fix undefined reference (@asolove)
- [#450](https://github.com/less/less.js/pull/450) store index on selector element objects for line number inference (@fat)
- [#432](https://github.com/less/less.js/pull/432) #361: Fix for quoted data URIs getting prepended with path (@asolove)
- [#388](https://github.com/less/less.js/pull/388) Rhino support (@erwan)
- [#355](https://github.com/less/less.js/pull/355) support imports with querystrings (google fonts) fix #265 (@revolunet)
- [#340](https://github.com/less/less.js/pull/340) Read less-content from stdin (@snorkypie)
- [#341](https://github.com/less/less.js/pull/341) patch for Issue 322 (@ttfkam)
- [#335](https://github.com/less/less.js/pull/335) update ARGB support, fix IE9 style injection (@ttfkam)
- [#229](https://github.com/less/less.js/pull/229) add fade() function (@bennyschudel)
- [#347](https://github.com/less/less.js/pull/347) support @-moz-keyframes. (@idris)
- [#169](https://github.com/less/less.js/pull/169) (fix) including .less files via absolute path with IE7 (@ldaley)
- [#189](https://github.com/less/less.js/pull/189) Google Chrome(Chromium) support for extensions (@dz0ny)
- [#247](https://github.com/less/less.js/pull/247) New "escape" function (@gilt)
- [#134](https://github.com/less/less.js/pull/134) Fixed issue (#134) where subfiles' @imports were regarding #, ? and url portions thereafter as part of the base url. (@dbergey)